"""Generated message classes for osconfig version v1alpha2.

Manages OS configurations for GCE VM instances.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'osconfig'


class AptRepository(_messages.Message):
  r"""Represents a single apt package repository. These will be added to a
  repo file that will be managed at
  /etc/apt/sources.list.d/google_osconfig.list.

  Enums:
    ArchiveTypeValueValuesEnum: Type of archive files in this repository. The
      default behavior is DEB.

  Fields:
    archiveType: Type of archive files in this repository. The default
      behavior is DEB.
    components: List of components for this repository. Must contain at least
      one item.
    distribution: Distribution of this repository.
    gpgKey: Optional. URI of the key file for this repository. The agent will
      ensure that this key has been downloaded.
    uri: URI for this repository.
  """

  class ArchiveTypeValueValuesEnum(_messages.Enum):
    r"""Type of archive files in this repository. The default behavior is DEB.

    Values:
      ARCHIVE_TYPE_UNSPECIFIED: Unspecified.
      DEB: Deb indicates that the archive contains binary files.
      DEB_SRC: Deb-src indicates that the archive contains source files.
    """
    ARCHIVE_TYPE_UNSPECIFIED = 0
    DEB = 1
    DEB_SRC = 2

  archiveType = _messages.EnumField('ArchiveTypeValueValuesEnum', 1)
  components = _messages.StringField(2, repeated=True)
  distribution = _messages.StringField(3)
  gpgKey = _messages.StringField(4)
  uri = _messages.StringField(5)


class AptSettings(_messages.Message):
  r"""Apt patching will be performed by executing `apt-get update && apt-get
  upgrade`. Additional options can be set to control how this is executed.

  Enums:
    TypeValueValuesEnum: Optional. By changing the type to DIST, the patching
      will be performed using `apt-get dist-upgrade` instead.

  Fields:
    type: Optional. By changing the type to DIST, the patching will be
      performed using `apt-get dist-upgrade` instead.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Optional. By changing the type to DIST, the patching will be performed
    using `apt-get dist-upgrade` instead.

    Values:
      TYPE_UNSPECIFIED: By default, a full upgrade will be performed.
      DIST: run `apt-get dist-upgrade` instead.
    """
    TYPE_UNSPECIFIED = 0
    DIST = 1

  type = _messages.EnumField('TypeValueValuesEnum', 1)


class Assignment(_messages.Message):
  r"""An Assignment represents the group or groups of VMs that the policy
  applies to.  If an Assignment is empty, it applies to all VMs. Otherwise,
  the targeted VMs must meet ALL criteria specified. So if both labels and
  zones are specified, the policy will apply to VMs with those labels AND in
  those zones.

  Fields:
    groupLabels: Targets instances matching at least one of these label sets.
      This allows an assignment to target disparate groups, for example
      "env=prod or env=staging".
    instanceNamePrefixes: Targets VMs whose name starts with one of these
      prefixes.  Like labels, this is another way to group VMs when targeting
      configs, for example prefix="prod-".  Only supported for project-level
      policies.
    instances: Targets any of the instances specified. Instances are specified
      by their URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]` or `ht
      tps://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/i
      nstances/[INSTANCE_NAME]`  Instance targeting is uncommon and is
      supported to facilitate orchestrating changes by instance or to target
      specific VMs for development and testing.  Only supported for project-
      level policies and must reference instances within this project.
    osArchitectures: Targets VMs with OS Inventory enabled and having one of
      the following OS architectures.
    osShortNames: Targets VMs with OS Inventory enabled and having one of the
      following OS short names, for example "debian", "windows".
    osVersions: Targets VMs with OS Inventory enabled and having one of the
      following OS versions.
    zones: Targets instances in ANY of these zones. Leave empty to target
      instances in any zone.  Zonal targeting is uncommon and is supported to
      facilitate orchestrating changes by zone.
  """

  groupLabels = _messages.MessageField('GroupLabel', 1, repeated=True)
  instanceNamePrefixes = _messages.StringField(2, repeated=True)
  instances = _messages.StringField(3, repeated=True)
  osArchitectures = _messages.StringField(4, repeated=True)
  osShortNames = _messages.StringField(5, repeated=True)
  osVersions = _messages.StringField(6, repeated=True)
  zones = _messages.StringField(7, repeated=True)


class CancelPatchJobRequest(_messages.Message):
  r"""Message for canceling a patch job."""


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ExecutePatchJobRequest(_messages.Message):
  r"""A request message to initiate patching across GCE instances.

  Fields:
    description: Description of the PatchJob. Length of the description is
      limited to 1024 characters.
    dryRun: Should this patch be a dry-run only.  Instances will be contacted,
      but they will do nothing.
    duration: Optional. Duration of the patch job. After the duration ends,
      the patch job will time out.
    filter: Required. There must be at least one instance to patch for this
      job to succeed. This is the same filter used when listing compute
      instances.
    patchConfig: Optional. Patch configuration being applied. If omitted,
      instances will be patched using the default configurations.
  """

  description = _messages.StringField(1)
  dryRun = _messages.BooleanField(2)
  duration = _messages.StringField(3)
  filter = _messages.StringField(4)
  patchConfig = _messages.MessageField('PatchConfig', 5)


class GooRepository(_messages.Message):
  r"""Represents a Goo package repository. These will be added to a repo file
  that will be managed at C:/ProgramData/GooGet/repos/google_osconfig.repo.

  Fields:
    name: The name of the repository.
    url: The url of the repository.
  """

  name = _messages.StringField(1)
  url = _messages.StringField(2)


class GooSettings(_messages.Message):
  r"""Googet patching is performed by running `googet update`."""


class GroupLabel(_messages.Message):
  r"""Represents a group of VMs that can be identified as having all these
  labels, for example "env=prod and app=web".

  Messages:
    LabelsValue: GCE instance labels that must be present for an instance to
      be included in this assignment group.

  Fields:
    labels: GCE instance labels that must be present for an instance to be
      included in this assignment group.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""GCE instance labels that must be present for an instance to be
    included in this assignment group.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)


class GuestConfig(_messages.Message):
  r"""A shortened description of the GuestPolicy only including the name and
  configs that should be applied to the instance.

  Fields:
    packageRepositories: The software package repositories managed by this
      policy.
    packages: The software packages managed by this policy.
    source: Name of the GuestPolicy providing this config.
  """

  packageRepositories = _messages.MessageField('PackageRepository', 1, repeated=True)
  packages = _messages.MessageField('Package', 2, repeated=True)
  source = _messages.StringField(3)


class GuestPolicy(_messages.Message):
  r"""An OS Config resource representing a guest configuration policy. These
  policies represent the desired state for a VM's guest environment including
  packages to install or remove, package repository configurations, and
  software to install.

  Fields:
    assignment: Specifies the VMs that are assigned this policy. This allows
      you to target sets or groups of VMs by different parameters such as
      labels, names, OS, or zones.  Empty assignments will target ALL VMs
      underneath this policy.   Conflict Management  Policies that exist
      higher up in the resource hierarchy (closer to the Org) will override
      those lower down if there is a conflict.  At the same level in the
      resource hierarchy (ie. within a project), the service will prevent the
      creation of multiple policies that conflict with each other. If there
      are multiple policies that specify the same config (eg. package,
      software recipe, repository, etc.), the service will ensure that no VM
      could potentially receive instructions from both policies. To create
      multiple policies that specify different versions of a package or
      different configs for different Operating Systems, each policy must be
      mutually exclusive in their targeting according to labels, OS, or other
      criteria.  Different configs are identified for conflicts in different
      ways. Packages are identified by their name and the package manager(s)
      they target. Package repositories are identified by their unique id
      where applicable. Some package managers don't have a unique identifier
      for repositories and where that's the case, no uniqueness is validated
      by the service.  Note that if OS Inventory is disabled, a VM will not be
      assigned a policy that targets by OS because the service will see this
      VM's OS as unknown.
    createTime: Output only. Time this GuestPolicy was created.
    description: Description of the GuestPolicy. Length of the description is
      limited to 1024 characters.
    etag: The etag for this GuestPolicy. If this is provided on update, it
      must match the server's etag.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    packageRepositories: Optional. A list of package repositories to configure
      on the VM. This will be done before any other configs are applied so
      they can use these repos. Package repositories will only be configured
      if the corresponding package manager(s) are available.
    packages: The software packages to be managed by this policy.
    updateTime: Output only. Last time this GuestPolicy was updated.
  """

  assignment = _messages.MessageField('Assignment', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  etag = _messages.StringField(4)
  name = _messages.StringField(5)
  packageRepositories = _messages.MessageField('PackageRepository', 6, repeated=True)
  packages = _messages.MessageField('Package', 7, repeated=True)
  updateTime = _messages.StringField(8)


class InstanceDetailsSummary(_messages.Message):
  r"""A summary of the current patch state across all instances this patch job
  affects. Contains counts of instances in different states. These states map
  to InstancePatchState. List patch job instance details to see the specific
  states of each instance.

  Fields:
    instancesAcked: Number of instances that have acked and will start
      shortly.
    instancesApplyingPatches: Number of instances that are applying patches.
    instancesDownloadingPatches: Number of instances that are downloading
      patches.
    instancesFailed: Number of instances that failed.
    instancesInactive: Number of instances that are inactive.
    instancesNotified: Number of instances notified about patch job.
    instancesPending: Number of instances pending patch job.
    instancesRebooting: Number of instances rebooting.
    instancesStarted: Number of instances that have started.
    instancesSucceeded: Number of instances that have completed successfully.
    instancesSucceededRebootRequired: Number of instances that require reboot.
    instancesTimedOut: Number of instances that exceeded the time out while
      applying the patch.
  """

  instancesAcked = _messages.IntegerField(1)
  instancesApplyingPatches = _messages.IntegerField(2)
  instancesDownloadingPatches = _messages.IntegerField(3)
  instancesFailed = _messages.IntegerField(4)
  instancesInactive = _messages.IntegerField(5)
  instancesNotified = _messages.IntegerField(6)
  instancesPending = _messages.IntegerField(7)
  instancesRebooting = _messages.IntegerField(8)
  instancesStarted = _messages.IntegerField(9)
  instancesSucceeded = _messages.IntegerField(10)
  instancesSucceededRebootRequired = _messages.IntegerField(11)
  instancesTimedOut = _messages.IntegerField(12)


class ListGuestPoliciesResponse(_messages.Message):
  r"""A response message for listing GuestPolicies.

  Fields:
    guestPolicies: The list of GuestPolicies.
    nextPageToken: A pagination token that can be used to get the next page of
      GuestPolicies.
  """

  guestPolicies = _messages.MessageField('GuestPolicy', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListPatchJobInstanceDetailsResponse(_messages.Message):
  r"""A response message for listing the instances' details for a patch job.

  Fields:
    nextPageToken: A pagination token that can be used to get the next page of
      results.
    patchJobInstanceDetails: The list of instance status.
  """

  nextPageToken = _messages.StringField(1)
  patchJobInstanceDetails = _messages.MessageField('PatchJobInstanceDetails', 2, repeated=True)


class ListPatchJobsResponse(_messages.Message):
  r"""A response message for listing patch jobs.

  Fields:
    nextPageToken: A pagination token that can be used to get the next page of
      results.
    patchJobs: The list of patch jobs.
  """

  nextPageToken = _messages.StringField(1)
  patchJobs = _messages.MessageField('PatchJob', 2, repeated=True)


class LookupEffectiveGuestPoliciesRequest(_messages.Message):
  r"""A request message for getting the policies assigned to the instance.

  Fields:
    instanceIdToken: This is the GCE instance identity token described in
      https://cloud.google.com/compute/docs/instances/verifying-instance-
      identity where the audience is 'osconfig.googleapis.com' and the format
      is 'full'.  If this is not provided, the request credentials will be
      used to authorize the request.
    osArchitecture: Architecture of OS running on the instance. The OS Config
      agent will only provide this field for targeting if OS Inventory is
      enabled for that instance.
    osShortName: Short name of the OS running on the instance. The OS Config
      agent will only provide this field for targeting if OS Inventory is
      enabled for that instance.
    osVersion: Version of the OS running on the instance. The OS Config agent
      will only provide this field for targeting if OS Inventory is enabled
      for that instance.
  """

  instanceIdToken = _messages.StringField(1)
  osArchitecture = _messages.StringField(2)
  osShortName = _messages.StringField(3)
  osVersion = _messages.StringField(4)


class LookupEffectiveGuestPoliciesResponse(_messages.Message):
  r"""Response with policies assigned to the instance.

  Fields:
    guestPolicies: List of GuestPolicies assigned to this instance.
  """

  guestPolicies = _messages.MessageField('GuestConfig', 1, repeated=True)


class OsconfigFoldersGuestPoliciesCreateRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesCreateRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    guestPolicyId: Required. The logical name of the Guest Policy in the
      project with the following restrictions:  * Must contain only lowercase
      letters, numbers, and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the project.
    parent: The resource name of the parent.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  guestPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigFoldersGuestPoliciesDeleteRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesDeleteRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigFoldersGuestPoliciesGetRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesGetRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigFoldersGuestPoliciesListRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesListRequest object.

  Fields:
    pageSize: The maximum number of GuestPolicies to return.
    pageToken: A pagination token returned from a previous call to
      ListGuestPolicies that indicates where this listing should continue
      from. This field is optional.
    parent: The resource name of the parent.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigFoldersGuestPoliciesPatchRequest(_messages.Message):
  r"""A OsconfigFoldersGuestPoliciesPatchRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    updateMask: Field mask that controls which fields of the GuestPolicy
      should be updated.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class OsconfigOrganizationsGuestPoliciesCreateRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesCreateRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    guestPolicyId: Required. The logical name of the Guest Policy in the
      project with the following restrictions:  * Must contain only lowercase
      letters, numbers, and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the project.
    parent: The resource name of the parent.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  guestPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigOrganizationsGuestPoliciesDeleteRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesDeleteRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigOrganizationsGuestPoliciesGetRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesGetRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigOrganizationsGuestPoliciesListRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesListRequest object.

  Fields:
    pageSize: The maximum number of GuestPolicies to return.
    pageToken: A pagination token returned from a previous call to
      ListGuestPolicies that indicates where this listing should continue
      from. This field is optional.
    parent: The resource name of the parent.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigOrganizationsGuestPoliciesPatchRequest(_messages.Message):
  r"""A OsconfigOrganizationsGuestPoliciesPatchRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    updateMask: Field mask that controls which fields of the GuestPolicy
      should be updated.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class OsconfigProjectsGuestPoliciesCreateRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesCreateRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    guestPolicyId: Required. The logical name of the Guest Policy in the
      project with the following restrictions:  * Must contain only lowercase
      letters, numbers, and hyphens. * Must start with a letter. * Must be
      between 1-63 characters. * Must end with a number or a letter. * Must be
      unique within the project.
    parent: The resource name of the parent.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  guestPolicyId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigProjectsGuestPoliciesDeleteRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesDeleteRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsGuestPoliciesGetRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesGetRequest object.

  Fields:
    name: The resource name of the GuestPolicy.
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsGuestPoliciesListRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesListRequest object.

  Fields:
    pageSize: The maximum number of GuestPolicies to return.
    pageToken: A pagination token returned from a previous call to
      ListGuestPolicies that indicates where this listing should continue
      from. This field is optional.
    parent: The resource name of the parent.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigProjectsGuestPoliciesPatchRequest(_messages.Message):
  r"""A OsconfigProjectsGuestPoliciesPatchRequest object.

  Fields:
    guestPolicy: A GuestPolicy resource to be passed as the request body.
    name: Unique name of the resource in this project using the form:
      `projects/{project_id}/guestPolicies/{guest_policy_id}`.
    updateMask: Field mask that controls which fields of the GuestPolicy
      should be updated.
  """

  guestPolicy = _messages.MessageField('GuestPolicy', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class OsconfigProjectsPatchJobsCancelRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsCancelRequest object.

  Fields:
    cancelPatchJobRequest: A CancelPatchJobRequest resource to be passed as
      the request body.
    name: Name of the patch in the form `projects/*/patchJobs/*`
  """

  cancelPatchJobRequest = _messages.MessageField('CancelPatchJobRequest', 1)
  name = _messages.StringField(2, required=True)


class OsconfigProjectsPatchJobsExecuteRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsExecuteRequest object.

  Fields:
    executePatchJobRequest: A ExecutePatchJobRequest resource to be passed as
      the request body.
    parent: The project in which to run this patch in the form `projects/*`
  """

  executePatchJobRequest = _messages.MessageField('ExecutePatchJobRequest', 1)
  parent = _messages.StringField(2, required=True)


class OsconfigProjectsPatchJobsGetRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsGetRequest object.

  Fields:
    name: Name of the patch in the form `projects/*/patchJobs/*`
  """

  name = _messages.StringField(1, required=True)


class OsconfigProjectsPatchJobsInstanceDetailsListRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsInstanceDetailsListRequest object.

  Fields:
    filter: A filter expression that filters results listed in the response.
      Supports filtering results by instance zone, name, state, or
      failure_reason.
    pageSize: The maximum number of instance details records to return.
    pageToken: A pagination token returned from a previous call that indicates
      where this listing should continue from. This field is optional.
    parent: In the form of `projects/*/patchJobs/*`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class OsconfigProjectsPatchJobsListRequest(_messages.Message):
  r"""A OsconfigProjectsPatchJobsListRequest object.

  Fields:
    pageSize: The maximum number of instance status to return.
    pageToken: A pagination token returned from a previous call that indicates
      where this listing should continue from. This field is optional.
    parent: In the form of `projects/*`
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class OsconfigProjectsZonesInstancesLookupGuestPoliciesRequest(_messages.Message):
  r"""A OsconfigProjectsZonesInstancesLookupGuestPoliciesRequest object.

  Fields:
    instance: The GCE VM instance whose policies are being looked up.
    lookupEffectiveGuestPoliciesRequest: A LookupEffectiveGuestPoliciesRequest
      resource to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  lookupEffectiveGuestPoliciesRequest = _messages.MessageField('LookupEffectiveGuestPoliciesRequest', 2)


class OsconfigProjectsZonesInstancesReportPatchJobInstanceDetailsRequest(_messages.Message):
  r"""A OsconfigProjectsZonesInstancesReportPatchJobInstanceDetailsRequest
  object.

  Fields:
    reportPatchJobInstanceDetailsRequest: A
      ReportPatchJobInstanceDetailsRequest resource to be passed as the
      request body.
    resource: The instance reporting its status in the form
      `projects/*/zones/*/instances/*`
  """

  reportPatchJobInstanceDetailsRequest = _messages.MessageField('ReportPatchJobInstanceDetailsRequest', 1)
  resource = _messages.StringField(2, required=True)


class Package(_messages.Message):
  r"""Package is a reference to the software package to be installed or
  removed. The agent on the VM will use the system package manager to apply
  the config.   These are the commands that the agent will use to install or
  remove packages.  Apt install: `apt-get update && apt-get -y install
  package1 package2 package3` remove: `apt-get -y remove package1 package2
  package3`  Yum install: `yum -y install package1 package2 package3` remove:
  `yum -y remove package1 package2 package3`  Zypper install: `zypper install
  package1 package2 package3` remove: `zypper rm package1 package2`  Googet
  install: `googet -noconfirm install package1 package2 package3` remove:
  `googet -noconfirm remove package1 package2 package3`

  Enums:
    DesiredStateValueValuesEnum: Optional. The desired_state the agent should
      maintain for this package. The default is to ensure the package is
      installed.
    ManagerValueValuesEnum: Optional. Type of package manager that can be used
      to install this package. If a system does not have the package manager,
      the package will not be installed/removed and there is no error. By
      default or when specifying ANY, the agent will attempt to install and
      remove this package using the default package manager. This is helpful
      when creating a policy that applies to different types of systems.  The
      default behavior is ANY.

  Fields:
    desiredState: Optional. The desired_state the agent should maintain for
      this package. The default is to ensure the package is installed.
    manager: Optional. Type of package manager that can be used to install
      this package. If a system does not have the package manager, the package
      will not be installed/removed and there is no error. By default or when
      specifying ANY, the agent will attempt to install and remove this
      package using the default package manager. This is helpful when creating
      a policy that applies to different types of systems.  The default
      behavior is ANY.
    name: The name of the package. A package is uniquely identified for
      conflict validation by checking its name and the manager(s) it targets.
    version: Optional. The version of the package to install. If omitted, the
      agent will install the latest version.
  """

  class DesiredStateValueValuesEnum(_messages.Enum):
    r"""Optional. The desired_state the agent should maintain for this
    package. The default is to ensure the package is installed.

    Values:
      DESIRED_STATE_UNSPECIFIED: The default is to ensure the package is
        installed.
      INSTALLED: The agent will ensure that the package is installed.
      UPDATED: The agent will ensure that the package is installed and will
        periodically check for and install any updates.
      REMOVED: The agent will ensure that the package is not installed and
        uninstall it if detected.
    """
    DESIRED_STATE_UNSPECIFIED = 0
    INSTALLED = 1
    UPDATED = 2
    REMOVED = 3

  class ManagerValueValuesEnum(_messages.Enum):
    r"""Optional. Type of package manager that can be used to install this
    package. If a system does not have the package manager, the package will
    not be installed/removed and there is no error. By default or when
    specifying ANY, the agent will attempt to install and remove this package
    using the default package manager. This is helpful when creating a policy
    that applies to different types of systems.  The default behavior is ANY.

    Values:
      MANAGER_UNSPECIFIED: The default behavior is ANY.
      ANY: Apply this package config using the default system package manager.
      APT: Apply this package config only if Apt is available on the system.
      YUM: Apply this package config only if Yum is available on the system.
      ZYPPER: Apply this package config only if Zypper is available on the
        system.
      GOO: Apply this package config only if GooGet is available on the
        system.
    """
    MANAGER_UNSPECIFIED = 0
    ANY = 1
    APT = 2
    YUM = 3
    ZYPPER = 4
    GOO = 5

  desiredState = _messages.EnumField('DesiredStateValueValuesEnum', 1)
  manager = _messages.EnumField('ManagerValueValuesEnum', 2)
  name = _messages.StringField(3)
  version = _messages.StringField(4)


class PackageRepository(_messages.Message):
  r"""A package repository.

  Fields:
    apt: An Apt Repository.
    goo: A Goo Repository.
    yum: A Yum Repository.
    zypper: A Zypper Repository.
  """

  apt = _messages.MessageField('AptRepository', 1)
  goo = _messages.MessageField('GooRepository', 2)
  yum = _messages.MessageField('YumRepository', 3)
  zypper = _messages.MessageField('ZypperRepository', 4)


class PatchConfig(_messages.Message):
  r"""Patch configuration specifications. Contains details on specifically how
  to apply the patch(es) to an instance.

  Enums:
    RebootConfigValueValuesEnum: Optional. Post-patch reboot settings.

  Fields:
    apt: Apt update settings. Use this override the default apt patch rules.
    goo: Goo update settings. Use this override the default goo patch rules.
    rebootConfig: Optional. Post-patch reboot settings.
    retryStrategy: Optional. Retry strategy can be defined to have the agent
      retry patching during the window if patching fails. If omitted, the
      agent will use its default retry strategy.
    windowsUpdate: Windows update settings. Use this override the default
      windows patch rules.
    yum: Yum update settings. Use this override the default yum patch rules.
    zypper: Zypper update settings. Use this override the default zypper patch
      rules.
  """

  class RebootConfigValueValuesEnum(_messages.Enum):
    r"""Optional. Post-patch reboot settings.

    Values:
      REBOOT_CONFIG_UNSPECIFIED: The default behavior is DEFAULT.
      DEFAULT: The agent will decide if a reboot is necessary by checking well
        known signals such as registry keys or `/var/run/reboot-required`.
      ALWAYS: Always reboot the machine after the update has completed.
      NEVER: Never reboot the machine after the update has completed.
    """
    REBOOT_CONFIG_UNSPECIFIED = 0
    DEFAULT = 1
    ALWAYS = 2
    NEVER = 3

  apt = _messages.MessageField('AptSettings', 1)
  goo = _messages.MessageField('GooSettings', 2)
  rebootConfig = _messages.EnumField('RebootConfigValueValuesEnum', 3)
  retryStrategy = _messages.MessageField('RetryStrategy', 4)
  windowsUpdate = _messages.MessageField('WindowsUpdateSettings', 5)
  yum = _messages.MessageField('YumSettings', 6)
  zypper = _messages.MessageField('ZypperSettings', 7)


class PatchJob(_messages.Message):
  r"""A high level representation of a patch job that is either in progress or
  has completed.  Instances' details are not included in the job. To paginate
  through instance details, use ListPatchJobInstanceDetails.

  Enums:
    StateValueValuesEnum: Output only. The current state of the PatchJob.

  Fields:
    createTime: Output only. Time this PatchJob was created.
    description: Description of the patch job. Length of the description is
      limited to 1024 characters.
    dryRun: If this patch job is a dry run, the agent will report that it has
      finished without running any updates on the VM.
    duration: Duration of the patch job. After the duration ends, the patch
      job will time out.
    errorMessage: If this patch job failed, this message will provide
      information about the failure.
    filter: Required. There must be at least one instance to patch for this
      job to succeed. This is the same filter used when listing compute
      instances.
    instanceDetailsSummary: Summary of instance details.
    name: Output only. Unique identifier for this patch job in the form
      `projects/*/patchJobs/*`
    patchConfig: Patch configuration being applied.
    percentComplete: Reflects the overall progress of the patch job in the
      range of 0.0 being no progress to 100.0 being complete.
    state: Output only. The current state of the PatchJob.
    updateTime: Output only. Last time this PatchJob was updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the PatchJob.

    Values:
      STATE_UNSPECIFIED: State must be specified.
      STARTED: The patch job was successfully initiated.
      INSTANCE_LOOKUP: The patch job is looking up instances to run the patch
        on.
      PATCHING: Instances are being patched.
      SUCCEEDED: Patch job completed successfully.
      COMPLETED_WITH_ERRORS: Patch job completed but there were errors.
      CANCELED: The patch job was canceled.
      TIMED_OUT: The patch job has timed out.
    """
    STATE_UNSPECIFIED = 0
    STARTED = 1
    INSTANCE_LOOKUP = 2
    PATCHING = 3
    SUCCEEDED = 4
    COMPLETED_WITH_ERRORS = 5
    CANCELED = 6
    TIMED_OUT = 7

  createTime = _messages.StringField(1)
  description = _messages.StringField(2)
  dryRun = _messages.BooleanField(3)
  duration = _messages.StringField(4)
  errorMessage = _messages.StringField(5)
  filter = _messages.StringField(6)
  instanceDetailsSummary = _messages.MessageField('InstanceDetailsSummary', 7)
  name = _messages.StringField(8)
  patchConfig = _messages.MessageField('PatchConfig', 9)
  percentComplete = _messages.FloatField(10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  updateTime = _messages.StringField(12)


class PatchJobInstanceDetails(_messages.Message):
  r"""Patch details of an instance.

  Enums:
    StateValueValuesEnum: Current state of instance patch.

  Fields:
    attemptCount: Number of times the agent attempted to apply the patch.
    failureReason: If the patch has failed, this is the reason.
    instanceSystemId: The unique, system-generated identifier for the
      instance.
    name: The instance name in the form `projects/*/zones/*/instances/*`
    state: Current state of instance patch.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Current state of instance patch.

    Values:
      PATCH_STATE_UNSPECIFIED: Unspecified.
      PENDING: The instance has not been notified yet.
      INACTIVE: Instance is inactive and cannot be patched.
      NOTIFIED: The instance has been notified that it should patch.
      STARTED: The instance has started the patching process.
      DOWNLOADING_PATCHES: The instance is downloading patches.
      APPLYING_PATCHES: The instance is applying patches.
      REBOOTING: The instance is rebooting.
      SUCCEEDED: The instance has completed applying patches.
      SUCCEEDED_REBOOT_REQUIRED: The instance has completed applying patches
        but a reboot is required.
      FAILED: The instance has failed to apply the patch.
      ACKED: The instance acked the notification and will start shortly.
      TIMED_OUT: The instance exceeded the time out while applying the patch.
    """
    PATCH_STATE_UNSPECIFIED = 0
    PENDING = 1
    INACTIVE = 2
    NOTIFIED = 3
    STARTED = 4
    DOWNLOADING_PATCHES = 5
    APPLYING_PATCHES = 6
    REBOOTING = 7
    SUCCEEDED = 8
    SUCCEEDED_REBOOT_REQUIRED = 9
    FAILED = 10
    ACKED = 11
    TIMED_OUT = 12

  attemptCount = _messages.IntegerField(1)
  failureReason = _messages.StringField(2)
  instanceSystemId = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class ReportPatchJobInstanceDetailsRequest(_messages.Message):
  r"""Request to report the patch status for an instance.

  Enums:
    StateValueValuesEnum: State of current patch execution on the instance.

  Fields:
    attemptCount: Number of times the agent attempted to apply the patch.
    failureReason: Reason for failure.
    instanceIdToken: This is the GCE instance identity token described in
      https://cloud.google.com/compute/docs/instances/verifying-instance-
      identity where the audience is 'osconfig.googleapis.com' and the format
      is 'full'.
    instanceSystemId: Required. The unique, system-generated identifier for
      the instance.  This is the immutable, auto-generated ID assigned to the
      instance upon creation. This is needed here because GCE instance names
      are not tombstoned; it is possible to delete an instance and create a
      new one with the same name; this provides a mechanism for this API to
      identify distinct instances in this case.
    patchJob: Unique identifier of the patch job this request applies to.
    state: State of current patch execution on the instance.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""State of current patch execution on the instance.

    Values:
      PATCH_STATE_UNSPECIFIED: Unspecified.
      PENDING: The instance has not been notified yet.
      INACTIVE: Instance is inactive and cannot be patched.
      NOTIFIED: The instance has been notified that it should patch.
      STARTED: The instance has started the patching process.
      DOWNLOADING_PATCHES: The instance is downloading patches.
      APPLYING_PATCHES: The instance is applying patches.
      REBOOTING: The instance is rebooting.
      SUCCEEDED: The instance has completed applying patches.
      SUCCEEDED_REBOOT_REQUIRED: The instance has completed applying patches
        but a reboot is required.
      FAILED: The instance has failed to apply the patch.
      ACKED: The instance acked the notification and will start shortly.
      TIMED_OUT: The instance exceeded the time out while applying the patch.
    """
    PATCH_STATE_UNSPECIFIED = 0
    PENDING = 1
    INACTIVE = 2
    NOTIFIED = 3
    STARTED = 4
    DOWNLOADING_PATCHES = 5
    APPLYING_PATCHES = 6
    REBOOTING = 7
    SUCCEEDED = 8
    SUCCEEDED_REBOOT_REQUIRED = 9
    FAILED = 10
    ACKED = 11
    TIMED_OUT = 12

  attemptCount = _messages.IntegerField(1)
  failureReason = _messages.StringField(2)
  instanceIdToken = _messages.StringField(3)
  instanceSystemId = _messages.StringField(4)
  patchJob = _messages.StringField(5)
  state = _messages.EnumField('StateValueValuesEnum', 6)


class ReportPatchJobInstanceDetailsResponse(_messages.Message):
  r"""Response from reporting instance patch details. Includes information the
  agent needs to continue or stop patching.

  Enums:
    PatchJobStateValueValuesEnum: State of the overall patch. If the patch is
      no longer active, the agent should not begin a new patch step.

  Fields:
    dryRun: If this patch job is a dry run, the agent will report its status
      as it goes through the motions but won't actually run any updates or
      perform any reboots.
    patchConfig: Patch configuration the agent should apply.
    patchJob: Unique identifier for the current patch job.
    patchJobState: State of the overall patch. If the patch is no longer
      active, the agent should not begin a new patch step.
  """

  class PatchJobStateValueValuesEnum(_messages.Enum):
    r"""State of the overall patch. If the patch is no longer active, the
    agent should not begin a new patch step.

    Values:
      PATCH_JOB_STATE_UNSPECIFIED: Unspecified is invalid.
      ACTIVE: The patch job is running. Instances will continue to run patch
        job steps.
      COMPLETED: The patch job is complete.
    """
    PATCH_JOB_STATE_UNSPECIFIED = 0
    ACTIVE = 1
    COMPLETED = 2

  dryRun = _messages.BooleanField(1)
  patchConfig = _messages.MessageField('PatchConfig', 2)
  patchJob = _messages.StringField(3)
  patchJobState = _messages.EnumField('PatchJobStateValueValuesEnum', 4)


class RetryStrategy(_messages.Message):
  r"""The strategy for retrying failed patches during the patch window.

  Fields:
    enabled: If true, the agent will continue to try and patch until the
      window has ended.
  """

  enabled = _messages.BooleanField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class WindowsUpdateSettings(_messages.Message):
  r"""Windows patching is performed using the Windows Update Agent.

  Enums:
    ClassificationsValueListEntryValuesEnum:

  Fields:
    classifications: Only apply updates of these windows update
      classifications. If empty, all updates will be applied.
    excludes: Optional list of KBs to exclude from update.
  """

  class ClassificationsValueListEntryValuesEnum(_messages.Enum):
    r"""ClassificationsValueListEntryValuesEnum enum type.

    Values:
      CLASSIFICATION_UNSPECIFIED: <no description>
      CRITICAL: <no description>
      SECURITY: <no description>
      DEFINITION: <no description>
      DRIVER: <no description>
      FEATURE_PACK: <no description>
      SERVICE_PACK: <no description>
      TOOL: <no description>
      UPDATE_ROLLUP: <no description>
      UPDATE: <no description>
    """
    CLASSIFICATION_UNSPECIFIED = 0
    CRITICAL = 1
    SECURITY = 2
    DEFINITION = 3
    DRIVER = 4
    FEATURE_PACK = 5
    SERVICE_PACK = 6
    TOOL = 7
    UPDATE_ROLLUP = 8
    UPDATE = 9

  classifications = _messages.EnumField('ClassificationsValueListEntryValuesEnum', 1, repeated=True)
  excludes = _messages.StringField(2, repeated=True)


class YumRepository(_messages.Message):
  r"""Represents a single yum package repository. These will be added to a
  repo file that will be managed at /etc/yum.repos.d/google_osconfig.repo.

  Fields:
    baseUrl: Required. The location of the repository directory.
    displayName: Optional. If omitted, the id will be used for the name.
    gpgKeys: Optional. URIs of GPG keys.
    id: Required. A one word, unique name for this repository. This will be
      the `repo id` in the yum config file and also the `display_name` if
      `display_name` is omitted. This id is also used as the unique identifier
      when checking for GuestPolicy conflicts.
  """

  baseUrl = _messages.StringField(1)
  displayName = _messages.StringField(2)
  gpgKeys = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)


class YumSettings(_messages.Message):
  r"""Yum patching will be performed by executing `yum update`. Additional
  options can be set to control how this is executed.  Note that not all
  settings are supported on all platforms.

  Fields:
    excludes: List of packages to exclude from update. These packages will be
      excluded by using the yum `--exclude` flag.
    minimal: Optional. Will cause patch to run `yum update-minimal` instead.
    security: Optional. Adds the `--security` flag to `yum update`. Not
      supported on all platforms.
  """

  excludes = _messages.StringField(1, repeated=True)
  minimal = _messages.BooleanField(2)
  security = _messages.BooleanField(3)


class ZypperRepository(_messages.Message):
  r"""Represents a single zypper package repository. These will be added to a
  repo file that will be managed at /etc/zypp/repos.d/google_osconfig.repo.

  Fields:
    baseUrl: Required. The location of the repository directory.
    displayName: Optional. If omitted, the id will be used for the name.
    gpgKeys: Optional. URIs of GPG keys.
    id: Required. A one word, unique name for this repository. This will be
      the `repo id` in the zypper config file and also the `display_name` if
      `display_name` is omitted. This id is also used as the unique identifier
      when checking for GuestPolicy conflicts.
  """

  baseUrl = _messages.StringField(1)
  displayName = _messages.StringField(2)
  gpgKeys = _messages.StringField(3, repeated=True)
  id = _messages.StringField(4)


class ZypperSettings(_messages.Message):
  r"""Zypper patching is performed by running `zypper refresh && zypper
  update`
  """



encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
