"""Generated message classes for datacatalog version v1beta1.

A fully managed and highly scalable data discovery and metadata management
service.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'datacatalog'


class DatacatalogEntriesLookupRequest(_messages.Message):
  r"""A DatacatalogEntriesLookupRequest object.

  Fields:
    linkedResource: The full name of the Google Cloud Platform resource the
      Data Catalog entry represents. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      Full names are case-sensitive.  Examples: "//bigquery.googleapis.com/pro
      jects/projectId/datasets/datasetId/tables/tableId".
      "//pubsub.googleapis.com/projects/projectId/topics/topicId"
    sqlResource: The SQL name of the entry. SQL names are case-sensitive.
      Examples: <ul>   <li>cloud_pubsub.project_id.topic_id</li>
      <li>pubsub.project_id.`topic.id.with.dots`</li>
      <li>bigquery.project_id.dataset_id.table_id</li>
      <li>datacatalog.project_id.location_id.entry_group_id.entry_id</li>
      </ul> *_ids shoud satisfy the standard SQL rules for identifiers.
      https://cloud.google.com/bigquery/docs/reference/standard-sql/lexical
  """

  linkedResource = _messages.StringField(1)
  sqlResource = _messages.StringField(2)


class DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesGetRequest object.

  Fields:
    name: Required. The name of the entry. For example, "projects/{project_id}
      /locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}".
  """

  name = _messages.StringField(1, required=True)


class DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest(_messages.Message):
  r"""A DatacatalogProjectsLocationsEntryGroupsEntriesPatchRequest object.

  Fields:
    googleCloudDatacatalogV1beta1Entry: A GoogleCloudDatacatalogV1beta1Entry
      resource to be passed as the request body.
    name: Required when used in UpdateEntryRequest. The Data Catalog resource
      name of the entry in URL format. For example, "projects/{project_id}/loc
      ations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}".
    updateMask: Optional. The fields to update on the entry.  If absent or
      empty, all modifiable fields are updated.  Modifiable fields in synced
      entries:  1. schema (Pub/Sub topics only)  Modifiable fields in native
      entries:  1. display_name 2. description 3. schema
  """

  googleCloudDatacatalogV1beta1Entry = _messages.MessageField('GoogleCloudDatacatalogV1beta1Entry', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GoogleCloudDatacatalogV1beta1BigQueryTableSpec(_messages.Message):
  r"""Describes a BigQuery table.

  Enums:
    TableSourceTypeValueValuesEnum: Output only. The table source type.

  Fields:
    tableSourceType: Output only. The table source type.
    viewSpec: Table view specification. This field should only be populated if
      table_source_type is BIGQUERY_VIEW.
  """

  class TableSourceTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The table source type.

    Values:
      TABLE_SOURCE_TYPE_UNSPECIFIED: Default unknown type.
      BIGQUERY_VIEW: Table view.
      BIGQUERY_TABLE: BigQuery native table.
    """
    TABLE_SOURCE_TYPE_UNSPECIFIED = 0
    BIGQUERY_VIEW = 1
    BIGQUERY_TABLE = 2

  tableSourceType = _messages.EnumField('TableSourceTypeValueValuesEnum', 1)
  viewSpec = _messages.MessageField('GoogleCloudDatacatalogV1beta1ViewSpec', 2)


class GoogleCloudDatacatalogV1beta1ColumnSchema(_messages.Message):
  r"""Representation of a column within a schema. Columns could be nested
  inside other columns.

  Fields:
    column: Required. Name of the column.
    description: Optional. Description of the column. Default value is an
      empty string.
    mode: Optional. A column's mode indicates whether the values in this
      column are required, nullable, etc. Only 'NULLABLE', 'REQUIRED' and
      'REPEATED' are supported. Default mode is 'NULLABLE'.
    subcolumns: Optional. Schema of sub-columns. A column can have zero or
      more sub-columns.
    type: Required. Type of the column.
  """

  column = _messages.StringField(1)
  description = _messages.StringField(2)
  mode = _messages.StringField(3)
  subcolumns = _messages.MessageField('GoogleCloudDatacatalogV1beta1ColumnSchema', 4, repeated=True)
  type = _messages.StringField(5)


class GoogleCloudDatacatalogV1beta1Entry(_messages.Message):
  r"""Entry Metadata.  A Data Catalog Entry resource represents another
  resource in Google Cloud Platform, such as a BigQuery Dataset or a Pub/Sub
  Topic. Clients can use the `linked_resource` field in the Entry resource to
  refer to the original resource id of the source system.  An Entry resource
  contains resource details, such as its schema. An Entry can also be used to
  attach flexible metadata, such as a Tag.

  Enums:
    TypeValueValuesEnum: Required. Type of entry.

  Fields:
    bigqueryTableSpec: Specification that applies to a BigQuery table. This is
      only valid on entries of type TABLE.
    description: Optional. Entry description, which can consist of several
      sentences or paragraphs that describe entry contents. Default value is
      an empty string.
    displayName: Optional. Display information such as title and description.
      A short name to identify the entry, for example, "Analytics Data - Jan
      2011". Default value is an empty string.
    linkedResource: Output only. The full name of the cloud resource the entry
      belongs to. See:
      https://cloud.google.com/apis/design/resource_names#full_resource_name
      Data Catalog supports resources from select Google Cloud Platform
      systems. `linked_resource` is the full name of the Google Cloud Platform
      resource. For example, the `linked_resource` for a table resource from
      BigQuery is:  "//bigquery.googleapis.com/projects/projectId/datasets/dat
      asetId/tables/tableId".
    name: Required when used in UpdateEntryRequest. The Data Catalog resource
      name of the entry in URL format. For example, "projects/{project_id}/loc
      ations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}".
    schema: Optional. Schema of the entry. An entry might not have any schema
      attached to it.
    sourceSystemTimestamps: Output only. Timestamps about the underlying
      Google Cloud Platform resource -- not about this Data Catalog Entry.
    type: Required. Type of entry.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. Type of entry.

    Values:
      ENTRY_TYPE_UNSPECIFIED: Default unknown type
      TABLE: The type of entry that has a GoogleSQL schema, including logical
        views.
      DATA_STREAM: An entry type which is used for streaming entries. Example
        - Pub/Sub.
    """
    ENTRY_TYPE_UNSPECIFIED = 0
    TABLE = 1
    DATA_STREAM = 2

  bigqueryTableSpec = _messages.MessageField('GoogleCloudDatacatalogV1beta1BigQueryTableSpec', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  linkedResource = _messages.StringField(4)
  name = _messages.StringField(5)
  schema = _messages.MessageField('GoogleCloudDatacatalogV1beta1Schema', 6)
  sourceSystemTimestamps = _messages.MessageField('GoogleCloudDatacatalogV1beta1SystemTimestamps', 7)
  type = _messages.EnumField('TypeValueValuesEnum', 8)


class GoogleCloudDatacatalogV1beta1Schema(_messages.Message):
  r"""Represents a schema (e.g. BigQuery, GoogleSQL, Avro schema).

  Fields:
    columns: Required. Schema of columns. A maximum of 10,000 columns and sub-
      columns can be specified.
  """

  columns = _messages.MessageField('GoogleCloudDatacatalogV1beta1ColumnSchema', 1, repeated=True)


class GoogleCloudDatacatalogV1beta1SystemTimestamps(_messages.Message):
  r"""Timestamps about this resource according to a particular system.

  Fields:
    createTime: Output only. The creation time of the resource within the
      given system.
    expireTime: Output only. The expiration time of the resource within the
      given system.
    updateTime: Output only. The last-modified time of the resource within the
      given system.
  """

  createTime = _messages.StringField(1)
  expireTime = _messages.StringField(2)
  updateTime = _messages.StringField(3)


class GoogleCloudDatacatalogV1beta1ViewSpec(_messages.Message):
  r"""Table view specification.

  Fields:
    viewQuery: Output only. The query that defines the table view.
  """

  viewQuery = _messages.StringField(1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
