"""Generated message classes for healthcare version v1alpha.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'healthcare'


class Annotation(_messages.Message):
  r"""An annotation record.

  Fields:
    annotationSource: Details of the source.
    imageAnnotation: Annnotations for images, e.g., bounding polygons.
    name: Output only. Resource name of the Annotation, of the form `projects/
      {project_id}/locations/{location_id}/datasets/{dataset_id}/annotationSto
      res/{annotation_store_id}/annotations/{annotation_id}`.
    resourceAnnotation: Annotations for resource, e.g., classification tags.
    textAnnotation: Annotations for sentitive texts, e.g., range of such
      texts.
  """

  annotationSource = _messages.MessageField('AnnotationSource', 1)
  imageAnnotation = _messages.MessageField('ImageAnnotation', 2)
  name = _messages.StringField(3)
  resourceAnnotation = _messages.MessageField('ResourceAnnotation', 4)
  textAnnotation = _messages.MessageField('SensitiveTextAnnotation', 5)


class AnnotationSource(_messages.Message):
  r"""AnnotationSource holds the source information of the annotation.

  Fields:
    cloudHealthcareSource: Cloud Healthcare API resource.
  """

  cloudHealthcareSource = _messages.MessageField('CloudHealthcareSource', 1)


class AnnotationStore(_messages.Message):
  r"""An Annotation store that can store annotation resources such as labels
  and tags for text, image and audio.

  Messages:
    LabelsValue: User-supplied key-value pairs used to organize Annotation
      stores.  Label keys must be between 1 and 63 characters long, have a
      UTF-8 encoding of maximum 128 bytes, and must conform to the following
      PCRE regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional,
      must be between 1 and 63 characters long, have a UTF-8 encoding of
      maximum 128 bytes, and must conform to the following PCRE regular
      expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be
      associated with a given store.

  Fields:
    labels: User-supplied key-value pairs used to organize Annotation stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.
    name: Output only. Resource name of the Annotation store, of the form `pro
      jects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotat
      ionStores/{annotation_store_id}`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-supplied key-value pairs used to organize Annotation stores.
    Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
    of maximum 128 bytes, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be between
    1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and
    must conform to the following PCRE regular expression:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated with
    a given store.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  name = _messages.StringField(2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class BigQueryDestination(_messages.Message):
  r"""The BigQuery table to which the output should be written.

  Fields:
    dataset: Required. The BigQuery dataset to which the DICOM store should be
      exported. If this dataset does not exist, the export call returns an
      error.
    overwriteTable: If the destination table already exists and this flag is
      `TRUE`, the table will be overwritten by the contents of the DICOM
      store. If the flag is not set and the destination table already exists,
      the export call returns an error.
    table: Required. The BigQuery table to which the DICOM store should be
      written. If this table does not exist, a new table with the given name
      will be created.
  """

  dataset = _messages.StringField(1)
  overwriteTable = _messages.BooleanField(2)
  table = _messages.StringField(3)


class BigQueryLocation(_messages.Message):
  r"""BigQuery dataset location.

  Fields:
    datasetId: ID of the dataset that houses the BigQuery tables.
    projectId: ID of the project that owns the BigQuery datasets.
    schemaConfig: The configuration for the exported BigQuery schema.
  """

  datasetId = _messages.StringField(1)
  projectId = _messages.StringField(2)
  schemaConfig = _messages.MessageField('SchemaConfig', 3)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: The G Suite domain (primary) that represents all
      the    users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BoundingPoly(_messages.Message):
  r"""A bounding polygon for the detected image annotation.

  Fields:
    label: A string attribute.
    vertices: A Vertex attribute.
  """

  label = _messages.StringField(1)
  vertices = _messages.MessageField('Vertex', 2, repeated=True)


class CloudHealthcareSource(_messages.Message):
  r"""Cloud Healthcare API resource.

  Fields:
    name: Full path of a Cloud Healthcare API resource.
  """

  name = _messages.StringField(1)


class CreateMessageRequest(_messages.Message):
  r"""Creates a new message.

  Fields:
    message: HL7v2 message.
  """

  message = _messages.MessageField('Message', 1)


class Dataset(_messages.Message):
  r"""A message representing a health dataset.  A health dataset represents a
  collection of healthcare data pertaining to one or more patients. This may
  include multiple modalities of healthcare data, such as electronic medical
  records or medical imaging data.

  Fields:
    name: Output only. Resource name of the dataset, of the form
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
    timeZone: The default timezone used by this dataset. Must be a either a
      valid IANA time zone name such as "America/New_York" or empty, which
      defaults to UTC. This is used for parsing times in resources (e.g., HL7
      messages) where no explicit timezone is specified.
  """

  name = _messages.StringField(1)
  timeZone = _messages.StringField(2)


class DeidentifyConfig(_messages.Message):
  r"""Configures de-id options specific to different types of content. Each
  submessage customizes the handling of an https://tools.ietf.org/html/rfc6838
  media type or subtype. Configs are applied in a nested manner at runtime.

  Fields:
    dicom: Configures de-id of application/DICOM content.
    fhir: Configures de-id of application/FHIR content.
    image: Configures de-identification of image pixels wherever they are
      found in the source_dataset.
  """

  dicom = _messages.MessageField('DicomConfig', 1)
  fhir = _messages.MessageField('FhirConfig', 2)
  image = _messages.MessageField('ImageConfig', 3)


class DeidentifyDatasetRequest(_messages.Message):
  r"""Redacts identifying information from the specified dataset.

  Fields:
    config: Deidentify configuration
    destinationDataset: The name of the dataset resource to which the redacted
      data should be written (e.g.,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`).
      The new dataset must not exist, or the request will fail.
  """

  config = _messages.MessageField('DeidentifyConfig', 1)
  destinationDataset = _messages.StringField(2)


class Detail(_messages.Message):
  r"""Contains multiple sensitive information findings for each resource
  slice.

  Fields:
    findings: A Finding attribute.
  """

  findings = _messages.MessageField('Finding', 1, repeated=True)


class DicomConfig(_messages.Message):
  r"""Specifies the parameters needed for de-identification of DICOM stores.

  Fields:
    whitelistTags: Tags to be whitelisted, for example "PatientID",
      "0010,0010". Any tag that is whitelisted will copied as is. All other
      tags will be omitted.
  """

  whitelistTags = _messages.StringField(1, repeated=True)


class DicomStore(_messages.Message):
  r"""Represents a DICOM store.

  Fields:
    name: Output only. Resource name of the DICOM store, of the form `projects
      /{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/
      {dicom_store_id}`.
    notificationConfig: Notification destination for new DICOM instances.
      Supplied by the client.
  """

  name = _messages.StringField(1)
  notificationConfig = _messages.MessageField('NotificationConfig', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class ExportDicomDataRequest(_messages.Message):
  r"""Exports data from the specified DICOM store. If a given resource (e.g.,
  a DICOM object with the same SOPInstance UID) already exists in the output,
  it is overwritten with the version in the source dataset. Exported DICOM
  data will persist when the DICOM store from which it was exported is
  deleted.

  Fields:
    outputConfig: Specifies where the exported data should be placed.
  """

  outputConfig = _messages.MessageField('OutputConfig', 1)


class ExportResourcesRequest(_messages.Message):
  r"""Request to export resources.

  Fields:
    bigqueryDestinationLocation: The BigQuery destination location. The output
      will be one BigQuery table per resource type.
    gcsDestinationLocation: The Cloud Storage destination location. Specify a
      path to a Cloud Storage bucket or folder rather than a concrete object.
      The exported outputs are organized by FHIR resource types. The server
      will create one object per resource type. Each object contains newline
      delimited JSON, and each line is a FHIR resource.
  """

  bigqueryDestinationLocation = _messages.MessageField('BigQueryLocation', 1)
  gcsDestinationLocation = _messages.MessageField('GcsDataLocation', 2)


class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class FhirConfig(_messages.Message):
  r"""Specifies how de-identification of a FHIR store should be handled."""


class FhirStore(_messages.Message):
  r"""Represents a FHIR store.

  Fields:
    disableReferentialIntegrity: Whether to disable referential integrity in
      this FHIR store. This field is immutable after FHIR store creation. The
      default value is false, meaning that the API will enforce referential
      integrity and fail the requests that will result in inconsistent state
      in the FHIR store. When this field is set to true, the API will skip
      referential integrity check. Consequently, operations that rely on
      references, such as GetPatientEverything, will not return all the
      results if broken references exist.
    disableResourceVersioning: Whether to disable resource versioning for this
      FHIR store. This field can not be changed after the creation of FHIR
      store. If set to false, which is the default behavior, all write
      operations will cause historical versions to be recorded automatically.
      The historical versions can be fetched through the history APIs, but
      cannot be updated. If set to true, no historical versions will be kept.
      The server will send back errors for attempts to read the historical
      versions.
    enableUpdateCreate: Whether this FHIR store has the [updateCreate
      capability](https://www.hl7.org/fhir/capabilitystatement-
      definitions.html#CapabilityStatement.rest.resource.updateCreate). This
      determines if the client can use an Update operation to create a new
      resource with a client-specified ID. If false, all IDs are server-
      assigned through the Create operation and attempts to Update a non-
      existent resource will return errors. Please treat the audit logs with
      appropriate levels of care if client-specified resource IDs contain
      sensitive data such as patient identifiers, those IDs will be part of
      the FHIR resource path recorded in Cloud audit logs and Cloud Pub/Sub
      notifications.
    name: Output only. Resource name of the FHIR store, of the form
      `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`
      .
    notificationConfig: If non-empty, publish all resource modifications of
      this FHIR store to this destination. The Cloud Pub/Sub message
      attributes will contain a map with a string describing the action that
      has triggered the notification, e.g. "action":"CreateResource".
  """

  disableReferentialIntegrity = _messages.BooleanField(1)
  disableResourceVersioning = _messages.BooleanField(2)
  enableUpdateCreate = _messages.BooleanField(3)
  name = _messages.StringField(4)
  notificationConfig = _messages.MessageField('NotificationConfig', 5)


class Finding(_messages.Message):
  r"""A Finding object.

  Fields:
    end: Zero-based ending index of the found text, exclusively.
    infoType: The type of information stored in this text range (e.g.
      HumanName, BirthDate, Address, etc.)
    start: Zero-based starting index of the found text, inclusively.
  """

  end = _messages.IntegerField(1)
  infoType = _messages.StringField(2)
  start = _messages.IntegerField(3)


class GcsDataLocation(_messages.Message):
  r"""Google Cloud Storage location.

  Fields:
    gcsUri: The gcs_uri must be in the format "gs://bucket/path/to/object".
      The gcs_uri may include wildcards in the "path/to/object" part to to
      indicate potential matching of multiple objects. Supported wildcards:
      '*' to match 0 or more non-separator characters   '**' to match 0 or
      more characters (including separators). Only   supported at the end of a
      path and with no other wildcards.   '?' to match 1 character.
  """

  gcsUri = _messages.StringField(1)


class GcsDestination(_messages.Message):
  r"""The Google Cloud Storage location to which the output should be written.

  Fields:
    mimeType: MIME types supported by DICOM spec. Each file will be written in
      the following format:
      `.../{study_id}/{series_id}/{instance_id}[/{frame_number}].{extension}`
      The frame_number component will exist only for multi-frame instances.
      Refer to the DICOM conformance statement for permissible MIME types:
      https://cloud.google.com/healthcare/docs/dicom#wado-rs  The following
      extensions will be used for output files:   application/dicom -> .dcm
      image/jpeg -> .jpg   image/png -> .png  If unspecified, the instances
      will be exported in their original DICOM format.
    uriPrefix: URI for a Google Cloud Storage directory to which result files
      should be written (e.g., `gs://bucket-id/path/to/destination/dir`). If
      there is no trailing slash, the service will append one when composing
      the object path. The user is responsible for creating the Google Cloud
      Storage bucket referenced in `uri_prefix`.
  """

  mimeType = _messages.StringField(1)
  uriPrefix = _messages.StringField(2)


class GetIamPolicyRequest(_messages.Message):
  r"""Request message for `GetIamPolicy` method."""


class GoogleCloudHealthcareV1alphaFhirRestExportResourcesResponse(_messages.Message):
  r"""Final response of exporting resources. This structure will be included
  in the response to describe the detailed outcome. It will only be included
  when the operation finishes.

  Fields:
    name: The FHIR store name of the resources that have been exported, in the
      format `projects/{project_id}/locations/{location_id}/datasets/{dataset_
      id}/fhirStores/{fhir_store_id}`.
    resourceCount: The total number of resources exported from the requested
      FHIR store.
  """

  name = _messages.StringField(1)
  resourceCount = _messages.IntegerField(2)


class GoogleCloudHealthcareV1alphaFhirRestImportResourcesResponse(_messages.Message):
  r"""Final response of importing resources. This structure will be included
  in the response to describe the detailed outcome. It will only be included
  when the operation finishes.

  Fields:
    errorCount: The number of resources that had errors.
    inputSize: The total number of resources included in the source data. This
      is the sum of the success and error counts.
    name: The FHIR store name the resources have been imported to, in the
      format `projects/{project_id}/locations/{location_id}/datasets/{dataset_
      id}/fhirStores/{fhir_store_id}`.
    successCount: The number of resources that have been imported.
  """

  errorCount = _messages.IntegerField(1)
  inputSize = _messages.IntegerField(2)
  name = _messages.StringField(3)
  successCount = _messages.IntegerField(4)


class GoogleCloudHealthcareV1alphaGcsSource(_messages.Message):
  r"""The Google Cloud Storage location for the input content.

  Fields:
    contentUri: Points to a [Google Cloud
      Storage](https://cloud.google.com/storage/) URI containing file(s) with
      content only. The URI must be in the following format: `gs://bucket-id
      /object-id`. The URI can include wildcards in `object-id` and thus
      identify multiple files. Supported wildcards:  '*' to match 0 or more
      non-separator characters  '**' to match 0 or more characters (including
      separators). Must be used at       the end of a path and with no other
      wildcards in the       path. Can also be used with a file extension
      (such as .dcm), which       imports all files with the extension in the
      specified directory and       its sub-directories. For example,
      `gs://bucket-id/directory-id/**.dcm` imports all files with .dcm
      extensions in `directory-id/` and its sub-directories.  '?' to match 1
      character Returns [google.rpc.Code.INVALID_ARGUMENT] for all other URI
      formats. Files matching the wildcard are expected to contain content
      only, no metadata.
  """

  contentUri = _messages.StringField(1)


class HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsCreateRequest
  object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    parent: The name of the Annotation store this annotation belongs to. For
      example, `projects/my-project/locations/us-
      central1/datasets/mydataset/annotationStores/myannotationstore`.
  """

  annotation = _messages.MessageField('Annotation', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsDeleteRequest
  object.

  Fields:
    name: The resource name of the Annotation to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsGetRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsGetRequest
  object.

  Fields:
    name: The resource name of the Annotation to retrieve.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsListRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsListRequest
  object.

  Fields:
    filter: Restricts Annotations returned to those matching a filter. Syntax:
      https://cloud.google.com/appengine/docs/standard/python/search/query_str
      ings Fields/functions available for filtering are: - source_version
    pageSize: Limit on the number of Annotations to return in a single
      response. If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the Annotation store to retrieve Annotations from.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresAnnotationsPatchRequest
  object.

  Fields:
    annotation: A Annotation resource to be passed as the request body.
    name: Output only. Resource name of the Annotation, of the form `projects/
      {project_id}/locations/{location_id}/datasets/{dataset_id}/annotationSto
      res/{annotation_store_id}/annotations/{annotation_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  annotation = _messages.MessageField('Annotation', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsAnnotationStoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresCreateRequest
  object.

  Fields:
    annotationStore: A AnnotationStore resource to be passed as the request
      body.
    annotationStoreId: The ID of the Annotation store that is being created.
      The string must match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the dataset this Annotation store belongs to.
  """

  annotationStore = _messages.MessageField('AnnotationStore', 1)
  annotationStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresDeleteRequest
  object.

  Fields:
    name: The resource name of the Annotation store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresGetRequest object.

  Fields:
    name: The resource name of the Annotation store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresListRequest object.

  Fields:
    filter: Restricts stores returned to those matching a filter. Syntax: http
      s://cloud.google.com/appengine/docs/standard/python/search/query_strings
      Only filtering on labels is supported, for example `labels.key=value`.
    pageSize: Limit on the number of Annotation stores to return in a single
      response. If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class HealthcareProjectsLocationsDatasetsAnnotationStoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresPatchRequest
  object.

  Fields:
    annotationStore: A AnnotationStore resource to be passed as the request
      body.
    name: Output only. Resource name of the Annotation store, of the form `pro
      jects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotat
      ionStores/{annotation_store_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  annotationStore = _messages.MessageField('AnnotationStore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsAnnotationStoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsAnnotationStoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsCreateRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    datasetId: The ID of the dataset that is being created. The string must
      match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the project in which the dataset should be created
      (e.g., `projects/{project_id}/locations/{location_id}`).
  """

  dataset = _messages.MessageField('Dataset', 1)
  datasetId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDeidentifyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDeidentifyRequest object.

  Fields:
    deidentifyDatasetRequest: A DeidentifyDatasetRequest resource to be passed
      as the request body.
    sourceDataset: Source dataset resource name. (e.g.,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`).
  """

  deidentifyDatasetRequest = _messages.MessageField('DeidentifyDatasetRequest', 1)
  sourceDataset = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDeleteRequest object.

  Fields:
    name: The name of the dataset to delete (e.g.,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`).
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresCreateRequest object.

  Fields:
    dicomStore: A DicomStore resource to be passed as the request body.
    dicomStoreId: The ID of the DICOM store that is being created. The string
      must match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the dataset this DICOM store belongs to.
  """

  dicomStore = _messages.MessageField('DicomStore', 1)
  dicomStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresDeleteRequest object.

  Fields:
    name: The resource name of the DICOM store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresDicomWebDicomWebDeleteRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresDicomWebDicomWebDeleteRequest
  object.

  Fields:
    dicomWebPath: The path of the DICOMweb request, as specified in the WADO-
      RS standard.
    parent: The name of the DICOM store that is being accessed (e.g., `project
      s/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores
      /{dicom_store_id}`).
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresDicomWebDicomWebGetRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresDicomWebDicomWebGetRequest
  object.

  Fields:
    dicomWebPath: The path of the DICOMweb request, as specified in the STOW-
      RS, WADO-RS, or QIDO-RS standard (e.g., studies/{study_id}/series`).
    parent: The name of the DICOM store that is being accessed (e.g., `project
      s/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores
      /{dicom_store_id}`).
  """

  dicomWebPath = _messages.StringField(1, required=True)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresDicomWebDicomWebPostRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresDicomWebDicomWebPostRequest
  object.

  Fields:
    dicomWebPath: The path of the DICOMweb request, as specified in the STOW-
      RS, WADO-RS, or QIDO-RS standard (e.g., studies/{study_id}`).
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the DICOM store that is being accessed (e.g., `project
      s/{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores
      /{dicom_store_id}`).
  """

  dicomWebPath = _messages.StringField(1, required=True)
  httpBody = _messages.MessageField('HttpBody', 2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresExportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresExportRequest object.

  Fields:
    exportDicomDataRequest: A ExportDicomDataRequest resource to be passed as
      the request body.
    name: The DICOM store resource name from which the data should be exported
      (e.g., `projects/{project_id}/locations/{location_id}/datasets/{dataset_
      id}/dicomStores/{dicom_store_id}`).
  """

  exportDicomDataRequest = _messages.MessageField('ExportDicomDataRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresGetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresGetRequest object.

  Fields:
    name: The resource name of the DICOM store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresImportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresImportRequest object.

  Fields:
    importDicomDataRequest: A ImportDicomDataRequest resource to be passed as
      the request body.
    name: The name of the DICOM store resource into which the data is imported
      (e.g., `projects/{project_id}/locations/{location_id}/datasets/{dataset_
      id}/dicomStores/{dicom_store_id}`).
  """

  importDicomDataRequest = _messages.MessageField('ImportDicomDataRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresListRequest object.

  Fields:
    pageSize: Limit on the number of DICOM stores to return in a single
      response. If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresPatchRequest object.

  Fields:
    dicomStore: A DicomStore resource to be passed as the request body.
    name: Output only. Resource name of the DICOM store, of the form `projects
      /{project_id}/locations/{location_id}/datasets/{dataset_id}/dicomStores/
      {dicom_store_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  dicomStore = _messages.MessageField('DicomStore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsDicomStoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsDicomStoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresCreateRequest object.

  Fields:
    fhirStore: A FhirStore resource to be passed as the request body.
    fhirStoreId: The ID of the FHIR store that is being created. The string
      must match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the dataset this FHIR store belongs to.
  """

  fhirStore = _messages.MessageField('FhirStore', 1)
  fhirStoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresDeleteRequest object.

  Fields:
    name: The resource name of the FHIR store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresExecuteBundleRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresExecuteBundleRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: Name of the FHIR store in which this bundle will be executed.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresExportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresExportRequest object.

  Fields:
    exportResourcesRequest: A ExportResourcesRequest resource to be passed as
      the request body.
    name: The FHIR store name to export from. The name should be in the format
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhi
      rStores/{fhir_store_id}`.
  """

  exportResourcesRequest = _messages.MessageField('ExportResourcesRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresGetIamPolicyRequest
  object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresGetMetadataRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresGetMetadataRequest
  object.

  Fields:
    name: Name of the FHIR store to retrieve the capabilities for.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresGetRequest object.

  Fields:
    name: The resource name of the FHIR store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresImportRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresImportRequest object.

  Fields:
    importResourcesRequest: A ImportResourcesRequest resource to be passed as
      the request body.
    name: The FHIR store name to import FHIR resources to. The name should be
      in the format `projects/{project_id}/locations/{location_id}/datasets/{d
      ataset_id}/fhirStores/{fhir_store_id}`.
  """

  importResourcesRequest = _messages.MessageField('ImportResourcesRequest', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresListRequest object.

  Fields:
    pageSize: Limit on the number of FHIR stores to return in a single
      response.  If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresPatchRequest object.

  Fields:
    fhirStore: A FhirStore resource to be passed as the request body.
    name: Output only. Resource name of the FHIR store, of the form
      `projects/{project_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`
      .
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  fhirStore = _messages.MessageField('FhirStore', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesConditionalDeleteResourceRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesConditionalDelet
  eResourceRequest object.

  Fields:
    parent: The name of the FHIR store this resource belongs to.
    type: The type of the resource to update.
  """

  parent = _messages.StringField(1, required=True)
  type = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesConditionalPatchResourceRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesConditionalPatch
  ResourceRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the FHIR store this resource belongs to.
    type: The type of the resource to update.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)
  type = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesConditionalUpdateResourceRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesConditionalUpdat
  eResourceRequest object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the FHIR store this resource belongs to.
    type: The type of the resource to update.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)
  type = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesCreateResourceRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresResourcesCreateResourceRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    parent: The name of the FHIR store this resource belongs to.
    type: The type of the resource to create.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  parent = _messages.StringField(2, required=True)
  type = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesDeletePurgeRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresResourcesDeletePurgeRequest
  object.

  Fields:
    name: The name of the resource to purge.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesDeleteRequest
  object.

  Fields:
    name: The name of the resource to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesGetMetadataRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresResourcesGetMetadataRequest
  object.

  Fields:
    name: Name of the FHIR store to retrieve the capabilities for.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesGetRequest
  object.

  Fields:
    name: The name of the resource to retrieve.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesHistoryGetRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresResourcesHistoryGetRequest
  object.

  Fields:
    name: The name of the resource version to retrieve.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesHistoryListRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresResourcesHistoryListRequest
  object.

  Fields:
    name: The name of the resource to retrieve.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesPatchRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    name: The name of the resource to update.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesPatientGetEverythingRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesPatientGetEveryt
  hingRequest object.

  Fields:
    end: The response includes records prior to the end date. If no end date
      is provided, all records subsequent to the start date are in scope.
    name: Name of the patient for which the information is required.
    start: The response includes records subsequent to the start date. If no
      start date is provided, all records prior to the end date are in scope.
  """

  end = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  start = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesSearchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesSearchRequest
  object.

  Fields:
    parent: Name of the FHIR store to retrieve resources from.
    searchResourcesRequest: A SearchResourcesRequest resource to be passed as
      the request body.
  """

  parent = _messages.StringField(1, required=True)
  searchResourcesRequest = _messages.MessageField('SearchResourcesRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesSearchResourcesRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsFhirStoresResourcesSearchResourcesRequest
  object.

  Fields:
    parent: Name of the FHIR store to retrieve resources from.
    resourceType: The type of the resource to search.
  """

  parent = _messages.StringField(1, required=True)
  resourceType = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresResourcesUpdateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresResourcesUpdateRequest
  object.

  Fields:
    httpBody: A HttpBody resource to be passed as the request body.
    name: The name of the resource to update.
  """

  httpBody = _messages.MessageField('HttpBody', 1)
  name = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresSecurityLabelsGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresSecurityLabelsGetIamPolic
  yRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsFhirStoresSecurityLabelsSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresSecurityLabelsSetIamPolic
  yRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsFhirStoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsGetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsGetRequest object.

  Fields:
    name: The name of the dataset to read (e.g.,
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`).
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresCreateRequest object.

  Fields:
    hl7V2Store: A Hl7V2Store resource to be passed as the request body.
    hl7V2StoreId: The ID of the HL7v2 store that is being created. The string
      must match the following regex: `[\p{L}\p{N}_\-\.]{1,256}`.
    parent: The name of the dataset this HL7v2 store belongs to.
  """

  hl7V2Store = _messages.MessageField('Hl7V2Store', 1)
  hl7V2StoreId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresDeleteRequest object.

  Fields:
    name: The resource name of the HL7v2 store to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresGetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresGetRequest object.

  Fields:
    name: The resource name of the HL7v2 store to get.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresListRequest object.

  Fields:
    pageSize: Limit on the number of HL7v2 stores to return in a single
      response. If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the dataset.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesCreateRequest
  object.

  Fields:
    createMessageRequest: A CreateMessageRequest resource to be passed as the
      request body.
    parent: The name of the dataset this message belongs to.
  """

  createMessageRequest = _messages.MessageField('CreateMessageRequest', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesDeleteRequest
  object.

  Fields:
    name: The resource name of the HL7v2 message to delete.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesGetRequest
  object.

  Enums:
    ViewValueValuesEnum: Specifies which parts of the Message resource should
      be returned in the response.

  Fields:
    name: The resource name of the HL7v2 message to retrieve.
    view: Specifies which parts of the Message resource should be returned in
      the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Specifies which parts of the Message resource should be returned in
    the response.

    Values:
      MESSAGE_VIEW_UNSPECIFIED: <no description>
      RAW_ONLY: <no description>
      PARSED_ONLY: <no description>
      FULL: <no description>
    """
    MESSAGE_VIEW_UNSPECIFIED = 0
    RAW_ONLY = 1
    PARSED_ONLY = 2
    FULL = 3

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesIngestRequest
  object.

  Fields:
    ingestMessageRequest: A IngestMessageRequest resource to be passed as the
      request body.
    parent: The name of the HL7v2 store this message belongs to.
  """

  ingestMessageRequest = _messages.MessageField('IngestMessageRequest', 1)
  parent = _messages.StringField(2, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesListRequest
  object.

  Fields:
    filter: Restricts messages returned to those matching a filter. Syntax: ht
      tps://cloud.google.com/appengine/docs/standard/python/search/query_strin
      gs Fields/functions available for filtering are: - message_type, from
      the MSH-9 segment, e.g. 'NOT message_type = "ADT"' - send_date or
      sendDate, the YYYY-MM-DD date the message was sent in the   dataset's
      time_zone, from the MSH-7 segment; e.g.   'send_date < "2017-01-02"' -
      send_time, the timestamp of when the message was sent, using the RFC3339
      time format for comparisons, from the MSH-7 segment; e.g. 'send_time <
      "2017-01-02T00:00:00-05:00"' - send_facility, the hospital/trust that
      the message came from, from the   MSH-4 segment, e.g. 'send_facility =
      "RAL"' - HL7RegExp(expr), which does regular expression matching of expr
      against   the HL7 message payload using re2
      (http://code.google.com/p/re2/)   syntax; e.g.
      'HL7RegExp("^.*\|.*\|CERNER")' - PatientId(value, type), which matches
      if the message lists a patient   having an ID of the given value and
      type in the PID-2, PID-3, or PID-4   segments; e.g. 'PatientId("123456",
      "MRN")' - HasLabel(x), a boolean returning true if the message has a
      label with   key x (having any value) set using the labels map in
      Message; e.g.   'HasLabel("priority")' - Label(x), a string value of the
      label with key x as set using the labels   map in Message, e.g.
      'Label("priority") = "high"' Negation on the patient ID function and the
      label function are not supported, e.g. invalid queries: 'NOT
      PatientId("123456", "MRN")', 'NOT HasLabel("tag1")', 'NOT Label("tag2")
      = "val2"'. Conjunction of multiple patient ID functions is not
      supported, e.g. an invalid query: 'PatientId("123456", "MRN") AND
      PatientId("456789", "MRN")'. Conjunction of multiple label functions is
      also not supported, e.g. an invalid query: 'HasLabel("tag1") AND
      Label("tag2") = "val2"'. Conjunction of one patient ID function, one
      label function and other fields is supported, e.g. a valid query:
      'PatientId("123456", "MRN") AND HasLabel("tag1") AND message_type =
      "ADT"'.
    orderBy: Orders messages returned by the specified order_by clause.
      Syntax:
      https://cloud.google.com/apis/design/design_patterns#sorting_order
      Fields available for ordering are: - send_time
    pageSize: Limit on the number of messages to return in a single response.
      If zero the default page size of 100 is used.
    pageToken: The next_page_token value returned from the previous List
      request, if any.
    parent: Name of the HL7v2 store to retrieve messages from.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresMessagesPatchRequest
  object.

  Fields:
    message: A Message resource to be passed as the request body.
    name: Resource name of the Message, of the form `projects/{project_id}/dat
      asets/{dataset_id}/hl7V2Stores/{hl7_v2_store_id}/messages/{message_id}`.
      Assigned by the server.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask Only the `labels` field
      is allowed to be updated. The labels in the request will be merged with
      the existing set of labels. Existing labels with the same keys will be
      updated.
  """

  message = _messages.MessageField('Message', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresPatchRequest object.

  Fields:
    hl7V2Store: A Hl7V2Store resource to be passed as the request body.
    name: Output only. Resource name of the HL7v2 store, of the form `projects
      /{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  hl7V2Store = _messages.MessageField('Hl7V2Store', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsHl7V2StoresSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest(_messages.Message):
  r"""A
  HealthcareProjectsLocationsDatasetsHl7V2StoresTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsDatasetsListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsListRequest object.

  Fields:
    pageSize: The maximum number of items to return. Capped to 100 if not
      specified. May not be larger than 1000.
    pageToken: The next_page_token value returned from a previous List
      request, if any.
    parent: The name of the project whose datasets should be listed (e.g.,
      `projects/{project_id}/locations/{location_id}`).
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class HealthcareProjectsLocationsDatasetsOperationsGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsDatasetsOperationsListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class HealthcareProjectsLocationsDatasetsPatchRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsPatchRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    name: Output only. Resource name of the dataset, of the form
      `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}`.
    updateMask: The update mask applies to the resource. For the `FieldMask`
      definition, see https://developers.google.com/protocol-
      buffers/docs/reference/google.protobuf#fieldmask
  """

  dataset = _messages.MessageField('Dataset', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class HealthcareProjectsLocationsDatasetsSetIamPolicyRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsDatasetsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class HealthcareProjectsLocationsGetRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class HealthcareProjectsLocationsListRequest(_messages.Message):
  r"""A HealthcareProjectsLocationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The resource that owns the locations collection, if applicable.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Hl7V2Store(_messages.Message):
  r"""Represents an HL7v2 store.

  Fields:
    name: Output only. Resource name of the HL7v2 store, of the form `projects
      /{project_id}/datasets/{dataset_id}/hl7V2Stores/{hl7v2_store_id}`.
    notificationConfig: The notification destination all messages (both Ingest
      & Create) are published on. Only the message name is sent as part of the
      notification. If this is unset, no notifications will be sent. Supplied
      by the client.
    parserConfig: The configuration for the parser. It determines how the
      server parses the messages.
  """

  name = _messages.StringField(1)
  notificationConfig = _messages.MessageField('NotificationConfig', 2)
  parserConfig = _messages.MessageField('ParserConfig', 3)


class HttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page.   This message can be used both in streaming and non-streaming
  API methods in the request as well as the response.  It can be used as a
  top-level request field, which is convenient if one wants to extract
  parameters from either the URL or HTTP template into the request fields and
  also want access to the raw HTTP body.  Example:      message
  GetResourceRequest {       // A unique request id.       string request_id =
  1;        // The raw HTTP body is bound to this field.
  google.api.HttpBody http_body = 2;     }      service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);       rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty);     }
  Example with streaming methods:      service CaldavService {       rpc
  GetCalendar(stream google.api.HttpBody)         returns (stream
  google.api.HttpBody);       rpc UpdateCalendar(stream google.api.HttpBody)
  returns (stream google.api.HttpBody);     }  Use of this type only changes
  how the request and response bodies are handled, all other features will
  continue to work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class ImageAnnotation(_messages.Message):
  r"""Image annotation.

  Fields:
    boundingPolys: The list of polygons outlining the sensitive regions in the
      image.
  """

  boundingPolys = _messages.MessageField('BoundingPoly', 1, repeated=True)


class ImageConfig(_messages.Message):
  r"""Specifies how de-identification of image pixel should be handled.

  Fields:
    redactAllText: If true, all text found in the image is redacted.
  """

  redactAllText = _messages.BooleanField(1)


class ImportDicomDataErrorDetails(_messages.Message):
  r"""Returns the errors encountered during DICOM store import.

  Fields:
    errors: Contains errors encountered in imports of individual resources
      (e.g., a Google Cloud Storage object).
  """

  errors = _messages.MessageField('ImportError', 1, repeated=True)


class ImportDicomDataRequest(_messages.Message):
  r"""Imports data into the specified DICOM store. Returns an error if any of
  the files to import are not DICOM files. This API will accept duplicate
  DICOM instances, by simply ignoring the newly pushed instance (it will not
  overwrite).

  Fields:
    inputConfig: Specifies where the imported data resides.
  """

  inputConfig = _messages.MessageField('InputConfig', 1)


class ImportError(_messages.Message):
  r"""Contains error status for each import failure.

  Fields:
    resource: Resource name.
    status: Error status associated with resource.
  """

  resource = _messages.StringField(1)
  status = _messages.MessageField('Status', 2)


class ImportResourcesRequest(_messages.Message):
  r"""Request to import resources. The FHIR resources to be imported must have
  client supplied IDs. The server will retain the resource IDs. The import
  operation is idempotent. Retry will overwrite existing data identified by
  client supplied IDs. The import operation is not transactional. The server
  will not roll back any committed changes upon partial failures.

  Enums:
    ContentStructureValueValuesEnum: The content structure in the source
      location. The default is BUNDLE.

  Fields:
    contentStructure: The content structure in the source location. The
      default is BUNDLE.
    gcsErrorLocation: The Cloud Storage bucket/folder path to write files that
      contain error details.
    gcsSourceLocation: Cloud Storage source data locations. Each Cloud Storage
      object should be a text file that contains newline delimited JSON
      structures conforming to FHIR standard.
  """

  class ContentStructureValueValuesEnum(_messages.Enum):
    r"""The content structure in the source location. The default is BUNDLE.

    Values:
      CONTENT_STRUCTURE_UNSPECIFIED: <no description>
      BUNDLE: Each unit is a bundle, which contains one or more resources.
      RESOURCE: Each unit is a single resource.
    """
    CONTENT_STRUCTURE_UNSPECIFIED = 0
    BUNDLE = 1
    RESOURCE = 2

  contentStructure = _messages.EnumField('ContentStructureValueValuesEnum', 1)
  gcsErrorLocation = _messages.MessageField('GcsDataLocation', 2)
  gcsSourceLocation = _messages.MessageField('GcsDataLocation', 3)


class IngestMessageRequest(_messages.Message):
  r"""Ingests a message into the specified HL7v2 store.

  Fields:
    message: HL7v2 message to ingest.
  """

  message = _messages.MessageField('Message', 1)


class IngestMessageResponse(_messages.Message):
  r"""Acknowledges that a message has been ingested into the specified HL7v2
  store.

  Fields:
    hl7Ack: HL7v2 ACK message.
    message: Created message resource.
  """

  hl7Ack = _messages.BytesField(1)
  message = _messages.MessageField('Message', 2)


class InputConfig(_messages.Message):
  r"""Specifies the location(s) from which data should be imported.

  Fields:
    gcsSource: Files on Google Cloud Storage. To enable the Cloud Healthcare
      API to read from resources in your project (e.g. Google Cloud Storage
      buckets), you must give the consumer Cloud Healthcare API service
      account the proper permissions. The service account is:
      `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`.
      The PROJECT_NUMBER identifies the project that contains the source
      Google Cloud Storage bucket. To get the project number, go to the GCP
      Console Dashboard.  GcsSource requires the `roles/storage.objectViewer`
      Cloud IAM role.
  """

  gcsSource = _messages.MessageField('GoogleCloudHealthcareV1alphaGcsSource', 1)


class ListAnnotationStoresResponse(_messages.Message):
  r"""Lists the Annotation stores in the given dataset.

  Fields:
    annotationStores: The returned Annotation stores. Won't be more Annotation
      stores than the value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  annotationStores = _messages.MessageField('AnnotationStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListAnnotationsResponse(_messages.Message):
  r"""Lists the Annotations in the specified Annotation store.

  Fields:
    annotations: The returned Annotations names. Won't be more values than the
      value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  annotations = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDatasetsResponse(_messages.Message):
  r"""Lists the available datasets.

  Fields:
    datasets: The first page of datasets.
    nextPageToken: Token to retrieve the next page of results, or empty if
      there are no more results in the list.
  """

  datasets = _messages.MessageField('Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListDicomStoresResponse(_messages.Message):
  r"""Lists the DICOM stores in the given dataset.

  Fields:
    dicomStores: The returned DICOM stores. Won't be more DICOM stores than
      the value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  dicomStores = _messages.MessageField('DicomStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFhirStoresResponse(_messages.Message):
  r"""Lists the FHIR stores in the given dataset.

  Fields:
    fhirStores: The returned FHIR stores. Won't be more FHIR stores than the
      value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  fhirStores = _messages.MessageField('FhirStore', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListHl7V2StoresResponse(_messages.Message):
  r"""Lists the HL7v2 stores in the given dataset.

  Fields:
    hl7V2Stores: The returned HL7v2 stores. Won't be more HL7v2 stores than
      the value of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  hl7V2Stores = _messages.MessageField('Hl7V2Store', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListMessagesResponse(_messages.Message):
  r"""Lists the messages in the specified HL7v2 store.

  Fields:
    messages: The returned message names. Won't be more values than the value
      of page_size in the request.
    nextPageToken: Token to retrieve the next page of results or empty if
      there are no more results in the list.
  """

  messages = _messages.StringField(1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents Google Cloud Platform location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Message(_messages.Message):
  r"""A complete HL7v2 message. See
  http://www.hl7.org/implement/standards/index.cfm?ref=common for details on
  the standard.

  Messages:
    LabelsValue: User-supplied key-value pairs used to organize HL7v2 stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.

  Fields:
    createTime: The datetime when the message was created. Set by the server.
    data: Raw message bytes.
    labels: User-supplied key-value pairs used to organize HL7v2 stores.
      Label keys must be between 1 and 63 characters long, have a UTF-8
      encoding of maximum 128 bytes, and must conform to the following PCRE
      regular expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must
      be between 1 and 63 characters long, have a UTF-8 encoding of maximum
      128 bytes, and must conform to the following PCRE regular expression:
      [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated
      with a given store.
    messageType: The message type and trigger event for this message. MSH-9.
    name: Resource name of the Message, of the form `projects/{project_id}/dat
      asets/{dataset_id}/hl7V2Stores/{hl7_v2_store_id}/messages/{message_id}`.
      Assigned by the server.
    parsedData: The parsed version of the raw message data.
    patientIds: All patient IDs listed in the PID-2, PID-3, and PID-4 segments
      of this message.
    sendFacility: The hospital that this message came from. MSH-4.
    sendTime: The datetime the sending application sent this message. MSH-7.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User-supplied key-value pairs used to organize HL7v2 stores.  Label
    keys must be between 1 and 63 characters long, have a UTF-8 encoding of
    maximum 128 bytes, and must conform to the following PCRE regular
    expression: \p{Ll}\p{Lo}{0,62}  Label values are optional, must be between
    1 and 63 characters long, have a UTF-8 encoding of maximum 128 bytes, and
    must conform to the following PCRE regular expression:
    [\p{Ll}\p{Lo}\p{N}_-]{0,63}  No more than 64 labels can be associated with
    a given store.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  data = _messages.BytesField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  messageType = _messages.StringField(4)
  name = _messages.StringField(5)
  parsedData = _messages.MessageField('ParsedData', 6)
  patientIds = _messages.MessageField('PatientId', 7, repeated=True)
  sendFacility = _messages.StringField(8)
  sendTime = _messages.StringField(9)


class NotificationConfig(_messages.Message):
  r"""Specifies where notifications should be sent upon changes to a data
  store.

  Fields:
    pubsubTopic: The [Cloud Pub/Sub](https://cloud.google.com/pubsub/docs/)
      topic that notifications of changes are published on. Supplied by the
      client. PubsubMessage.Data will contain the resource name.
      PubsubMessage.MessageId is the ID of this message. It is guaranteed to
      be unique within the topic. PubsubMessage.PublishTime is the time at
      which the message was published. Notifications are only sent if the
      topic is non-empty. [Topic
      names](https://cloud.google.com/pubsub/docs/overview#names) must be
      scoped to a project. cloud-healthcare@system.gserviceaccount.com must
      have publisher permissions on the given Cloud Pub/Sub topic. Not having
      adequate permissions will cause the calls that send notifications to
      fail.
  """

  pubsubTopic = _messages.StringField(1)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""OperationMetadata provides information about the operation execution.
  Returned in the long-running operation's metadata field.

  Fields:
    apiMethodName: The name of the API method that initiated the operation.
    counter: A ProgressCounter attribute.
    createTime: The time at which the operation was created by the API.
    endTime: The time at which execution was completed.
  """

  apiMethodName = _messages.StringField(1)
  counter = _messages.MessageField('ProgressCounter', 2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)


class OutputConfig(_messages.Message):
  r"""Specifies the location(s) to which data should be exported.

  Fields:
    bigQueryDestination: BigQueryDestination requires two IAM roles:
      `roles/bigquery.dataEditor` and `roles/bigquery.jobUser`.
    gcsDestination: GcsDestination requires `roles/storage.objectAdmin` Cloud
      IAM role. Note that writing a file to the same destination multiple
      times will result in the previous version of the file being overwritten.
  """

  bigQueryDestination = _messages.MessageField('BigQueryDestination', 1)
  gcsDestination = _messages.MessageField('GcsDestination', 2)


class ParsedData(_messages.Message):
  r"""The content of a HL7v2 message in a structured format.

  Fields:
    segments: A Segment attribute.
  """

  segments = _messages.MessageField('Segment', 1, repeated=True)


class ParserConfig(_messages.Message):
  r"""The configuration for the parser. It determines how the server parses
  the messages.

  Fields:
    allowNullHeader: Determines whether messages with no header are allowed.
    segmentTerminator: Byte(s) to be used as the segment terminator. If this
      is unset, '\r' will be used as segment terminator.
  """

  allowNullHeader = _messages.BooleanField(1)
  segmentTerminator = _messages.BytesField(2)


class PatientId(_messages.Message):
  r"""A patient identifier and associated type.

  Fields:
    type: ID type, e.g. MRN or NHS.
    value: The patient's unique identifier.
  """

  type = _messages.StringField(1)
  value = _messages.StringField(2)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ProgressCounter(_messages.Message):
  r"""ProgressCounter provides counters to describe an operation's progress.

  Fields:
    failure: The number of units that failed in the operation.
    pending: The number of units that are pending in the operation.
    success: The number of units that succeeded in the operation.
  """

  failure = _messages.IntegerField(1)
  pending = _messages.IntegerField(2)
  success = _messages.IntegerField(3)


class ResourceAnnotation(_messages.Message):
  r"""Resource level annotation.

  Fields:
    label: A string attribute.
  """

  label = _messages.StringField(1)


class SchemaConfig(_messages.Message):
  r"""Configuration for the FHIR BigQuery schema. Determines how the server
  generates the schema.

  Enums:
    SchemaTypeValueValuesEnum: Specifies the output schema type. If
      unspecified, the default is `LOSSLESS`.

  Fields:
    recursiveStructureDepth: The depth for all recursive structures in the
      output analytics schema. For example, concept in the CodeSystem resource
      is a recursive structure; when the depth is 2, the CodeSystem table will
      have a column called `concept.concept` but not
      `concept.concept.concept`. If not specified or set to 0, the server will
      use the default value 2.
    schemaType: Specifies the output schema type. If unspecified, the default
      is `LOSSLESS`.
  """

  class SchemaTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the output schema type. If unspecified, the default is
    `LOSSLESS`.

    Values:
      SCHEMA_TYPE_UNSPECIFIED: No schema type specified. Same as `LOSSLESS`.
      LOSSLESS: Schema generated from original FHIR data.
      ANALYTICS: Analytics schema defined by the FHIR community. See
        https://github.com/FHIR/sql-on-fhir.
    """
    SCHEMA_TYPE_UNSPECIFIED = 0
    LOSSLESS = 1
    ANALYTICS = 2

  recursiveStructureDepth = _messages.IntegerField(1)
  schemaType = _messages.EnumField('SchemaTypeValueValuesEnum', 2)


class SearchResourcesRequest(_messages.Message):
  r"""Request to search the resources in the specified FHIR store.

  Fields:
    resourceType: The type of the resource to search.
  """

  resourceType = _messages.StringField(1)


class Segment(_messages.Message):
  r"""A segment in a structured format.

  Messages:
    FieldsValue: A mapping from the positional location to the value. The key
      string uses indexes separated by dots to identify Fields, components and
      sub-components. To be consistent with how the standard refers to
      different parts of message, we use zero-based indexes for fields and
      one-based indexes for components and sub-components. A bracket notation
      is also used to identify different instances of a repeated field. Zero-
      based indexes are used to refer to each instance. Regex for key:
      (\d+)(\[\d+\])?(.\d+)?(.\d+)?  Examples of (key, value) pairs:  (0.1,
      "foo") denotes First component of Field 0 has the value "foo".  (1.1.2,
      "bar") denotes Second sub-component of the first component of Field 1
      has the value "bar".  (1[0].1, "baz") denotes First component of the
      first Instance of Field 1, which is repeated, has the value "baz".

  Fields:
    fields: A mapping from the positional location to the value. The key
      string uses indexes separated by dots to identify Fields, components and
      sub-components. To be consistent with how the standard refers to
      different parts of message, we use zero-based indexes for fields and
      one-based indexes for components and sub-components. A bracket notation
      is also used to identify different instances of a repeated field. Zero-
      based indexes are used to refer to each instance. Regex for key:
      (\d+)(\[\d+\])?(.\d+)?(.\d+)?  Examples of (key, value) pairs:  (0.1,
      "foo") denotes First component of Field 0 has the value "foo".  (1.1.2,
      "bar") denotes Second sub-component of the first component of Field 1
      has the value "bar".  (1[0].1, "baz") denotes First component of the
      first Instance of Field 1, which is repeated, has the value "baz".
    segmentId: A string that indicates the type of segment, e.g., EVN, PID.
    setId: Set ID for segments that can be in a set. This can be empty if it
      is missing or it is not applicable.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FieldsValue(_messages.Message):
    r"""A mapping from the positional location to the value. The key string
    uses indexes separated by dots to identify Fields, components and sub-
    components. To be consistent with how the standard refers to different
    parts of message, we use zero-based indexes for fields and one-based
    indexes for components and sub-components. A bracket notation is also used
    to identify different instances of a repeated field. Zero-based indexes
    are used to refer to each instance. Regex for key:
    (\d+)(\[\d+\])?(.\d+)?(.\d+)?  Examples of (key, value) pairs:  (0.1,
    "foo") denotes First component of Field 0 has the value "foo".  (1.1.2,
    "bar") denotes Second sub-component of the first component of Field 1 has
    the value "bar".  (1[0].1, "baz") denotes First component of the first
    Instance of Field 1, which is repeated, has the value "baz".

    Messages:
      AdditionalProperty: An additional property for a FieldsValue object.

    Fields:
      additionalProperties: Additional properties of type FieldsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FieldsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fields = _messages.MessageField('FieldsValue', 1)
  segmentId = _messages.StringField(2)
  setId = _messages.StringField(3)


class SensitiveTextAnnotation(_messages.Message):
  r"""A TextAnnotation specifies a text range that includes sensitive
  information.

  Messages:
    DetailsValue: Maps from a resource slice (e.g. FHIR resource field path)
      to a set of sensitive text findings. For example, Appointment.Narrative
      text1 --> {findings_1, findings_2, findings_3}

  Fields:
    details: Maps from a resource slice (e.g. FHIR resource field path) to a
      set of sensitive text findings. For example, Appointment.Narrative text1
      --> {findings_1, findings_2, findings_3}
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValue(_messages.Message):
    r"""Maps from a resource slice (e.g. FHIR resource field path) to a set of
    sensitive text findings. For example, Appointment.Narrative text1 -->
    {findings_1, findings_2, findings_3}

    Messages:
      AdditionalProperty: An additional property for a DetailsValue object.

    Fields:
      additionalProperties: Additional properties of type DetailsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValue object.

      Fields:
        key: Name of the additional property.
        value: A Detail attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Detail', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  details = _messages.MessageField('DetailsValue', 1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class Vertex(_messages.Message):
  r"""A 2D coordinate in an image. The origin is the top-left.

  Fields:
    x: X coordinate.
    y: Y coordinate.
  """

  x = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  y = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
