"""Generated client library for edgeml version v1beta1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.edgeml.v1beta1 import edgeml_v1beta1_messages as messages


class EdgemlV1beta1(base_api.BaseApiClient):
  """Generated client library for service edgeml version v1beta1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://edgeml.googleapis.com/'

  _PACKAGE = u'edgeml'
  _SCOPES = [u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/cloudiot', u'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = u'v1beta1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'EdgemlV1beta1'
  _URL_VERSION = u'v1beta1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new edgeml handle."""
    url = url or self.BASE_URL
    super(EdgemlV1beta1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.operations = self.OperationsService(self)
    self.projects_models = self.ProjectsModelsService(self)
    self.projects = self.ProjectsService(self)

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(EdgemlV1beta1.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.  Clients can use this.
method to poll the operation result at intervals as recommended by the API
service.

      Args:
        request: (EdgemlOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'edgeml.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1beta1/{+name}',
        request_field='',
        request_type_name=u'EdgemlOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsModelsService(base_api.BaseApiService):
    """Service class for the projects_models resource."""

    _NAME = u'projects_models'

    def __init__(self, client):
      super(EdgemlV1beta1.ProjectsModelsService, self).__init__(client)
      self._upload_configs = {
          }

    def Analyze(self, request, global_params=None):
      r"""Takes as input a file and returns information about the file. The result.
of the Operation will be `AnalyzeModelResponse` if successful. If the given
file is in an unknown format, the operation will succeed and
`Operation.result` will have a `response` with `model_type` of
`UNKNOWN_FORMAT`. If the given file is bigger than 100 MB, the operation
will fail and the `Operation.result` will be an `INVALID_ARGUMENT` error.

      Args:
        request: (EdgemlProjectsModelsAnalyzeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Analyze')
      return self._RunMethod(
          config, request, global_params=global_params)

    Analyze.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/models:analyze',
        http_method=u'POST',
        method_id=u'edgeml.projects.models.analyze',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'v1beta1/{+project}/models:analyze',
        request_field=u'analyzeModelRequest',
        request_type_name=u'EdgemlProjectsModelsAnalyzeRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Compile(self, request, global_params=None):
      r"""Compiles the input to a TPU-optimized TensorFlow Lite model. Currently, the.
input must be a pre-quantized TensorFlow Lite model. The result of the
Operation will be `CompileModelResponse` if successful. Even if the input
model has a structure that is not officially verified, compilation will
succeed, but with a warning message in
`CompileModelResponse.additional_message`.

      Args:
        request: (EdgemlProjectsModelsCompileRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Compile')
      return self._RunMethod(
          config, request, global_params=global_params)

    Compile.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/models:compile',
        http_method=u'POST',
        method_id=u'edgeml.projects.models.compile',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'v1beta1/{+project}/models:compile',
        request_field=u'compileModelRequest',
        request_type_name=u'EdgemlProjectsModelsCompileRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Convert(self, request, global_params=None):
      r"""Converts the input to a TensorFlow Lite model. Currently, the input must be.
a TensorFlow SavedModel file archived in a zip file. If the input model is
pre-quantized, it will generate a quantized TFLite model, that can be
compiled. If the input model is not quantized, the generated TFLite model
will also be non-quantized (and therefore unable to be compiled). Note that
this API method does not compile the file to a TPU-optimized TensorFlow
Lite model; use `CompileModel` API to do that compilation. The result of
the Operation will be `ConvertModelResponse` if successful.

      Args:
        request: (EdgemlProjectsModelsConvertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Convert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Convert.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1beta1/projects/{projectsId}/models:convert',
        http_method=u'POST',
        method_id=u'edgeml.projects.models.convert',
        ordered_params=[u'project'],
        path_params=[u'project'],
        query_params=[],
        relative_path=u'v1beta1/{+project}/models:convert',
        request_field=u'convertModelRequest',
        request_type_name=u'EdgemlProjectsModelsConvertRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = u'projects'

    def __init__(self, client):
      super(EdgemlV1beta1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
