"""Generated message classes for iam version v1.

Manages identity and access control for Google Cloud Platform resources,
including the creation of service accounts, which you can use to authenticate
to Google and make API calls.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'iam'


class AttributeTranslatorCEL(_messages.Message):
  r"""Specifies a list of output attribute names and the corresponding input
  attribute to use for that output attribute. Each defined output attribute is
  populated with the value of the specified input attribute.

  Messages:
    AttributesValue: Each entry specifies the desired output attribute and a
      CEL field selector expression for the corresponding input to read. This
      field supports a subset of the CEL functionality to select fields from
      the input (no boolean expressions, functions or arithmetics).  Output
      attributes must match `(google.sub|a-z_*)`.  The output attribute
      google.sub is interpreted to be the "identity" of the requesting user.
      For example, to copy the inbound attribute "sub" into the output
      `google.sub` add an entry `google.sub` -> `inclaim.sub` or `google.sub`
      -> `inclaim[\"sub\"]`.  See https://github.com/google/cel-spec for more
      details.  If the input does not exist the output attribute will be null.

  Fields:
    attributes: Each entry specifies the desired output attribute and a CEL
      field selector expression for the corresponding input to read. This
      field supports a subset of the CEL functionality to select fields from
      the input (no boolean expressions, functions or arithmetics).  Output
      attributes must match `(google.sub|a-z_*)`.  The output attribute
      google.sub is interpreted to be the "identity" of the requesting user.
      For example, to copy the inbound attribute "sub" into the output
      `google.sub` add an entry `google.sub` -> `inclaim.sub` or `google.sub`
      -> `inclaim[\"sub\"]`.  See https://github.com/google/cel-spec for more
      details.  If the input does not exist the output attribute will be null.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AttributesValue(_messages.Message):
    r"""Each entry specifies the desired output attribute and a CEL field
    selector expression for the corresponding input to read. This field
    supports a subset of the CEL functionality to select fields from the input
    (no boolean expressions, functions or arithmetics).  Output attributes
    must match `(google.sub|a-z_*)`.  The output attribute google.sub is
    interpreted to be the "identity" of the requesting user.  For example, to
    copy the inbound attribute "sub" into the output `google.sub` add an entry
    `google.sub` -> `inclaim.sub` or `google.sub` -> `inclaim[\"sub\"]`.  See
    https://github.com/google/cel-spec for more details.  If the input does
    not exist the output attribute will be null.

    Messages:
      AdditionalProperty: An additional property for a AttributesValue object.

    Fields:
      additionalProperties: Additional properties of type AttributesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AttributesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  attributes = _messages.MessageField('AttributesValue', 1)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditData(_messages.Message):
  r"""Audit log information specific to Cloud IAM. This message is serialized
  as an `Any` type in the `ServiceData` message of an `AuditLog` message.

  Fields:
    policyDelta: Policy delta between the original policy and the newly set
      policy.
  """

  policyDelta = _messages.MessageField('PolicyDelta', 1)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuditableService(_messages.Message):
  r"""Contains information about an auditable service.

  Fields:
    name: Public name of the service. For example, the service name for Cloud
      IAM is 'iam.googleapis.com'.
  """

  name = _messages.StringField(1)


class Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BindingDelta(_messages.Message):
  r"""One delta entry for Binding. Each individual change (only one member in
  each entry) to a binding will be a separate entry.

  Enums:
    ActionValueValuesEnum: The action that was performed on a Binding.
      Required

  Fields:
    action: The action that was performed on a Binding. Required
    condition: Unimplemented. The condition that is associated with this
      binding. This field is logged only for Cloud Audit Logging.
    member: A single identity requesting access for a Cloud Platform resource.
      Follows the same format of Binding.members. Required
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""The action that was performed on a Binding. Required

    Values:
      ACTION_UNSPECIFIED: Unspecified.
      ADD: Addition of a Binding.
      REMOVE: Removal of a Binding.
    """
    ACTION_UNSPECIFIED = 0
    ADD = 1
    REMOVE = 2

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  condition = _messages.MessageField('Expr', 2)
  member = _messages.StringField(3)
  role = _messages.StringField(4)


class CreateRoleRequest(_messages.Message):
  r"""The request to create a new role.

  Fields:
    role: The Role resource to create.
    roleId: The role id to use for this role.
  """

  role = _messages.MessageField('Role', 1)
  roleId = _messages.StringField(2)


class CreateServiceAccountIdentityBindingRequest(_messages.Message):
  r"""The service account identity binding create request.

  Fields:
    acceptanceFilter: A CEL expression that is evaluated to determine whether
      a credential should be accepted. To accept any credential, specify
      "true". See: https://github.com/google/cel-spec . The input claims are
      available using "inclaim[\"attribute_name\"]". The output attributes
      calculated by the translator are available using
      "outclaim[\"attribute_name\"]"
    cel: A set of output attributes and corresponding input attribute names.
    oidc: An OIDC reference with Discovery.
  """

  acceptanceFilter = _messages.StringField(1)
  cel = _messages.MessageField('AttributeTranslatorCEL', 2)
  oidc = _messages.MessageField('IDPReferenceOIDC', 3)


class CreateServiceAccountKeyRequest(_messages.Message):
  r"""The service account key create request.

  Enums:
    KeyAlgorithmValueValuesEnum: Which type of key and algorithm to use for
      the key. The default is currently a 2K RSA key.  However this may change
      in the future.
    PrivateKeyTypeValueValuesEnum: The output format of the private key. The
      default value is `TYPE_GOOGLE_CREDENTIALS_FILE`, which is the Google
      Credentials File format.

  Fields:
    keyAlgorithm: Which type of key and algorithm to use for the key. The
      default is currently a 2K RSA key.  However this may change in the
      future.
    privateKeyType: The output format of the private key. The default value is
      `TYPE_GOOGLE_CREDENTIALS_FILE`, which is the Google Credentials File
      format.
  """

  class KeyAlgorithmValueValuesEnum(_messages.Enum):
    r"""Which type of key and algorithm to use for the key. The default is
    currently a 2K RSA key.  However this may change in the future.

    Values:
      KEY_ALG_UNSPECIFIED: An unspecified key algorithm.
      KEY_ALG_RSA_1024: 1k RSA Key.
      KEY_ALG_RSA_2048: 2k RSA Key.
    """
    KEY_ALG_UNSPECIFIED = 0
    KEY_ALG_RSA_1024 = 1
    KEY_ALG_RSA_2048 = 2

  class PrivateKeyTypeValueValuesEnum(_messages.Enum):
    r"""The output format of the private key. The default value is
    `TYPE_GOOGLE_CREDENTIALS_FILE`, which is the Google Credentials File
    format.

    Values:
      TYPE_UNSPECIFIED: Unspecified. Equivalent to
        `TYPE_GOOGLE_CREDENTIALS_FILE`.
      TYPE_PKCS12_FILE: PKCS12 format. The password for the PKCS12 file is
        `notasecret`. For more information, see
        https://tools.ietf.org/html/rfc7292.
      TYPE_GOOGLE_CREDENTIALS_FILE: Google Credentials File format.
    """
    TYPE_UNSPECIFIED = 0
    TYPE_PKCS12_FILE = 1
    TYPE_GOOGLE_CREDENTIALS_FILE = 2

  keyAlgorithm = _messages.EnumField('KeyAlgorithmValueValuesEnum', 1)
  privateKeyType = _messages.EnumField('PrivateKeyTypeValueValuesEnum', 2)


class CreateServiceAccountRequest(_messages.Message):
  r"""The service account create request.

  Fields:
    accountId: Required. The account id that is used to generate the service
      account email address and a stable unique id. It is unique within a
      project, must be 6-30 characters long, and match the regular expression
      `[a-z]([-a-z0-9]*[a-z0-9])` to comply with RFC1035.
    serviceAccount: The ServiceAccount resource to create. Currently, only the
      following values are user assignable: `display_name` .
  """

  accountId = _messages.StringField(1)
  serviceAccount = _messages.MessageField('ServiceAccount', 2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Expr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class IDPReferenceOIDC(_messages.Message):
  r"""Represents a reference to an OIDC provider.

  Fields:
    audience: Optional. The acceptable audience. Default is the unique_id of
      the Service Account.
    maxTokenLifetimeSeconds: This optional field allows enforcing a maximum
      lifetime for tokens. Using a lifetime that is as short as possible
      improves security since it prevents use of exfiltrated tokens after a
      certain amount of time. All tokens must specify both exp and iat or they
      will be rejected. If "nbf" is present we will reject tokens that are not
      yet valid. Expiration and lifetime will be enforced in the following
      way: - "exp" > "current time" is always required (expired tokens are
      rejected) - "iat" < "current time" + 300 seconds is required (tokens
      from the future .      are rejected although a small amount of clock
      skew is tolerated). - If max_token_lifetime_seconds is set:        "exp"
      - "iat" < max_token_lifetime_seconds will be checked - The default is
      otherwise to accept a max_token_lifetime_seconds of 3600 (1 hour)
    url: The OpenID Connect URL. To use this Identity Binding, JWT 'iss' field
      should match this field.
  """

  audience = _messages.StringField(1)
  maxTokenLifetimeSeconds = _messages.IntegerField(2)
  url = _messages.StringField(3)


class IamOrganizationsRolesCreateRequest(_messages.Message):
  r"""A IamOrganizationsRolesCreateRequest object.

  Fields:
    createRoleRequest: A CreateRoleRequest resource to be passed as the
      request body.
    parent: The resource name of the parent resource in one of the following
      formats: `organizations/{ORGANIZATION_ID}` `projects/{PROJECT_ID}`
  """

  createRoleRequest = _messages.MessageField('CreateRoleRequest', 1)
  parent = _messages.StringField(2, required=True)


class IamOrganizationsRolesDeleteRequest(_messages.Message):
  r"""A IamOrganizationsRolesDeleteRequest object.

  Fields:
    etag: Used to perform a consistent read-modify-write.
    name: The resource name of the role in one of the following formats:
      `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
  """

  etag = _messages.BytesField(1)
  name = _messages.StringField(2, required=True)


class IamOrganizationsRolesGetRequest(_messages.Message):
  r"""A IamOrganizationsRolesGetRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `roles/{ROLE_NAME}` `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
  """

  name = _messages.StringField(1, required=True)


class IamOrganizationsRolesListRequest(_messages.Message):
  r"""A IamOrganizationsRolesListRequest object.

  Enums:
    ViewValueValuesEnum: Optional view for the returned Role objects.

  Fields:
    pageSize: Optional limit on the number of roles to include in the
      response.
    pageToken: Optional pagination token returned in an earlier
      ListRolesResponse.
    parent: The resource name of the parent resource in one of the following
      formats: `` (empty string) -- this refers to curated roles.
      `organizations/{ORGANIZATION_ID}` `projects/{PROJECT_ID}`
    showDeleted: Include Roles that have been deleted.
    view: Optional view for the returned Role objects.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional view for the returned Role objects.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  showDeleted = _messages.BooleanField(4)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class IamOrganizationsRolesPatchRequest(_messages.Message):
  r"""A IamOrganizationsRolesPatchRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `roles/{ROLE_NAME}` `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
    role: A Role resource to be passed as the request body.
    updateMask: A mask describing which fields in the Role have changed.
  """

  name = _messages.StringField(1, required=True)
  role = _messages.MessageField('Role', 2)
  updateMask = _messages.StringField(3)


class IamOrganizationsRolesUndeleteRequest(_messages.Message):
  r"""A IamOrganizationsRolesUndeleteRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
    undeleteRoleRequest: A UndeleteRoleRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteRoleRequest = _messages.MessageField('UndeleteRoleRequest', 2)


class IamProjectsRolesCreateRequest(_messages.Message):
  r"""A IamProjectsRolesCreateRequest object.

  Fields:
    createRoleRequest: A CreateRoleRequest resource to be passed as the
      request body.
    parent: The resource name of the parent resource in one of the following
      formats: `organizations/{ORGANIZATION_ID}` `projects/{PROJECT_ID}`
  """

  createRoleRequest = _messages.MessageField('CreateRoleRequest', 1)
  parent = _messages.StringField(2, required=True)


class IamProjectsRolesDeleteRequest(_messages.Message):
  r"""A IamProjectsRolesDeleteRequest object.

  Fields:
    etag: Used to perform a consistent read-modify-write.
    name: The resource name of the role in one of the following formats:
      `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
  """

  etag = _messages.BytesField(1)
  name = _messages.StringField(2, required=True)


class IamProjectsRolesGetRequest(_messages.Message):
  r"""A IamProjectsRolesGetRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `roles/{ROLE_NAME}` `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
  """

  name = _messages.StringField(1, required=True)


class IamProjectsRolesListRequest(_messages.Message):
  r"""A IamProjectsRolesListRequest object.

  Enums:
    ViewValueValuesEnum: Optional view for the returned Role objects.

  Fields:
    pageSize: Optional limit on the number of roles to include in the
      response.
    pageToken: Optional pagination token returned in an earlier
      ListRolesResponse.
    parent: The resource name of the parent resource in one of the following
      formats: `` (empty string) -- this refers to curated roles.
      `organizations/{ORGANIZATION_ID}` `projects/{PROJECT_ID}`
    showDeleted: Include Roles that have been deleted.
    view: Optional view for the returned Role objects.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional view for the returned Role objects.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  showDeleted = _messages.BooleanField(4)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class IamProjectsRolesPatchRequest(_messages.Message):
  r"""A IamProjectsRolesPatchRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `roles/{ROLE_NAME}` `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
    role: A Role resource to be passed as the request body.
    updateMask: A mask describing which fields in the Role have changed.
  """

  name = _messages.StringField(1, required=True)
  role = _messages.MessageField('Role', 2)
  updateMask = _messages.StringField(3)


class IamProjectsRolesUndeleteRequest(_messages.Message):
  r"""A IamProjectsRolesUndeleteRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
    undeleteRoleRequest: A UndeleteRoleRequest resource to be passed as the
      request body.
  """

  name = _messages.StringField(1, required=True)
  undeleteRoleRequest = _messages.MessageField('UndeleteRoleRequest', 2)


class IamProjectsServiceAccountsCreateRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsCreateRequest object.

  Fields:
    createServiceAccountRequest: A CreateServiceAccountRequest resource to be
      passed as the request body.
    name: Required. The resource name of the project associated with the
      service accounts, such as `projects/my-project-123`.
  """

  createServiceAccountRequest = _messages.MessageField('CreateServiceAccountRequest', 1)
  name = _messages.StringField(2, required=True)


class IamProjectsServiceAccountsDeleteRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsDeleteRequest object.

  Fields:
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
      wildcard for the `PROJECT_ID` will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsGetIamPolicyRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsGetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsGetRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsGetRequest object.

  Fields:
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
      wildcard for the `PROJECT_ID` will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsIdentityBindingsCreateRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsIdentityBindingsCreateRequest object.

  Fields:
    createServiceAccountIdentityBindingRequest: A
      CreateServiceAccountIdentityBindingRequest resource to be passed as the
      request body.
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
      wildcard for the `PROJECT_ID` will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
  """

  createServiceAccountIdentityBindingRequest = _messages.MessageField('CreateServiceAccountIdentityBindingRequest', 1)
  name = _messages.StringField(2, required=True)


class IamProjectsServiceAccountsIdentityBindingsDeleteRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsIdentityBindingsDeleteRequest object.

  Fields:
    name: The resource name of the service account identity binding in the
      following format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/identi
      tyBindings/{BINDING}`. Using `-` as a wildcard for the `PROJECT_ID` will
      infer the project from the account. The `ACCOUNT` value can be the
      `email` address or the `unique_id` of the service account.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsIdentityBindingsGetRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsIdentityBindingsGetRequest object.

  Fields:
    name: The resource name of the service account identity binding in the
      following format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/identi
      tyBindings/{BINDING}`.  Using `-` as a wildcard for the `PROJECT_ID`
      will infer the project from the account. The `ACCOUNT` value can be the
      `email` address or the `unique_id` of the service account.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsIdentityBindingsListRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsIdentityBindingsListRequest object.

  Fields:
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.  Using `-` as a
      wildcard for the `PROJECT_ID`, will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsKeysCreateRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsKeysCreateRequest object.

  Fields:
    createServiceAccountKeyRequest: A CreateServiceAccountKeyRequest resource
      to be passed as the request body.
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
      wildcard for the `PROJECT_ID` will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
  """

  createServiceAccountKeyRequest = _messages.MessageField('CreateServiceAccountKeyRequest', 1)
  name = _messages.StringField(2, required=True)


class IamProjectsServiceAccountsKeysDeleteRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsKeysDeleteRequest object.

  Fields:
    name: The resource name of the service account key in the following
      format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
      Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
      the account. The `ACCOUNT` value can be the `email` address or the
      `unique_id` of the service account.
  """

  name = _messages.StringField(1, required=True)


class IamProjectsServiceAccountsKeysGetRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsKeysGetRequest object.

  Enums:
    PublicKeyTypeValueValuesEnum: The output format of the public key
      requested. X509_PEM is the default output format.

  Fields:
    name: The resource name of the service account key in the following
      format: `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
      Using `-` as a wildcard for the `PROJECT_ID` will infer the project from
      the account. The `ACCOUNT` value can be the `email` address or the
      `unique_id` of the service account.
    publicKeyType: The output format of the public key requested. X509_PEM is
      the default output format.
  """

  class PublicKeyTypeValueValuesEnum(_messages.Enum):
    r"""The output format of the public key requested. X509_PEM is the default
    output format.

    Values:
      TYPE_NONE: <no description>
      TYPE_X509_PEM_FILE: <no description>
      TYPE_RAW_PUBLIC_KEY: <no description>
    """
    TYPE_NONE = 0
    TYPE_X509_PEM_FILE = 1
    TYPE_RAW_PUBLIC_KEY = 2

  name = _messages.StringField(1, required=True)
  publicKeyType = _messages.EnumField('PublicKeyTypeValueValuesEnum', 2)


class IamProjectsServiceAccountsKeysListRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsKeysListRequest object.

  Enums:
    KeyTypesValueValuesEnum: Filters the types of keys the user wants to
      include in the list response. Duplicate key types are not allowed. If no
      key type is provided, all keys are returned.

  Fields:
    keyTypes: Filters the types of keys the user wants to include in the list
      response. Duplicate key types are not allowed. If no key type is
      provided, all keys are returned.
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.  Using `-` as a
      wildcard for the `PROJECT_ID`, will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
  """

  class KeyTypesValueValuesEnum(_messages.Enum):
    r"""Filters the types of keys the user wants to include in the list
    response. Duplicate key types are not allowed. If no key type is provided,
    all keys are returned.

    Values:
      KEY_TYPE_UNSPECIFIED: <no description>
      USER_MANAGED: <no description>
      SYSTEM_MANAGED: <no description>
    """
    KEY_TYPE_UNSPECIFIED = 0
    USER_MANAGED = 1
    SYSTEM_MANAGED = 2

  keyTypes = _messages.EnumField('KeyTypesValueValuesEnum', 1, repeated=True)
  name = _messages.StringField(2, required=True)


class IamProjectsServiceAccountsListRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsListRequest object.

  Fields:
    name: Required. The resource name of the project associated with the
      service accounts, such as `projects/my-project-123`.
    pageSize: Optional limit on the number of service accounts to include in
      the response. Further accounts can subsequently be obtained by including
      the ListServiceAccountsResponse.next_page_token in a subsequent request.
    pageToken: Optional pagination token returned in an earlier
      ListServiceAccountsResponse.next_page_token.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class IamProjectsServiceAccountsSetIamPolicyRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class IamProjectsServiceAccountsSignBlobRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsSignBlobRequest object.

  Fields:
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
      wildcard for the `PROJECT_ID` will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
    signBlobRequest: A SignBlobRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  signBlobRequest = _messages.MessageField('SignBlobRequest', 2)


class IamProjectsServiceAccountsSignJwtRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsSignJwtRequest object.

  Fields:
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a
      wildcard for the `PROJECT_ID` will infer the project from the account.
      The `ACCOUNT` value can be the `email` address or the `unique_id` of the
      service account.
    signJwtRequest: A SignJwtRequest resource to be passed as the request
      body.
  """

  name = _messages.StringField(1, required=True)
  signJwtRequest = _messages.MessageField('SignJwtRequest', 2)


class IamProjectsServiceAccountsTestIamPermissionsRequest(_messages.Message):
  r"""A IamProjectsServiceAccountsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class IamRolesGetRequest(_messages.Message):
  r"""A IamRolesGetRequest object.

  Fields:
    name: The resource name of the role in one of the following formats:
      `roles/{ROLE_NAME}` `organizations/{ORGANIZATION_ID}/roles/{ROLE_NAME}`
      `projects/{PROJECT_ID}/roles/{ROLE_NAME}`
  """

  name = _messages.StringField(1, required=True)


class IamRolesListRequest(_messages.Message):
  r"""A IamRolesListRequest object.

  Enums:
    ViewValueValuesEnum: Optional view for the returned Role objects.

  Fields:
    pageSize: Optional limit on the number of roles to include in the
      response.
    pageToken: Optional pagination token returned in an earlier
      ListRolesResponse.
    parent: The resource name of the parent resource in one of the following
      formats: `` (empty string) -- this refers to curated roles.
      `organizations/{ORGANIZATION_ID}` `projects/{PROJECT_ID}`
    showDeleted: Include Roles that have been deleted.
    view: Optional view for the returned Role objects.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional view for the returned Role objects.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3)
  showDeleted = _messages.BooleanField(4)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class LintPolicyRequest(_messages.Message):
  r"""The request to lint a Cloud IAM policy object. LintPolicy is currently
  functional only for `lint_object` of type `condition`.

  Messages:
    ContextValue: `context` contains additional *permission-controlled* data
      that any lint unit may depend on, in form of `{key: value}` pairs.
      Currently, this field is non-operational and it will not be used during
      the lint operation.

  Fields:
    binding: Binding object to be linted. The functionality of linting a
      binding is not yet implemented and if this field is set, it returns
      NOT_IMPLEMENTED error.
    condition: google.iam.v1.Binding.condition object to be linted.
    context: `context` contains additional *permission-controlled* data that
      any lint unit may depend on, in form of `{key: value}` pairs. Currently,
      this field is non-operational and it will not be used during the lint
      operation.
    fullResourceName: The full resource name of the policy this lint request
      is about.  The name follows the Google Cloud Platform (GCP) resource
      format. For example, a GCP project with ID `my-project` will be named
      `//cloudresourcemanager.googleapis.com/projects/my-project`.  The
      resource name is not used to read the policy instance from the Cloud IAM
      database. The candidate policy for lint has to be provided in the same
      request object.
    policy: Policy object to be linted. The functionality of linting a policy
      is not yet implemented and if this field is set, it returns
      NOT_IMPLEMENTED error.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ContextValue(_messages.Message):
    r"""`context` contains additional *permission-controlled* data that any
    lint unit may depend on, in form of `{key: value}` pairs. Currently, this
    field is non-operational and it will not be used during the lint
    operation.

    Messages:
      AdditionalProperty: An additional property for a ContextValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ContextValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  binding = _messages.MessageField('Binding', 1)
  condition = _messages.MessageField('Expr', 2)
  context = _messages.MessageField('ContextValue', 3)
  fullResourceName = _messages.StringField(4)
  policy = _messages.MessageField('Policy', 5)


class LintPolicyResponse(_messages.Message):
  r"""The response of a lint operation. An empty response indicates the
  operation was able to fully execute and no lint issue was found.

  Fields:
    lintResults: List of lint results sorted by a composite <severity,
      binding_ordinal> key, descending order of severity and ascending order
      of binding_ordinal. There is no certain order among the same keys.  For
      cross-binding results (only if the input object to lint is instance of
      google.iam.v1.Policy), there will be a google.iam.admin.v1.LintResult
      for each of the involved bindings, and the associated debug_message may
      enumerate the other involved binding ordinal number(s).
  """

  lintResults = _messages.MessageField('LintResult', 1, repeated=True)


class LintResult(_messages.Message):
  r"""Structured response of a single validation unit.

  Enums:
    LevelValueValuesEnum: The validation unit level.
    SeverityValueValuesEnum: The validation unit severity.

  Fields:
    bindingOrdinal: 0-based index ordinality of the binding in the input
      object associated with this result. This field is populated only if the
      input object to lint is of type google.iam.v1.Policy, which can comprise
      more than one binding. It is set to -1 if the result is not associated
      with any particular binding and only targets the policy as a whole, such
      as results about policy size violations.
    debugMessage: Human readable debug message associated with the issue.
    fieldName: The name of the field for which this lint result is about.  For
      nested messages, `field_name` consists of names of the embedded fields
      separated by period character. The top-level qualifier is the input
      object to lint in the request. For instance, if the lint request is on a
      google.iam.v1.Policy and this lint result is about a condition
      expression of one of the input policy bindings, the field would be
      populated as `policy.bindings.condition.expression`.  This field does
      not identify the ordinality of the repetitive fields (for instance
      bindings in a policy).
    level: The validation unit level.
    locationOffset: 0-based character position of problematic construct within
      the object identified by `field_name`. Currently, this is populated only
      for condition expression.
    severity: The validation unit severity.
    validationUnitName: The validation unit name, for instance
      "lintValidationUnits/ConditionComplexityCheck".
  """

  class LevelValueValuesEnum(_messages.Enum):
    r"""The validation unit level.

    Values:
      LEVEL_UNSPECIFIED: Level is unspecified.
      POLICY: A validation unit which operates on a policy. It is executed
        only if the input object to lint is of type google.iam.v1.Policy.
      BINDING: A validation unit which operates on an individual binding. It
        is executed in both cases where the input object to lint is of type
        google.iam.v1.Policy or google.iam.v1.Binding.
      CONDITION: A validation unit which operates on an individual condition
        within a binding. It is executed in all three cases where the input
        object to lint is of type google.iam.v1.Policy, google.iam.v1.Binding
        or google.iam.v1.Binding.condition.
    """
    LEVEL_UNSPECIFIED = 0
    POLICY = 1
    BINDING = 2
    CONDITION = 3

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The validation unit severity.

    Values:
      SEVERITY_UNSPECIFIED: Severity is unspecified.
      ERROR: A validation unit returns an error only for critical issues. If
        an attempt is made to set the problematic policy without rectifying
        the critical issue, it causes the `setPolicy` operation to fail.
      WARNING: Any issue which is severe enough but does not cause an error.
        For example, suspicious constructs in the input object will not
        necessarily fail `setPolicy`, but there is a high likelihood that they
        won't behave as expected during policy evaluation in `checkPolicy`.
        This includes the following common scenarios:  - Unsatisfiable
        condition: Expired timestamp in date/time condition. - Ineffective
        condition: Condition on a <member, role> pair which is   granted
        unconditionally in another binding of the same policy.
      NOTICE: Reserved for the issues that are not severe as
        `ERROR`/`WARNING`, but need special handling. For instance, messages
        about skipped validation units are issued as `NOTICE`.
      INFO: Any informative statement which is not severe enough to raise
        `ERROR`/`WARNING`/`NOTICE`, like auto-correction recommendations on
        the input content. Note that current version of the linter does not
        utilize `INFO`.
      DEPRECATED: Deprecated severity level.
    """
    SEVERITY_UNSPECIFIED = 0
    ERROR = 1
    WARNING = 2
    NOTICE = 3
    INFO = 4
    DEPRECATED = 5

  bindingOrdinal = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  debugMessage = _messages.StringField(2)
  fieldName = _messages.StringField(3)
  level = _messages.EnumField('LevelValueValuesEnum', 4)
  locationOffset = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)
  validationUnitName = _messages.StringField(7)


class ListRolesResponse(_messages.Message):
  r"""The response containing the roles defined under a resource.

  Fields:
    nextPageToken: To retrieve the next page of results, set
      `ListRolesRequest.page_token` to this value.
    roles: The Roles defined on this resource.
  """

  nextPageToken = _messages.StringField(1)
  roles = _messages.MessageField('Role', 2, repeated=True)


class ListServiceAccountIdentityBindingsResponse(_messages.Message):
  r"""The service account identity bindings list response.

  Fields:
    identityBinding: The identity bindings trusted to assert the service
      account.
  """

  identityBinding = _messages.MessageField('ServiceAccountIdentityBinding', 1, repeated=True)


class ListServiceAccountKeysResponse(_messages.Message):
  r"""The service account keys list response.

  Fields:
    keys: The public keys for the service account.
  """

  keys = _messages.MessageField('ServiceAccountKey', 1, repeated=True)


class ListServiceAccountsResponse(_messages.Message):
  r"""The service account list response.

  Fields:
    accounts: The list of matching service accounts.
    nextPageToken: To retrieve the next page of results, set
      ListServiceAccountsRequest.page_token to this value.
  """

  accounts = _messages.MessageField('ServiceAccount', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class Permission(_messages.Message):
  r"""A permission which can be included by a role.

  Enums:
    CustomRolesSupportLevelValueValuesEnum: The current custom role support
      level.
    StageValueValuesEnum: The current launch stage of the permission.

  Fields:
    apiDisabled: The service API associated with the permission is not
      enabled.
    customRolesSupportLevel: The current custom role support level.
    description: A brief description of what this Permission is used for.
    name: The name of this Permission.
    onlyInPredefinedRoles: This permission can ONLY be used in predefined
      roles.
    stage: The current launch stage of the permission.
    title: The title of this Permission.
  """

  class CustomRolesSupportLevelValueValuesEnum(_messages.Enum):
    r"""The current custom role support level.

    Values:
      SUPPORTED: Permission is fully supported for custom role use.
      TESTING: Permission is being tested to check custom role compatibility.
      NOT_SUPPORTED: Permission is not supported for custom role use.
    """
    SUPPORTED = 0
    TESTING = 1
    NOT_SUPPORTED = 2

  class StageValueValuesEnum(_messages.Enum):
    r"""The current launch stage of the permission.

    Values:
      ALPHA: The permission is currently in an alpha phase.
      BETA: The permission is currently in a beta phase.
      GA: The permission is generally available.
      DEPRECATED: The permission is being deprecated.
    """
    ALPHA = 0
    BETA = 1
    GA = 2
    DEPRECATED = 3

  apiDisabled = _messages.BooleanField(1)
  customRolesSupportLevel = _messages.EnumField('CustomRolesSupportLevelValueValuesEnum', 2)
  description = _messages.StringField(3)
  name = _messages.StringField(4)
  onlyInPredefinedRoles = _messages.BooleanField(5)
  stage = _messages.EnumField('StageValueValuesEnum', 6)
  title = _messages.StringField(7)


class Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class PolicyDelta(_messages.Message):
  r"""The difference delta between two policies.

  Fields:
    bindingDeltas: The delta for Bindings between two policies.
  """

  bindingDeltas = _messages.MessageField('BindingDelta', 1, repeated=True)


class QueryAuditableServicesRequest(_messages.Message):
  r"""A request to get the list of auditable services for a resource.

  Fields:
    fullResourceName: Required. The full resource name to query from the list
      of auditable services.  The name follows the Google Cloud Platform
      resource format. For example, a Cloud Platform project with id `my-
      project` will be named `//cloudresourcemanager.googleapis.com/projects
      /my-project`.
  """

  fullResourceName = _messages.StringField(1)


class QueryAuditableServicesResponse(_messages.Message):
  r"""A response containing a list of auditable services for a resource.

  Fields:
    services: The auditable services for a resource.
  """

  services = _messages.MessageField('AuditableService', 1, repeated=True)


class QueryGrantableRolesRequest(_messages.Message):
  r"""The grantable role query request.

  Enums:
    ViewValueValuesEnum:

  Fields:
    fullResourceName: Required. The full resource name to query from the list
      of grantable roles.  The name follows the Google Cloud Platform resource
      format. For example, a Cloud Platform project with id `my-project` will
      be named `//cloudresourcemanager.googleapis.com/projects/my-project`.
    pageSize: Optional limit on the number of roles to include in the
      response.
    pageToken: Optional pagination token returned in an earlier
      QueryGrantableRolesResponse.
    view: A ViewValueValuesEnum attribute.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""ViewValueValuesEnum enum type.

    Values:
      BASIC: Omits the `included_permissions` field. This is the default
        value.
      FULL: Returns all fields.
    """
    BASIC = 0
    FULL = 1

  fullResourceName = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class QueryGrantableRolesResponse(_messages.Message):
  r"""The grantable role query response.

  Fields:
    nextPageToken: To retrieve the next page of results, set
      `QueryGrantableRolesRequest.page_token` to this value.
    roles: The list of matching roles.
  """

  nextPageToken = _messages.StringField(1)
  roles = _messages.MessageField('Role', 2, repeated=True)


class QueryTestablePermissionsRequest(_messages.Message):
  r"""A request to get permissions which can be tested on a resource.

  Fields:
    fullResourceName: Required. The full resource name to query from the list
      of testable permissions.  The name follows the Google Cloud Platform
      resource format. For example, a Cloud Platform project with id `my-
      project` will be named `//cloudresourcemanager.googleapis.com/projects
      /my-project`.
    pageSize: Optional limit on the number of permissions to include in the
      response.
    pageToken: Optional pagination token returned in an earlier
      QueryTestablePermissionsRequest.
  """

  fullResourceName = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class QueryTestablePermissionsResponse(_messages.Message):
  r"""The response containing permissions which can be tested on a resource.

  Fields:
    nextPageToken: To retrieve the next page of results, set
      `QueryTestableRolesRequest.page_token` to this value.
    permissions: The Permissions testable on the requested resource.
  """

  nextPageToken = _messages.StringField(1)
  permissions = _messages.MessageField('Permission', 2, repeated=True)


class Role(_messages.Message):
  r"""A role in the Identity and Access Management API.

  Enums:
    StageValueValuesEnum: The current launch stage of the role. If the `ALPHA`
      launch stage has been selected for a role, the `stage` field will not be
      included in the returned definition for the role.

  Fields:
    deleted: The current deleted state of the role. This field is read only.
      It will be ignored in calls to CreateRole and UpdateRole.
    description: Optional.  A human-readable description for the role.
    etag: Used to perform a consistent read-modify-write.
    includedPermissions: The names of the permissions this role grants when
      bound in an IAM policy.
    name: The name of the role.  When Role is used in CreateRole, the role
      name must not be set.  When Role is used in output and other input such
      as UpdateRole, the role name is the complete path, e.g.,
      roles/logging.viewer for curated roles and
      organizations/{ORGANIZATION_ID}/roles/logging.viewer for custom roles.
    stage: The current launch stage of the role. If the `ALPHA` launch stage
      has been selected for a role, the `stage` field will not be included in
      the returned definition for the role.
    title: Optional.  A human-readable title for the role.  Typically this is
      limited to 100 UTF-8 bytes.
  """

  class StageValueValuesEnum(_messages.Enum):
    r"""The current launch stage of the role. If the `ALPHA` launch stage has
    been selected for a role, the `stage` field will not be included in the
    returned definition for the role.

    Values:
      ALPHA: The user has indicated this role is currently in an Alpha phase.
        If this launch stage is selected, the `stage` field will not be
        included when requesting the definition for a given role.
      BETA: The user has indicated this role is currently in a Beta phase.
      GA: The user has indicated this role is generally available.
      DEPRECATED: The user has indicated this role is being deprecated.
      DISABLED: This role is disabled and will not contribute permissions to
        any members it is granted to in policies.
      EAP: The user has indicated this role is currently in an EAP phase.
    """
    ALPHA = 0
    BETA = 1
    GA = 2
    DEPRECATED = 3
    DISABLED = 4
    EAP = 5

  deleted = _messages.BooleanField(1)
  description = _messages.StringField(2)
  etag = _messages.BytesField(3)
  includedPermissions = _messages.StringField(4, repeated=True)
  name = _messages.StringField(5)
  stage = _messages.EnumField('StageValueValuesEnum', 6)
  title = _messages.StringField(7)


class ServiceAccount(_messages.Message):
  r"""A service account in the Identity and Access Management API.  To create
  a service account, specify the `project_id` and the `account_id` for the
  account.  The `account_id` is unique within the project, and is used to
  generate the service account email address and a stable `unique_id`.  If the
  account already exists, the account's resource name is returned in the
  format of projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}. The caller can
  use the name in other methods to access the account.  All other methods can
  identify the service account using the format
  `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. Using `-` as a wildcard
  for the `PROJECT_ID` will infer the project from the account. The `ACCOUNT`
  value can be the `email` address or the `unique_id` of the service account.

  Fields:
    displayName: Optional. A user-specified name for the service account. Must
      be less than or equal to 100 UTF-8 bytes.
    email: @OutputOnly The email address of the service account.
    etag: Optional. Note: `etag` is an inoperable legacy field that is only
      returned for backwards compatibility.
    name: The resource name of the service account in the following format:
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.  Requests using `-`
      as a wildcard for the `PROJECT_ID` will infer the project from the
      `account` and the `ACCOUNT` value can be the `email` address or the
      `unique_id` of the service account.  In responses the resource name will
      always be in the format
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`.
    oauth2ClientId: @OutputOnly The OAuth2 client id for the service account.
      This is used in conjunction with the OAuth2 clientconfig API to make
      three legged OAuth2 (3LO) flows to access the data of Google users.
    projectId: @OutputOnly The id of the project that owns the service
      account.
    uniqueId: @OutputOnly The unique and stable id of the service account.
  """

  displayName = _messages.StringField(1)
  email = _messages.StringField(2)
  etag = _messages.BytesField(3)
  name = _messages.StringField(4)
  oauth2ClientId = _messages.StringField(5)
  projectId = _messages.StringField(6)
  uniqueId = _messages.StringField(7)


class ServiceAccountIdentityBinding(_messages.Message):
  r"""Represents a service account identity provider reference.  A service
  account has at most one identity binding for the EAP.  This is an
  alternative to service account keys and enables the service account to be
  configured to trust an external IDP through the provided identity binding.

  Fields:
    acceptanceFilter: A CEL expression that is evaluated to determine whether
      a credential should be accepted. To accept any credential, specify
      "true". See: https://github.com/google/cel-spec . This field supports a
      subset of the CEL functionality to select fields and evaluate boolean
      expressions based on the input (no functions or arithmetics). The values
      for input claims are available using `inclaim.attribute_name` or
      `inclaim[\"attribute_name\"]`. The values for output attributes
      calculated by the translator are available using
      `outclaim.attribute_name` or `outclaim[\"attribute_name\"]`.
    cel: A set of output attributes and corresponding input attribute
      expressions.
    name: The resource name of the service account identity binding in the
      following format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/identi
      tyBindings/{BINDING}`.
    oidc: OIDC with discovery.
  """

  acceptanceFilter = _messages.StringField(1)
  cel = _messages.MessageField('AttributeTranslatorCEL', 2)
  name = _messages.StringField(3)
  oidc = _messages.MessageField('IDPReferenceOIDC', 4)


class ServiceAccountKey(_messages.Message):
  r"""Represents a service account key.  A service account has two sets of
  key-pairs: user-managed, and system-managed.  User-managed key-pairs can be
  created and deleted by users.  Users are responsible for rotating these keys
  periodically to ensure security of their service accounts.  Users retain the
  private key of these key-pairs, and Google retains ONLY the public key.
  System-managed keys are automatically rotated by Google, and are used for
  signing for a maximum of two weeks. The rotation process is probabilistic,
  and usage of the new key will gradually ramp up and down over the key's
  lifetime. We recommend caching the public key set for a service account for
  no more than 24 hours to ensure you have access to the latest keys.  Public
  keys for all service accounts are also published at the OAuth2 Service
  Account API.

  Enums:
    KeyAlgorithmValueValuesEnum: Specifies the algorithm (and possibly key
      size) for the key.
    PrivateKeyTypeValueValuesEnum: The output format for the private key. Only
      provided in `CreateServiceAccountKey` responses, not in
      `GetServiceAccountKey` or `ListServiceAccountKey` responses.  Google
      never exposes system-managed private keys, and never retains user-
      managed private keys.

  Fields:
    keyAlgorithm: Specifies the algorithm (and possibly key size) for the key.
    name: The resource name of the service account key in the following format
      `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}`.
    privateKeyData: The private key data. Only provided in
      `CreateServiceAccountKey` responses. Make sure to keep the private key
      data secure because it allows for the assertion of the service account
      identity. When base64 decoded, the private key data can be used to
      authenticate with Google API client libraries and with <a
      href="/sdk/gcloud/reference/auth/activate-service-account">gcloud auth
      activate-service-account</a>.
    privateKeyType: The output format for the private key. Only provided in
      `CreateServiceAccountKey` responses, not in `GetServiceAccountKey` or
      `ListServiceAccountKey` responses.  Google never exposes system-managed
      private keys, and never retains user-managed private keys.
    publicKeyData: The public key data. Only provided in
      `GetServiceAccountKey` responses.
    validAfterTime: The key can be used after this timestamp.
    validBeforeTime: The key can be used before this timestamp.
  """

  class KeyAlgorithmValueValuesEnum(_messages.Enum):
    r"""Specifies the algorithm (and possibly key size) for the key.

    Values:
      KEY_ALG_UNSPECIFIED: An unspecified key algorithm.
      KEY_ALG_RSA_1024: 1k RSA Key.
      KEY_ALG_RSA_2048: 2k RSA Key.
    """
    KEY_ALG_UNSPECIFIED = 0
    KEY_ALG_RSA_1024 = 1
    KEY_ALG_RSA_2048 = 2

  class PrivateKeyTypeValueValuesEnum(_messages.Enum):
    r"""The output format for the private key. Only provided in
    `CreateServiceAccountKey` responses, not in `GetServiceAccountKey` or
    `ListServiceAccountKey` responses.  Google never exposes system-managed
    private keys, and never retains user-managed private keys.

    Values:
      TYPE_UNSPECIFIED: Unspecified. Equivalent to
        `TYPE_GOOGLE_CREDENTIALS_FILE`.
      TYPE_PKCS12_FILE: PKCS12 format. The password for the PKCS12 file is
        `notasecret`. For more information, see
        https://tools.ietf.org/html/rfc7292.
      TYPE_GOOGLE_CREDENTIALS_FILE: Google Credentials File format.
    """
    TYPE_UNSPECIFIED = 0
    TYPE_PKCS12_FILE = 1
    TYPE_GOOGLE_CREDENTIALS_FILE = 2

  keyAlgorithm = _messages.EnumField('KeyAlgorithmValueValuesEnum', 1)
  name = _messages.StringField(2)
  privateKeyData = _messages.BytesField(3)
  privateKeyType = _messages.EnumField('PrivateKeyTypeValueValuesEnum', 4)
  publicKeyData = _messages.BytesField(5)
  validAfterTime = _messages.StringField(6)
  validBeforeTime = _messages.StringField(7)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SignBlobRequest(_messages.Message):
  r"""The service account sign blob request.

  Fields:
    bytesToSign: The bytes to sign.
  """

  bytesToSign = _messages.BytesField(1)


class SignBlobResponse(_messages.Message):
  r"""The service account sign blob response.

  Fields:
    keyId: The id of the key used to sign the blob.
    signature: The signed blob.
  """

  keyId = _messages.StringField(1)
  signature = _messages.BytesField(2)


class SignJwtRequest(_messages.Message):
  r"""The service account sign JWT request.

  Fields:
    payload: The JWT payload to sign, a JSON JWT Claim set.
  """

  payload = _messages.StringField(1)


class SignJwtResponse(_messages.Message):
  r"""The service account sign JWT response.

  Fields:
    keyId: The id of the key used to sign the JWT.
    signedJwt: The signed JWT.
  """

  keyId = _messages.StringField(1)
  signedJwt = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UndeleteRoleRequest(_messages.Message):
  r"""The request to undelete an existing role.

  Fields:
    etag: Used to perform a consistent read-modify-write.
  """

  etag = _messages.BytesField(1)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
