"""Generated client library for genomics version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.
from apitools.base.py import base_api
from googlecloudsdk.third_party.apis.genomics.v1 import genomics_v1_messages as messages


class GenomicsV1(base_api.BaseApiClient):
  """Generated client library for service genomics version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = u'https://genomics.googleapis.com/'

  _PACKAGE = u'genomics'
  _SCOPES = [u'https://www.googleapis.com/auth/bigquery', u'https://www.googleapis.com/auth/cloud-platform', u'https://www.googleapis.com/auth/devstorage.read_write', u'https://www.googleapis.com/auth/genomics', u'https://www.googleapis.com/auth/genomics.readonly']
  _VERSION = u'v1'
  _CLIENT_ID = '1042881264118.apps.googleusercontent.com'
  _CLIENT_SECRET = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = u'GenomicsV1'
  _URL_VERSION = u'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new genomics handle."""
    url = url or self.BASE_URL
    super(GenomicsV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.annotations = self.AnnotationsService(self)
    self.annotationsets = self.AnnotationsetsService(self)
    self.callsets = self.CallsetsService(self)
    self.datasets = self.DatasetsService(self)
    self.operations = self.OperationsService(self)
    self.readgroupsets_coveragebuckets = self.ReadgroupsetsCoveragebucketsService(self)
    self.readgroupsets = self.ReadgroupsetsService(self)
    self.reads = self.ReadsService(self)
    self.references_bases = self.ReferencesBasesService(self)
    self.references = self.ReferencesService(self)
    self.referencesets = self.ReferencesetsService(self)
    self.variants = self.VariantsService(self)
    self.variantsets = self.VariantsetsService(self)

  class AnnotationsService(base_api.BaseApiService):
    """Service class for the annotations resource."""

    _NAME = u'annotations'

    def __init__(self, client):
      super(GenomicsV1.AnnotationsService, self).__init__(client)
      self._upload_configs = {
          }

    def BatchCreate(self, request, global_params=None):
      r"""Creates one or more new annotations atomically. All annotations must.
belong to the same annotation set. Caller must have WRITE
permission for this annotation set. For optimal performance, batch
positionally adjacent annotations together.

If the request has a systemic issue, such as an attempt to write to
an inaccessible annotation set, the entire RPC will fail accordingly. For
lesser data issues, when possible an error will be isolated to the
corresponding batch entry in the response; the remaining well formed
annotations will be created normally.

For details on the requirements for each individual annotation resource,
see
CreateAnnotation.

      Args:
        request: (BatchCreateAnnotationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BatchCreateAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('BatchCreate')
      return self._RunMethod(
          config, request, global_params=global_params)

    BatchCreate.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.annotations.batchCreate',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/annotations:batchCreate',
        request_field='<request>',
        request_type_name=u'BatchCreateAnnotationsRequest',
        response_type_name=u'BatchCreateAnnotationsResponse',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new annotation. Caller must have WRITE permission.
for the associated annotation set.

The following fields are required:

* annotationSetId
* referenceName or
  referenceId

### Transcripts

For annotations of type TRANSCRIPT, the following fields of
transcript must be provided:

* exons.start
* exons.end

All other fields may be optionally specified, unless documented as being
server-generated (for example, the `id` field). The annotated
range must be no longer than 100Mbp (mega base pairs). See the
Annotation resource
for additional restrictions on each field.

      Args:
        request: (Annotation) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.annotations.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/annotations',
        request_field='<request>',
        request_type_name=u'Annotation',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an annotation. Caller must have WRITE permission for.
the associated annotation set.

      Args:
        request: (GenomicsAnnotationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.annotations.delete',
        ordered_params=[u'annotationId'],
        path_params=[u'annotationId'],
        query_params=[],
        relative_path=u'v1/annotations/{annotationId}',
        request_field='',
        request_type_name=u'GenomicsAnnotationsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an annotation. Caller must have READ permission.
for the associated annotation set.

      Args:
        request: (GenomicsAnnotationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.annotations.get',
        ordered_params=[u'annotationId'],
        path_params=[u'annotationId'],
        query_params=[],
        relative_path=u'v1/annotations/{annotationId}',
        request_field='',
        request_type_name=u'GenomicsAnnotationsGetRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for annotations that match the given criteria. Results are.
ordered by genomic coordinate (by reference sequence, then position).
Annotations with equivalent genomic coordinates are returned in an
unspecified order. This order is consistent, such that two queries for the
same content (regardless of page size) yield annotations in the same order
across their respective streams of paginated responses. Caller must have
READ permission for the queried annotation sets.

      Args:
        request: (SearchAnnotationsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchAnnotationsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.annotations.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/annotations/search',
        request_field='<request>',
        request_type_name=u'SearchAnnotationsRequest',
        response_type_name=u'SearchAnnotationsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an annotation. Caller must have.
WRITE permission for the associated dataset.

      Args:
        request: (GenomicsAnnotationsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Annotation) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'genomics.annotations.update',
        ordered_params=[u'annotationId'],
        path_params=[u'annotationId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/annotations/{annotationId}',
        request_field=u'annotation',
        request_type_name=u'GenomicsAnnotationsUpdateRequest',
        response_type_name=u'Annotation',
        supports_download=False,
    )

  class AnnotationsetsService(base_api.BaseApiService):
    """Service class for the annotationsets resource."""

    _NAME = u'annotationsets'

    def __init__(self, client):
      super(GenomicsV1.AnnotationsetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new annotation set. Caller must have WRITE permission for the.
associated dataset.

The following fields are required:

  * datasetId
  * referenceSetId

All other fields may be optionally specified, unless documented as being
server-generated (for example, the `id` field).

      Args:
        request: (AnnotationSet) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationSet) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.annotationsets.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/annotationsets',
        request_field='<request>',
        request_type_name=u'AnnotationSet',
        response_type_name=u'AnnotationSet',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an annotation set. Caller must have WRITE permission.
for the associated annotation set.

      Args:
        request: (GenomicsAnnotationsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.annotationsets.delete',
        ordered_params=[u'annotationSetId'],
        path_params=[u'annotationSetId'],
        query_params=[],
        relative_path=u'v1/annotationsets/{annotationSetId}',
        request_field='',
        request_type_name=u'GenomicsAnnotationsetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an annotation set. Caller must have READ permission for.
the associated dataset.

      Args:
        request: (GenomicsAnnotationsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.annotationsets.get',
        ordered_params=[u'annotationSetId'],
        path_params=[u'annotationSetId'],
        query_params=[],
        relative_path=u'v1/annotationsets/{annotationSetId}',
        request_field='',
        request_type_name=u'GenomicsAnnotationsetsGetRequest',
        response_type_name=u'AnnotationSet',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for annotation sets that match the given criteria. Annotation sets.
are returned in an unspecified order. This order is consistent, such that
two queries for the same content (regardless of page size) yield annotation
sets in the same order across their respective streams of paginated
responses. Caller must have READ permission for the queried datasets.

      Args:
        request: (SearchAnnotationSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchAnnotationSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.annotationsets.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/annotationsets/search',
        request_field='<request>',
        request_type_name=u'SearchAnnotationSetsRequest',
        response_type_name=u'SearchAnnotationSetsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an annotation set. The update must respect all mutability.
restrictions and other invariants described on the annotation set resource.
Caller must have WRITE permission for the associated dataset.

      Args:
        request: (GenomicsAnnotationsetsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (AnnotationSet) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PUT',
        method_id=u'genomics.annotationsets.update',
        ordered_params=[u'annotationSetId'],
        path_params=[u'annotationSetId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/annotationsets/{annotationSetId}',
        request_field=u'annotationSet',
        request_type_name=u'GenomicsAnnotationsetsUpdateRequest',
        response_type_name=u'AnnotationSet',
        supports_download=False,
    )

  class CallsetsService(base_api.BaseApiService):
    """Service class for the callsets resource."""

    _NAME = u'callsets'

    def __init__(self, client):
      super(GenomicsV1.CallsetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new call set.

      Args:
        request: (CallSet) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CallSet) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.callsets.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/callsets',
        request_field='<request>',
        request_type_name=u'CallSet',
        response_type_name=u'CallSet',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a call set.

      Args:
        request: (GenomicsCallsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.callsets.delete',
        ordered_params=[u'callSetId'],
        path_params=[u'callSetId'],
        query_params=[],
        relative_path=u'v1/callsets/{callSetId}',
        request_field='',
        request_type_name=u'GenomicsCallsetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a call set by ID.

      Args:
        request: (GenomicsCallsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CallSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.callsets.get',
        ordered_params=[u'callSetId'],
        path_params=[u'callSetId'],
        query_params=[],
        relative_path=u'v1/callsets/{callSetId}',
        request_field='',
        request_type_name=u'GenomicsCallsetsGetRequest',
        response_type_name=u'CallSet',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a call set.

This method supports patch semantics.

      Args:
        request: (GenomicsCallsetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CallSet) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'genomics.callsets.patch',
        ordered_params=[u'callSetId'],
        path_params=[u'callSetId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/callsets/{callSetId}',
        request_field=u'callSet',
        request_type_name=u'GenomicsCallsetsPatchRequest',
        response_type_name=u'CallSet',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Gets a list of call sets matching the criteria.

Implements
[GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).

      Args:
        request: (SearchCallSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchCallSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.callsets.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/callsets/search',
        request_field='<request>',
        request_type_name=u'SearchCallSetsRequest',
        response_type_name=u'SearchCallSetsResponse',
        supports_download=False,
    )

  class DatasetsService(base_api.BaseApiService):
    """Service class for the datasets resource."""

    _NAME = u'datasets'

    def __init__(self, client):
      super(GenomicsV1.DatasetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new dataset.

      Args:
        request: (Dataset) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.datasets.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/datasets',
        request_field='<request>',
        request_type_name=u'Dataset',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a dataset and all of its contents (all read group sets,.
reference sets, variant sets, call sets, annotation sets, etc.)
This is reversible (up to one week after the deletion) via
the
datasets.undelete
operation.

      Args:
        request: (GenomicsDatasetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.datasets.delete',
        ordered_params=[u'datasetId'],
        path_params=[u'datasetId'],
        query_params=[],
        relative_path=u'v1/datasets/{datasetId}',
        request_field='',
        request_type_name=u'GenomicsDatasetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a dataset by ID.

      Args:
        request: (GenomicsDatasetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.datasets.get',
        ordered_params=[u'datasetId'],
        path_params=[u'datasetId'],
        query_params=[],
        relative_path=u'v1/datasets/{datasetId}',
        request_field='',
        request_type_name=u'GenomicsDatasetsGetRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for the dataset. This is empty if the.
policy or resource does not exist.

See <a href="/iam/docs/managing-policies#getting_a_policy">Getting a
Policy</a> for more information.

      Args:
        request: (GenomicsDatasetsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/datasets/{datasetsId}:getIamPolicy',
        http_method=u'POST',
        method_id=u'genomics.datasets.getIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:getIamPolicy',
        request_field=u'getIamPolicyRequest',
        request_type_name=u'GenomicsDatasetsGetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists datasets within a project.

      Args:
        request: (GenomicsDatasetsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDatasetsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.datasets.list',
        ordered_params=[],
        path_params=[],
        query_params=[u'pageSize', u'pageToken', u'projectId'],
        relative_path=u'v1/datasets',
        request_field='',
        request_type_name=u'GenomicsDatasetsListRequest',
        response_type_name=u'ListDatasetsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a dataset.

This method supports patch semantics.

      Args:
        request: (GenomicsDatasetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'genomics.datasets.patch',
        ordered_params=[u'datasetId'],
        path_params=[u'datasetId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/datasets/{datasetId}',
        request_field=u'dataset',
        request_type_name=u'GenomicsDatasetsPatchRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified dataset. Replaces any.
existing policy.

See <a href="/iam/docs/managing-policies#setting_a_policy">Setting a
Policy</a> for more information.

      Args:
        request: (GenomicsDatasetsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/datasets/{datasetsId}:setIamPolicy',
        http_method=u'POST',
        method_id=u'genomics.datasets.setIamPolicy',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:setIamPolicy',
        request_field=u'setIamPolicyRequest',
        request_type_name=u'GenomicsDatasetsSetIamPolicyRequest',
        response_type_name=u'Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource.
See <a href="/iam/docs/managing-policies#testing_permissions">Testing
Permissions</a> for more information.

      Args:
        request: (GenomicsDatasetsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/datasets/{datasetsId}:testIamPermissions',
        http_method=u'POST',
        method_id=u'genomics.datasets.testIamPermissions',
        ordered_params=[u'resource'],
        path_params=[u'resource'],
        query_params=[],
        relative_path=u'v1/{+resource}:testIamPermissions',
        request_field=u'testIamPermissionsRequest',
        request_type_name=u'GenomicsDatasetsTestIamPermissionsRequest',
        response_type_name=u'TestIamPermissionsResponse',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undeletes a dataset by restoring a dataset which was deleted via this API.

This operation is only possible for a week after the deletion occurred.

      Args:
        request: (GenomicsDatasetsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Dataset) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.datasets.undelete',
        ordered_params=[u'datasetId'],
        path_params=[u'datasetId'],
        query_params=[],
        relative_path=u'v1/datasets/{datasetId}:undelete',
        request_field=u'undeleteDatasetRequest',
        request_type_name=u'GenomicsDatasetsUndeleteRequest',
        response_type_name=u'Dataset',
        supports_download=False,
    )

  class OperationsService(base_api.BaseApiService):
    """Service class for the operations resource."""

    _NAME = u'operations'

    def __init__(self, client):
      super(GenomicsV1.OperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation.
The server makes a best effort to cancel the operation, but success is not
guaranteed. Clients may use Operations.GetOperation
or Operations.ListOperations
to check whether the cancellation succeeded or the operation completed
despite cancellation.
Authorization requires the following [Google IAM](https://cloud.google.com/iam) permission&#58;

* `genomics.operations.cancel`

      Args:
        request: (GenomicsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/operations/{operationsId}:cancel',
        http_method=u'POST',
        method_id=u'genomics.operations.cancel',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}:cancel',
        request_field=u'cancelOperationRequest',
        request_type_name=u'GenomicsOperationsCancelRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation.
Clients can use this method to poll the operation result at intervals as
recommended by the API service.
Authorization requires the following [Google IAM](https://cloud.google.com/iam) permission&#58;

* `genomics.operations.get`

      Args:
        request: (GenomicsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/operations/{operationsId}',
        http_method=u'GET',
        method_id=u'genomics.operations.get',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'GenomicsOperationsGetRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request.
Authorization requires the following [Google IAM](https://cloud.google.com/iam) permission&#58;

* `genomics.operations.list`

      Args:
        request: (GenomicsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path=u'v1/operations',
        http_method=u'GET',
        method_id=u'genomics.operations.list',
        ordered_params=[u'name'],
        path_params=[u'name'],
        query_params=[u'filter', u'pageSize', u'pageToken'],
        relative_path=u'v1/{+name}',
        request_field='',
        request_type_name=u'GenomicsOperationsListRequest',
        response_type_name=u'ListOperationsResponse',
        supports_download=False,
    )

  class ReadgroupsetsCoveragebucketsService(base_api.BaseApiService):
    """Service class for the readgroupsets_coveragebuckets resource."""

    _NAME = u'readgroupsets_coveragebuckets'

    def __init__(self, client):
      super(GenomicsV1.ReadgroupsetsCoveragebucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists fixed width coverage buckets for a read group set, each of which.
correspond to a range of a reference sequence. Each bucket summarizes
coverage information across its corresponding genomic range.

Coverage is defined as the number of reads which are aligned to a given
base in the reference sequence. Coverage buckets are available at several
precomputed bucket widths, enabling retrieval of various coverage 'zoom
levels'. The caller must have READ permissions for the target read group
set.

      Args:
        request: (GenomicsReadgroupsetsCoveragebucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCoverageBucketsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.readgroupsets.coveragebuckets.list',
        ordered_params=[u'readGroupSetId'],
        path_params=[u'readGroupSetId'],
        query_params=[u'end', u'pageSize', u'pageToken', u'referenceName', u'start', u'targetBucketWidth'],
        relative_path=u'v1/readgroupsets/{readGroupSetId}/coveragebuckets',
        request_field='',
        request_type_name=u'GenomicsReadgroupsetsCoveragebucketsListRequest',
        response_type_name=u'ListCoverageBucketsResponse',
        supports_download=False,
    )

  class ReadgroupsetsService(base_api.BaseApiService):
    """Service class for the readgroupsets resource."""

    _NAME = u'readgroupsets'

    def __init__(self, client):
      super(GenomicsV1.ReadgroupsetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Deletes a read group set.

      Args:
        request: (GenomicsReadgroupsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.readgroupsets.delete',
        ordered_params=[u'readGroupSetId'],
        path_params=[u'readGroupSetId'],
        query_params=[],
        relative_path=u'v1/readgroupsets/{readGroupSetId}',
        request_field='',
        request_type_name=u'GenomicsReadgroupsetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports a read group set to a BAM file in Google Cloud Storage.

Note that currently there may be some differences between exported BAM
files and the original BAM file at the time of import. See
ImportReadGroupSets
for caveats.

      Args:
        request: (GenomicsReadgroupsetsExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.readgroupsets.export',
        ordered_params=[u'readGroupSetId'],
        path_params=[u'readGroupSetId'],
        query_params=[],
        relative_path=u'v1/readgroupsets/{readGroupSetId}:export',
        request_field=u'exportReadGroupSetRequest',
        request_type_name=u'GenomicsReadgroupsetsExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a read group set by ID.

      Args:
        request: (GenomicsReadgroupsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadGroupSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.readgroupsets.get',
        ordered_params=[u'readGroupSetId'],
        path_params=[u'readGroupSetId'],
        query_params=[],
        relative_path=u'v1/readgroupsets/{readGroupSetId}',
        request_field='',
        request_type_name=u'GenomicsReadgroupsetsGetRequest',
        response_type_name=u'ReadGroupSet',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Creates read group sets by asynchronously importing the provided.
information.

The caller must have WRITE permissions to the dataset.

## Notes on [BAM](https://samtools.github.io/hts-specs/SAMv1.pdf) import

- Tags will be converted to strings - tag types are not preserved
- Comments (`@CO`) in the input file header will not be preserved
- Original header order of references (`@SQ`) will not be preserved
- Any reverse stranded unmapped reads will be reverse complemented, and
their qualities (also the "BQ" and "OQ" tags, if any) will be reversed
- Unmapped reads will be stripped of positional information (reference name
and position)

      Args:
        request: (ImportReadGroupSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.readgroupsets.import',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/readgroupsets:import',
        request_field='<request>',
        request_type_name=u'ImportReadGroupSetsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a read group set.

This method supports patch semantics.

      Args:
        request: (GenomicsReadgroupsetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReadGroupSet) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'genomics.readgroupsets.patch',
        ordered_params=[u'readGroupSetId'],
        path_params=[u'readGroupSetId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/readgroupsets/{readGroupSetId}',
        request_field=u'readGroupSet',
        request_type_name=u'GenomicsReadgroupsetsPatchRequest',
        response_type_name=u'ReadGroupSet',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for read group sets matching the criteria.

Implements
[GlobalAllianceApi.searchReadGroupSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L135).

      Args:
        request: (SearchReadGroupSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReadGroupSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.readgroupsets.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/readgroupsets/search',
        request_field='<request>',
        request_type_name=u'SearchReadGroupSetsRequest',
        response_type_name=u'SearchReadGroupSetsResponse',
        supports_download=False,
    )

  class ReadsService(base_api.BaseApiService):
    """Service class for the reads resource."""

    _NAME = u'reads'

    def __init__(self, client):
      super(GenomicsV1.ReadsService, self).__init__(client)
      self._upload_configs = {
          }

    def Search(self, request, global_params=None):
      r"""Gets a list of reads for one or more read group sets.

Reads search operates over a genomic coordinate space of reference sequence
& position defined over the reference sequences to which the requested
read group sets are aligned.

If a target positional range is specified, search returns all reads whose
alignment to the reference genome overlap the range. A query which
specifies only read group set IDs yields all reads in those read group
sets, including unmapped reads.

All reads returned (including reads on subsequent pages) are ordered by
genomic coordinate (by reference sequence, then position). Reads with
equivalent genomic coordinates are returned in an unspecified order. This
order is consistent, such that two queries for the same content (regardless
of page size) yield reads in the same order across their respective streams
of paginated responses.

Implements
[GlobalAllianceApi.searchReads](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/readmethods.avdl#L85).

      Args:
        request: (SearchReadsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReadsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.reads.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/reads/search',
        request_field='<request>',
        request_type_name=u'SearchReadsRequest',
        response_type_name=u'SearchReadsResponse',
        supports_download=False,
    )

  class ReferencesBasesService(base_api.BaseApiService):
    """Service class for the references_bases resource."""

    _NAME = u'references_bases'

    def __init__(self, client):
      super(GenomicsV1.ReferencesBasesService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""Lists the bases in a reference, optionally restricted to a range.

Implements
[GlobalAllianceApi.getReferenceBases](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L221).

      Args:
        request: (GenomicsReferencesBasesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListBasesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.references.bases.list',
        ordered_params=[u'referenceId'],
        path_params=[u'referenceId'],
        query_params=[u'end', u'pageSize', u'pageToken', u'start'],
        relative_path=u'v1/references/{referenceId}/bases',
        request_field='',
        request_type_name=u'GenomicsReferencesBasesListRequest',
        response_type_name=u'ListBasesResponse',
        supports_download=False,
    )

  class ReferencesService(base_api.BaseApiService):
    """Service class for the references resource."""

    _NAME = u'references'

    def __init__(self, client):
      super(GenomicsV1.ReferencesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a reference.

Implements
[GlobalAllianceApi.getReference](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L158).

      Args:
        request: (GenomicsReferencesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Reference) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.references.get',
        ordered_params=[u'referenceId'],
        path_params=[u'referenceId'],
        query_params=[],
        relative_path=u'v1/references/{referenceId}',
        request_field='',
        request_type_name=u'GenomicsReferencesGetRequest',
        response_type_name=u'Reference',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for references which match the given criteria.

Implements
[GlobalAllianceApi.searchReferences](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L146).

      Args:
        request: (SearchReferencesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReferencesResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.references.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/references/search',
        request_field='<request>',
        request_type_name=u'SearchReferencesRequest',
        response_type_name=u'SearchReferencesResponse',
        supports_download=False,
    )

  class ReferencesetsService(base_api.BaseApiService):
    """Service class for the referencesets resource."""

    _NAME = u'referencesets'

    def __init__(self, client):
      super(GenomicsV1.ReferencesetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets a reference set.

Implements
[GlobalAllianceApi.getReferenceSet](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L83).

      Args:
        request: (GenomicsReferencesetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ReferenceSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.referencesets.get',
        ordered_params=[u'referenceSetId'],
        path_params=[u'referenceSetId'],
        query_params=[],
        relative_path=u'v1/referencesets/{referenceSetId}',
        request_field='',
        request_type_name=u'GenomicsReferencesetsGetRequest',
        response_type_name=u'ReferenceSet',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Searches for reference sets which match the given criteria.

Implements
[GlobalAllianceApi.searchReferenceSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/referencemethods.avdl#L71)

      Args:
        request: (SearchReferenceSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchReferenceSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.referencesets.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/referencesets/search',
        request_field='<request>',
        request_type_name=u'SearchReferenceSetsRequest',
        response_type_name=u'SearchReferenceSetsResponse',
        supports_download=False,
    )

  class VariantsService(base_api.BaseApiService):
    """Service class for the variants resource."""

    _NAME = u'variants'

    def __init__(self, client):
      super(GenomicsV1.VariantsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new variant.

      Args:
        request: (Variant) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variants.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/variants',
        request_field='<request>',
        request_type_name=u'Variant',
        response_type_name=u'Variant',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a variant.

      Args:
        request: (GenomicsVariantsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.variants.delete',
        ordered_params=[u'variantId'],
        path_params=[u'variantId'],
        query_params=[],
        relative_path=u'v1/variants/{variantId}',
        request_field='',
        request_type_name=u'GenomicsVariantsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a variant by ID.

      Args:
        request: (GenomicsVariantsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.variants.get',
        ordered_params=[u'variantId'],
        path_params=[u'variantId'],
        query_params=[],
        relative_path=u'v1/variants/{variantId}',
        request_field='',
        request_type_name=u'GenomicsVariantsGetRequest',
        response_type_name=u'Variant',
        supports_download=False,
    )

    def Import(self, request, global_params=None):
      r"""Creates variant data by asynchronously importing the provided information.

The variants for import will be merged with any existing variant that
matches its reference sequence, start, end, reference bases, and
alternative bases. If no such variant exists, a new one will be created.

When variants are merged, the call information from the new variant
is added to the existing variant, and Variant info fields are merged
as specified in
infoMergeConfig.
As a special case, for single-sample VCF files, QUAL and FILTER fields will
be moved to the call level; these are sometimes interpreted in a
call-specific context.
Imported VCF headers are appended to the metadata already in a variant set.

      Args:
        request: (ImportVariantsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Import')
      return self._RunMethod(
          config, request, global_params=global_params)

    Import.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variants.import',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/variants:import',
        request_field='<request>',
        request_type_name=u'ImportVariantsRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Merge(self, request, global_params=None):
      r"""Merges the given variants with existing variants.

Each variant will be
merged with an existing variant that matches its reference sequence,
start, end, reference bases, and alternative bases. If no such variant
exists, a new one will be created.

When variants are merged, the call information from the new variant
is added to the existing variant. Variant info fields are merged as
specified in the
infoMergeConfig
field of the MergeVariantsRequest.

Please exercise caution when using this method!  It is easy to introduce
mistakes in existing variants and difficult to back out of them.  For
example,
suppose you were trying to merge a new variant with an existing one and
both
variants contain calls that belong to callsets with the same callset ID.

    // Existing variant - irrelevant fields trimmed for clarity
    {
        "variantSetId": "10473108253681171589",
        "referenceName": "1",
        "start": "10582",
        "referenceBases": "G",
        "alternateBases": [
            "A"
        ],
        "calls": [
            {
                "callSetId": "10473108253681171589-0",
                "callSetName": "CALLSET0",
                "genotype": [
                    0,
                    1
                ],
            }
        ]
    }

    // New variant with conflicting call information
    {
        "variantSetId": "10473108253681171589",
        "referenceName": "1",
        "start": "10582",
        "referenceBases": "G",
        "alternateBases": [
            "A"
        ],
        "calls": [
            {
                "callSetId": "10473108253681171589-0",
                "callSetName": "CALLSET0",
                "genotype": [
                    1,
                    1
                ],
            }
        ]
    }

The resulting merged variant would overwrite the existing calls with those
from the new variant:

    {
        "variantSetId": "10473108253681171589",
        "referenceName": "1",
        "start": "10582",
        "referenceBases": "G",
        "alternateBases": [
            "A"
        ],
        "calls": [
            {
                "callSetId": "10473108253681171589-0",
                "callSetName": "CALLSET0",
                "genotype": [
                    1,
                    1
                ],
            }
        ]
    }

This may be the desired outcome, but it is up to the user to determine if
if that is indeed the case.

      Args:
        request: (MergeVariantsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Merge')
      return self._RunMethod(
          config, request, global_params=global_params)

    Merge.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variants.merge',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/variants:merge',
        request_field='<request>',
        request_type_name=u'MergeVariantsRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a variant.

This method supports patch semantics. Returns the modified variant without
its calls.

      Args:
        request: (GenomicsVariantsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Variant) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'genomics.variants.patch',
        ordered_params=[u'variantId'],
        path_params=[u'variantId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/variants/{variantId}',
        request_field=u'variant',
        request_type_name=u'GenomicsVariantsPatchRequest',
        response_type_name=u'Variant',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Gets a list of variants matching the criteria.

Implements
[GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).

      Args:
        request: (SearchVariantsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchVariantsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variants.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/variants/search',
        request_field='<request>',
        request_type_name=u'SearchVariantsRequest',
        response_type_name=u'SearchVariantsResponse',
        supports_download=False,
    )

  class VariantsetsService(base_api.BaseApiService):
    """Service class for the variantsets resource."""

    _NAME = u'variantsets'

    def __init__(self, client):
      super(GenomicsV1.VariantsetsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new variant set.

The provided variant set must have a valid `datasetId` set - all other
fields are optional. Note that the `id` field will be ignored, as this is
assigned by the server.

      Args:
        request: (VariantSet) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VariantSet) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variantsets.create',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/variantsets',
        request_field='<request>',
        request_type_name=u'VariantSet',
        response_type_name=u'VariantSet',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a variant set including all variants, call sets, and calls within.
This is not reversible.

      Args:
        request: (GenomicsVariantsetsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'DELETE',
        method_id=u'genomics.variantsets.delete',
        ordered_params=[u'variantSetId'],
        path_params=[u'variantSetId'],
        query_params=[],
        relative_path=u'v1/variantsets/{variantSetId}',
        request_field='',
        request_type_name=u'GenomicsVariantsetsDeleteRequest',
        response_type_name=u'Empty',
        supports_download=False,
    )

    def Export(self, request, global_params=None):
      r"""Exports variant set data to an external destination.

      Args:
        request: (GenomicsVariantsetsExportRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Export')
      return self._RunMethod(
          config, request, global_params=global_params)

    Export.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variantsets.export',
        ordered_params=[u'variantSetId'],
        path_params=[u'variantSetId'],
        query_params=[],
        relative_path=u'v1/variantsets/{variantSetId}:export',
        request_field=u'exportVariantSetRequest',
        request_type_name=u'GenomicsVariantsetsExportRequest',
        response_type_name=u'Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a variant set by ID.

      Args:
        request: (GenomicsVariantsetsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VariantSet) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'GET',
        method_id=u'genomics.variantsets.get',
        ordered_params=[u'variantSetId'],
        path_params=[u'variantSetId'],
        query_params=[],
        relative_path=u'v1/variantsets/{variantSetId}',
        request_field='',
        request_type_name=u'GenomicsVariantsetsGetRequest',
        response_type_name=u'VariantSet',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a variant set using patch semantics.

      Args:
        request: (GenomicsVariantsetsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VariantSet) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'PATCH',
        method_id=u'genomics.variantsets.patch',
        ordered_params=[u'variantSetId'],
        path_params=[u'variantSetId'],
        query_params=[u'updateMask'],
        relative_path=u'v1/variantsets/{variantSetId}',
        request_field=u'variantSet',
        request_type_name=u'GenomicsVariantsetsPatchRequest',
        response_type_name=u'VariantSet',
        supports_download=False,
    )

    def Search(self, request, global_params=None):
      r"""Returns a list of all variant sets matching search criteria.

Implements
[GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).

      Args:
        request: (SearchVariantSetsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchVariantSetsResponse) The response message.
      """
      config = self.GetMethodConfig('Search')
      return self._RunMethod(
          config, request, global_params=global_params)

    Search.method_config = lambda: base_api.ApiMethodInfo(
        http_method=u'POST',
        method_id=u'genomics.variantsets.search',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path=u'v1/variantsets/search',
        request_field='<request>',
        request_type_name=u'SearchVariantSetsRequest',
        response_type_name=u'SearchVariantSetsResponse',
        supports_download=False,
    )
