"""Generated message classes for container version v1.

The Google Kubernetes Engine API is used for building and managing container
based applications, powered by the open source Kubernetes technology.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding


package = 'container'


class AcceleratorConfig(_messages.Message):
  r"""AcceleratorConfig represents a Hardware Accelerator request.

  Fields:
    acceleratorCount: The number of the accelerator cards exposed to an
      instance.
    acceleratorType: The accelerator type resource name. List of supported
      accelerators [here](/compute/docs/gpus/#Introduction)
  """

  acceleratorCount = _messages.IntegerField(1)
  acceleratorType = _messages.StringField(2)


class AddonsConfig(_messages.Message):
  r"""Configuration for the addons that can be automatically spun up in the
  cluster, enabling additional functionality.

  Fields:
    horizontalPodAutoscaling: Configuration for the horizontal pod autoscaling
      feature, which increases or decreases the number of replica pods a
      replication controller has based on the resource usage of the existing
      pods.
    httpLoadBalancing: Configuration for the HTTP (L7) load balancing
      controller addon, which makes it easy to set up HTTP load balancers for
      services in a cluster.
    kubernetesDashboard: Configuration for the Kubernetes Dashboard.
    networkPolicyConfig: Configuration for NetworkPolicy. This only tracks
      whether the addon is enabled or not on the Master, it does not track
      whether network policy is enabled for the nodes.
  """

  horizontalPodAutoscaling = _messages.MessageField('HorizontalPodAutoscaling', 1)
  httpLoadBalancing = _messages.MessageField('HttpLoadBalancing', 2)
  kubernetesDashboard = _messages.MessageField('KubernetesDashboard', 3)
  networkPolicyConfig = _messages.MessageField('NetworkPolicyConfig', 4)


class AutoUpgradeOptions(_messages.Message):
  r"""AutoUpgradeOptions defines the set of options for the user to control
  how the Auto Upgrades will proceed.

  Fields:
    autoUpgradeStartTime: [Output only] This field is set when upgrades are
      about to commence with the approximate start time for the upgrades, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    description: [Output only] This field is set when upgrades are about to
      commence with the description of the upgrade.
  """

  autoUpgradeStartTime = _messages.StringField(1)
  description = _messages.StringField(2)


class CancelOperationRequest(_messages.Message):
  r"""CancelOperationRequest cancels a single operation.

  Fields:
    name: The name (project, location, operation id) of the operation to
      cancel. Specified in the format 'projects/*/locations/*/operations/*'.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the operation resides.
      This field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1)
  operationId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class CidrBlock(_messages.Message):
  r"""CidrBlock contains an optional name and one CIDR block.

  Fields:
    cidrBlock: cidr_block must be specified in CIDR notation.
    displayName: display_name is an optional field for users to identify CIDR
      blocks.
  """

  cidrBlock = _messages.StringField(1)
  displayName = _messages.StringField(2)


class ClientCertificateConfig(_messages.Message):
  r"""Configuration for client certificates on the cluster.

  Fields:
    issueClientCertificate: Issue a client certificate.
  """

  issueClientCertificate = _messages.BooleanField(1)


class Cluster(_messages.Message):
  r"""A Google Kubernetes Engine cluster.

  Enums:
    StatusValueValuesEnum: [Output only] The current status of this cluster.

  Messages:
    ResourceLabelsValue: The resource labels for the cluster to use to
      annotate any related Google Compute Engine resources.

  Fields:
    addonsConfig: Configurations for the various addons available to run in
      the cluster.
    clusterIpv4Cidr: The IP address range of the container pods in this
      cluster, in [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-
      Domain_Routing) notation (e.g. `10.96.0.0/14`). Leave blank to have one
      automatically chosen or specify a `/14` block in `10.0.0.0/8`.
    conditions: Which conditions caused the current cluster state.
    createTime: [Output only] The time the cluster was created, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    currentMasterVersion: [Output only] The current software version of the
      master endpoint.
    currentNodeCount: [Output only] The number of nodes currently in the
      cluster.
    currentNodeVersion: [Output only] Deprecated, use [NodePool.version
      ](/kubernetes-
      engine/docs/reference/rest/v1/projects.zones.clusters.nodePool) instead.
      The current version of the node software components. If they are
      currently at multiple versions because they're in the process of being
      upgraded, this reflects the minimum version of all nodes.
    description: An optional description of this cluster.
    enableKubernetesAlpha: Kubernetes alpha features are enabled on this
      cluster. This includes alpha API groups (e.g. v1alpha1) and features
      that may not be production ready in the kubernetes version of the master
      and nodes. The cluster has no SLA for uptime and master/node upgrades
      are disabled. Alpha enabled clusters are automatically deleted thirty
      days after creation.
    endpoint: [Output only] The IP address of this cluster's master endpoint.
      The endpoint can be accessed from the internet at
      `https://username:password@endpoint/`.  See the `masterAuth` property of
      this resource for username and password information.
    expireTime: [Output only] The time the cluster will be automatically
      deleted in [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    initialClusterVersion: The initial Kubernetes version for this cluster.
      Valid versions are those found in validMasterVersions returned by
      getServerConfig.  The version can be upgraded over time; such upgrades
      are reflected in currentMasterVersion and currentNodeVersion.  Users may
      specify either explicit versions offered by Kubernetes Engine or version
      aliases, which have the following behavior:  - "latest": picks the
      highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "","-": picks the default Kubernetes version
    initialNodeCount: The number of nodes to create in this cluster. You must
      ensure that your Compute Engine <a href="/compute/docs/resource-
      quotas">resource quota</a> is sufficient for this number of instances.
      You must also have available firewall and routes quota. For requests,
      this field should only be used in lieu of a "node_pool" object, since
      this configuration (along with the "node_config") will be used to create
      a "NodePool" object with an auto-generated name. Do not use this and a
      node_pool at the same time.
    instanceGroupUrls: Deprecated. Use node_pools.instance_group_urls.
    ipAllocationPolicy: Configuration for cluster IP allocation.
    labelFingerprint: The fingerprint of the set of labels for this cluster.
    legacyAbac: Configuration for the legacy ABAC authorization mode.
    location: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/regions-zones/regions-zones#available) or
      [region](/compute/docs/regions-zones/regions-zones#available) in which
      the cluster resides.
    locations: The list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located.
    loggingService: The logging service the cluster should use to write logs.
      Currently available options:  * `logging.googleapis.com` - the Google
      Cloud Logging service. * `none` - no logs will be exported from the
      cluster. * if left as an empty string,`logging.googleapis.com` will be
      used.
    maintenancePolicy: Configure the maintenance policy for this cluster.
    masterAuth: The authentication information for accessing the master
      endpoint.
    masterAuthorizedNetworksConfig: The configuration options for master
      authorized networks feature.
    monitoringService: The monitoring service the cluster should use to write
      metrics. Currently available options:  * `monitoring.googleapis.com` -
      the Google Cloud Monitoring service. * `none` - no metrics will be
      exported from the cluster. * if left as an empty string,
      `monitoring.googleapis.com` will be used.
    name: The name of this cluster. The name must be unique within this
      project and zone, and can be up to 40 characters with the following
      restrictions:  * Lowercase letters, numbers, and hyphens only. * Must
      start with a letter. * Must end with a number or a letter.
    network: The name of the Google Compute Engine [network](/compute/docs
      /networks-and-firewalls#networks) to which the cluster is connected. If
      left unspecified, the `default` network will be used.
    networkConfig: Configuration for cluster networking.
    networkPolicy: Configuration options for the NetworkPolicy feature.
    nodeConfig: Parameters used in creating the cluster's nodes. See
      `nodeConfig` for the description of its properties. For requests, this
      field should only be used in lieu of a "node_pool" object, since this
      configuration (along with the "initial_node_count") will be used to
      create a "NodePool" object with an auto-generated name. Do not use this
      and a node_pool at the same time. For responses, this field will be
      populated with the node configuration of the first node pool.  If
      unspecified, the defaults are used.
    nodeIpv4CidrSize: [Output only] The size of the address space on each node
      for hosting containers. This is provisioned from within the
      `container_ipv4_cidr` range.
    nodePools: The node pools associated with this cluster. This field should
      not be set if "node_config" or "initial_node_count" are specified.
    privateClusterConfig: Configuration for private cluster.
    resourceLabels: The resource labels for the cluster to use to annotate any
      related Google Compute Engine resources.
    selfLink: [Output only] Server-defined URL for the resource.
    servicesIpv4Cidr: [Output only] The IP address range of the Kubernetes
      services in this cluster, in [CIDR](http://en.wikipedia.org/wiki
      /Classless_Inter-Domain_Routing) notation (e.g. `1.2.3.4/29`). Service
      addresses are typically put in the last `/16` from the container CIDR.
    status: [Output only] The current status of this cluster.
    statusMessage: [Output only] Additional information about the current
      status of this cluster, if available.
    subnetwork: The name of the Google Compute Engine
      [subnetwork](/compute/docs/subnetworks) to which the cluster is
      connected.
    zone: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field is deprecated, use location instead.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output only] The current status of this cluster.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the cluster is being
        created.
      RUNNING: The RUNNING state indicates the cluster has been created and is
        fully usable.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the cluster, such as upgrading the master or node
        software. Details can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the cluster is being deleted.
      ERROR: The ERROR state indicates the cluster may be unusable. Details
        can be found in the `statusMessage` field.
      DEGRADED: The DEGRADED state indicates the cluster requires user action
        to restore full functionality. Details can be found in the
        `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RECONCILING = 3
    STOPPING = 4
    ERROR = 5
    DEGRADED = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""The resource labels for the cluster to use to annotate any related
    Google Compute Engine resources.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  clusterIpv4Cidr = _messages.StringField(2)
  conditions = _messages.MessageField('StatusCondition', 3, repeated=True)
  createTime = _messages.StringField(4)
  currentMasterVersion = _messages.StringField(5)
  currentNodeCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  currentNodeVersion = _messages.StringField(7)
  description = _messages.StringField(8)
  enableKubernetesAlpha = _messages.BooleanField(9)
  endpoint = _messages.StringField(10)
  expireTime = _messages.StringField(11)
  initialClusterVersion = _messages.StringField(12)
  initialNodeCount = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(14, repeated=True)
  ipAllocationPolicy = _messages.MessageField('IPAllocationPolicy', 15)
  labelFingerprint = _messages.StringField(16)
  legacyAbac = _messages.MessageField('LegacyAbac', 17)
  location = _messages.StringField(18)
  locations = _messages.StringField(19, repeated=True)
  loggingService = _messages.StringField(20)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 21)
  masterAuth = _messages.MessageField('MasterAuth', 22)
  masterAuthorizedNetworksConfig = _messages.MessageField('MasterAuthorizedNetworksConfig', 23)
  monitoringService = _messages.StringField(24)
  name = _messages.StringField(25)
  network = _messages.StringField(26)
  networkConfig = _messages.MessageField('NetworkConfig', 27)
  networkPolicy = _messages.MessageField('NetworkPolicy', 28)
  nodeConfig = _messages.MessageField('NodeConfig', 29)
  nodeIpv4CidrSize = _messages.IntegerField(30, variant=_messages.Variant.INT32)
  nodePools = _messages.MessageField('NodePool', 31, repeated=True)
  privateClusterConfig = _messages.MessageField('PrivateClusterConfig', 32)
  resourceLabels = _messages.MessageField('ResourceLabelsValue', 33)
  selfLink = _messages.StringField(34)
  servicesIpv4Cidr = _messages.StringField(35)
  status = _messages.EnumField('StatusValueValuesEnum', 36)
  statusMessage = _messages.StringField(37)
  subnetwork = _messages.StringField(38)
  zone = _messages.StringField(39)


class ClusterUpdate(_messages.Message):
  r"""ClusterUpdate describes an update to the cluster. Exactly one update can
  be applied to a cluster with each request, so at most one field can be
  provided.

  Fields:
    desiredAddonsConfig: Configurations for the various addons available to
      run in the cluster.
    desiredImage: The desired name of the image to use for this node. This is
      used to create clusters using a custom image. NOTE: Set the
      "desired_node_pool" field as well.
    desiredImageProject: The project containing the desired image to use for
      this node. This is used to create clusters using a custom image. NOTE:
      Set the "desired_node_pool" field as well.
    desiredImageType: The desired image type for the node pool. NOTE: Set the
      "desired_node_pool" field as well.
    desiredLocations: The desired list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located. Changing the locations a cluster is in will result in
      nodes being either created or removed from the cluster, depending on
      whether locations are being added or removed.  This list must always
      include the cluster's primary zone.
    desiredMasterAuthorizedNetworksConfig: The desired configuration options
      for master authorized networks feature.
    desiredMasterVersion: The Kubernetes version to change the master to.
      Users may specify either explicit versions offered by Kubernetes Engine
      or version aliases, which have the following behavior:  - "latest":
      picks the highest valid Kubernetes version - "1.X": picks the highest
      valid patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest
      valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an
      explicit Kubernetes version - "-": picks the default Kubernetes version
    desiredMonitoringService: The monitoring service the cluster should use to
      write metrics. Currently available options:  *
      "monitoring.googleapis.com" - the Google Cloud Monitoring service *
      "none" - no metrics will be exported from the cluster
    desiredNodePoolAutoscaling: Autoscaler configuration for the node pool
      specified in desired_node_pool_id. If there is only one pool in the
      cluster and desired_node_pool_id is not provided then the change applies
      to that single node pool.
    desiredNodePoolId: The node pool to be upgraded. This field is mandatory
      if "desired_node_version", "desired_image_family" or
      "desired_node_pool_autoscaling" is specified and there is more than one
      node pool on the cluster.
    desiredNodeVersion: The Kubernetes version to change the nodes to
      (typically an upgrade).  Users may specify either explicit versions
      offered by Kubernetes Engine or version aliases, which have the
      following behavior:  - "latest": picks the highest valid Kubernetes
      version - "1.X": picks the highest valid patch+gke.N patch in the 1.X
      version - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y
      version - "1.X.Y-gke.N": picks an explicit Kubernetes version - "-":
      picks the Kubernetes master version
  """

  desiredAddonsConfig = _messages.MessageField('AddonsConfig', 1)
  desiredImage = _messages.StringField(2)
  desiredImageProject = _messages.StringField(3)
  desiredImageType = _messages.StringField(4)
  desiredLocations = _messages.StringField(5, repeated=True)
  desiredMasterAuthorizedNetworksConfig = _messages.MessageField('MasterAuthorizedNetworksConfig', 6)
  desiredMasterVersion = _messages.StringField(7)
  desiredMonitoringService = _messages.StringField(8)
  desiredNodePoolAutoscaling = _messages.MessageField('NodePoolAutoscaling', 9)
  desiredNodePoolId = _messages.StringField(10)
  desiredNodeVersion = _messages.StringField(11)


class CompleteIPRotationRequest(_messages.Message):
  r"""CompleteIPRotationRequest moves the cluster master back into single-IP
  mode.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to complete
      IP rotation. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersDeleteRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to delete. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to delete.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to retrieve. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to retrieve.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsClustersListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersListRequest object.

  Fields:
    parent: The parent (project and location) where the clusters will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides, or
      "-" for all zones. This field has been deprecated and replaced by the
      parent field.
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class ContainerProjectsLocationsClustersNodePoolsDeleteRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to delete. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to delete. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsClustersNodePoolsGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to get. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool. This field has been
      deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class ContainerProjectsLocationsClustersNodePoolsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsClustersNodePoolsListRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    parent: The parent (project, location, cluster id) where the node pools
      will be listed. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  clusterId = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsGetServerConfigRequest(_messages.Message):
  r"""A ContainerProjectsLocationsGetServerConfigRequest object.

  Fields:
    name: The name (project and location) of the server config to get
      Specified in the format 'projects/*/locations/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class ContainerProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ContainerProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name (project, location, operation id) of the operation to get.
      Specified in the format 'projects/*/locations/*/operations/*'.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1, required=True)
  operationId = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ContainerProjectsLocationsOperationsListRequest object.

  Fields:
    parent: The parent (project and location) where the operations will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for, or `-`
      for all zones. This field has been deprecated and replaced by the parent
      field.
  """

  parent = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2)
  zone = _messages.StringField(3)


class ContainerProjectsZonesClustersDeleteRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to delete. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to delete.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster to retrieve. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to retrieve.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesClustersListRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersListRequest object.

  Fields:
    parent: The parent (project and location) where the clusters will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides, or
      "-" for all zones. This field has been deprecated and replaced by the
      parent field.
  """

  parent = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesClustersNodePoolsDeleteRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsDeleteRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to delete. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to delete. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersNodePoolsGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsGetRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to get. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool. This field has been
      deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1, required=True)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3, required=True)
  projectId = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class ContainerProjectsZonesClustersNodePoolsListRequest(_messages.Message):
  r"""A ContainerProjectsZonesClustersNodePoolsListRequest object.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    parent: The parent (project, location, cluster id) where the node pools
      will be listed. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  clusterId = _messages.StringField(1, required=True)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesGetServerconfigRequest(_messages.Message):
  r"""A ContainerProjectsZonesGetServerconfigRequest object.

  Fields:
    name: The name (project and location) of the server config to get
      Specified in the format 'projects/*/locations/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class ContainerProjectsZonesOperationsGetRequest(_messages.Message):
  r"""A ContainerProjectsZonesOperationsGetRequest object.

  Fields:
    name: The name (project, location, operation id) of the operation to get.
      Specified in the format 'projects/*/locations/*/operations/*'.
    operationId: Deprecated. The server-assigned `name` of the operation. This
      field has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  name = _messages.StringField(1)
  operationId = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class ContainerProjectsZonesOperationsListRequest(_messages.Message):
  r"""A ContainerProjectsZonesOperationsListRequest object.

  Fields:
    parent: The parent (project and location) where the operations will be
      listed. Specified in the format 'projects/*/locations/*'. Location "-"
      matches all zones and all regions.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) to return operations for, or `-`
      for all zones. This field has been deprecated and replaced by the parent
      field.
  """

  parent = _messages.StringField(1)
  projectId = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class CreateClusterRequest(_messages.Message):
  r"""CreateClusterRequest creates a cluster.

  Fields:
    cluster: A [cluster resource](/container-
      engine/reference/rest/v1/projects.zones.clusters)
    parent: The parent (project and location) where the cluster will be
      created. Specified in the format 'projects/*/locations/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  cluster = _messages.MessageField('Cluster', 1)
  parent = _messages.StringField(2)
  projectId = _messages.StringField(3)
  zone = _messages.StringField(4)


class CreateNodePoolRequest(_messages.Message):
  r"""CreateNodePoolRequest creates a node pool for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the parent field.
    nodePool: The node pool to create.
    parent: The parent (project, location, cluster id) where the node pool
      will be created. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the parent field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the parent field.
  """

  clusterId = _messages.StringField(1)
  nodePool = _messages.MessageField('NodePool', 2)
  parent = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class CustomImageConfig(_messages.Message):
  r"""CustomImageConfig contains the information r

  Fields:
    image: The name of the image to use for this node.
    imageFamily: The name of the image family to use for this node.
    imageProject: The project containing the image to use for this node.
  """

  image = _messages.StringField(1)
  imageFamily = _messages.StringField(2)
  imageProject = _messages.StringField(3)


class DailyMaintenanceWindow(_messages.Message):
  r"""Time window specified for daily maintenance operations.

  Fields:
    duration: [Output only] Duration of the time window, automatically chosen
      to be smallest possible in the given scenario. Duration will be in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "PTnHnMnS".
    startTime: Time within the maintenance window to start the maintenance
      operations. Time format should be in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) format "HH:MM", where HH
      : [00-23] and MM : [00-59] GMT.
  """

  duration = _messages.StringField(1)
  startTime = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class HorizontalPodAutoscaling(_messages.Message):
  r"""Configuration options for the horizontal pod autoscaling feature, which
  increases or decreases the number of replica pods a replication controller
  has based on the resource usage of the existing pods.

  Fields:
    disabled: Whether the Horizontal Pod Autoscaling feature is enabled in the
      cluster. When enabled, it ensures that a Heapster pod is running in the
      cluster, which is also used by the Cloud Monitoring service.
  """

  disabled = _messages.BooleanField(1)


class HttpLoadBalancing(_messages.Message):
  r"""Configuration options for the HTTP (L7) load balancing controller addon,
  which makes it easy to set up HTTP load balancers for services in a cluster.

  Fields:
    disabled: Whether the HTTP Load Balancing controller is enabled in the
      cluster. When enabled, it runs a small pod in the cluster that manages
      the load balancers.
  """

  disabled = _messages.BooleanField(1)


class IPAllocationPolicy(_messages.Message):
  r"""Configuration for controlling how IPs are allocated in the cluster.

  Fields:
    clusterIpv4Cidr: This field is deprecated, use cluster_ipv4_cidr_block.
    clusterIpv4CidrBlock: The IP address range for the cluster pod IPs. If
      this field is set, then `cluster.cluster_ipv4_cidr` must be left blank.
      This field is only applicable when `use_ip_aliases` is true.  Set to
      blank to have a range chosen with the default size.  Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    clusterSecondaryRangeName: The name of the secondary range to be used for
      the cluster CIDR block.  The secondary range will be used for pod IP
      addresses. This must be an existing secondary range associated with the
      cluster subnetwork.  This field is only applicable with use_ip_aliases
      is true and create_subnetwork is false.
    createSubnetwork: Whether a new subnetwork will be created automatically
      for the cluster.  This field is only applicable when `use_ip_aliases` is
      true.
    nodeIpv4Cidr: This field is deprecated, use node_ipv4_cidr_block.
    nodeIpv4CidrBlock: The IP address range of the instance IPs in this
      cluster.  This is applicable only if `create_subnetwork` is true.  Set
      to blank to have a range chosen with the default size.  Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    servicesIpv4Cidr: This field is deprecated, use services_ipv4_cidr_block.
    servicesIpv4CidrBlock: The IP address range of the services IPs in this
      cluster. If blank, a range will be automatically chosen with the default
      size.  This field is only applicable when `use_ip_aliases` is true.  Set
      to blank to have a range chosen with the default size.  Set to /netmask
      (e.g. `/14`) to have a range chosen with a specific netmask.  Set to a
      [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing)
      notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g.
      `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific
      range to use.
    servicesSecondaryRangeName: The name of the secondary range to be used as
      for the services CIDR block.  The secondary range will be used for
      service ClusterIPs. This must be an existing secondary range associated
      with the cluster subnetwork.  This field is only applicable with
      use_ip_aliases is true and create_subnetwork is false.
    subnetworkName: A custom subnetwork name to be used if `create_subnetwork`
      is true.  If this field is empty, then an automatic name will be chosen
      for the new subnetwork.
    useIpAliases: Whether alias IPs will be used for pod IPs in the cluster.
  """

  clusterIpv4Cidr = _messages.StringField(1)
  clusterIpv4CidrBlock = _messages.StringField(2)
  clusterSecondaryRangeName = _messages.StringField(3)
  createSubnetwork = _messages.BooleanField(4)
  nodeIpv4Cidr = _messages.StringField(5)
  nodeIpv4CidrBlock = _messages.StringField(6)
  servicesIpv4Cidr = _messages.StringField(7)
  servicesIpv4CidrBlock = _messages.StringField(8)
  servicesSecondaryRangeName = _messages.StringField(9)
  subnetworkName = _messages.StringField(10)
  useIpAliases = _messages.BooleanField(11)


class KubernetesDashboard(_messages.Message):
  r"""Configuration for the Kubernetes Dashboard.

  Fields:
    disabled: Whether the Kubernetes Dashboard is enabled for this cluster.
  """

  disabled = _messages.BooleanField(1)


class LegacyAbac(_messages.Message):
  r"""Configuration for the legacy Attribute Based Access Control
  authorization mode.

  Fields:
    enabled: Whether the ABAC authorizer is enabled for this cluster. When
      enabled, identities in the system, including service accounts, nodes,
      and controllers, will have statically granted permissions beyond those
      provided by the RBAC configuration or IAM.
  """

  enabled = _messages.BooleanField(1)


class ListClustersResponse(_messages.Message):
  r"""ListClustersResponse is the result of ListClustersRequest.

  Fields:
    clusters: A list of clusters in the project in the specified zone, or
      across all ones.
    missingZones: If any zones are listed here, the list of clusters returned
      may be missing those zones.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  missingZones = _messages.StringField(2, repeated=True)


class ListNodePoolsResponse(_messages.Message):
  r"""ListNodePoolsResponse is the result of ListNodePoolsRequest.

  Fields:
    nodePools: A list of node pools for a cluster.
  """

  nodePools = _messages.MessageField('NodePool', 1, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""ListOperationsResponse is the result of ListOperationsRequest.

  Fields:
    missingZones: If any zones are listed here, the list of operations
      returned may be missing the operations from those zones.
    operations: A list of operations in the project in the specified zone.
  """

  missingZones = _messages.StringField(1, repeated=True)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class MaintenancePolicy(_messages.Message):
  r"""MaintenancePolicy defines the maintenance policy to be used for the
  cluster.

  Fields:
    window: Specifies the maintenance window in which maintenance may be
      performed.
  """

  window = _messages.MessageField('MaintenanceWindow', 1)


class MaintenanceWindow(_messages.Message):
  r"""MaintenanceWindow defines the maintenance window to be used for the
  cluster.

  Fields:
    dailyMaintenanceWindow: DailyMaintenanceWindow specifies a daily
      maintenance operation window.
  """

  dailyMaintenanceWindow = _messages.MessageField('DailyMaintenanceWindow', 1)


class MasterAuth(_messages.Message):
  r"""The authentication information for accessing the master endpoint.
  Authentication can be done using HTTP basic auth or using client
  certificates.

  Fields:
    clientCertificate: [Output only] Base64-encoded public certificate used by
      clients to authenticate to the cluster endpoint.
    clientCertificateConfig: Configuration for client certificate
      authentication on the cluster. For clusters before v1.12, if no
      configuration is specified, a client certificate is issued.
    clientKey: [Output only] Base64-encoded private key used by clients to
      authenticate to the cluster endpoint.
    clusterCaCertificate: [Output only] Base64-encoded public certificate that
      is the root of trust for the cluster.
    password: The password to use for HTTP basic authentication to the master
      endpoint. Because the master endpoint is open to the Internet, you
      should create a strong password.  If a password is provided for cluster
      creation, username must be non-empty.
    username: The username to use for HTTP basic authentication to the master
      endpoint. For clusters v1.6.0 and later, you can disable basic
      authentication by providing an empty username.
  """

  clientCertificate = _messages.StringField(1)
  clientCertificateConfig = _messages.MessageField('ClientCertificateConfig', 2)
  clientKey = _messages.StringField(3)
  clusterCaCertificate = _messages.StringField(4)
  password = _messages.StringField(5)
  username = _messages.StringField(6)


class MasterAuthorizedNetworksConfig(_messages.Message):
  r"""Configuration options for the master authorized networks feature.
  Enabled master authorized networks will disallow all external traffic to
  access Kubernetes master through HTTPS except traffic from the given CIDR
  blocks, Google Compute Engine Public IPs and Google Prod IPs.

  Fields:
    cidrBlocks: cidr_blocks define up to 10 external networks that could
      access Kubernetes master through HTTPS.
    enabled: Whether or not master authorized networks is enabled.
  """

  cidrBlocks = _messages.MessageField('CidrBlock', 1, repeated=True)
  enabled = _messages.BooleanField(2)


class NetworkConfig(_messages.Message):
  r"""NetworkConfig reports the relative names of network & subnetwork.

  Fields:
    network: Output only. The relative name of the Google Compute Engine
      network(/compute/docs/networks-and-firewalls#networks) to which the
      cluster is connected. Example: projects/my-project/global/networks/my-
      network
    subnetwork: Output only. The relative name of the Google Compute Engine
      [subnetwork](/compute/docs/vpc) to which the cluster is connected.
      Example: projects/my-project/regions/us-central1/subnetworks/my-subnet
  """

  network = _messages.StringField(1)
  subnetwork = _messages.StringField(2)


class NetworkPolicy(_messages.Message):
  r"""Configuration options for the NetworkPolicy feature.
  https://kubernetes.io/docs/concepts/services-networking/networkpolicies/

  Enums:
    ProviderValueValuesEnum: The selected network policy provider.

  Fields:
    enabled: Whether network policy is enabled on the cluster.
    provider: The selected network policy provider.
  """

  class ProviderValueValuesEnum(_messages.Enum):
    r"""The selected network policy provider.

    Values:
      PROVIDER_UNSPECIFIED: Not set
      CALICO: Tigera (Calico Felix).
    """
    PROVIDER_UNSPECIFIED = 0
    CALICO = 1

  enabled = _messages.BooleanField(1)
  provider = _messages.EnumField('ProviderValueValuesEnum', 2)


class NetworkPolicyConfig(_messages.Message):
  r"""Configuration for NetworkPolicy. This only tracks whether the addon is
  enabled or not on the Master, it does not track whether network policy is
  enabled for the nodes.

  Fields:
    disabled: Whether NetworkPolicy is enabled for this cluster.
  """

  disabled = _messages.BooleanField(1)


class NodeConfig(_messages.Message):
  r"""Parameters that describe the nodes in a cluster.

  Messages:
    LabelsValue: The map of Kubernetes labels (key/value pairs) to be applied
      to each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    MetadataValue: The metadata key/value pairs assigned to instances in the
      cluster.  Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      reserved keys:  "cluster-location"  "cluster-name"  "cluster-uid"
      "configure-sh"  "enable-os-login"  "gci-update-strategy"  "gci-ensure-
      gke-docker"  "instance-template"  "kube-env"  "startup-script"  "user-
      data"  Values are free-form strings, and only have meaning as
      interpreted by the image running in the instance. The only restriction
      placed on them is that each value's size must be less than or equal to
      32 KB.  The total size of all keys and values must be less than 512 KB.

  Fields:
    accelerators: A list of hardware accelerators to be attached to each node.
      See https://cloud.google.com/compute/docs/gpus for more information
      about support for GPUs.
    diskSizeGb: Size of the disk attached to each node, specified in GB. The
      smallest allowed disk size is 10GB.  If unspecified, the default disk
      size is 100GB.
    diskType: Type of the disk attached to each node (e.g. 'pd-standard' or
      'pd-ssd')  If unspecified, the default disk type is 'pd-standard'
    imageType: The image type to use for this node. Note that for a given
      image type, the latest version of it will be used.
    labels: The map of Kubernetes labels (key/value pairs) to be applied to
      each node. These will added in addition to any default label(s) that
      Kubernetes may apply to the node. In case of conflict in label keys, the
      applied set may differ depending on the Kubernetes version -- it's best
      to assume the behavior is undefined and conflicts should be avoided. For
      more information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/overview/working-with-
      objects/labels/
    localSsdCount: The number of local SSD disks to be attached to the node.
      The limit for this value is dependant upon the maximum number of disks
      available on a machine per zone. See:
      https://cloud.google.com/compute/docs/disks/local-ssd#local_ssd_limits
      for more information.
    machineType: The name of a Google Compute Engine [machine
      type](/compute/docs/machine-types) (e.g. `n1-standard-1`).  If
      unspecified, the default machine type is `n1-standard-1`.
    metadata: The metadata key/value pairs assigned to instances in the
      cluster.  Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less
      than 128 bytes in length. These are reflected as part of a URL in the
      metadata server. Additionally, to avoid ambiguity, keys must not
      conflict with any other metadata keys for the project or be one of the
      reserved keys:  "cluster-location"  "cluster-name"  "cluster-uid"
      "configure-sh"  "enable-os-login"  "gci-update-strategy"  "gci-ensure-
      gke-docker"  "instance-template"  "kube-env"  "startup-script"  "user-
      data"  Values are free-form strings, and only have meaning as
      interpreted by the image running in the instance. The only restriction
      placed on them is that each value's size must be less than or equal to
      32 KB.  The total size of all keys and values must be less than 512 KB.
    minCpuPlatform: Minimum CPU platform to be used by this instance. The
      instance may be scheduled on the specified or newer CPU platform.
      Applicable values are the friendly names of CPU platforms, such as
      <code>minCpuPlatform: &quot;Intel Haswell&quot;</code> or
      <code>minCpuPlatform: &quot;Intel Sandy Bridge&quot;</code>. For more
      information, read [how to specify min CPU
      platform](https://cloud.google.com/compute/docs/instances/specify-min-
      cpu-platform)
    nodeImageConfig: The node image configuration to use for this node pool.
      Note that this is only applicable for node pools using
      image_type=CUSTOM.
    oauthScopes: The set of Google API scopes to be made available on all of
      the node VMs under the "default" service account.  The following scopes
      are recommended, but not required, and by default are not included:  *
      `https://www.googleapis.com/auth/compute` is required for mounting
      persistent storage on your nodes. *
      `https://www.googleapis.com/auth/devstorage.read_only` is required for
      communicating with **gcr.io** (the [Google Container Registry
      ](/container-registry/)).  If unspecified, no scopes are added, unless
      Cloud Logging or Cloud Monitoring are enabled, in which case their
      required scopes will be added.
    preemptible: Whether the nodes are created as preemptible VM instances.
      See: https://cloud.google.com/compute/docs/instances/preemptible for
      more information about preemptible VM instances.
    serviceAccount: The Google Cloud Platform Service Account to be used by
      the node VMs. If no Service Account is specified, the "default" service
      account is used.
    tags: The list of instance tags applied to all nodes. Tags are used to
      identify valid sources or targets for network firewalls and are
      specified by the client during cluster or node pool creation. Each tag
      within the list must comply with RFC1035.
    taints: List of kubernetes taints to be applied to each node.  For more
      information, including usage and the valid values, see:
      https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The map of Kubernetes labels (key/value pairs) to be applied to each
    node. These will added in addition to any default label(s) that Kubernetes
    may apply to the node. In case of conflict in label keys, the applied set
    may differ depending on the Kubernetes version -- it's best to assume the
    behavior is undefined and conflicts should be avoided. For more
    information, including usage and the valid values, see:
    https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The metadata key/value pairs assigned to instances in the cluster.
    Keys must conform to the regexp [a-zA-Z0-9-_]+ and be less than 128 bytes
    in length. These are reflected as part of a URL in the metadata server.
    Additionally, to avoid ambiguity, keys must not conflict with any other
    metadata keys for the project or be one of the reserved keys:  "cluster-
    location"  "cluster-name"  "cluster-uid"  "configure-sh"  "enable-os-
    login"  "gci-update-strategy"  "gci-ensure-gke-docker"  "instance-
    template"  "kube-env"  "startup-script"  "user-data"  Values are free-form
    strings, and only have meaning as interpreted by the image running in the
    instance. The only restriction placed on them is that each value's size
    must be less than or equal to 32 KB.  The total size of all keys and
    values must be less than 512 KB.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Additional properties of type MetadataValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accelerators = _messages.MessageField('AcceleratorConfig', 1, repeated=True)
  diskSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  diskType = _messages.StringField(3)
  imageType = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  localSsdCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  machineType = _messages.StringField(7)
  metadata = _messages.MessageField('MetadataValue', 8)
  minCpuPlatform = _messages.StringField(9)
  nodeImageConfig = _messages.MessageField('CustomImageConfig', 10)
  oauthScopes = _messages.StringField(11, repeated=True)
  preemptible = _messages.BooleanField(12)
  serviceAccount = _messages.StringField(13)
  tags = _messages.StringField(14, repeated=True)
  taints = _messages.MessageField('NodeTaint', 15, repeated=True)


class NodeManagement(_messages.Message):
  r"""NodeManagement defines the set of node management services turned on for
  the node pool.

  Fields:
    autoRepair: A flag that specifies whether the node auto-repair is enabled
      for the node pool. If enabled, the nodes in this node pool will be
      monitored and, if they fail health checks too many times, an automatic
      repair action will be triggered.
    autoUpgrade: A flag that specifies whether node auto-upgrade is enabled
      for the node pool. If enabled, node auto-upgrade helps keep the nodes in
      your node pool up to date with the latest release version of Kubernetes.
    upgradeOptions: Specifies the Auto Upgrade knobs for the node pool.
  """

  autoRepair = _messages.BooleanField(1)
  autoUpgrade = _messages.BooleanField(2)
  upgradeOptions = _messages.MessageField('AutoUpgradeOptions', 3)


class NodePool(_messages.Message):
  r"""NodePool contains the name and configuration for a cluster's node pool.
  Node pools are a set of nodes (i.e. VM's), with a common configuration and
  specification, under the control of the cluster master. They may have a set
  of Kubernetes labels applied to them, which may be used to reference them
  during pod scheduling. They may also be resized up or down, to accommodate
  the workload.

  Enums:
    StatusValueValuesEnum: [Output only] The status of the nodes in this pool
      instance.

  Fields:
    autoscaling: Autoscaler configuration for this NodePool. Autoscaler is
      enabled only if a valid configuration is present.
    conditions: Which conditions caused the current node pool state.
    config: The node configuration of the pool.
    initialNodeCount: The initial node count for the pool. You must ensure
      that your Compute Engine <a href="/compute/docs/resource-
      quotas">resource quota</a> is sufficient for this number of instances.
      You must also have available firewall and routes quota.
    instanceGroupUrls: [Output only] The resource URLs of the [managed
      instance groups](/compute/docs/instance-groups/creating-groups-of-
      managed-instances) associated with this node pool.
    management: NodeManagement configuration for this NodePool.
    name: The name of the node pool.
    selfLink: [Output only] Server-defined URL for the resource.
    status: [Output only] The status of the nodes in this pool instance.
    statusMessage: [Output only] Additional information about the current
      status of this node pool instance, if available.
    version: The version of the Kubernetes of this node.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""[Output only] The status of the nodes in this pool instance.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PROVISIONING: The PROVISIONING state indicates the node pool is being
        created.
      RUNNING: The RUNNING state indicates the node pool has been created and
        is fully usable.
      RUNNING_WITH_ERROR: The RUNNING_WITH_ERROR state indicates the node pool
        has been created and is partially usable. Some error state has
        occurred and some functionality may be impaired. Customer may need to
        reissue a request or trigger a new update.
      RECONCILING: The RECONCILING state indicates that some work is actively
        being done on the node pool, such as upgrading node software. Details
        can be found in the `statusMessage` field.
      STOPPING: The STOPPING state indicates the node pool is being deleted.
      ERROR: The ERROR state indicates the node pool may be unusable. Details
        can be found in the `statusMessage` field.
    """
    STATUS_UNSPECIFIED = 0
    PROVISIONING = 1
    RUNNING = 2
    RUNNING_WITH_ERROR = 3
    RECONCILING = 4
    STOPPING = 5
    ERROR = 6

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  conditions = _messages.MessageField('StatusCondition', 2, repeated=True)
  config = _messages.MessageField('NodeConfig', 3)
  initialNodeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  instanceGroupUrls = _messages.StringField(5, repeated=True)
  management = _messages.MessageField('NodeManagement', 6)
  name = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  status = _messages.EnumField('StatusValueValuesEnum', 9)
  statusMessage = _messages.StringField(10)
  version = _messages.StringField(11)


class NodePoolAutoscaling(_messages.Message):
  r"""NodePoolAutoscaling contains information required by cluster autoscaler
  to adjust the size of the node pool to the current cluster usage.

  Fields:
    enabled: Is autoscaling enabled for this node pool.
    maxNodeCount: Maximum number of nodes in the NodePool. Must be >=
      min_node_count. There has to enough quota to scale up the cluster.
    minNodeCount: Minimum number of nodes in the NodePool. Must be >= 1 and <=
      max_node_count.
  """

  enabled = _messages.BooleanField(1)
  maxNodeCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class NodeTaint(_messages.Message):
  r"""Kubernetes taint is comprised of three fields: key, value, and effect.
  Effect can only be one of three types:  NoSchedule, PreferNoSchedule or
  NoExecute.  For more information, including usage and the valid values, see:
  https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/

  Enums:
    EffectValueValuesEnum: Effect for taint.

  Fields:
    effect: Effect for taint.
    key: Key for taint.
    value: Value for taint.
  """

  class EffectValueValuesEnum(_messages.Enum):
    r"""Effect for taint.

    Values:
      EFFECT_UNSPECIFIED: Not set
      NO_SCHEDULE: NoSchedule
      PREFER_NO_SCHEDULE: PreferNoSchedule
      NO_EXECUTE: NoExecute
    """
    EFFECT_UNSPECIFIED = 0
    NO_SCHEDULE = 1
    PREFER_NO_SCHEDULE = 2
    NO_EXECUTE = 3

  effect = _messages.EnumField('EffectValueValuesEnum', 1)
  key = _messages.StringField(2)
  value = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This operation resource represents operations that may have happened or
  are happening on the cluster. All fields are output only.

  Enums:
    OperationTypeValueValuesEnum: The operation type.
    StatusValueValuesEnum: The current status of the operation.

  Fields:
    clusterConditions: Which conditions caused the current cluster state.
    detail: Detailed operation progress, if available.
    endTime: [Output only] The time the operation completed, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    location: [Output only] The name of the Google Compute Engine
      [zone](/compute/docs/regions-zones/regions-zones#available) or
      [region](/compute/docs/regions-zones/regions-zones#available) in which
      the cluster resides.
    name: The server-assigned ID for the operation.
    nodepoolConditions: Which conditions caused the current node pool state.
    operationType: The operation type.
    selfLink: Server-defined URL for the resource.
    startTime: [Output only] The time the operation started, in
      [RFC3339](https://www.ietf.org/rfc/rfc3339.txt) text format.
    status: The current status of the operation.
    statusMessage: If an error has occurred, a textual description of the
      error.
    targetLink: Server-defined URL for the target of the operation.
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the operation is taking
      place. This field is deprecated, use location instead.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The operation type.

    Values:
      TYPE_UNSPECIFIED: Not set.
      CREATE_CLUSTER: Cluster create.
      DELETE_CLUSTER: Cluster delete.
      UPGRADE_MASTER: A master upgrade.
      UPGRADE_NODES: A node upgrade.
      REPAIR_CLUSTER: Cluster repair.
      UPDATE_CLUSTER: Cluster update.
      CREATE_NODE_POOL: Node pool create.
      DELETE_NODE_POOL: Node pool delete.
      SET_NODE_POOL_MANAGEMENT: Set node pool management.
      AUTO_REPAIR_NODES: Automatic node pool repair.
      AUTO_UPGRADE_NODES: Automatic node upgrade.
      SET_LABELS: Set labels.
      SET_MASTER_AUTH: Set/generate master auth materials
      SET_NODE_POOL_SIZE: Set node pool size.
      SET_NETWORK_POLICY: Updates network policy for a cluster.
      SET_MAINTENANCE_POLICY: Set the maintenance policy.
    """
    TYPE_UNSPECIFIED = 0
    CREATE_CLUSTER = 1
    DELETE_CLUSTER = 2
    UPGRADE_MASTER = 3
    UPGRADE_NODES = 4
    REPAIR_CLUSTER = 5
    UPDATE_CLUSTER = 6
    CREATE_NODE_POOL = 7
    DELETE_NODE_POOL = 8
    SET_NODE_POOL_MANAGEMENT = 9
    AUTO_REPAIR_NODES = 10
    AUTO_UPGRADE_NODES = 11
    SET_LABELS = 12
    SET_MASTER_AUTH = 13
    SET_NODE_POOL_SIZE = 14
    SET_NETWORK_POLICY = 15
    SET_MAINTENANCE_POLICY = 16

  class StatusValueValuesEnum(_messages.Enum):
    r"""The current status of the operation.

    Values:
      STATUS_UNSPECIFIED: Not set.
      PENDING: The operation has been created.
      RUNNING: The operation is currently running.
      DONE: The operation is done, either cancelled or completed.
      ABORTING: The operation is aborting.
    """
    STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3
    ABORTING = 4

  clusterConditions = _messages.MessageField('StatusCondition', 1, repeated=True)
  detail = _messages.StringField(2)
  endTime = _messages.StringField(3)
  location = _messages.StringField(4)
  name = _messages.StringField(5)
  nodepoolConditions = _messages.MessageField('StatusCondition', 6, repeated=True)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 7)
  selfLink = _messages.StringField(8)
  startTime = _messages.StringField(9)
  status = _messages.EnumField('StatusValueValuesEnum', 10)
  statusMessage = _messages.StringField(11)
  targetLink = _messages.StringField(12)
  zone = _messages.StringField(13)


class PrivateClusterConfig(_messages.Message):
  r"""Configuration options for private clusters.

  Fields:
    enablePrivateEndpoint: Whether the master's internal IP address is used as
      the cluster endpoint.
    enablePrivateNodes: Whether nodes have internal IP addresses only. If
      enabled, all nodes are given only RFC 1918 private addresses and
      communicate with the master via private networking.
    masterIpv4CidrBlock: The IP range in CIDR notation to use for the hosted
      master network. This range will be used for assigning internal IP
      addresses to the master or set of masters, as well as the ILB VIP. This
      range must not overlap with any other ranges in use within the cluster's
      network.
    privateEndpoint: Output only. The internal IP address of this cluster's
      master endpoint.
    publicEndpoint: Output only. The external IP address of this cluster's
      master endpoint.
  """

  enablePrivateEndpoint = _messages.BooleanField(1)
  enablePrivateNodes = _messages.BooleanField(2)
  masterIpv4CidrBlock = _messages.StringField(3)
  privateEndpoint = _messages.StringField(4)
  publicEndpoint = _messages.StringField(5)


class RollbackNodePoolUpgradeRequest(_messages.Message):
  r"""RollbackNodePoolUpgradeRequest rollbacks the previously Aborted or
  Failed NodePool upgrade. This will be an no-op if the last upgrade
  successfully completed.

  Fields:
    clusterId: Deprecated. The name of the cluster to rollback. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node poll
      to rollback upgrade. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to rollback. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  nodePoolId = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class ServerConfig(_messages.Message):
  r"""Kubernetes Engine service configuration.

  Fields:
    defaultClusterVersion: Version of Kubernetes the service deploys by
      default.
    defaultImageType: Default image type.
    validImageTypes: List of valid image types.
    validMasterVersions: List of valid master versions.
    validNodeVersions: List of valid node upgrade target versions.
  """

  defaultClusterVersion = _messages.StringField(1)
  defaultImageType = _messages.StringField(2)
  validImageTypes = _messages.StringField(3, repeated=True)
  validMasterVersions = _messages.StringField(4, repeated=True)
  validNodeVersions = _messages.StringField(5, repeated=True)


class SetAddonsConfigRequest(_messages.Message):
  r"""SetAddonsConfigRequest sets the addons associated with the cluster.

  Fields:
    addonsConfig: The desired configurations for the various addons available
      to run in the cluster.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to set addons.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  addonsConfig = _messages.MessageField('AddonsConfig', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetLabelsRequest(_messages.Message):
  r"""SetLabelsRequest sets the Google Cloud Platform labels on a Google
  Container Engine cluster, which will in turn set them for Google Compute
  Engine resources used by that cluster

  Messages:
    ResourceLabelsValue: The labels to set for that cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    labelFingerprint: The fingerprint of the previous set of labels for this
      resource, used to detect conflicts. The fingerprint is initially
      generated by Kubernetes Engine and changes after every request to modify
      or update labels. You must always provide an up-to-date fingerprint hash
      when updating or changing labels. Make a <code>get()</code> request to
      the resource to get the latest fingerprint.
    name: The name (project, location, cluster id) of the cluster to set
      labels. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    resourceLabels: The labels to set for that cluster.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResourceLabelsValue(_messages.Message):
    r"""The labels to set for that cluster.

    Messages:
      AdditionalProperty: An additional property for a ResourceLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type ResourceLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResourceLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusterId = _messages.StringField(1)
  labelFingerprint = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  resourceLabels = _messages.MessageField('ResourceLabelsValue', 5)
  zone = _messages.StringField(6)


class SetLegacyAbacRequest(_messages.Message):
  r"""SetLegacyAbacRequest enables or disables the ABAC authorization
  mechanism for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    enabled: Whether ABAC authorization will be enabled in the cluster.
    name: The name (project, location, cluster id) of the cluster to set
      legacy abac. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  enabled = _messages.BooleanField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetLocationsRequest(_messages.Message):
  r"""SetLocationsRequest sets the locations of the cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    locations: The desired list of Google Compute Engine
      [locations](/compute/docs/zones#available) in which the cluster's nodes
      should be located. Changing the locations a cluster is in will result in
      nodes being either created or removed from the cluster, depending on
      whether locations are being added or removed.  This list must always
      include the cluster's primary zone.
    name: The name (project, location, cluster) of the cluster to set
      locations. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  locations = _messages.StringField(2, repeated=True)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetLoggingServiceRequest(_messages.Message):
  r"""SetLoggingServiceRequest sets the logging service of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    loggingService: The logging service the cluster should use to write
      metrics. Currently available options:  * "logging.googleapis.com" - the
      Google Cloud Logging service * "none" - no metrics will be exported from
      the cluster
    name: The name (project, location, cluster) of the cluster to set logging.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  loggingService = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetMaintenancePolicyRequest(_messages.Message):
  r"""SetMaintenancePolicyRequest sets the maintenance policy for a cluster.

  Fields:
    clusterId: The name of the cluster to update.
    maintenancePolicy: The maintenance policy to be set for the cluster. An
      empty field clears the existing maintenance policy.
    name: The name (project, location, cluster id) of the cluster to set
      maintenance policy. Specified in the format
      'projects/*/locations/*/clusters/*'.
    projectId: The Google Developers Console [project ID or project
      number](https://support.google.com/cloud/answer/6158840).
    zone: The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides.
  """

  clusterId = _messages.StringField(1)
  maintenancePolicy = _messages.MessageField('MaintenancePolicy', 2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetMasterAuthRequest(_messages.Message):
  r"""SetMasterAuthRequest updates the admin password of a cluster.

  Enums:
    ActionValueValuesEnum: The exact form of action to be taken on the master
      auth.

  Fields:
    action: The exact form of action to be taken on the master auth.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to set auth.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    update: A description of the update.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  class ActionValueValuesEnum(_messages.Enum):
    r"""The exact form of action to be taken on the master auth.

    Values:
      UNKNOWN: Operation is unknown and will error out.
      SET_PASSWORD: Set the password to a user generated value.
      GENERATE_PASSWORD: Generate a new password and set it to that.
      SET_USERNAME: Set the username.  If an empty username is provided, basic
        authentication is disabled for the cluster.  If a non-empty username
        is provided, basic authentication is enabled, with either a provided
        password or a generated one.
    """
    UNKNOWN = 0
    SET_PASSWORD = 1
    GENERATE_PASSWORD = 2
    SET_USERNAME = 3

  action = _messages.EnumField('ActionValueValuesEnum', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  update = _messages.MessageField('MasterAuth', 5)
  zone = _messages.StringField(6)


class SetMonitoringServiceRequest(_messages.Message):
  r"""SetMonitoringServiceRequest sets the monitoring service of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    monitoringService: The monitoring service the cluster should use to write
      metrics. Currently available options:  * "monitoring.googleapis.com" -
      the Google Cloud Monitoring service * "none" - no metrics will be
      exported from the cluster
    name: The name (project, location, cluster) of the cluster to set
      monitoring. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  monitoringService = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetNetworkPolicyRequest(_messages.Message):
  r"""SetNetworkPolicyRequest enables/disables network policy for a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to set
      networking policy. Specified in the format
      'projects/*/locations/*/clusters/*'.
    networkPolicy: Configuration options for the NetworkPolicy feature.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  networkPolicy = _messages.MessageField('NetworkPolicy', 3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class SetNodePoolAutoscalingRequest(_messages.Message):
  r"""SetNodePoolAutoscalingRequest sets the autoscaler settings of a node
  pool.

  Fields:
    autoscaling: Autoscaling configuration for the node pool.
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool) of the node pool to
      set autoscaler settings. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to upgrade. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  autoscaling = _messages.MessageField('NodePoolAutoscaling', 1)
  clusterId = _messages.StringField(2)
  name = _messages.StringField(3)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetNodePoolManagementRequest(_messages.Message):
  r"""SetNodePoolManagementRequest sets the node management properties of a
  node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    management: NodeManagement configuration for the node pool.
    name: The name (project, location, cluster, node pool id) of the node pool
      to set management properties. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to update. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  management = _messages.MessageField('NodeManagement', 2)
  name = _messages.StringField(3)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  zone = _messages.StringField(6)


class SetNodePoolSizeRequest(_messages.Message):
  r"""SetNodePoolSizeRequest sets the size a node pool.

  Fields:
    clusterId: Deprecated. The name of the cluster to update. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster, node pool id) of the node pool
      to set size. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodeCount: The desired node count for the pool.
    nodePoolId: Deprecated. The name of the node pool to update. This field
      has been deprecated and replaced by the name field.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  nodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  nodePoolId = _messages.StringField(4)
  projectId = _messages.StringField(5)
  zone = _messages.StringField(6)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class StartIPRotationRequest(_messages.Message):
  r"""StartIPRotationRequest creates a new IP for the cluster and then
  performs a node upgrade on each node pool to point to the new IP.

  Fields:
    clusterId: Deprecated. The name of the cluster. This field has been
      deprecated and replaced by the name field.
    name: The name (project, location, cluster id) of the cluster to start IP
      rotation. Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project
      number](https://developers.google.com/console/help/new/#projectnumber).
      This field has been deprecated and replaced by the name field.
    rotateCredentials: Whether to rotate credentials during IP rotation.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  rotateCredentials = _messages.BooleanField(4)
  zone = _messages.StringField(5)


class StatusCondition(_messages.Message):
  r"""StatusCondition describes why a cluster or a node pool has a certain
  status (e.g., ERROR or DEGRADED).

  Enums:
    CodeValueValuesEnum: Machine-friendly representation of the condition

  Fields:
    code: Machine-friendly representation of the condition
    message: Human-friendly representation of the condition
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""Machine-friendly representation of the condition

    Values:
      UNKNOWN: UNKNOWN indicates a generic condition.
      GCE_STOCKOUT: GCE_STOCKOUT indicates a GCE stockout.
      GKE_SERVICE_ACCOUNT_DELETED: GKE_SERVICE_ACCOUNT_DELETED indicates that
        the user deleted their robot service account.
      GCE_QUOTA_EXCEEDED: GCE quota was exceeded. More codes TBA
    """
    UNKNOWN = 0
    GCE_STOCKOUT = 1
    GKE_SERVICE_ACCOUNT_DELETED = 2
    GCE_QUOTA_EXCEEDED = 3

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  message = _messages.StringField(2)


class UpdateClusterRequest(_messages.Message):
  r"""UpdateClusterRequest updates the settings of a cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    name: The name (project, location, cluster) of the cluster to update.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    update: A description of the update.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  name = _messages.StringField(2)
  projectId = _messages.StringField(3)
  update = _messages.MessageField('ClusterUpdate', 4)
  zone = _messages.StringField(5)


class UpdateMasterRequest(_messages.Message):
  r"""UpdateMasterRequest updates the master of the cluster.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    masterVersion: The Kubernetes version to change the master to.  Users may
      specify either explicit versions offered by Kubernetes Engine or version
      aliases, which have the following behavior:  - "latest": picks the
      highest valid Kubernetes version - "1.X": picks the highest valid
      patch+gke.N patch in the 1.X version - "1.X.Y": picks the highest valid
      gke.N patch in the 1.X.Y version - "1.X.Y-gke.N": picks an explicit
      Kubernetes version - "-": picks the default Kubernetes version
    name: The name (project, location, cluster) of the cluster to update.
      Specified in the format 'projects/*/locations/*/clusters/*'.
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  masterVersion = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)
  zone = _messages.StringField(5)


class UpdateNodePoolRequest(_messages.Message):
  r"""UpdateNodePoolRequests update a node pool's image and/or version.

  Fields:
    clusterId: Deprecated. The name of the cluster to upgrade. This field has
      been deprecated and replaced by the name field.
    image: The desired name of the image name to use for this node. This is
      used to create clusters using a custom image.
    imageProject: The project containing the desired image to use for this
      node pool. This is used to create clusters using a custom image.
    imageType: The desired image type for the node pool.
    name: The name (project, location, cluster, node pool) of the node pool to
      update. Specified in the format
      'projects/*/locations/*/clusters/*/nodePools/*'.
    nodePoolId: Deprecated. The name of the node pool to upgrade. This field
      has been deprecated and replaced by the name field.
    nodeVersion: The Kubernetes version to change the nodes to (typically an
      upgrade).  Users may specify either explicit versions offered by
      Kubernetes Engine or version aliases, which have the following behavior:
      - "latest": picks the highest valid Kubernetes version - "1.X": picks
      the highest valid patch+gke.N patch in the 1.X version - "1.X.Y": picks
      the highest valid gke.N patch in the 1.X.Y version - "1.X.Y-gke.N":
      picks an explicit Kubernetes version - "-": picks the Kubernetes master
      version
    projectId: Deprecated. The Google Developers Console [project ID or
      project number](https://support.google.com/cloud/answer/6158840). This
      field has been deprecated and replaced by the name field.
    zone: Deprecated. The name of the Google Compute Engine
      [zone](/compute/docs/zones#available) in which the cluster resides. This
      field has been deprecated and replaced by the name field.
  """

  clusterId = _messages.StringField(1)
  image = _messages.StringField(2)
  imageProject = _messages.StringField(3)
  imageType = _messages.StringField(4)
  name = _messages.StringField(5)
  nodePoolId = _messages.StringField(6)
  nodeVersion = _messages.StringField(7)
  projectId = _messages.StringField(8)
  zone = _messages.StringField(9)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
