"""Generated message classes for ml version v1.

An API to enable creating and using machine learning models.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'ml'


class GoogleApiHttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page.   This message can be used both in streaming and non-streaming
  API methods in the request as well as the response.  It can be used as a
  top-level request field, which is convenient if one wants to extract
  parameters from either the URL or HTTP template into the request fields and
  also want access to the raw HTTP body.  Example:      message
  GetResourceRequest {       // A unique request id.       string request_id =
  1;        // The raw HTTP body is bound to this field.
  google.api.HttpBody http_body = 2;     }      service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);       rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty);     }
  Example with streaming methods:      service CaldavService {       rpc
  GetCalendar(stream google.api.HttpBody)         returns (stream
  google.api.HttpBody);       rpc UpdateCalendar(stream google.api.HttpBody)
  returns (stream google.api.HttpBody);     }  Use of this type only changes
  how the request and response bodies are handled, all other features will
  continue to work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type string representing the content type of
      the body.
    data: HTTP body binary data.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class GoogleCloudMlV1AcceleratorConfig(_messages.Message):
  r"""Represents a hardware accelerator request config.

  Enums:
    TypeValueValuesEnum: The available types of accelerators.

  Fields:
    count: The number of accelerators to attach to each machine running the
      job.
    type: The available types of accelerators.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The available types of accelerators.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: Unspecified accelerator type. Default to
        no GPU.
      NVIDIA_TESLA_K80: Nvidia tesla k80 GPU.
      NVIDIA_TESLA_P100: Nvidia tesla P100 GPU.
      NVIDIA_TESLA_V100: Nvidia tesla V100 GPU. Not supported for batch
        prediction.
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3

  count = _messages.IntegerField(1)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudMlV1AutoScaling(_messages.Message):
  r"""Options for automatically scaling a model.

  Fields:
    minNodes: Optional. The minimum number of nodes to allocate for this
      model. These nodes are always up, starting from the time the model is
      deployed. Therefore, the cost of operating this model will be at least
      `rate` * `min_nodes` * number of hours since last billing cycle, where
      `rate` is the cost per node-hour as documented in the [pricing guide
      ](/ml-engine/docs/pricing), even if no predictions are performed. There
      is additional cost for each prediction performed.  Unlike manual
      scaling, if the load gets too heavy for the nodes that are up, the
      service will automatically add nodes to handle the increased load as
      well as scale back as traffic drops, always maintaining at least
      `min_nodes`. You will be charged for the time in which additional nodes
      are used.  If not specified, `min_nodes` defaults to 0, in which case,
      when traffic to a model stops (and after a cool-down period), nodes will
      be shut down and no charges will be incurred until traffic to the model
      resumes.  You can set `min_nodes` when creating the model version, and
      you can also update `min_nodes` for an existing version: <pre>
      update_body.json: {   'autoScaling': {     'minNodes': 5   } } </pre>
      HTTP request: <pre> PATCH https://ml.googleapis.com/v1/{name=projects/*/
      models/*/versions/*}?update_mask=autoScaling.minNodes -d
      @./update_body.json </pre>
  """

  minNodes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1CancelJobRequest(_messages.Message):
  r"""Request message for the CancelJob method."""


class GoogleCloudMlV1Capability(_messages.Message):
  r"""A GoogleCloudMlV1Capability object.

  Enums:
    AvailableAcceleratorsValueListEntryValuesEnum:
    TypeValueValuesEnum:

  Fields:
    availableAccelerators: Available accelerators for the capability.
    type: A TypeValueValuesEnum attribute.
  """

  class AvailableAcceleratorsValueListEntryValuesEnum(_messages.Enum):
    r"""AvailableAcceleratorsValueListEntryValuesEnum enum type.

    Values:
      ACCELERATOR_TYPE_UNSPECIFIED: <no description>
      NVIDIA_TESLA_K80: <no description>
      NVIDIA_TESLA_P100: <no description>
      NVIDIA_TESLA_V100: <no description>
    """
    ACCELERATOR_TYPE_UNSPECIFIED = 0
    NVIDIA_TESLA_K80 = 1
    NVIDIA_TESLA_P100 = 2
    NVIDIA_TESLA_V100 = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""TypeValueValuesEnum enum type.

    Values:
      TYPE_UNSPECIFIED: <no description>
      TRAINING: <no description>
      BATCH_PREDICTION: <no description>
      ONLINE_PREDICTION: <no description>
    """
    TYPE_UNSPECIFIED = 0
    TRAINING = 1
    BATCH_PREDICTION = 2
    ONLINE_PREDICTION = 3

  availableAccelerators = _messages.EnumField('AvailableAcceleratorsValueListEntryValuesEnum', 1, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 2)


class GoogleCloudMlV1Config(_messages.Message):
  r"""A GoogleCloudMlV1Config object.

  Fields:
    tpuServiceAccount: The service account Cloud ML uses to run on TPU node.
  """

  tpuServiceAccount = _messages.StringField(1)


class GoogleCloudMlV1GetConfigResponse(_messages.Message):
  r"""Returns service account information associated with a project.

  Fields:
    config: A GoogleCloudMlV1Config attribute.
    serviceAccount: The service account Cloud ML uses to access resources in
      the project.
    serviceAccountProject: The project number for `service_account`.
  """

  config = _messages.MessageField('GoogleCloudMlV1Config', 1)
  serviceAccount = _messages.StringField(2)
  serviceAccountProject = _messages.IntegerField(3)


class GoogleCloudMlV1HyperparameterOutput(_messages.Message):
  r"""Represents the result of a single hyperparameter tuning trial from a
  training job. The TrainingOutput object that is returned on successful
  completion of a training job with hyperparameter tuning includes a list of
  HyperparameterOutput objects, one for each successful trial.

  Messages:
    HyperparametersValue: The hyperparameters given to this trial.

  Fields:
    allMetrics: All recorded object metrics for this trial. This field is not
      currently populated.
    finalMetric: The final objective metric seen for this trial.
    hyperparameters: The hyperparameters given to this trial.
    isTrialStoppedEarly: True if the trial is stopped early.
    trialId: The trial id for these results.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HyperparametersValue(_messages.Message):
    r"""The hyperparameters given to this trial.

    Messages:
      AdditionalProperty: An additional property for a HyperparametersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HyperparametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a HyperparametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allMetrics = _messages.MessageField('GoogleCloudMlV1HyperparameterOutputHyperparameterMetric', 1, repeated=True)
  finalMetric = _messages.MessageField('GoogleCloudMlV1HyperparameterOutputHyperparameterMetric', 2)
  hyperparameters = _messages.MessageField('HyperparametersValue', 3)
  isTrialStoppedEarly = _messages.BooleanField(4)
  trialId = _messages.StringField(5)


class GoogleCloudMlV1HyperparameterOutputHyperparameterMetric(_messages.Message):
  r"""An observed value of a metric.

  Fields:
    objectiveValue: The objective value at this training step.
    trainingStep: The global training step for this metric.
  """

  objectiveValue = _messages.FloatField(1)
  trainingStep = _messages.IntegerField(2)


class GoogleCloudMlV1HyperparameterSpec(_messages.Message):
  r"""Represents a set of hyperparameters to optimize.

  Enums:
    AlgorithmValueValuesEnum: Optional. The search algorithm specified for the
      hyperparameter tuning job. Uses the default CloudML Engine
      hyperparameter tuning algorithm if unspecified.
    GoalValueValuesEnum: Required. The type of goal to use for tuning.
      Available types are `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.

  Fields:
    algorithm: Optional. The search algorithm specified for the hyperparameter
      tuning job. Uses the default CloudML Engine hyperparameter tuning
      algorithm if unspecified.
    enableTrialEarlyStopping: Optional. Indicates if the hyperparameter tuning
      job enables auto trial early stopping.
    goal: Required. The type of goal to use for tuning. Available types are
      `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.
    hyperparameterMetricTag: Optional. The Tensorflow summary tag name to use
      for optimizing trials. For current versions of Tensorflow, this tag name
      should exactly match what is shown in Tensorboard, including all scopes.
      For versions of Tensorflow prior to 0.12, this should be only the tag
      passed to tf.Summary. By default, "training/hptuning/metric" will be
      used.
    maxParallelTrials: Optional. The number of training trials to run
      concurrently. You can reduce the time it takes to perform hyperparameter
      tuning by adding trials in parallel. However, each trail only benefits
      from the information gained in completed trials. That means that a trial
      does not get access to the results of trials running at the same time,
      which could reduce the quality of the overall optimization.  Each trial
      will use the same scale tier and machine types.  Defaults to one.
    maxTrials: Optional. How many training trials should be attempted to
      optimize the specified hyperparameters.  Defaults to one.
    params: Required. The set of parameters to tune.
    resumePreviousJobId: Optional. The prior hyperparameter tuning job id that
      users hope to continue with. The job id will be used to find the
      corresponding vizier study guid and resume the study.
  """

  class AlgorithmValueValuesEnum(_messages.Enum):
    r"""Optional. The search algorithm specified for the hyperparameter tuning
    job. Uses the default CloudML Engine hyperparameter tuning algorithm if
    unspecified.

    Values:
      ALGORITHM_UNSPECIFIED: The default algorithm used by hyperparameter
        tuning service.
      GRID_SEARCH: Simple grid search within the feasible space. To use grid
        search, all parameters must be `INTEGER`, `CATEGORICAL`, or
        `DISCRETE`.
      RANDOM_SEARCH: Simple random search within the feasible space.
    """
    ALGORITHM_UNSPECIFIED = 0
    GRID_SEARCH = 1
    RANDOM_SEARCH = 2

  class GoalValueValuesEnum(_messages.Enum):
    r"""Required. The type of goal to use for tuning. Available types are
    `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  algorithm = _messages.EnumField('AlgorithmValueValuesEnum', 1)
  enableTrialEarlyStopping = _messages.BooleanField(2)
  goal = _messages.EnumField('GoalValueValuesEnum', 3)
  hyperparameterMetricTag = _messages.StringField(4)
  maxParallelTrials = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxTrials = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  params = _messages.MessageField('GoogleCloudMlV1ParameterSpec', 7, repeated=True)
  resumePreviousJobId = _messages.StringField(8)


class GoogleCloudMlV1Job(_messages.Message):
  r"""Represents a training or prediction job.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of a job.

  Messages:
    LabelsValue: Optional. One or more labels that you can add, to organize
      your jobs. Each label is a key-value pair, where both the key and the
      value are arbitrary strings that you supply. For more information, see
      the documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.

  Fields:
    createTime: Output only. When the job was created.
    endTime: Output only. When the job processing was completed.
    errorMessage: Output only. The details of a failure or a cancellation.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a job from overwriting each other. It is
      strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform job updates in order to avoid race
      conditions: An `etag` is returned in the response to `GetJob`, and
      systems are expected to put that etag in the request to `UpdateJob` to
      ensure that their change will be applied to the same version of the job.
    jobId: Required. The user-specified id of the job.
    labels: Optional. One or more labels that you can add, to organize your
      jobs. Each label is a key-value pair, where both the key and the value
      are arbitrary strings that you supply. For more information, see the
      documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.
    predictionInput: Input parameters to create a prediction job.
    predictionOutput: The current prediction job result.
    startTime: Output only. When the job processing was started.
    state: Output only. The detailed state of a job.
    trainingInput: Input parameters to create a training job.
    trainingOutput: The current training job result.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The detailed state of a job.

    Values:
      STATE_UNSPECIFIED: The job state is unspecified.
      QUEUED: The job has been just created and processing has not yet begun.
      PREPARING: The service is preparing to run the job.
      RUNNING: The job is in progress.
      SUCCEEDED: The job completed successfully.
      FAILED: The job failed. `error_message` should contain the details of
        the failure.
      CANCELLING: The job is being cancelled. `error_message` should describe
        the reason for the cancellation.
      CANCELLED: The job has been cancelled. `error_message` should describe
        the reason for the cancellation.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    PREPARING = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. One or more labels that you can add, to organize your jobs.
    Each label is a key-value pair, where both the key and the value are
    arbitrary strings that you supply. For more information, see the
    documentation on <a href="/ml-engine/docs/tensorflow/resource-
    labels">using labels</a>.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  errorMessage = _messages.StringField(3)
  etag = _messages.BytesField(4)
  jobId = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  predictionInput = _messages.MessageField('GoogleCloudMlV1PredictionInput', 7)
  predictionOutput = _messages.MessageField('GoogleCloudMlV1PredictionOutput', 8)
  startTime = _messages.StringField(9)
  state = _messages.EnumField('StateValueValuesEnum', 10)
  trainingInput = _messages.MessageField('GoogleCloudMlV1TrainingInput', 11)
  trainingOutput = _messages.MessageField('GoogleCloudMlV1TrainingOutput', 12)


class GoogleCloudMlV1ListJobsResponse(_messages.Message):
  r"""Response message for the ListJobs method.

  Fields:
    jobs: The list of jobs.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  jobs = _messages.MessageField('GoogleCloudMlV1Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1ListLocationsResponse(_messages.Message):
  r"""A GoogleCloudMlV1ListLocationsResponse object.

  Fields:
    locations: Locations where at least one type of CMLE capability is
      available.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  locations = _messages.MessageField('GoogleCloudMlV1Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1ListModelsResponse(_messages.Message):
  r"""Response message for the ListModels method.

  Fields:
    models: The list of models.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  models = _messages.MessageField('GoogleCloudMlV1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1ListVersionsResponse(_messages.Message):
  r"""Response message for the ListVersions method.

  Fields:
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
    versions: The list of versions.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('GoogleCloudMlV1Version', 2, repeated=True)


class GoogleCloudMlV1Location(_messages.Message):
  r"""A GoogleCloudMlV1Location object.

  Fields:
    capabilities: Capabilities available in the location.
    name: A string attribute.
  """

  capabilities = _messages.MessageField('GoogleCloudMlV1Capability', 1, repeated=True)
  name = _messages.StringField(2)


class GoogleCloudMlV1ManualScaling(_messages.Message):
  r"""Options for manually scaling a model.

  Fields:
    nodes: The number of nodes to allocate for this model. These nodes are
      always up, starting from the time the model is deployed, so the cost of
      operating this model will be proportional to `nodes` * number of hours
      since last billing cycle plus the cost for each prediction performed.
  """

  nodes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1Model(_messages.Message):
  r"""Represents a machine learning solution.  A model can have multiple
  versions, each of which is a deployed, trained model ready to receive
  prediction requests. The model itself is just a container.

  Messages:
    LabelsValue: Optional. One or more labels that you can add, to organize
      your models. Each label is a key-value pair, where both the key and the
      value are arbitrary strings that you supply. For more information, see
      the documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.

  Fields:
    defaultVersion: Output only. The default version of the model. This
      version will be used to handle prediction requests that do not specify a
      version.  You can change the default version by calling
      [projects.methods.versions.setDefault](/ml-
      engine/reference/rest/v1/projects.models.versions/setDefault).
    description: Optional. The description specified for the model when it was
      created.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a model from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform model updates in order to avoid race
      conditions: An `etag` is returned in the response to `GetModel`, and
      systems are expected to put that etag in the request to `UpdateModel` to
      ensure that their change will be applied to the model as intended.
    labels: Optional. One or more labels that you can add, to organize your
      models. Each label is a key-value pair, where both the key and the value
      are arbitrary strings that you supply. For more information, see the
      documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.
    name: Required. The name specified for the model when it was created.  The
      model name must be unique within the project it is created in.
    onlinePredictionLogging: Optional. If true, enables StackDriver Logging
      for online prediction. Default is false.
    regions: Optional. The list of regions where the model is going to be
      deployed. Currently only one region per model is supported. Defaults to
      'us-central1' if nothing is set. See the <a href="/ml-
      engine/docs/tensorflow/regions">available regions</a> for ML Engine
      services. Note: *   No matter where a model is deployed, it can always
      be accessed by     users from anywhere, both for online and batch
      prediction. *   The region for a batch prediction job is set by the
      region field when     submitting the batch prediction job and does not
      take its value from     this field.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. One or more labels that you can add, to organize your
    models. Each label is a key-value pair, where both the key and the value
    are arbitrary strings that you supply. For more information, see the
    documentation on <a href="/ml-engine/docs/tensorflow/resource-
    labels">using labels</a>.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  defaultVersion = _messages.MessageField('GoogleCloudMlV1Version', 1)
  description = _messages.StringField(2)
  etag = _messages.BytesField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  onlinePredictionLogging = _messages.BooleanField(6)
  regions = _messages.StringField(7, repeated=True)


class GoogleCloudMlV1OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Enums:
    OperationTypeValueValuesEnum: The operation type.

  Messages:
    LabelsValue: The user labels, inherited from the model or the model
      version being operated on.

  Fields:
    createTime: The time the operation was submitted.
    endTime: The time operation processing completed.
    isCancellationRequested: Indicates whether a request to cancel this
      operation has been made.
    labels: The user labels, inherited from the model or the model version
      being operated on.
    modelName: Contains the name of the model associated with the operation.
    operationType: The operation type.
    projectNumber: Contains the project number associated with the operation.
    startTime: The time operation processing started.
    version: Contains the version associated with the operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The operation type.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified operation type.
      CREATE_VERSION: An operation to create a new version.
      DELETE_VERSION: An operation to delete an existing version.
      DELETE_MODEL: An operation to delete an existing model.
      UPDATE_MODEL: An operation to update an existing model.
      UPDATE_VERSION: An operation to update an existing version.
      UPDATE_CONFIG: An operation to update project configuration.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    CREATE_VERSION = 1
    DELETE_VERSION = 2
    DELETE_MODEL = 3
    UPDATE_MODEL = 4
    UPDATE_VERSION = 5
    UPDATE_CONFIG = 6

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The user labels, inherited from the model or the model version being
    operated on.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  isCancellationRequested = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  modelName = _messages.StringField(5)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 6)
  projectNumber = _messages.IntegerField(7)
  startTime = _messages.StringField(8)
  version = _messages.MessageField('GoogleCloudMlV1Version', 9)


class GoogleCloudMlV1ParameterSpec(_messages.Message):
  r"""Represents a single hyperparameter to optimize.

  Enums:
    ScaleTypeValueValuesEnum: Optional. How the parameter should be scaled to
      the hypercube. Leave unset for categorical parameters. Some kind of
      scaling is strongly recommended for real or integral parameters (e.g.,
      `UNIT_LINEAR_SCALE`).
    TypeValueValuesEnum: Required. The type of the parameter.

  Fields:
    categoricalValues: Required if type is `CATEGORICAL`. The list of possible
      categories.
    discreteValues: Required if type is `DISCRETE`. A list of feasible points.
      The list should be in strictly increasing order. For instance, this
      parameter might have possible settings of 1.5, 2.5, and 4.0. This list
      should not contain more than 1,000 values.
    maxValue: Required if type is `DOUBLE` or `INTEGER`. This field should be
      unset if type is `CATEGORICAL`. This value should be integers if type is
      `INTEGER`.
    minValue: Required if type is `DOUBLE` or `INTEGER`. This field should be
      unset if type is `CATEGORICAL`. This value should be integers if type is
      INTEGER.
    parameterName: Required. The parameter name must be unique amongst all
      ParameterConfigs in a HyperparameterSpec message. E.g., "learning_rate".
    scaleType: Optional. How the parameter should be scaled to the hypercube.
      Leave unset for categorical parameters. Some kind of scaling is strongly
      recommended for real or integral parameters (e.g., `UNIT_LINEAR_SCALE`).
    type: Required. The type of the parameter.
  """

  class ScaleTypeValueValuesEnum(_messages.Enum):
    r"""Optional. How the parameter should be scaled to the hypercube. Leave
    unset for categorical parameters. Some kind of scaling is strongly
    recommended for real or integral parameters (e.g., `UNIT_LINEAR_SCALE`).

    Values:
      NONE: By default, no scaling is applied.
      UNIT_LINEAR_SCALE: Scales the feasible space to (0, 1) linearly.
      UNIT_LOG_SCALE: Scales the feasible space logarithmically to (0, 1). The
        entire feasible space must be strictly positive.
      UNIT_REVERSE_LOG_SCALE: Scales the feasible space "reverse"
        logarithmically to (0, 1). The result is that values close to the top
        of the feasible space are spread out more than points near the bottom.
        The entire feasible space must be strictly positive.
    """
    NONE = 0
    UNIT_LINEAR_SCALE = 1
    UNIT_LOG_SCALE = 2
    UNIT_REVERSE_LOG_SCALE = 3

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the parameter.

    Values:
      PARAMETER_TYPE_UNSPECIFIED: You must specify a valid type. Using this
        unspecified type will result in an error.
      DOUBLE: Type for real-valued parameters.
      INTEGER: Type for integral parameters.
      CATEGORICAL: The parameter is categorical, with a value chosen from the
        categories field.
      DISCRETE: The parameter is real valued, with a fixed set of feasible
        points. If `type==DISCRETE`, feasible_points must be provided, and
        {`min_value`, `max_value`} will be ignored.
    """
    PARAMETER_TYPE_UNSPECIFIED = 0
    DOUBLE = 1
    INTEGER = 2
    CATEGORICAL = 3
    DISCRETE = 4

  categoricalValues = _messages.StringField(1, repeated=True)
  discreteValues = _messages.FloatField(2, repeated=True)
  maxValue = _messages.FloatField(3)
  minValue = _messages.FloatField(4)
  parameterName = _messages.StringField(5)
  scaleType = _messages.EnumField('ScaleTypeValueValuesEnum', 6)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class GoogleCloudMlV1PredictRequest(_messages.Message):
  r"""Request for predictions to be issued against a trained model.

  Fields:
    httpBody:  Required. The prediction request body.
  """

  httpBody = _messages.MessageField('GoogleApiHttpBody', 1)


class GoogleCloudMlV1PredictionInput(_messages.Message):
  r"""Represents input parameters for a prediction job.

  Enums:
    DataFormatValueValuesEnum: Required. The format of the input data files.
    OutputDataFormatValueValuesEnum: Optional. Format of the output data
      files, defaults to JSON.

  Fields:
    accelerator: Optional. The type and number of accelerators to be attached
      to each machine running the job.
    batchSize: Optional. Number of records per batch, defaults to 64. The
      service will buffer batch_size number of records in memory before
      invoking one Tensorflow prediction call internally. So take the record
      size and memory available into consideration when setting this
      parameter.
    dataFormat: Required. The format of the input data files.
    inputPaths: Required. The Google Cloud Storage location of the input data
      files. May contain wildcards.
    maxWorkerCount: Optional. The maximum number of workers to be used for
      parallel processing. Defaults to 10 if not specified.
    modelName: Use this field if you want to use the default version for the
      specified model. The string must use the following format:
      `"projects/YOUR_PROJECT/models/YOUR_MODEL"`
    outputDataFormat: Optional. Format of the output data files, defaults to
      JSON.
    outputPath: Required. The output Google Cloud Storage location.
    region: Required. The Google Compute Engine region to run the prediction
      job in. See the <a href="/ml-engine/docs/tensorflow/regions">available
      regions</a> for ML Engine services.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      this batch prediction. If not set, Google Cloud ML will pick the runtime
      version used during the CreateVersion request for this model version, or
      choose the latest stable version when model version information is not
      available such as when the model is specified by uri.
    signatureName: Optional. The name of the signature defined in the
      SavedModel to use for this job. Please refer to
      [SavedModel](https://tensorflow.github.io/serving/serving_basic.html)
      for information about how to use signatures.  Defaults to [DEFAULT_SERVI
      NG_SIGNATURE_DEF_KEY](https://www.tensorflow.org/api_docs/python/tf/save
      d_model/signature_constants) , which is "serving_default".
    uri: Use this field if you want to specify a Google Cloud Storage path for
      the model to use.
    versionName: Use this field if you want to specify a version of the model
      to use. The string is formatted the same way as `model_version`, with
      the addition of the version information:
      `"projects/YOUR_PROJECT/models/YOUR_MODEL/versions/YOUR_VERSION"`
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    r"""Required. The format of the input data files.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      JSON: Each line of the file is a JSON dictionary representing one
        record.
      TEXT: Deprecated. Use JSON instead.
      TF_RECORD: INPUT ONLY. The source file is a TFRecord file.
      TF_RECORD_GZIP: INPUT ONLY. The source file is a GZIP-compressed
        TFRecord file.
      CSV: OUTPUT ONLY. Output values will be in comma-separated rows, with
        keys in a separate file.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSON = 1
    TEXT = 2
    TF_RECORD = 3
    TF_RECORD_GZIP = 4
    CSV = 5

  class OutputDataFormatValueValuesEnum(_messages.Enum):
    r"""Optional. Format of the output data files, defaults to JSON.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      JSON: Each line of the file is a JSON dictionary representing one
        record.
      TEXT: Deprecated. Use JSON instead.
      TF_RECORD: INPUT ONLY. The source file is a TFRecord file.
      TF_RECORD_GZIP: INPUT ONLY. The source file is a GZIP-compressed
        TFRecord file.
      CSV: OUTPUT ONLY. Output values will be in comma-separated rows, with
        keys in a separate file.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    JSON = 1
    TEXT = 2
    TF_RECORD = 3
    TF_RECORD_GZIP = 4
    CSV = 5

  accelerator = _messages.MessageField('GoogleCloudMlV1AcceleratorConfig', 1)
  batchSize = _messages.IntegerField(2)
  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 3)
  inputPaths = _messages.StringField(4, repeated=True)
  maxWorkerCount = _messages.IntegerField(5)
  modelName = _messages.StringField(6)
  outputDataFormat = _messages.EnumField('OutputDataFormatValueValuesEnum', 7)
  outputPath = _messages.StringField(8)
  region = _messages.StringField(9)
  runtimeVersion = _messages.StringField(10)
  signatureName = _messages.StringField(11)
  uri = _messages.StringField(12)
  versionName = _messages.StringField(13)


class GoogleCloudMlV1PredictionOutput(_messages.Message):
  r"""Represents results of a prediction job.

  Fields:
    errorCount: The number of data instances which resulted in errors.
    nodeHours: Node hours used by the batch prediction job.
    outputPath: The output Google Cloud Storage location provided at the job
      creation time.
    predictionCount: The number of generated predictions.
  """

  errorCount = _messages.IntegerField(1)
  nodeHours = _messages.FloatField(2)
  outputPath = _messages.StringField(3)
  predictionCount = _messages.IntegerField(4)


class GoogleCloudMlV1SetDefaultVersionRequest(_messages.Message):
  r"""Request message for the SetDefaultVersion request."""


class GoogleCloudMlV1TrainingInput(_messages.Message):
  r"""Represents input parameters for a training job. When using the gcloud
  command to submit your training job, you can specify the input parameters as
  command-line arguments and/or in a YAML configuration file referenced from
  the --config command-line argument. For details, see the guide to <a href
  ="/ml-engine/docs/tensorflow/training-jobs">submitting a training job</a>.

  Enums:
    ScaleTierValueValuesEnum: Required. Specifies the machine types, the
      number of replicas for workers and parameter servers.

  Fields:
    args: Optional. Command line arguments to pass to the program.
    hyperparameters: Optional. The set of Hyperparameters to tune.
    jobDir: Optional. A Google Cloud Storage path in which to store training
      outputs and other data needed for training. This path is passed to your
      TensorFlow program as the '--job-dir' command-line argument. The benefit
      of specifying this field is that Cloud ML validates the path for use in
      training.
    masterType: Optional. Specifies the type of virtual machine to use for
      your training job's master worker.  The following types are supported:
      <dl>   <dt>standard</dt>   <dd>   A basic machine configuration suitable
      for training simple models with   small to moderate datasets.   </dd>
      <dt>large_model</dt>   <dd>   A machine with a lot of memory, specially
      suited for parameter servers   when your model is large (having many
      hidden layers or layers with very   large numbers of nodes).   </dd>
      <dt>complex_model_s</dt>   <dd>   A machine suitable for the master and
      workers of the cluster when your   model requires more computation than
      the standard machine can handle   satisfactorily.   </dd>
      <dt>complex_model_m</dt>   <dd>   A machine with roughly twice the
      number of cores and roughly double the   memory of
      <i>complex_model_s</i>.   </dd>   <dt>complex_model_l</dt>   <dd>   A
      machine with roughly twice the number of cores and roughly double the
      memory of <i>complex_model_m</i>.   </dd>   <dt>standard_gpu</dt>   <dd>
      A machine equivalent to <i>standard</i> that   also includes a single
      NVIDIA Tesla K80 GPU. See more about   <a href="/ml-
      engine/docs/tensorflow/using-gpus">using GPUs to   train your model</a>.
      </dd>   <dt>complex_model_m_gpu</dt>   <dd>   A machine equivalent to
      <i>complex_model_m</i> that also includes   four NVIDIA Tesla K80 GPUs.
      </dd>   <dt>complex_model_l_gpu</dt>   <dd>   A machine equivalent to
      <i>complex_model_l</i> that also includes   eight NVIDIA Tesla K80 GPUs.
      </dd>   <dt>standard_p100</dt>   <dd>   A machine equivalent to
      <i>standard</i> that   also includes a single NVIDIA Tesla P100 GPU. The
      availability of these   GPUs is in the <i>Beta</i> launch stage.   </dd>
      <dt>complex_model_m_p100</dt>   <dd>   A machine equivalent to
      <i>complex_model_m</i> that also includes   four NVIDIA Tesla P100 GPUs.
      The availability of these GPUs is in   the <i>Beta</i> launch stage.
      </dd>   <dt>cloud_tpu</dt>   <dd>   A TPU VM including one Cloud TPU.
      See more about   <a href="/ml-engine/docs/tensorflow/using-tpus">using
      TPUs to train   your model</a>.   </dd> </dl>  You must set this value
      when `scaleTier` is set to `CUSTOM`.
    packageUris: Required. The Google Cloud Storage location of the packages
      with the training program and any additional dependencies. The maximum
      number of package URIs is 100.
    parameterServerCount: Optional. The number of parameter server replicas to
      use for the training job. Each replica in the cluster will be of the
      type specified in `parameter_server_type`.  This value can only be used
      when `scale_tier` is set to `CUSTOM`.If you set this value, you must
      also set `parameter_server_type`.
    parameterServerType: Optional. Specifies the type of virtual machine to
      use for your training job's parameter server.  The supported values are
      the same as those described in the entry for `master_type`.  This value
      must be present when `scaleTier` is set to `CUSTOM` and
      `parameter_server_count` is greater than zero.
    pythonModule: Required. The Python module name to run after installing the
      packages.
    pythonVersion: Optional. The version of Python used in training. If not
      set, the default version is '2.7'. Python '3.5' is available when
      `runtime_version` is set to '1.4' and above. Python '2.7' works with all
      supported runtime versions.
    region: Required. The Google Compute Engine region to run the training job
      in. See the <a href="/ml-engine/docs/tensorflow/regions">available
      regions</a> for ML Engine services.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      training.  If not set, Google Cloud ML will choose a stable version,
      which is defined in the documentation of runtime version list.
    scaleTier: Required. Specifies the machine types, the number of replicas
      for workers and parameter servers.
    workerCount: Optional. The number of worker replicas to use for the
      training job. Each replica in the cluster will be of the type specified
      in `worker_type`.  This value can only be used when `scale_tier` is set
      to `CUSTOM`. If you set this value, you must also set `worker_type`.
    workerType: Optional. Specifies the type of virtual machine to use for
      your training job's worker nodes.  The supported values are the same as
      those described in the entry for `masterType`.  This value must be
      present when `scaleTier` is set to `CUSTOM` and `workerCount` is greater
      than zero.
  """

  class ScaleTierValueValuesEnum(_messages.Enum):
    r"""Required. Specifies the machine types, the number of replicas for
    workers and parameter servers.

    Values:
      BASIC: A single worker instance. This tier is suitable for learning how
        to use Cloud ML, and for experimenting with new models using small
        datasets.
      STANDARD_1: Many workers and a few parameter servers.
      PREMIUM_1: A large number of workers with many parameter servers.
      BASIC_GPU: A single worker instance [with a GPU](/ml-
        engine/docs/tensorflow/using-gpus).
      BASIC_TPU: A single worker instance with a [Cloud TPU](/ml-
        engine/docs/tensorflow/using-tpus).
      CUSTOM: The CUSTOM tier is not a set tier, but rather enables you to use
        your own cluster specification. When you use this tier, set values to
        configure your processing cluster according to these guidelines:  *
        You _must_ set `TrainingInput.masterType` to specify the type     of
        machine to use for your master node. This is the only required
        setting.  *   You _may_ set `TrainingInput.workerCount` to specify the
        number of     workers to use. If you specify one or more workers, you
        _must_ also     set `TrainingInput.workerType` to specify the type of
        machine to use     for your worker nodes.  *   You _may_ set
        `TrainingInput.parameterServerCount` to specify the     number of
        parameter servers to use. If you specify one or more     parameter
        servers, you _must_ also set     `TrainingInput.parameterServerType`
        to specify the type of machine to     use for your parameter servers.
        Note that all of your workers must use the same machine type, which
        can be different from your parameter server type and master type. Your
        parameter servers must likewise use the same machine type, which can
        be different from your worker type and master type.
    """
    BASIC = 0
    STANDARD_1 = 1
    PREMIUM_1 = 2
    BASIC_GPU = 3
    BASIC_TPU = 4
    CUSTOM = 5

  args = _messages.StringField(1, repeated=True)
  hyperparameters = _messages.MessageField('GoogleCloudMlV1HyperparameterSpec', 2)
  jobDir = _messages.StringField(3)
  masterType = _messages.StringField(4)
  packageUris = _messages.StringField(5, repeated=True)
  parameterServerCount = _messages.IntegerField(6)
  parameterServerType = _messages.StringField(7)
  pythonModule = _messages.StringField(8)
  pythonVersion = _messages.StringField(9)
  region = _messages.StringField(10)
  runtimeVersion = _messages.StringField(11)
  scaleTier = _messages.EnumField('ScaleTierValueValuesEnum', 12)
  workerCount = _messages.IntegerField(13)
  workerType = _messages.StringField(14)


class GoogleCloudMlV1TrainingOutput(_messages.Message):
  r"""Represents results of a training job. Output only.

  Fields:
    completedTrialCount: The number of hyperparameter tuning trials that
      completed successfully. Only set for hyperparameter tuning jobs.
    consumedMLUnits: The amount of ML units consumed by the job.
    isHyperparameterTuningJob: Whether this job is a hyperparameter tuning
      job.
    trials: Results for individual Hyperparameter trials. Only set for
      hyperparameter tuning jobs.
  """

  completedTrialCount = _messages.IntegerField(1)
  consumedMLUnits = _messages.FloatField(2)
  isHyperparameterTuningJob = _messages.BooleanField(3)
  trials = _messages.MessageField('GoogleCloudMlV1HyperparameterOutput', 4, repeated=True)


class GoogleCloudMlV1Version(_messages.Message):
  r"""Represents a version of the model.  Each version is a trained model
  deployed in the cloud, ready to handle prediction requests. A model can have
  multiple versions. You can get information about all of the versions of a
  given model by calling [projects.models.versions.list](/ml-
  engine/reference/rest/v1/projects.models.versions/list).

  Enums:
    FrameworkValueValuesEnum: Optional. The machine learning framework Cloud
      ML Engine uses to train this version of the model. Valid values are
      `TENSORFLOW`, `SCIKIT_LEARN`, and `XGBOOST`. If you do not specify a
      framework, Cloud ML Engine uses TensorFlow. If you choose `SCIKIT_LEARN`
      or `XGBOOST`, you must also set the runtime version of the model to 1.4
      or greater.
    StateValueValuesEnum: Output only. The state of a version.

  Messages:
    LabelsValue: Optional. One or more labels that you can add, to organize
      your model versions. Each label is a key-value pair, where both the key
      and the value are arbitrary strings that you supply. For more
      information, see the documentation on <a href="/ml-
      engine/docs/tensorflow/resource-labels">using labels</a>.

  Fields:
    autoScaling: Automatically scale the number of nodes used to serve the
      model in response to increases and decreases in traffic. Care should be
      taken to ramp up traffic according to the model's ability to scale or
      you will start seeing increases in latency and 429 response codes.
    createTime: Output only. The time the version was created.
    deploymentUri: Required. The Google Cloud Storage location of the trained
      model used to create the version. See the [guide to model deployment
      ](/ml-engine/docs/tensorflow/deploying-models) for more information.
      When passing Version to [projects.models.versions.create](/ml-
      engine/reference/rest/v1/projects.models.versions/create) the model
      service uses the specified location as the source of the model. Once
      deployed, the model version is hosted by the prediction service, so this
      location is useful only as a historical record. The total number of
      model files can't exceed 1000.
    description: Optional. The description specified for the version when it
      was created.
    errorMessage: Output only. The details of a failure or a cancellation.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a model from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform model updates in order to avoid race
      conditions: An `etag` is returned in the response to `GetVersion`, and
      systems are expected to put that etag in the request to `UpdateVersion`
      to ensure that their change will be applied to the model as intended.
    framework: Optional. The machine learning framework Cloud ML Engine uses
      to train this version of the model. Valid values are `TENSORFLOW`,
      `SCIKIT_LEARN`, and `XGBOOST`. If you do not specify a framework, Cloud
      ML Engine uses TensorFlow. If you choose `SCIKIT_LEARN` or `XGBOOST`,
      you must also set the runtime version of the model to 1.4 or greater.
    isDefault: Output only. If true, this version will be used to handle
      prediction requests that do not specify a version.  You can change the
      default version by calling [projects.methods.versions.setDefault](/ml-
      engine/reference/rest/v1/projects.models.versions/setDefault).
    labels: Optional. One or more labels that you can add, to organize your
      model versions. Each label is a key-value pair, where both the key and
      the value are arbitrary strings that you supply. For more information,
      see the documentation on <a href="/ml-engine/docs/tensorflow/resource-
      labels">using labels</a>.
    lastUseTime: Output only. The time the version was last used for
      prediction.
    machineType: Optional. The type of machine on which to serve the model.
      Currently only applies to online prediction service. The following are
      currently supported and will be deprecated in Beta release.
      mls1-highmem-1    1 core    2 Gb RAM   mls1-highcpu-4    4 core    2 Gb
      RAM The following are available in Beta:   mls1-c1-m2        1 core    2
      Gb RAM   Default   mls1-c4-m2        4 core    2 Gb RAM
    manualScaling: Manually select the number of nodes to use for serving the
      model. You should generally use `auto_scaling` with an appropriate
      `min_nodes` instead, but this option is available if you want more
      predictable billing. Beware that latency and error rates will increase
      if the traffic exceeds that capability of the system to serve it based
      on the selected number of nodes.
    modelClass: class Model(object):   " " "A Model performs predictions on a
      given list of instances.    The input instances are the raw values sent
      by the user. It is the   responsibility of a Model to translate these
      instances into   actual predictions.    The input instances and the
      output use python data types. The input   instances have been decoded
      prior to being passed to the predict   method. The output, which should
      use python data types is   encoded after being returned from the predict
      method.   " " "    def predict(self, instances, **kwargs):     " "
      "Returns predictions for the provided instances.      Instances are the
      decoded values from the request. Clients need not     worry about
      decoding json nor base64 decoding.      Args:       instances: A list of
      instances, as described in the API.       **kwargs: Additional keyword
      arguments, will be passed into the           client's predict method.
      Returns:       A list of outputs containing the prediction results.
      " " "    @classmethod   def from_path(cls, model_path):     " " "Creates
      a model using the given model path.      Path is useful, e.g., to load
      files from the exported directory     containing the model.      Args:
      model_path: The local directory that contains the exported model
      file along with any additional files uploaded when creating the
      version resource.      Returns:       An instance implementing this
      Model class.     " " "
    name: Required.The name specified for the version when it was created.
      The version name must be unique within the model it is created in.
    packageUris: Optional. The Google Cloud Storage location of the packages
      for custom prediction and any additional dependencies.
    pythonVersion: Optional. The version of Python used in prediction. If not
      set, the default version is '2.7'. Python '3.5' is available when
      `runtime_version` is set to '1.4' and above. Python '2.7' works with all
      supported runtime versions.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      this deployment. If not set, Google Cloud ML will choose a version.
    state: Output only. The state of a version.
  """

  class FrameworkValueValuesEnum(_messages.Enum):
    r"""Optional. The machine learning framework Cloud ML Engine uses to train
    this version of the model. Valid values are `TENSORFLOW`, `SCIKIT_LEARN`,
    and `XGBOOST`. If you do not specify a framework, Cloud ML Engine uses
    TensorFlow. If you choose `SCIKIT_LEARN` or `XGBOOST`, you must also set
    the runtime version of the model to 1.4 or greater.

    Values:
      FRAMEWORK_UNSPECIFIED: Unspecified framework. Defaults to TensorFlow.
      TENSORFLOW: Tensorflow framework.
      SCIKIT_LEARN: Scikit-learn framework.
      XGBOOST: XGBoost framework.
    """
    FRAMEWORK_UNSPECIFIED = 0
    TENSORFLOW = 1
    SCIKIT_LEARN = 2
    XGBOOST = 3

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of a version.

    Values:
      UNKNOWN: The version state is unspecified.
      READY: The version is ready for prediction.
      CREATING: The version is being created. New UpdateVersion and
        DeleteVersion requests will fail if a version is in the CREATING
        state.
      FAILED: The version failed to be created, possibly cancelled.
        `error_message` should contain the details of the failure.
      DELETING: The version is being deleted. New UpdateVersion and
        DeleteVersion requests will fail if a version is in the DELETING
        state.
      UPDATING: The version is being updated. New UpdateVersion and
        DeleteVersion requests will fail if a version is in the UPDATING
        state.
    """
    UNKNOWN = 0
    READY = 1
    CREATING = 2
    FAILED = 3
    DELETING = 4
    UPDATING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. One or more labels that you can add, to organize your model
    versions. Each label is a key-value pair, where both the key and the value
    are arbitrary strings that you supply. For more information, see the
    documentation on <a href="/ml-engine/docs/tensorflow/resource-
    labels">using labels</a>.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  autoScaling = _messages.MessageField('GoogleCloudMlV1AutoScaling', 1)
  createTime = _messages.StringField(2)
  deploymentUri = _messages.StringField(3)
  description = _messages.StringField(4)
  errorMessage = _messages.StringField(5)
  etag = _messages.BytesField(6)
  framework = _messages.EnumField('FrameworkValueValuesEnum', 7)
  isDefault = _messages.BooleanField(8)
  labels = _messages.MessageField('LabelsValue', 9)
  lastUseTime = _messages.StringField(10)
  machineType = _messages.StringField(11)
  manualScaling = _messages.MessageField('GoogleCloudMlV1ManualScaling', 12)
  modelClass = _messages.StringField(13)
  name = _messages.StringField(14)
  packageUris = _messages.StringField(15, repeated=True)
  pythonVersion = _messages.StringField(16)
  runtimeVersion = _messages.StringField(17)
  state = _messages.EnumField('StateValueValuesEnum', 18)


class GoogleIamV1AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs.  If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted.  Example Policy with
  multiple AuditConfigs:      {       "audit_configs": [         {
  "service": "allServices"           "audit_log_configs": [             {
  "log_type": "DATA_READ",               "exempted_members": [
  "user:foo@gmail.com"               ]             },             {
  "log_type": "DATA_WRITE",             },             {
  "log_type": "ADMIN_READ",             }           ]         },         {
  "service": "fooservice.googleapis.com"           "audit_log_configs": [
  {               "log_type": "DATA_READ",             },             {
  "log_type": "DATA_WRITE",               "exempted_members": [
  "user:bar@gmail.com"               ]             }           ]         }
  ]     }  For fooservice, this policy enables DATA_READ, DATA_WRITE and
  ADMIN_READ logging. It also exempts foo@gmail.com from DATA_READ logging,
  and bar@gmail.com from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('GoogleIamV1AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class GoogleIamV1AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example:
  {       "audit_log_configs": [         {           "log_type": "DATA_READ",
  "exempted_members": [             "user:foo@gmail.com"           ]
  },         {           "log_type": "DATA_WRITE",         }       ]     }
  This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting
  foo@gmail.com from DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class GoogleIamV1Binding(_messages.Message):
  r"""Associates `members` with a `role`.

  Fields:
    condition: Unimplemented. The condition that is associated with this
      binding. NOTE: an unsatisfied condition will not allow user access via
      current binding. Different bindings, including their conditions, are
      examined independently.
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      .   * `serviceAccount:{emailid}`: An email address that represents a
      service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.
      * `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`.
  """

  condition = _messages.MessageField('GoogleTypeExpr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class GoogleIamV1Policy(_messages.Message):
  r"""Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **JSON Example**      {       "bindings": [         {
  "role": "roles/owner",           "members": [
  "user:mike@example.com",             "group:admins@example.com",
  "domain:google.com",             "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"           ]         },         {
  "role": "roles/viewer",           "members": ["user:sean@example.com"]
  }       ]     }  **YAML Example**      bindings:     - members:       -
  user:mike@example.com       - group:admins@example.com       -
  domain:google.com       - serviceAccount:my-other-
  app@appspot.gserviceaccount.com       role: roles/owner     - members:
  - user:sean@example.com       role: roles/viewer   For a description of IAM
  and its features, see the [IAM developer's
  guide](https://cloud.google.com/iam/docs).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members` to a `role`. `bindings` with no
      members will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Deprecated.
  """

  auditConfigs = _messages.MessageField('GoogleIamV1AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('GoogleIamV1Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class GoogleIamV1SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: paths: "bindings, etag"
      This field is only used by Cloud IAM.
  """

  policy = _messages.MessageField('GoogleIamV1Policy', 1)
  updateMask = _messages.StringField(2)


class GoogleIamV1TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleIamV1TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class GoogleTypeExpr(_messages.Message):
  r"""Represents an expression text. Example:      title: "User account
  presence"     description: "Determines whether the request has a user
  account"     expression: "size(request.user) > 0"

  Fields:
    description: An optional description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.  The application context of the containing message
      determines which well-known feature set of CEL is supported.
    location: An optional string indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: An optional title for the expression, i.e. a short string
      describing its purpose. This can be used e.g. in UIs which allow to
      enter the expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class MlProjectsGetConfigRequest(_messages.Message):
  r"""A MlProjectsGetConfigRequest object.

  Fields:
    name: Required. The project name.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsJobsCancelRequest(_messages.Message):
  r"""A MlProjectsJobsCancelRequest object.

  Fields:
    googleCloudMlV1CancelJobRequest: A GoogleCloudMlV1CancelJobRequest
      resource to be passed as the request body.
    name: Required. The name of the job to cancel.
  """

  googleCloudMlV1CancelJobRequest = _messages.MessageField('GoogleCloudMlV1CancelJobRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsJobsCreateRequest(_messages.Message):
  r"""A MlProjectsJobsCreateRequest object.

  Fields:
    googleCloudMlV1Job: A GoogleCloudMlV1Job resource to be passed as the
      request body.
    parent: Required. The project name.
  """

  googleCloudMlV1Job = _messages.MessageField('GoogleCloudMlV1Job', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsJobsGetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsJobsGetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class MlProjectsJobsGetRequest(_messages.Message):
  r"""A MlProjectsJobsGetRequest object.

  Fields:
    name: Required. The name of the job to get the description of.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsJobsListRequest(_messages.Message):
  r"""A MlProjectsJobsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of jobs to retrieve. You can filter
      on the value of one or more attributes of the job object. For example,
      retrieve jobs with a job identifier that starts with 'census':
      <p><code>gcloud ml-engine jobs list --filter='jobId:census*'</code>
      <p>List all failed jobs with names that start with 'rnn':
      <p><code>gcloud ml-engine jobs list --filter='jobId:rnn* AND
      state:FAILED'</code> <p>For more examples, see the guide to <a href
      ="/ml-engine/docs/tensorflow/monitor-training">monitoring jobs</a>.
    pageSize: Optional. The number of jobs to retrieve per "page" of results.
      If there are more remaining results than this number, the response
      message will contain a valid value in the `next_page_token` field.  The
      default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project for which to list jobs.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsJobsPatchRequest(_messages.Message):
  r"""A MlProjectsJobsPatchRequest object.

  Fields:
    googleCloudMlV1Job: A GoogleCloudMlV1Job resource to be passed as the
      request body.
    name: Required. The job name.
    updateMask: Required. Specifies the path, relative to `Job`, of the field
      to update. To adopt etag mechanism, include `etag` field in the mask,
      and include the `etag` value in your job resource.  For example, to
      change the labels of a job, the `update_mask` parameter would be
      specified as `labels`, `etag`, and the `PATCH` request body would
      specify the new value, as follows:     {       "labels": {
      "owner": "Google",          "color": "Blue"       }       "etag":
      "33a64df551425fcc55e4d42a148795d9f25f89d4"     } If `etag` matches the
      one on the server, the labels of the job will be replaced with the given
      ones, and the server end `etag` will be recalculated.  Currently the
      only supported update masks are `labels` and `etag`.
  """

  googleCloudMlV1Job = _messages.MessageField('GoogleCloudMlV1Job', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MlProjectsJobsSetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsJobsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsJobsTestIamPermissionsRequest(_messages.Message):
  r"""A MlProjectsJobsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsLocationsGetRequest(_messages.Message):
  r"""A MlProjectsLocationsGetRequest object.

  Fields:
    name: Required. The name of the location.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsLocationsListRequest(_messages.Message):
  r"""A MlProjectsLocationsListRequest object.

  Fields:
    pageSize: Optional. The number of locations to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project for which available locations
      are to be listed (since some locations might be whitelisted for specific
      projects).
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MlProjectsModelsCreateRequest(_messages.Message):
  r"""A MlProjectsModelsCreateRequest object.

  Fields:
    googleCloudMlV1Model: A GoogleCloudMlV1Model resource to be passed as the
      request body.
    parent: Required. The project name.
  """

  googleCloudMlV1Model = _messages.MessageField('GoogleCloudMlV1Model', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsModelsDeleteRequest(_messages.Message):
  r"""A MlProjectsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the model.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsGetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsModelsGetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being requested.
      See the operation documentation for the appropriate value for this
      field.
  """

  resource = _messages.StringField(1, required=True)


class MlProjectsModelsGetRequest(_messages.Message):
  r"""A MlProjectsModelsGetRequest object.

  Fields:
    name: Required. The name of the model.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsListRequest(_messages.Message):
  r"""A MlProjectsModelsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of models to retrieve.
    pageSize: Optional. The number of models to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project whose models are to be listed.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsModelsPatchRequest(_messages.Message):
  r"""A MlProjectsModelsPatchRequest object.

  Fields:
    googleCloudMlV1Model: A GoogleCloudMlV1Model resource to be passed as the
      request body.
    name: Required. The project name.
    updateMask: Required. Specifies the path, relative to `Model`, of the
      field to update.  For example, to change the description of a model to
      "foo" and set its default version to "version_1", the `update_mask`
      parameter would be specified as `description`, `default_version.name`,
      and the `PATCH` request body would specify the new value, as follows:
      {       "description": "foo",       "defaultVersion": {
      "name":"version_1"       }     }  Currently the supported update masks
      are `description` and `default_version.name`.
  """

  googleCloudMlV1Model = _messages.MessageField('GoogleCloudMlV1Model', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MlProjectsModelsSetIamPolicyRequest(_messages.Message):
  r"""A MlProjectsModelsSetIamPolicyRequest object.

  Fields:
    googleIamV1SetIamPolicyRequest: A GoogleIamV1SetIamPolicyRequest resource
      to be passed as the request body.
    resource: REQUIRED: The resource for which the policy is being specified.
      See the operation documentation for the appropriate value for this
      field.
  """

  googleIamV1SetIamPolicyRequest = _messages.MessageField('GoogleIamV1SetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsModelsTestIamPermissionsRequest(_messages.Message):
  r"""A MlProjectsModelsTestIamPermissionsRequest object.

  Fields:
    googleIamV1TestIamPermissionsRequest: A
      GoogleIamV1TestIamPermissionsRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See the operation documentation for the appropriate value for
      this field.
  """

  googleIamV1TestIamPermissionsRequest = _messages.MessageField('GoogleIamV1TestIamPermissionsRequest', 1)
  resource = _messages.StringField(2, required=True)


class MlProjectsModelsVersionsCreateRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsCreateRequest object.

  Fields:
    googleCloudMlV1Version: A GoogleCloudMlV1Version resource to be passed as
      the request body.
    parent: Required. The name of the model.
  """

  googleCloudMlV1Version = _messages.MessageField('GoogleCloudMlV1Version', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsModelsVersionsDeleteRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsDeleteRequest object.

  Fields:
    name: Required. The name of the version. You can get the names of all the
      versions of a model by calling [projects.models.versions.list](/ml-
      engine/reference/rest/v1/projects.models.versions/list).
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsVersionsGetRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsGetRequest object.

  Fields:
    name: Required. The name of the version.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsVersionsListRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of versions to retrieve.
    pageSize: Optional. The number of versions to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the model for which to list the version.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsModelsVersionsPatchRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsPatchRequest object.

  Fields:
    googleCloudMlV1Version: A GoogleCloudMlV1Version resource to be passed as
      the request body.
    name: Required. The name of the model.
    updateMask: Required. Specifies the path, relative to `Version`, of the
      field to update. Must be present and non-empty.  For example, to change
      the description of a version to "foo", the `update_mask` parameter would
      be specified as `description`, and the `PATCH` request body would
      specify the new value, as follows:     {       "description": "foo"
      }  Currently the only supported update mask fields are `description` and
      `autoScaling.minNodes`.
  """

  googleCloudMlV1Version = _messages.MessageField('GoogleCloudMlV1Version', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class MlProjectsModelsVersionsSetDefaultRequest(_messages.Message):
  r"""A MlProjectsModelsVersionsSetDefaultRequest object.

  Fields:
    googleCloudMlV1SetDefaultVersionRequest: A
      GoogleCloudMlV1SetDefaultVersionRequest resource to be passed as the
      request body.
    name: Required. The name of the version to make the default for the model.
      You can get the names of all the versions of a model by calling
      [projects.models.versions.list](/ml-
      engine/reference/rest/v1/projects.models.versions/list).
  """

  googleCloudMlV1SetDefaultVersionRequest = _messages.MessageField('GoogleCloudMlV1SetDefaultVersionRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsOperationsCancelRequest(_messages.Message):
  r"""A MlProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsDeleteRequest(_messages.Message):
  r"""A MlProjectsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsGetRequest(_messages.Message):
  r"""A MlProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsListRequest(_messages.Message):
  r"""A MlProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MlProjectsPredictRequest(_messages.Message):
  r"""A MlProjectsPredictRequest object.

  Fields:
    googleCloudMlV1PredictRequest: A GoogleCloudMlV1PredictRequest resource to
      be passed as the request body.
    name: Required. The resource name of a model or a version.  Authorization:
      requires the `predict` permission on the specified resource.
  """

  googleCloudMlV1PredictRequest = _messages.MessageField('GoogleCloudMlV1PredictRequest', 1)
  name = _messages.StringField(2, required=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
