"""Generated message classes for cloudbuild version v1.

Creates and manages builds on Google Cloud Platform.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudbuild'


class ArtifactObjects(_messages.Message):
  r"""Files in the workspace to upload to Cloud Storage upon successful
  completion of all build steps.

  Fields:
    location: Cloud Storage bucket and optional object path, in the form
      "gs://bucket/path/to/somewhere/". (see [Bucket Name
      Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).  Files in the workspace matching any path pattern
      will be uploaded to Cloud Storage with this location as a prefix.
    paths: Path globs used to match files in the build's workspace.
    timing: Output only. Stores timing information for pushing all artifact
      objects.
  """

  location = _messages.StringField(1)
  paths = _messages.StringField(2, repeated=True)
  timing = _messages.MessageField('TimeSpan', 3)


class ArtifactResult(_messages.Message):
  r"""An artifact that was uploaded during a build. This is a single record in
  the artifact manifest JSON file.

  Fields:
    fileHash: The file hash of the artifact.
    location: The path of an artifact in a Google Cloud Storage bucket, with
      the generation number. For example,
      `gs://mybucket/path/to/output.jar#generation`.
  """

  fileHash = _messages.MessageField('FileHashes', 1, repeated=True)
  location = _messages.StringField(2)


class Artifacts(_messages.Message):
  r"""Artifacts produced by a build that should be uploaded upon successful
  completion of all build steps.

  Fields:
    images: A list of images to be pushed upon the successful completion of
      all build steps.  The images will be pushed using the builder service
      account's credentials.  The digests of the pushed images will be stored
      in the Build resource's results field.  If any of the images fail to be
      pushed, the build is marked FAILURE.
    objects: A list of objects to be uploaded to Cloud Storage upon successful
      completion of all build steps.  Files in the workspace matching
      specified paths globs will be uploaded to the specified Cloud Storage
      location using the builder service account's credentials.  The location
      and generation of the uploaded objects will be stored in the Build
      resource's results field.  If any objects fail to be pushed, the build
      is marked FAILURE.
  """

  images = _messages.StringField(1, repeated=True)
  objects = _messages.MessageField('ArtifactObjects', 2)


class Build(_messages.Message):
  r"""A build resource in the Cloud Build API.  At a high level, a `Build`
  describes where to find source code, how to build it (for example, the
  builder image to run on the source), and where to store the built artifacts.
  Fields can include the following variables, which will be expanded when the
  build is created:  - $PROJECT_ID: the project ID of the build. - $BUILD_ID:
  the autogenerated ID of the build. - $REPO_NAME: the source repository name
  specified by RepoSource. - $BRANCH_NAME: the branch name specified by
  RepoSource. - $TAG_NAME: the tag name specified by RepoSource. -
  $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or
  resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters
  of $REVISION_ID or $COMMIT_SHA.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build.

  Messages:
    SubstitutionsValue: Substitutions data for `Build` resource.
    TimingValue: Output only. Stores timing information for phases of the
      build. Valid keys are:  * BUILD: time to execute all build steps * PUSH:
      time to push all specified images. * FETCHSOURCE: time to fetch source.
      If the build does not specify source or images, these keys will not be
      included.

  Fields:
    artifacts: Artifacts produced by the build that should be uploaded upon
      successful completion of all build steps.
    buildTriggerId: Output only. The ID of the `BuildTrigger` that triggered
      this build, if it was triggered automatically.
    createTime: Output only. Time at which the request to create the build was
      received.
    finishTime: Output only. Time at which execution of the build was
      finished.  The difference between finish_time and start_time is the
      duration of the build's execution.
    id: Output only. Unique identifier of the build.
    images: A list of images to be pushed upon the successful completion of
      all build steps.  The images are pushed using the builder service
      account's credentials.  The digests of the pushed images will be stored
      in the `Build` resource's results field.  If any of the images fail to
      be pushed, the build status is marked `FAILURE`.
    logUrl: Output only. URL to logs for this build in Google Cloud Console.
    logsBucket: Google Cloud Storage bucket where logs should be written (see
      [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)). Logs file names will be of the format
      `${logs_bucket}/log-${build_id}.txt`.
    options: Special options for this build.
    projectId: Output only. ID of the project.
    results: Output only. Results of the build.
    secrets: Secrets to decrypt using Cloud Key Management Service.
    source: The location of the source files to build.
    sourceProvenance: Output only. A permanent fixed identifier for source.
    startTime: Output only. Time at which execution of the build was started.
    status: Output only. Status of the build.
    statusDetail: Output only. Customer-readable message about the current
      status.
    steps: Required. The operations to be performed on the workspace.
    substitutions: Substitutions data for `Build` resource.
    tags: Tags for annotation of a `Build`. These are not docker tags.
    timeout: Amount of time that this build should be allowed to run, to
      second granularity. If this amount of time elapses, work on the build
      will cease and the build status will be `TIMEOUT`.  Default time is ten
      minutes.
    timing: Output only. Stores timing information for phases of the build.
      Valid keys are:  * BUILD: time to execute all build steps * PUSH: time
      to push all specified images. * FETCHSOURCE: time to fetch source.  If
      the build does not specify source or images, these keys will not be
      included.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
    """
    STATUS_UNKNOWN = 0
    QUEUED = 1
    WORKING = 2
    SUCCESS = 3
    FAILURE = 4
    INTERNAL_ERROR = 5
    TIMEOUT = 6
    CANCELLED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions data for `Build` resource.

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TimingValue(_messages.Message):
    r"""Output only. Stores timing information for phases of the build. Valid
    keys are:  * BUILD: time to execute all build steps * PUSH: time to push
    all specified images. * FETCHSOURCE: time to fetch source.  If the build
    does not specify source or images, these keys will not be included.

    Messages:
      AdditionalProperty: An additional property for a TimingValue object.

    Fields:
      additionalProperties: Additional properties of type TimingValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TimingValue object.

      Fields:
        key: Name of the additional property.
        value: A TimeSpan attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('TimeSpan', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  artifacts = _messages.MessageField('Artifacts', 1)
  buildTriggerId = _messages.StringField(2)
  createTime = _messages.StringField(3)
  finishTime = _messages.StringField(4)
  id = _messages.StringField(5)
  images = _messages.StringField(6, repeated=True)
  logUrl = _messages.StringField(7)
  logsBucket = _messages.StringField(8)
  options = _messages.MessageField('BuildOptions', 9)
  projectId = _messages.StringField(10)
  results = _messages.MessageField('Results', 11)
  secrets = _messages.MessageField('Secret', 12, repeated=True)
  source = _messages.MessageField('Source', 13)
  sourceProvenance = _messages.MessageField('SourceProvenance', 14)
  startTime = _messages.StringField(15)
  status = _messages.EnumField('StatusValueValuesEnum', 16)
  statusDetail = _messages.StringField(17)
  steps = _messages.MessageField('BuildStep', 18, repeated=True)
  substitutions = _messages.MessageField('SubstitutionsValue', 19)
  tags = _messages.StringField(20, repeated=True)
  timeout = _messages.StringField(21)
  timing = _messages.MessageField('TimingValue', 22)


class BuildOperationMetadata(_messages.Message):
  r"""Metadata for build operations.

  Fields:
    build: The build that the operation is tracking.
  """

  build = _messages.MessageField('Build', 1)


class BuildOptions(_messages.Message):
  r"""Optional arguments to enable specific features of builds.

  Enums:
    LogStreamingOptionValueValuesEnum: Option to define build log streaming
      behavior to Google Cloud Storage.
    MachineTypeValueValuesEnum: Compute Engine machine type on which to run
      the build.
    RequestedVerifyOptionValueValuesEnum: Requested verifiability options.
    SourceProvenanceHashValueListEntryValuesEnum:
    SubstitutionOptionValueValuesEnum: Option to specify behavior when there
      is an error in the substitution checks.

  Fields:
    diskSizeGb: Requested disk size for the VM that runs the build. Note that
      this is *NOT* "disk free"; some of the space will be used by the
      operating system and build utilities. Also note that this is the minimum
      disk size that will be allocated for the build -- the build may run with
      a larger disk than requested. At present, the maximum disk size is
      1000GB; builds that request more than the maximum are rejected with an
      error.
    logStreamingOption: Option to define build log streaming behavior to
      Google Cloud Storage.
    machineType: Compute Engine machine type on which to run the build.
    requestedVerifyOption: Requested verifiability options.
    sourceProvenanceHash: Requested hash for SourceProvenance.
    substitutionOption: Option to specify behavior when there is an error in
      the substitution checks.
  """

  class LogStreamingOptionValueValuesEnum(_messages.Enum):
    r"""Option to define build log streaming behavior to Google Cloud Storage.

    Values:
      STREAM_DEFAULT: Service may automatically determine build log streaming
        behavior.
      STREAM_ON: Build logs should be streamed to Google Cloud Storage.
      STREAM_OFF: Build logs should not be streamed to Google Cloud Storage;
        they will be written when the build is completed.
    """
    STREAM_DEFAULT = 0
    STREAM_ON = 1
    STREAM_OFF = 2

  class MachineTypeValueValuesEnum(_messages.Enum):
    r"""Compute Engine machine type on which to run the build.

    Values:
      UNSPECIFIED: Standard machine type.
      N1_HIGHCPU_8: Highcpu machine with 8 CPUs.
      N1_HIGHCPU_32: Highcpu machine with 32 CPUs.
    """
    UNSPECIFIED = 0
    N1_HIGHCPU_8 = 1
    N1_HIGHCPU_32 = 2

  class RequestedVerifyOptionValueValuesEnum(_messages.Enum):
    r"""Requested verifiability options.

    Values:
      NOT_VERIFIED: Not a verifiable build. (default)
      VERIFIED: Verified build.
    """
    NOT_VERIFIED = 0
    VERIFIED = 1

  class SourceProvenanceHashValueListEntryValuesEnum(_messages.Enum):
    r"""SourceProvenanceHashValueListEntryValuesEnum enum type.

    Values:
      NONE: <no description>
      SHA256: <no description>
      MD5: <no description>
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  class SubstitutionOptionValueValuesEnum(_messages.Enum):
    r"""Option to specify behavior when there is an error in the substitution
    checks.

    Values:
      MUST_MATCH: Fails the build if error in substitutions checks, like
        missing a substitution in the template or in the map.
      ALLOW_LOOSE: Do not fail the build if error in substitutions checks.
    """
    MUST_MATCH = 0
    ALLOW_LOOSE = 1

  diskSizeGb = _messages.IntegerField(1)
  logStreamingOption = _messages.EnumField('LogStreamingOptionValueValuesEnum', 2)
  machineType = _messages.EnumField('MachineTypeValueValuesEnum', 3)
  requestedVerifyOption = _messages.EnumField('RequestedVerifyOptionValueValuesEnum', 4)
  sourceProvenanceHash = _messages.EnumField('SourceProvenanceHashValueListEntryValuesEnum', 5, repeated=True)
  substitutionOption = _messages.EnumField('SubstitutionOptionValueValuesEnum', 6)


class BuildStep(_messages.Message):
  r"""A step in the build pipeline.

  Enums:
    StatusValueValuesEnum: Output only. Status of the build step. At this
      time, build step status is only updated on build completion; step status
      is not updated in real-time as the build progresses.

  Fields:
    args: A list of arguments that will be presented to the step when it is
      started.  If the image used to run the step's container has an
      entrypoint, the `args` are used as arguments to that entrypoint. If the
      image does not define an entrypoint, the first element in args is used
      as the entrypoint, and the remainder will be used as arguments.
    dir: Working directory to use when running this step's container.  If this
      value is a relative path, it is relative to the build's working
      directory. If this value is absolute, it may be outside the build's
      working directory, in which case the contents of the path may not be
      persisted across build step executions, unless a `volume` for that path
      is specified.  If the build specifies a `RepoSource` with `dir` and a
      step with a `dir`, which specifies an absolute path, the `RepoSource`
      `dir` is ignored for the step's execution.
    entrypoint: Entrypoint to be used instead of the build step image's
      default entrypoint. If unset, the image's default entrypoint is used.
    env: A list of environment variable definitions to be used when running a
      step.  The elements are of the form "KEY=VALUE" for the environment
      variable "KEY" being given the value "VALUE".
    id: Unique identifier for this build step, used in `wait_for` to reference
      this build step as a dependency.
    name: Required. The name of the container image that will run this
      particular build step.  If the image is available in the host's Docker
      daemon's cache, it will be run directly. If not, the host will attempt
      to pull the image first, using the builder service account's credentials
      if necessary.  The Docker daemon's cache will already have the latest
      versions of all of the officially supported build steps
      ([https://github.com/GoogleCloudPlatform/cloud-
      builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The
      Docker daemon will also have cached many of the layers for some popular
      images, like "ubuntu", "debian", but they will be refreshed at the time
      you attempt to use them.  If you built an image in a previous build
      step, it will be stored in the host's Docker daemon's cache and is
      available to use as the name for a later build step.
    secretEnv: A list of environment variables which are encrypted using a
      Cloud Key Management Service crypto key. These values must be specified
      in the build's `Secret`.
    status: Output only. Status of the build step. At this time, build step
      status is only updated on build completion; step status is not updated
      in real-time as the build progresses.
    timeout: Time limit for executing this build step. If not defined, the
      step has no time limit and will be allowed to continue to run until
      either it completes or the build itself times out.
    timing: Output only. Stores timing information for executing this build
      step.
    volumes: List of volumes to mount into the build step.  Each volume will
      be created as an empty volume prior to execution of the build step. Upon
      completion of the build, volumes and their contents will be discarded.
      Using a named volume in only one step is not valid as it is indicative
      of a mis-configured build request.
    waitFor: The ID(s) of the step(s) that this build step depends on. This
      build step will not start until all the build steps in `wait_for` have
      completed successfully. If `wait_for` is empty, this build step will
      start when all previous build steps in the `Build.Steps` list have
      completed successfully.
  """

  class StatusValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the build step. At this time, build step status
    is only updated on build completion; step status is not updated in real-
    time as the build progresses.

    Values:
      STATUS_UNKNOWN: Status of the build is unknown.
      QUEUED: Build or step is queued; work has not yet begun.
      WORKING: Build or step is being executed.
      SUCCESS: Build or step finished successfully.
      FAILURE: Build or step failed to complete successfully.
      INTERNAL_ERROR: Build or step failed due to an internal cause.
      TIMEOUT: Build or step took longer than was allowed.
      CANCELLED: Build or step was canceled by a user.
    """
    STATUS_UNKNOWN = 0
    QUEUED = 1
    WORKING = 2
    SUCCESS = 3
    FAILURE = 4
    INTERNAL_ERROR = 5
    TIMEOUT = 6
    CANCELLED = 7

  args = _messages.StringField(1, repeated=True)
  dir = _messages.StringField(2)
  entrypoint = _messages.StringField(3)
  env = _messages.StringField(4, repeated=True)
  id = _messages.StringField(5)
  name = _messages.StringField(6)
  secretEnv = _messages.StringField(7, repeated=True)
  status = _messages.EnumField('StatusValueValuesEnum', 8)
  timeout = _messages.StringField(9)
  timing = _messages.MessageField('TimeSpan', 10)
  volumes = _messages.MessageField('Volume', 11, repeated=True)
  waitFor = _messages.StringField(12, repeated=True)


class BuildTrigger(_messages.Message):
  r"""Configuration for an automated build in response to source repository
  changes.

  Messages:
    SubstitutionsValue: Substitutions data for Build resource.

  Fields:
    build: Contents of the build template.
    createTime: Output only. Time when the trigger was created.
    description: Human-readable description of this trigger.
    disabled: If true, the trigger will never result in a build.
    filename: Path, from the source root, to a file whose contents is used for
      the template.
    id: Output only. Unique identifier of the trigger.
    substitutions: Substitutions data for Build resource.
    triggerTemplate: Template describing the types of source changes to
      trigger a build.  Branch and tag names in trigger templates are
      interpreted as regular expressions. Any branch or tag change that
      matches that regular expression will trigger a build.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SubstitutionsValue(_messages.Message):
    r"""Substitutions data for Build resource.

    Messages:
      AdditionalProperty: An additional property for a SubstitutionsValue
        object.

    Fields:
      additionalProperties: Additional properties of type SubstitutionsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SubstitutionsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  build = _messages.MessageField('Build', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  disabled = _messages.BooleanField(4)
  filename = _messages.StringField(5)
  id = _messages.StringField(6)
  substitutions = _messages.MessageField('SubstitutionsValue', 7)
  triggerTemplate = _messages.MessageField('RepoSource', 8)


class BuiltImage(_messages.Message):
  r"""An image built by the pipeline.

  Fields:
    digest: Docker Registry 2.0 digest.
    name: Name used to push the container image to Google Container Registry,
      as presented to `docker push`.
    pushTiming: Output only. Stores timing information for pushing the
      specified image.
  """

  digest = _messages.StringField(1)
  name = _messages.StringField(2)
  pushTiming = _messages.MessageField('TimeSpan', 3)


class CancelBuildRequest(_messages.Message):
  r"""Request to cancel an ongoing build."""


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudbuildOperationsCancelRequest(_messages.Message):
  r"""A CloudbuildOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudbuildOperationsGetRequest(_messages.Message):
  r"""A CloudbuildOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudbuildOperationsListRequest(_messages.Message):
  r"""A CloudbuildOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class CloudbuildProjectsBuildsCancelRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsCancelRequest object.

  Fields:
    cancelBuildRequest: A CancelBuildRequest resource to be passed as the
      request body.
    id: ID of the build.
    projectId: ID of the project.
  """

  cancelBuildRequest = _messages.MessageField('CancelBuildRequest', 1)
  id = _messages.StringField(2, required=True)
  projectId = _messages.StringField(3, required=True)


class CloudbuildProjectsBuildsCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsCreateRequest object.

  Fields:
    build: A Build resource to be passed as the request body.
    projectId: ID of the project.
  """

  build = _messages.MessageField('Build', 1)
  projectId = _messages.StringField(2, required=True)


class CloudbuildProjectsBuildsGetRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsGetRequest object.

  Fields:
    id: ID of the build.
    projectId: ID of the project.
  """

  id = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)


class CloudbuildProjectsBuildsListRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsListRequest object.

  Fields:
    filter: The raw filter text to constrain the results.
    pageSize: Number of results to return in the list.
    pageToken: Token to provide to skip to a particular spot in the list.
    projectId: ID of the project.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  projectId = _messages.StringField(4, required=True)


class CloudbuildProjectsBuildsRetryRequest(_messages.Message):
  r"""A CloudbuildProjectsBuildsRetryRequest object.

  Fields:
    id: Build ID of the original build.
    projectId: ID of the project.
    retryBuildRequest: A RetryBuildRequest resource to be passed as the
      request body.
  """

  id = _messages.StringField(1, required=True)
  projectId = _messages.StringField(2, required=True)
  retryBuildRequest = _messages.MessageField('RetryBuildRequest', 3)


class CloudbuildProjectsTriggersCreateRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersCreateRequest object.

  Fields:
    buildTrigger: A BuildTrigger resource to be passed as the request body.
    projectId: ID of the project for which to configure automatic builds.
  """

  buildTrigger = _messages.MessageField('BuildTrigger', 1)
  projectId = _messages.StringField(2, required=True)


class CloudbuildProjectsTriggersDeleteRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersDeleteRequest object.

  Fields:
    projectId: ID of the project that owns the trigger.
    triggerId: ID of the `BuildTrigger` to delete.
  """

  projectId = _messages.StringField(1, required=True)
  triggerId = _messages.StringField(2, required=True)


class CloudbuildProjectsTriggersGetRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersGetRequest object.

  Fields:
    projectId: ID of the project that owns the trigger.
    triggerId: ID of the `BuildTrigger` to get.
  """

  projectId = _messages.StringField(1, required=True)
  triggerId = _messages.StringField(2, required=True)


class CloudbuildProjectsTriggersListRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersListRequest object.

  Fields:
    projectId: ID of the project for which to list BuildTriggers.
  """

  projectId = _messages.StringField(1, required=True)


class CloudbuildProjectsTriggersPatchRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersPatchRequest object.

  Fields:
    buildTrigger: A BuildTrigger resource to be passed as the request body.
    projectId: ID of the project that owns the trigger.
    triggerId: ID of the `BuildTrigger` to update.
  """

  buildTrigger = _messages.MessageField('BuildTrigger', 1)
  projectId = _messages.StringField(2, required=True)
  triggerId = _messages.StringField(3, required=True)


class CloudbuildProjectsTriggersRunRequest(_messages.Message):
  r"""A CloudbuildProjectsTriggersRunRequest object.

  Fields:
    projectId: ID of the project.
    repoSource: A RepoSource resource to be passed as the request body.
    triggerId: ID of the trigger.
  """

  projectId = _messages.StringField(1, required=True)
  repoSource = _messages.MessageField('RepoSource', 2)
  triggerId = _messages.StringField(3, required=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class FileHashes(_messages.Message):
  r"""Container message for hashes of byte content of files, used in
  SourceProvenance messages to verify integrity of source input to the build.

  Fields:
    fileHash: Collection of file hashes.
  """

  fileHash = _messages.MessageField('Hash', 1, repeated=True)


class Hash(_messages.Message):
  r"""Container message for hash values.

  Enums:
    TypeValueValuesEnum: The type of hash that was performed.

  Fields:
    type: The type of hash that was performed.
    value: The hash value.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of hash that was performed.

    Values:
      NONE: No hash requested.
      SHA256: Use a sha256 hash.
      MD5: Use a md5 hash.
    """
    NONE = 0
    SHA256 = 1
    MD5 = 2

  type = _messages.EnumField('TypeValueValuesEnum', 1)
  value = _messages.BytesField(2)


class ListBuildTriggersResponse(_messages.Message):
  r"""Response containing existing `BuildTriggers`.

  Fields:
    triggers: `BuildTriggers` for the project, sorted by `create_time`
      descending.
  """

  triggers = _messages.MessageField('BuildTrigger', 1, repeated=True)


class ListBuildsResponse(_messages.Message):
  r"""Response including listed builds.

  Fields:
    builds: Builds will be sorted by `create_time`, descending.
    nextPageToken: Token to receive the next page of results.
  """

  builds = _messages.MessageField('Build', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class RepoSource(_messages.Message):
  r"""Location of the source in a Google Cloud Source Repository.

  Fields:
    branchName: Name of the branch to build.
    commitSha: Explicit commit SHA to build.
    dir: Directory, relative to the source root, in which to run the build.
      This must be a relative path. If a step's `dir` is specified and is an
      absolute path, this value is ignored for that step's execution.
    projectId: ID of the project that owns the Cloud Source Repository. If
      omitted, the project ID requesting the build is assumed.
    repoName: Name of the Cloud Source Repository. If omitted, the name
      "default" is assumed.
    tagName: Name of the tag to build.
  """

  branchName = _messages.StringField(1)
  commitSha = _messages.StringField(2)
  dir = _messages.StringField(3)
  projectId = _messages.StringField(4)
  repoName = _messages.StringField(5)
  tagName = _messages.StringField(6)


class Results(_messages.Message):
  r"""Artifacts created by the build pipeline.

  Fields:
    artifactManifest: Path to the artifact manifest. Only populated when
      artifacts are uploaded.
    buildStepImages: List of build step digests, in the order corresponding to
      build step indices.
    images: Container images that were built as a part of the build.
    numArtifacts: Number of artifacts uploaded. Only populated when artifacts
      are uploaded.
  """

  artifactManifest = _messages.StringField(1)
  buildStepImages = _messages.StringField(2, repeated=True)
  images = _messages.MessageField('BuiltImage', 3, repeated=True)
  numArtifacts = _messages.IntegerField(4)


class RetryBuildRequest(_messages.Message):
  r"""Specifies a build to retry."""


class Secret(_messages.Message):
  r"""Pairs a set of secret environment variables containing encrypted values
  with the Cloud KMS key to use to decrypt the value.

  Messages:
    SecretEnvValue: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 1 KB in size. There can be at most ten secret values across all of
      a build's secrets.

  Fields:
    kmsKeyName: Cloud KMS key name to use to decrypt these envs.
    secretEnv: Map of environment variable name to its encrypted value.
      Secret environment variables must be unique across all of a build's
      secrets, and must be used by at least one build step. Values can be at
      most 1 KB in size. There can be at most ten secret values across all of
      a build's secrets.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class SecretEnvValue(_messages.Message):
    r"""Map of environment variable name to its encrypted value.  Secret
    environment variables must be unique across all of a build's secrets, and
    must be used by at least one build step. Values can be at most 1 KB in
    size. There can be at most ten secret values across all of a build's
    secrets.

    Messages:
      AdditionalProperty: An additional property for a SecretEnvValue object.

    Fields:
      additionalProperties: Additional properties of type SecretEnvValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a SecretEnvValue object.

      Fields:
        key: Name of the additional property.
        value: A byte attribute.
      """

      key = _messages.StringField(1)
      value = _messages.BytesField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  kmsKeyName = _messages.StringField(1)
  secretEnv = _messages.MessageField('SecretEnvValue', 2)


class Source(_messages.Message):
  r"""Location of the source in a supported storage service.

  Fields:
    repoSource: If provided, get the source from this location in a Cloud
      Source Repository.
    storageSource: If provided, get the source from this location in Google
      Cloud Storage.
  """

  repoSource = _messages.MessageField('RepoSource', 1)
  storageSource = _messages.MessageField('StorageSource', 2)


class SourceProvenance(_messages.Message):
  r"""Provenance of the source. Ways to find the original source, or verify
  that some source was used for this build.

  Messages:
    FileHashesValue: Output only. Hash(es) of the build source, which can be
      used to verify that the originalsource integrity was maintained in the
      build. Note that `FileHashes` willonly be populated if `BuildOptions`
      has requested a `SourceProvenanceHash`.  The keys to this map are file
      paths used as build source and the values contain the hash values for
      those files.  If the build source came in a single package such as a
      gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path
      to that file.

  Fields:
    fileHashes: Output only. Hash(es) of the build source, which can be used
      to verify that the originalsource integrity was maintained in the build.
      Note that `FileHashes` willonly be populated if `BuildOptions` has
      requested a `SourceProvenanceHash`.  The keys to this map are file paths
      used as build source and the values contain the hash values for those
      files.  If the build source came in a single package such as a gzipped
      tarfile (`.tar.gz`), the `FileHash` will be for the single path to that
      file.
    resolvedRepoSource: A copy of the build's `source.repo_source`, if exists,
      with any revisions resolved.
    resolvedStorageSource: A copy of the build's `source.storage_source`, if
      exists, with any generations resolved.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FileHashesValue(_messages.Message):
    r"""Output only. Hash(es) of the build source, which can be used to verify
    that the originalsource integrity was maintained in the build. Note that
    `FileHashes` willonly be populated if `BuildOptions` has requested a
    `SourceProvenanceHash`.  The keys to this map are file paths used as build
    source and the values contain the hash values for those files.  If the
    build source came in a single package such as a gzipped tarfile
    (`.tar.gz`), the `FileHash` will be for the single path to that file.

    Messages:
      AdditionalProperty: An additional property for a FileHashesValue object.

    Fields:
      additionalProperties: Additional properties of type FileHashesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FileHashesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileHashes attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileHashes', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  fileHashes = _messages.MessageField('FileHashesValue', 1)
  resolvedRepoSource = _messages.MessageField('RepoSource', 2)
  resolvedStorageSource = _messages.MessageField('StorageSource', 3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StorageSource(_messages.Message):
  r"""Location of the source in an archive file in Google Cloud Storage.

  Fields:
    bucket: Google Cloud Storage bucket containing the source (see [Bucket
      Name Requirements](https://cloud.google.com/storage/docs/bucket-
      naming#requirements)).
    generation: Google Cloud Storage generation for the object. If the
      generation is omitted, the latest generation will be used.
    object: Google Cloud Storage object containing the source.  This object
      must be a gzipped archive file (`.tar.gz`) containing source to build.
  """

  bucket = _messages.StringField(1)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3)


class TimeSpan(_messages.Message):
  r"""Start and end times for a build execution phase.

  Fields:
    endTime: End of time span.
    startTime: Start of time span.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class Volume(_messages.Message):
  r"""Volume describes a Docker container volume which is mounted into build
  steps in order to persist files across build step execution.

  Fields:
    name: Name of the volume to mount.  Volume names must be unique per build
      step and must be valid names for Docker volumes. Each named volume must
      be used by at least two build steps.
    path: Path at which to mount the volume.  Paths must be absolute and
      cannot conflict with other volume paths on the same build step or with
      certain reserved volume paths.
  """

  name = _messages.StringField(1)
  path = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
