"""Generated message classes for genomics version v2alpha1.

Upload, process, query, and search Genomics data in the cloud.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'genomics'


class Accelerator(_messages.Message):
  r"""Carries information about an accelerator that can be attached to a VM.

  Fields:
    count: How many accelerators of this type to attach.
    type: The accelerator type string (eg nvidia-tesla-k80).  Only NVIDIA GPU
      accelerators are currently supported.  If an NVIDIA GPU is attached, the
      required runtime libraries will be made available to all containers
      under `/usr/local/nvidia`.  The driver version to install must be
      specified using the NVIDIA driver version parameter on the virtual
      machine specification.  Note that attaching a GPU increases the worker
      VM startup time by a few minutes.
  """

  count = _messages.IntegerField(1)
  type = _messages.StringField(2)


class Action(_messages.Message):
  r"""Action specifies a single action that runs a docker container.

  Enums:
    FlagsValueListEntryValuesEnum:

  Messages:
    EnvironmentValue: The environment to pass into the container.  This
      environment is merged with any values specified in the Pipeline message.
      These values overwrite any in the Pipeline message.  In addition to the
      values passed here, a few other values are automatically injected into
      the environment.  These cannot be hidden or overwritten.
      `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline has failed
      because an action has exited with a non-zero status (and did not have
      the IGNORE_EXIT_STATUS flag set).  This can be used to determine if
      additional debug or logging actions should execute.
      `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
      non-background action that executed.  This can be used by workflow
      engine authors to determine whether an individual action has succeeded
      or failed.
    LabelsValue: Labels to associate with the action.  This field is provided
      to assist workflow engine authors in identifying actions (for example,
      to indicate what sort of action they perform: eg. localization,
      debugging, etc).  They are returned in the operation metadata but are
      otherwise ignored.
    PortMappingsValue: A map of container to host port mappings for this
      container.  Note that if the container already specifies exposed ports,
      the PUBLISH_EXPOSED_PORTS flag should be used instead.  The host port
      number must be less than 65536.  If it is zero, an unused random port is
      assigned.  To determine the resulting port number, consult the
      ContainerStartedEvent in the operation metadata.

  Fields:
    commands: If specified, overrides the CMD specified in the container.  If
      the container also has an ENTRYPOINT the values are used as entrypoint
      arguments.  Otherwise, they are used as a command and arguments to run
      inside the container.
    entrypoint: If specified, overrides the ENTRYPOINT specified in the
      container.
    environment: The environment to pass into the container.  This environment
      is merged with any values specified in the Pipeline message.  These
      values overwrite any in the Pipeline message.  In addition to the values
      passed here, a few other values are automatically injected into the
      environment.  These cannot be hidden or overwritten.
      `GOOGLE_PIPELINE_FAILED` will be set to "1" if the pipeline has failed
      because an action has exited with a non-zero status (and did not have
      the IGNORE_EXIT_STATUS flag set).  This can be used to determine if
      additional debug or logging actions should execute.
      `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the last
      non-background action that executed.  This can be used by workflow
      engine authors to determine whether an individual action has succeeded
      or failed.
    flags: The set of flags to apply to this action.
    imageUri: The URI to pull the container image from.  Note that all images
      referenced by actions in the pipeline are pulled before the first action
      runs.  If multiple actions reference the same image, it is only pulled
      once, ensuring that the same image is used for all actions in a single
      pipeline.
    labels: Labels to associate with the action.  This field is provided to
      assist workflow engine authors in identifying actions (for example, to
      indicate what sort of action they perform: eg. localization, debugging,
      etc).  They are returned in the operation metadata but are otherwise
      ignored.
    mounts: A list of mounts to make available to the action.  In addition to
      the values specified here, every action has a special virtual disk
      mounted under /google that contains log files and other operational
      components.  <ul>   <li><code>/google/logs</code>: all logs written
      during the pipeline   execution are stored here.</li>
      <li><code>/google/logs/output</code>: the combined standard output and
      standard error of all actions run as part of the pipeline
      execution.</li>   <li><code>/google/logs/action/*/stdout</code>: the
      complete contents of   each individual action's standard output</li>
      <li><code>/google/logs/action/*/stderr</code>: the complete contents of
      each individual action's standard error output</li> </ul>
    name: An optional name for the container.  The container hostname will be
      set to this name, making it useful for inter-container communication.
      The name must contain only upper and lowercase alphanumeric characters
      and hypens and cannot start with a hypen.
    pidNamespace: The PID namespace to run the action inside.  If unspecified,
      a separate isolated namespace is used.
    portMappings: A map of container to host port mappings for this container.
      Note that if the container already specifies exposed ports, the
      PUBLISH_EXPOSED_PORTS flag should be used instead.  The host port number
      must be less than 65536.  If it is zero, an unused random port is
      assigned.  To determine the resulting port number, consult the
      ContainerStartedEvent in the operation metadata.
  """

  class FlagsValueListEntryValuesEnum(_messages.Enum):
    r"""FlagsValueListEntryValuesEnum enum type.

    Values:
      FLAG_UNSPECIFIED: <no description>
      IGNORE_EXIT_STATUS: <no description>
      RUN_IN_BACKGROUND: <no description>
      ALWAYS_RUN: <no description>
      ENABLE_FUSE: <no description>
      PUBLISH_EXPOSED_PORTS: <no description>
      DISABLE_IMAGE_PREFETCH: <no description>
      DISABLE_STANDARD_ERROR_CAPTURE: <no description>
    """
    FLAG_UNSPECIFIED = 0
    IGNORE_EXIT_STATUS = 1
    RUN_IN_BACKGROUND = 2
    ALWAYS_RUN = 3
    ENABLE_FUSE = 4
    PUBLISH_EXPOSED_PORTS = 5
    DISABLE_IMAGE_PREFETCH = 6
    DISABLE_STANDARD_ERROR_CAPTURE = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentValue(_messages.Message):
    r"""The environment to pass into the container.  This environment is
    merged with any values specified in the Pipeline message.  These values
    overwrite any in the Pipeline message.  In addition to the values passed
    here, a few other values are automatically injected into the environment.
    These cannot be hidden or overwritten.  `GOOGLE_PIPELINE_FAILED` will be
    set to "1" if the pipeline has failed because an action has exited with a
    non-zero status (and did not have the IGNORE_EXIT_STATUS flag set).  This
    can be used to determine if additional debug or logging actions should
    execute.  `GOOGLE_LAST_EXIT_STATUS` will be set to the exit status of the
    last non-background action that executed.  This can be used by workflow
    engine authors to determine whether an individual action has succeeded or
    failed.

    Messages:
      AdditionalProperty: An additional property for a EnvironmentValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvironmentValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels to associate with the action.  This field is provided to assist
    workflow engine authors in identifying actions (for example, to indicate
    what sort of action they perform: eg. localization, debugging, etc).  They
    are returned in the operation metadata but are otherwise ignored.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PortMappingsValue(_messages.Message):
    r"""A map of container to host port mappings for this container.  Note
    that if the container already specifies exposed ports, the
    PUBLISH_EXPOSED_PORTS flag should be used instead.  The host port number
    must be less than 65536.  If it is zero, an unused random port is
    assigned.  To determine the resulting port number, consult the
    ContainerStartedEvent in the operation metadata.

    Messages:
      AdditionalProperty: An additional property for a PortMappingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type PortMappingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PortMappingsValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  commands = _messages.StringField(1, repeated=True)
  entrypoint = _messages.StringField(2)
  environment = _messages.MessageField('EnvironmentValue', 3)
  flags = _messages.EnumField('FlagsValueListEntryValuesEnum', 4, repeated=True)
  imageUri = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  mounts = _messages.MessageField('Mount', 7, repeated=True)
  name = _messages.StringField(8)
  pidNamespace = _messages.StringField(9)
  portMappings = _messages.MessageField('PortMappingsValue', 10)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CheckInRequest(_messages.Message):
  r"""The parameters to the CheckIn method.

  Messages:
    EventValue: A workflow specific event occurred.

  Fields:
    deadlineExpired: The deadline has expired and the worker needs more time.
    event: A workflow specific event occurred.
    result: The operation has finished with the given result.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EventValue(_messages.Message):
    r"""A workflow specific event occurred.

    Messages:
      AdditionalProperty: An additional property for a EventValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EventValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deadlineExpired = _messages.MessageField('Empty', 1)
  event = _messages.MessageField('EventValue', 2)
  result = _messages.MessageField('Status', 3)


class CheckInResponse(_messages.Message):
  r"""The response to the CheckIn method.

  Messages:
    MetadataValue: The metadata that describes the operation assigned to the
      worker.

  Fields:
    deadline: The deadline by which the worker must request an extension.  The
      backend will allow for network transmission time and other delays, but
      the worker must attempt to transmit the extension request no later than
      the deadline.
    metadata: The metadata that describes the operation assigned to the
      worker.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""The metadata that describes the operation assigned to the worker.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  deadline = _messages.StringField(1)
  metadata = _messages.MessageField('MetadataValue', 2)


class ComputeEngine(_messages.Message):
  r"""Describes a Compute Engine resource that is being managed by a running
  pipeline.

  Fields:
    diskNames: The names of the disks that were created for this pipeline.
    instanceName: The instance on which the operation is running.
    machineType: The machine type of the instance.
    zone: The availability zone in which the instance resides.
  """

  diskNames = _messages.StringField(1, repeated=True)
  instanceName = _messages.StringField(2)
  machineType = _messages.StringField(3)
  zone = _messages.StringField(4)


class ContainerStartedEvent(_messages.Message):
  r"""This event is generated when a container starts.

  Messages:
    PortMappingsValue: The container to host port mappings installed for this
      container.  This set will contain any ports exposed using the
      PUBLISH_EXPOSED_PORTS flag as well as any specified in the Action
      definition.

  Fields:
    actionId: The numeric ID of the action that started this container.
    ipAddress: The public IP address that can be used to connect to the
      container.  This field is only populated when at least one port mapping
      is present.  If the instance was created with a private address this
      field will be empty even if port mappings exist.
    portMappings: The container to host port mappings installed for this
      container.  This set will contain any ports exposed using the
      PUBLISH_EXPOSED_PORTS flag as well as any specified in the Action
      definition.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PortMappingsValue(_messages.Message):
    r"""The container to host port mappings installed for this container.
    This set will contain any ports exposed using the PUBLISH_EXPOSED_PORTS
    flag as well as any specified in the Action definition.

    Messages:
      AdditionalProperty: An additional property for a PortMappingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type PortMappingsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PortMappingsValue object.

      Fields:
        key: Name of the additional property.
        value: A integer attribute.
      """

      key = _messages.StringField(1)
      value = _messages.IntegerField(2, variant=_messages.Variant.INT32)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  ipAddress = _messages.StringField(2)
  portMappings = _messages.MessageField('PortMappingsValue', 3)


class ContainerStoppedEvent(_messages.Message):
  r"""This event is generated when a container exits.

  Fields:
    actionId: The numeric ID of the action that started this container.
    exitStatus: The exit status of the container.
    stderr: The tail end of any content written to standard error by the
      container. To prevent this from being recorded if the action is known to
      emit large amounts of debugging noise or sensitive information, set the
      DISABLE_STANDARD_ERROR_CAPTURE flag.  Note that only a small amount of
      the end of the stream is captured here. The entire stream is stored in
      the /google/logs directory mounted into each action, and may be copied
      off the machine as described elsewhere.
  """

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  exitStatus = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  stderr = _messages.StringField(3)


class DelayedEvent(_messages.Message):
  r"""This event is generated whenever a resource limitation or transient
  error delays execution of a pipeline that was otherwise ready to run.

  Fields:
    cause: A textual description of the cause of the delay.  The string may
      change without notice since it is often generated by another service
      (such as Compute Engine).
    metrics: If the delay was caused by a resource shortage, this field lists
      the Compute Engine metrics that are preventing this operation from
      running (for example, CPUS or INSTANCES).  If the particular metric is
      not known, a single UNKNOWN metric will be present.
  """

  cause = _messages.StringField(1)
  metrics = _messages.StringField(2, repeated=True)


class Disk(_messages.Message):
  r"""Carries information about a disk that can be attached to a VM.

  Fields:
    name: A user supplied name for the disk, used when mounting it into
      actions. The name must contain only upper and lowercase alphanumeric
      characters and hypens and cannot start with a hypen.
    sizeGb: The size, in gigabytes, of the disk to attach.  Note that this
      value is not configurable for some disk types such as local-ssd.  If the
      size is not specified, a size of at least 500gb is used to ensure
      reasonable I/O performance.
    sourceImage: An optional image to put on the disk before attaching it to
      the VM.
    type: The Compute Engine disk type.  If unspecified, 'standard-pd' is
      used.
  """

  name = _messages.StringField(1)
  sizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  sourceImage = _messages.StringField(3)
  type = _messages.StringField(4)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Event(_messages.Message):
  r"""Event carries information about events that occur during pipeline
  execution.

  Messages:
    DetailsValue: Machine readable details about the event.

  Fields:
    description: A human readable description of the event.  Note that these
      strings may change at any time without notice.  Any application logic
      must use the information in the details field.
    details: Machine readable details about the event.
    timestamp: The time that the event occurred.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValue(_messages.Message):
    r"""Machine readable details about the event.

    Messages:
      AdditionalProperty: An additional property for a DetailsValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  details = _messages.MessageField('DetailsValue', 2)
  timestamp = _messages.StringField(3)


class FailedEvent(_messages.Message):
  r"""This event is generated when the execution of a pipeline has failed.
  Note that other events may continue to occur after this event.

  Enums:
    CodeValueValuesEnum: The Google standard error code that best describes
      this failure.

  Fields:
    cause: The human readable description of the cause of the failure.
    code: The Google standard error code that best describes this failure.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""The Google standard error code that best describes this failure.

    Values:
      OK: Not an error; returned on success  HTTP Mapping: 200 OK
      CANCELLED: The operation was cancelled, typically by the caller.  HTTP
        Mapping: 499 Client Closed Request
      UNKNOWN: Unknown error.  For example, this error may be returned when a
        `Status` value received from another address space belongs to an error
        space that is not known in this address space.  Also errors raised by
        APIs that do not return enough error information may be converted to
        this error.  HTTP Mapping: 500 Internal Server Error
      INVALID_ARGUMENT: The client specified an invalid argument.  Note that
        this differs from `FAILED_PRECONDITION`.  `INVALID_ARGUMENT` indicates
        arguments that are problematic regardless of the state of the system
        (e.g., a malformed file name).  HTTP Mapping: 400 Bad Request
      DEADLINE_EXCEEDED: The deadline expired before the operation could
        complete. For operations that change the state of the system, this
        error may be returned even if the operation has completed
        successfully.  For example, a successful response from a server could
        have been delayed long enough for the deadline to expire.  HTTP
        Mapping: 504 Gateway Timeout
      NOT_FOUND: Some requested entity (e.g., file or directory) was not
        found.  Note to server developers: if a request is denied for an
        entire class of users, such as gradual feature rollout or undocumented
        whitelist, `NOT_FOUND` may be used. If a request is denied for some
        users within a class of users, such as user-based access control,
        `PERMISSION_DENIED` must be used.  HTTP Mapping: 404 Not Found
      ALREADY_EXISTS: The entity that a client attempted to create (e.g., file
        or directory) already exists.  HTTP Mapping: 409 Conflict
      PERMISSION_DENIED: The caller does not have permission to execute the
        specified operation. `PERMISSION_DENIED` must not be used for
        rejections caused by exhausting some resource (use
        `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
        must not be used if the caller can not be identified (use
        `UNAUTHENTICATED` instead for those errors). This error code does not
        imply the request is valid or the requested entity exists or satisfies
        other pre-conditions.  HTTP Mapping: 403 Forbidden
      UNAUTHENTICATED: The request does not have valid authentication
        credentials for the operation.  HTTP Mapping: 401 Unauthorized
      RESOURCE_EXHAUSTED: Some resource has been exhausted, perhaps a per-user
        quota, or perhaps the entire file system is out of space.  HTTP
        Mapping: 429 Too Many Requests
      FAILED_PRECONDITION: The operation was rejected because the system is
        not in a state required for the operation's execution.  For example,
        the directory to be deleted is non-empty, an rmdir operation is
        applied to a non-directory, etc.  Service implementors can use the
        following guidelines to decide between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`:  (a) Use `UNAVAILABLE` if the client can
        retry just the failing call.  (b) Use `ABORTED` if the client should
        retry at a higher level      (e.g., when a client-specified test-and-
        set fails, indicating the      client should restart a read-modify-
        write sequence).  (c) Use `FAILED_PRECONDITION` if the client should
        not retry until      the system state has been explicitly fixed.
        E.g., if an "rmdir"      fails because the directory is non-empty,
        `FAILED_PRECONDITION`      should be returned since the client should
        not retry unless      the files are deleted from the directory.  HTTP
        Mapping: 400 Bad Request
      ABORTED: The operation was aborted, typically due to a concurrency issue
        such as a sequencer check failure or transaction abort.  See the
        guidelines above for deciding between `FAILED_PRECONDITION`,
        `ABORTED`, and `UNAVAILABLE`.  HTTP Mapping: 409 Conflict
      OUT_OF_RANGE: The operation was attempted past the valid range.  E.g.,
        seeking or reading past end-of-file.  Unlike `INVALID_ARGUMENT`, this
        error indicates a problem that may be fixed if the system state
        changes. For example, a 32-bit file system will generate
        `INVALID_ARGUMENT` if asked to read at an offset that is not in the
        range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to read
        from an offset past the current file size.  There is a fair bit of
        overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`.  We
        recommend using `OUT_OF_RANGE` (the more specific error) when it
        applies so that callers who are iterating through a space can easily
        look for an `OUT_OF_RANGE` error to detect when they are done.  HTTP
        Mapping: 400 Bad Request
      UNIMPLEMENTED: The operation is not implemented or is not
        supported/enabled in this service.  HTTP Mapping: 501 Not Implemented
      INTERNAL: Internal errors.  This means that some invariants expected by
        the underlying system have been broken.  This error code is reserved
        for serious errors.  HTTP Mapping: 500 Internal Server Error
      UNAVAILABLE: The service is currently unavailable.  This is most likely
        a transient condition, which can be corrected by retrying with a
        backoff.  See the guidelines above for deciding between
        `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`.  HTTP Mapping:
        503 Service Unavailable
      DATA_LOSS: Unrecoverable data loss or corruption.  HTTP Mapping: 500
        Internal Server Error
    """
    OK = 0
    CANCELLED = 1
    UNKNOWN = 2
    INVALID_ARGUMENT = 3
    DEADLINE_EXCEEDED = 4
    NOT_FOUND = 5
    ALREADY_EXISTS = 6
    PERMISSION_DENIED = 7
    UNAUTHENTICATED = 8
    RESOURCE_EXHAUSTED = 9
    FAILED_PRECONDITION = 10
    ABORTED = 11
    OUT_OF_RANGE = 12
    UNIMPLEMENTED = 13
    INTERNAL = 14
    UNAVAILABLE = 15
    DATA_LOSS = 16

  cause = _messages.StringField(1)
  code = _messages.EnumField('CodeValueValuesEnum', 2)


class GenomicsProjectsOperationsCancelRequest(_messages.Message):
  r"""A GenomicsProjectsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GenomicsProjectsOperationsGetRequest(_messages.Message):
  r"""A GenomicsProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GenomicsProjectsOperationsListRequest(_messages.Message):
  r"""A GenomicsProjectsOperationsListRequest object.

  Fields:
    filter: A string for filtering Operations. In v2alpha1, the following
      filter fields are supported&#58;  * createTime&#58; The time this job
      was created * events&#58; The set of event (names) that have occurred
      while running   the pipeline.  The &#58; operator can be used to
      determine if a   particular event has occurred. * error&#58; If the
      pipeline is running, this value is NULL.  Once the   pipeline finishes,
      the value is the standard Google error code. * labels.key or labels."key
      with space" where key is a label key.  In v1 and v1alpha2, the following
      filter fields are supported&#58;  * projectId&#58; Required. Corresponds
      to   OperationMetadata.projectId. * createTime&#58; The time this job
      was created, in seconds from the
      [epoch](http://en.wikipedia.org/wiki/Unix_time). Can use `>=` and/or
      `<=`   operators. * status&#58; Can be `RUNNING`, `SUCCESS`, `FAILURE`,
      or `CANCELED`. Only   one status may be specified. * labels.key where
      key is a label key.  Examples&#58;  * `projectId = my-project AND
      createTime >= 1432140000` * `projectId = my-project AND createTime >=
      1432140000 AND createTime <= 1432150000 AND status = RUNNING` *
      `projectId = my-project AND labels.color = *` * `projectId = my-project
      AND labels.color = red`
    name: The name of the operation's parent resource.
    pageSize: The maximum number of results to return. If unspecified,
      defaults to 256. The maximum value is 2048.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GenomicsWorkersCheckInRequest(_messages.Message):
  r"""A GenomicsWorkersCheckInRequest object.

  Fields:
    checkInRequest: A CheckInRequest resource to be passed as the request
      body.
    id: The worker id, assigned when it was created.
  """

  checkInRequest = _messages.MessageField('CheckInRequest', 1)
  id = _messages.StringField(2, required=True)


class ImportReadGroupSetsResponse(_messages.Message):
  r"""The read group set import response.

  Fields:
    readGroupSetIds: IDs of the read group sets that were created.
  """

  readGroupSetIds = _messages.StringField(1, repeated=True)


class ImportVariantsResponse(_messages.Message):
  r"""The variant data import response.

  Fields:
    callSetIds: IDs of the call sets created during the import.
  """

  callSetIds = _messages.StringField(1, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Metadata(_messages.Message):
  r"""Metadata carries information about the pipeline execution that is
  returned in the long running operation's metadata field.

  Messages:
    LabelsValue: The user defined labels associated with this operation.

  Fields:
    createTime: The time that the operation was created by the API.
    endTime: The time at which execution was completed and resources were
      cleaned up.
    events: The list of events that have happened so far during the execution
      of this operation.
    labels: The user defined labels associated with this operation.
    pipeline: The pipeline this operation represents.
    startTime: The first time at which resources were allocated to execute the
      pipeline.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""The user defined labels associated with this operation.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  events = _messages.MessageField('Event', 3, repeated=True)
  labels = _messages.MessageField('LabelsValue', 4)
  pipeline = _messages.MessageField('Pipeline', 5)
  startTime = _messages.StringField(6)


class Mount(_messages.Message):
  r"""Mount carries information about a particular disk mount inside a
  container.

  Fields:
    disk: The name of the disk to mount, as specified in the resources
      section.
    path: The path to mount the disk at inside the container.
    readOnly: If true, the disk is mounted read only inside the container.
  """

  disk = _messages.StringField(1)
  path = _messages.StringField(2)
  readOnly = _messages.BooleanField(3)


class Network(_messages.Message):
  r"""VM networking options.

  Fields:
    name: The network name to attach the VM's network interface to.  If
      unspecified, the global default network is used.
    usePrivateAddress: If set to true, do not attach a public IP address to
      the VM.  Note that without an public IP address, additional
      configuration is required to allow the VM to access Google services.
      See https://cloud.google.com/vpc/docs/configure-private-google-access
      for more information.
  """

  name = _messages.StringField(1)
  usePrivateAddress = _messages.BooleanField(2)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: An OperationMetadata or Metadata object. This will always
      be returned with the Operation.
    ResponseValue: If importing ReadGroupSets, an ImportReadGroupSetsResponse
      is returned. If importing Variants, an ImportVariantsResponse is
      returned. For pipelines and exports, an Empty response is returned.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: An OperationMetadata or Metadata object. This will always be
      returned with the Operation.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. For example&#58; `operations
      /CJHU7Oi_ChDrveSpBRjfuL-qzoWAgEw`
    response: If importing ReadGroupSets, an ImportReadGroupSetsResponse is
      returned. If importing Variants, an ImportVariantsResponse is returned.
      For pipelines and exports, an Empty response is returned.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""An OperationMetadata or Metadata object. This will always be returned
    with the Operation.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""If importing ReadGroupSets, an ImportReadGroupSetsResponse is
    returned. If importing Variants, an ImportVariantsResponse is returned.
    For pipelines and exports, an Empty response is returned.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationEvent(_messages.Message):
  r"""An event that occurred during an Operation.

  Fields:
    description: Required description of event.
    endTime: Optional time of when event finished. An event can have a start
      time and no finish time. If an event has a finish time, there must be a
      start time.
    startTime: Optional time of when event started.
  """

  description = _messages.StringField(1)
  endTime = _messages.StringField(2)
  startTime = _messages.StringField(3)


class OperationMetadata(_messages.Message):
  r"""Metadata describing an Operation.

  Messages:
    LabelsValue: Optionally provided by the caller when submitting the request
      that creates the operation.
    RequestValue: The original request that started the operation. Note that
      this will be in current version of the API. If the operation was started
      with v1beta2 API and a GetOperation is performed on v1 API, a v1 request
      will be returned.
    RuntimeMetadataValue: Runtime metadata on this Operation.

  Fields:
    clientId: This field is deprecated. Use `labels` instead. Optionally
      provided by the caller when submitting the request that creates the
      operation.
    createTime: The time at which the job was submitted to the Genomics
      service.
    endTime: The time at which the job stopped running.
    events: Optional event messages that were generated during the job's
      execution. This also contains any warnings that were generated during
      import or export.
    labels: Optionally provided by the caller when submitting the request that
      creates the operation.
    projectId: The Google Cloud Project in which the job is scoped.
    request: The original request that started the operation. Note that this
      will be in current version of the API. If the operation was started with
      v1beta2 API and a GetOperation is performed on v1 API, a v1 request will
      be returned.
    runtimeMetadata: Runtime metadata on this Operation.
    startTime: The time at which the job began to run.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optionally provided by the caller when submitting the request that
    creates the operation.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestValue(_messages.Message):
    r"""The original request that started the operation. Note that this will
    be in current version of the API. If the operation was started with
    v1beta2 API and a GetOperation is performed on v1 API, a v1 request will
    be returned.

    Messages:
      AdditionalProperty: An additional property for a RequestValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RuntimeMetadataValue(_messages.Message):
    r"""Runtime metadata on this Operation.

    Messages:
      AdditionalProperty: An additional property for a RuntimeMetadataValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RuntimeMetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clientId = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  events = _messages.MessageField('OperationEvent', 4, repeated=True)
  labels = _messages.MessageField('LabelsValue', 5)
  projectId = _messages.StringField(6)
  request = _messages.MessageField('RequestValue', 7)
  runtimeMetadata = _messages.MessageField('RuntimeMetadataValue', 8)
  startTime = _messages.StringField(9)


class Pipeline(_messages.Message):
  r"""The Pipeline object describes a series of actions to execute, expressed
  as docker containers.

  Messages:
    EnvironmentValue: The environment to pass into every action.  Each action
      may also specify additional environment variables but cannot delete an
      entry from this map (though they may overwrite it with a different
      value).

  Fields:
    actions: The list of actions to execute, in the order they are specified.
    environment: The environment to pass into every action.  Each action may
      also specify additional environment variables but cannot delete an entry
      from this map (though they may overwrite it with a different value).
    resources: The resources required for execution.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvironmentValue(_messages.Message):
    r"""The environment to pass into every action.  Each action may also
    specify additional environment variables but cannot delete an entry from
    this map (though they may overwrite it with a different value).

    Messages:
      AdditionalProperty: An additional property for a EnvironmentValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvironmentValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a EnvironmentValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  actions = _messages.MessageField('Action', 1, repeated=True)
  environment = _messages.MessageField('EnvironmentValue', 2)
  resources = _messages.MessageField('Resources', 3)


class PullStartedEvent(_messages.Message):
  r"""This event is generated when the worker starts pulling an image.

  Fields:
    imageUri: The URI of the image that was pulled.
  """

  imageUri = _messages.StringField(1)


class PullStoppedEvent(_messages.Message):
  r"""This event is generated when the worker stops pulling an image.

  Fields:
    imageUri: The URI of the image that was pulled.
  """

  imageUri = _messages.StringField(1)


class Resources(_messages.Message):
  r"""The system resources for the pipeline run.  At least one zone or region
  must be specified or the pipeline run will fail.

  Fields:
    projectId: The customer project ID to allocate resources in.
    regions: The list of regions allowed for VM allocation.  If set, the zones
      field must not be set.
    virtualMachine: The virtual machine specification.
    zones: The list of zones allowed for VM allocation.  If set, the regions
      field must not be set.
  """

  projectId = _messages.StringField(1)
  regions = _messages.StringField(2, repeated=True)
  virtualMachine = _messages.MessageField('VirtualMachine', 3)
  zones = _messages.StringField(4, repeated=True)


class RunPipelineRequest(_messages.Message):
  r"""The arguments to the RunPipeline method.  The requesting user must have
  the iam.serviceAccounts.actAs permission for the Google Genomics Service
  Account or the request will fail.

  Messages:
    LabelsValue: User defined labels to associate with the returned operation.
      These labels are not propagated to any Google Cloud Platform resources
      used by the operation, and may be modified at any time.  To associate
      labels with resources created while executing the operation, see the
      appropriate resource message (i.e., VirtualMachine).

  Fields:
    labels: User defined labels to associate with the returned operation.
      These labels are not propagated to any Google Cloud Platform resources
      used by the operation, and may be modified at any time.  To associate
      labels with resources created while executing the operation, see the
      appropriate resource message (i.e., VirtualMachine).
    pipeline: The description of the pipeline to run.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""User defined labels to associate with the returned operation.  These
    labels are not propagated to any Google Cloud Platform resources used by
    the operation, and may be modified at any time.  To associate labels with
    resources created while executing the operation, see the appropriate
    resource message (i.e., VirtualMachine).

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  pipeline = _messages.MessageField('Pipeline', 2)


class RuntimeMetadata(_messages.Message):
  r"""Runtime metadata that will be populated in the runtimeMetadata field of
  the Operation associated with a RunPipeline execution.

  Fields:
    computeEngine: Execution information specific to Google Compute Engine.
  """

  computeEngine = _messages.MessageField('ComputeEngine', 1)


class ServiceAccount(_messages.Message):
  r"""Carries information about a Google Cloud Service Account.

  Fields:
    email: Email address of the service account.  If not specified, the
      default compute engine service account for the project will be used.
    scopes: List of scopes to be enabled for this service account on the VM,
      in addition to the Google Genomics API scope.
  """

  email = _messages.StringField(1)
  scopes = _messages.StringField(2, repeated=True)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` that can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting.  - Batch operations. If a
  client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class UnexpectedExitStatusEvent(_messages.Message):
  r"""This event is generated when the execution of a container results in a
  non-zero exit status that was not otherwise ignored.  Execution will
  continue, but only actions that are flagged as ALWAYS_RUN will be executed:
  other actions will be skipped.

  Fields:
    actionId: The numeric ID of the action that started the container.
    exitStatus: The exit status of the container.
  """

  actionId = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  exitStatus = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class VirtualMachine(_messages.Message):
  r"""Carries information about a Compute Engine VM resource.

  Messages:
    LabelsValue: Optional set of labels to apply to the VM and any attached
      disk resources. These labels must adhere to the name and value
      restrictions on VM labels imposed by Compute Engine.  These labels are
      applied at creation time to the VM and are applied on a best-effort
      basis to attached disk resources shortly after VM creation.

  Fields:
    accelerators: The list of accelerators to attach to the VM.
    bootDiskSizeGb: The size of the boot disk, in gigabytes. The boot disk
      must be large enough to accommodate all of the docker images from each
      action in the pipeline at the same time. If not specified, a small but
      reasonable default value is used.
    bootImage: The host operating system image to use.  At present, only
      Container Optimized OS images may be used.  The default value is
      "projects/cos-cloud/global/images/family/cos-stable" which selects the
      latest stable release of Container Optimized OS.  This option is
      provided to allow testing against the beta release of the operating
      system to ensure that the new version does not interact negatively with
      production pipelines.  To test a pipeline against the beta release of
      COS, use the value "projects/cos-cloud/global/images/family/cos-beta".
    cpuPlatform: The CPU platform to request.  An instance based on a newer
      platform may be allocated but never one with less capabilities.  The
      value of this parameter must be a valid Compute Engine CPU platform name
      (such as "Intel Skylake").  This parameter is only useful for carefully
      optimized work loads where the CPU platform has a significant impact.
      For more information about the effect of this parameter, please visit
      https://cloud.google.com/compute/docs/instances/specify-min-cpu-
      platform.
    disks: The list of disks to create and attach to the VM.
    labels: Optional set of labels to apply to the VM and any attached disk
      resources. These labels must adhere to the name and value restrictions
      on VM labels imposed by Compute Engine.  These labels are applied at
      creation time to the VM and are applied on a best-effort basis to
      attached disk resources shortly after VM creation.
    machineType: The machine type of the virtual machine to create.  Must be
      the short name of a standard machine type (such as "n1-standard-1") or a
      custom machine type (such as "custom-1-4096").
    network: The VM network configuration.
    nvidiaDriverVersion: The NVIDIA driver version to use when attaching an
      NVIDIA GPU accelerator. The version specified here must be compatible
      with the GPU libraries contained in the container being executed, and
      must be one of the drivers hosted in the 'nvidia-drivers-us-public'
      bucket on Google Cloud Storage.
    preemptible: If true, allocate a preemptible VM.
    serviceAccount: The service account to install on the VM.  This account
      does not need any permissions other than those required by the pipeline.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional set of labels to apply to the VM and any attached disk
    resources. These labels must adhere to the name and value restrictions on
    VM labels imposed by Compute Engine.  These labels are applied at creation
    time to the VM and are applied on a best-effort basis to attached disk
    resources shortly after VM creation.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accelerators = _messages.MessageField('Accelerator', 1, repeated=True)
  bootDiskSizeGb = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  bootImage = _messages.StringField(3)
  cpuPlatform = _messages.StringField(4)
  disks = _messages.MessageField('Disk', 5, repeated=True)
  labels = _messages.MessageField('LabelsValue', 6)
  machineType = _messages.StringField(7)
  network = _messages.MessageField('Network', 8)
  nvidiaDriverVersion = _messages.StringField(9)
  preemptible = _messages.BooleanField(10)
  serviceAccount = _messages.MessageField('ServiceAccount', 11)


class WorkerAssignedEvent(_messages.Message):
  r"""This event is generated once a worker VM has been assigned to run the
  pipeline.

  Fields:
    instance: The worker's instance name.
    zone: The zone the worker is running in.
  """

  instance = _messages.StringField(1)
  zone = _messages.StringField(2)


class WorkerReleasedEvent(_messages.Message):
  r"""This event is generated when the worker VM that was assigned to the
  pipeline has been released (i.e., deleted).

  Fields:
    instance: The worker's instance name.
    zone: The zone the worker was running in.
  """

  instance = _messages.StringField(1)
  zone = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
