export default function PluginsSvg() {
  return (
    <svg
      width="828"
      height="699"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g className="plugin pluginTerraform">
        <path
          opacity=".2"
          d="m319.25 270.781 39.436-.267 119.054-67.485a1.87 1.87 0 0 0 .948-1.631 1.877 1.877 0 0 0-.948-1.632l-38.623-22.641.146 24.08-120.013 69.576Z"
          fill="#A7CDD1"
        />
        <path
          d="m317.277 104.952-130.148 75.13a2.104 2.104 0 0 0 0 3.622l130.148 75.143a4.184 4.184 0 0 0 4.182 0l130.135-75.143a2.09 2.09 0 0 0 0-3.622l-130.135-75.13a4.18 4.18 0 0 0-4.182 0Z"
          fill="url(#paint0_linear)"
        />
        <path
          d="M452.661 181.894a2.05 2.05 0 0 1-1.052 1.811l-130.135 75.143a4.213 4.213 0 0 1-2.091.559v11.135a4.204 4.204 0 0 0 2.091-.56l130.135-75.13a2.087 2.087 0 0 0 1.052-1.811v-11.147Z"
          fill="url(#paint1_linear)"
        />
        <path
          d="m317.279 258.848-130.148-75.143a2.06 2.06 0 0 1-1.039-1.811v11.147a2.103 2.103 0 0 0 1.039 1.811l130.148 75.13c.636.367 1.357.56 2.091.56v-11.135a4.172 4.172 0 0 1-2.091-.559Z"
          fill="url(#paint2_linear)"
        />
        <path
          d="m306.441 218.781-8.936 5.159 1.825 1.054 3.46-1.998 8.48 4.896 2.017-1.164-8.48-4.896 3.46-1.997-1.826-1.054Zm13.769 4.188c1.958-1.13 2.017-2.49 1.472-3.297l-2.267.714c.265.493.117 1.07-.825 1.614-1.354.782-2.768.748-3.857.272l5.786-3.34a4.451 4.451 0 0 0-.648-.425c-2.135-1.232-5.227-1.402-7.671.009-2.34 1.351-2.193 3.238.03 4.521 2.356 1.36 5.595 1.309 7.98-.068Zm-6.699-1.402c-.751-.552-.81-1.436.324-2.091 1.163-.671 2.606-.654 3.607-.178l-3.931 2.269Zm7.254-6.483-1.104-.637-1.944 1.122 7.45 4.3 1.944-1.122-3.239-1.869c-2.003-1.156-1.87-2.083-.03-2.856l-1.825-1.054c-1.326.578-1.679 1.36-1.252 2.116Zm5.665-3.27-1.104-.638-1.944 1.122 7.45 4.301 1.943-1.122-3.239-1.87c-2.002-1.156-1.869-2.082-.029-2.855l-1.826-1.054c-1.325.578-1.678 1.359-1.251 2.116Zm13.08.013c1.046-.603 1.428-1.334 1.281-2.031l.913.527 1.958-1.131-7.45-4.3-1.958 1.13.898.518c-1.207-.085-2.458.145-3.504.748-2.061 1.19-2.017 3.086.251 4.395 2.252 1.3 5.55 1.334 7.611.144Zm-1.398-1.198c-1.222.705-3.004.68-4.299-.068-1.281-.74-1.311-1.76-.089-2.465 1.178-.68 3.018-.706 4.299.034 1.296.748 1.266 1.819.089 2.499Zm2.024-8.785c-.706-.408-.795-.85-.176-1.207a3.722 3.722 0 0 1 1.119-.425l-1.09-1.173a6.518 6.518 0 0 0-2.002.782c-1.737 1.003-1.517 2.151.206 3.145l.677.391-1.428.825 1.708.986 1.428-.825 5.742 3.315 1.943-1.122-5.741-3.315 2.252-1.3-1.708-.986-2.252 1.3-.678-.391Zm14.766 1.098c2.296-1.326 2.267-3.281.044-4.564-2.238-1.292-5.61-1.301-7.906.025-2.297 1.326-2.297 3.281-.059 4.573 2.223 1.283 5.624 1.292 7.921-.034Zm-1.767-1.02c-1.252.722-3.018.671-4.255-.043-1.237-.714-1.325-1.734-.074-2.456 1.237-.714 3.019-.672 4.255.042 1.237.714 1.311 1.743.074 2.457Zm2.611-7.032-1.104-.638-1.944 1.122 7.45 4.301 1.944-1.122-3.239-1.87c-2.003-1.156-1.87-2.082-.03-2.856l-1.826-1.054c-1.325.578-1.678 1.36-1.251 2.117Zm11.318-8.047c-1.192.688-1.531 1.462-1.398 2.099-1.163-.144-2.312.043-3.357.646-.987.57-1.266 1.258-1.119 1.904l-.883-.51-1.944 1.122 7.45 4.301 1.943-1.122-3.739-2.159c-1.311-.757-1.546-1.539-.501-2.142 1.001-.578 2.12-.391 3.224.246l4.02 2.321 1.958-1.131-3.799-2.192c-1.266-.731-1.516-1.488-.471-2.091 1.016-.587 2.135-.417 3.254.229l4.019 2.321 1.944-1.122-4.432-2.559c-2.076-1.198-4.387-1.19-6.169-.161Z"
          fill="#000"
        />
        <g
          clipPath="url(#clip0)"
          fillRule="evenodd"
          clipRule="evenodd"
          fill="#7B42BC"
        >
          <path d="m236.74 181.092 12.121-1.877 8.875 5.124-12.123 1.875-8.873-5.122Z" />
          <path d="m249.703 178.729 8.875 5.124 3.246-6.998-8.873-5.122-3.248 6.996Z" />
          <path d="m223.262 183.154 8.872 5.123 12.121-1.874-8.872-5.123-12.121 1.874Z" />
          <path d="m255.457 191.898 12.121-1.874-8.815-5.089-.058-.033-12.121 1.873 8.873 5.123Z" />
        </g>
      </g>
      <g className="plugin pluginCloudRun">
        <path
          opacity=".2"
          d="m135.25 375.041 39.436-.267 119.054-67.485a1.87 1.87 0 0 0 .948-1.631 1.874 1.874 0 0 0-.948-1.632l-38.623-22.641.146 24.08-120.013 69.576Z"
          fill="#A7CDD1"
        />
        <path
          d="M133.277 209.212 3.129 284.341a2.101 2.101 0 0 0-.757 2.854c.181.318.442.583.757.769l130.148 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.09 2.09 0 0 0 0-3.623l-130.135-75.129a4.181 4.181 0 0 0-4.182 0Z"
          fill="url(#paint3_linear)"
        />
        <path
          d="M268.661 286.153a2.045 2.045 0 0 1-1.052 1.812l-130.135 75.143a4.213 4.213 0 0 1-2.091.559v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.087 2.087 0 0 0 1.052-1.811v-11.148Z"
          fill="url(#paint4_linear)"
        />
        <path
          d="M133.279 363.108 3.131 287.965a2.073 2.073 0 0 1-1.04-1.812v11.148a2.107 2.107 0 0 0 1.04 1.811l130.148 75.13c.636.367 1.357.56 2.091.559v-11.134a4.172 4.172 0 0 1-2.091-.559Z"
          fill="url(#paint5_linear)"
        />
        <path
          d="M129.744 330.962c2.723-1.572 2.797-3.536 1.619-4.76l-2.458.842c.677.782.471 1.938-1.09 2.839-2.032 1.172-4.962.977-6.817-.094-1.855-1.071-2.134-2.728-.103-3.901 1.561-.901 3.593-1.003 4.932-.621l1.487-1.419c-2.105-.672-5.55-.655-8.333.952-3.062 1.768-3.062 4.437-.029 6.187 3.048 1.76 7.685 1.768 10.792-.025Zm6.218-3.828 1.944-1.122-10.748-6.205-1.943 1.122 10.747 6.205Zm7.593-4.145c2.297-1.326 2.268-3.281.044-4.565-2.237-1.292-5.609-1.3-7.906.026-2.296 1.326-2.296 3.281-.059 4.573 2.224 1.283 5.625 1.291 7.921-.034Zm-1.766-1.02c-1.252.722-3.019.671-4.255-.043-1.237-.714-1.325-1.734-.074-2.456 1.237-.714 3.018-.672 4.255.042 1.237.714 1.31 1.743.074 2.457Zm4.819-9.582 3.666 2.116c1.325.765 1.487 1.657.383 2.295-1.075.62-2.326.493-3.46-.162l-3.975-2.294-1.944 1.122 4.344 2.507c2.002 1.156 4.299 1.343 6.257.212 1.075-.62 1.398-1.368 1.237-2.04l.942.544 1.943-1.121-7.45-4.301-1.943 1.122Zm6.186-7.379 4.196 2.422c-1.208-.085-2.459.145-3.504.748-2.062 1.19-2.017 3.086.25 4.395 2.253 1.3 5.55 1.334 7.612.144 1.045-.603 1.428-1.334 1.28-2.031l.913.527 1.958-1.131-10.747-6.204-1.958 1.13Zm7.155 6.511c-1.222.705-3.003.68-4.299-.068-1.281-.74-1.31-1.76-.088-2.465 1.177-.68 3.018-.706 4.299.034 1.295.748 1.266 1.819.088 2.499Zm13.994-6.312 2.327-1.342-6.375-.723c.957-1.13.471-2.329-.884-3.111-1.634-.943-4.652-1.19-6.89.102l-5.02 2.899 10.305 5.949 2.003-1.156-3.607-2.082 2.193-1.266 5.948.73Zm-13.029-2.286 2.959-1.708c.957-.553 2.356-.527 3.18-.051.854.493.913 1.292-.132 1.895l-2.886 1.666-3.121-1.802Zm14.392-7.102 3.666 2.117c1.325.765 1.487 1.657.383 2.295-1.075.62-2.327.493-3.46-.162l-3.975-2.295-1.944 1.122 4.344 2.508c2.002 1.156 4.299 1.343 6.257.212 1.074-.62 1.398-1.368 1.236-2.04l.943.544 1.943-1.122-7.45-4.3-1.943 1.121Zm7.996-4.854c-1.074.621-1.398 1.368-1.251 2.048l-.942-.544-1.944 1.122 7.45 4.301 1.943-1.122-3.68-2.125c-1.311-.756-1.458-1.657-.368-2.286 1.074-.62 2.311-.501 3.445.153l3.99 2.303 1.943-1.122-4.358-2.515c-1.987-1.148-4.284-1.335-6.228-.213Z"
          fill="#000"
        />
        <path
          d="m100.934 314.5-3.409 1.967 7.275 4.2 1.414-.816-2.224-1.284 1.933-1.116c1.673-.966 1.288-2.243.062-2.951-1.206-.696-3.45-.924-5.051 0Zm3.679 2.243-1.891 1.092-2.495-1.44 1.954-1.127c.697-.402 1.788-.336 2.432.036.634.366.769.995 0 1.439Zm8.317-2.281-5.966-3.444-1.423.822 7.274 4.2 5.051-2.916-1.309-.756-3.627 2.094Zm4.311-9.376 4.271 2.466c1.071.618 1.268 1.391.125 2.051-1.133.654-2.474.54-3.544-.078l-4.271-2.465-1.445.834 4.292 2.477a6.272 6.272 0 0 0 6.277-.012c2.027-1.17 1.871-2.555.021-3.623l-4.292-2.478-1.434.828Zm14.4-4.582-3.71 2.142 1.226.708 2.235-1.29c.779.594.758 1.446-.468 2.154-1.632.942-3.7.792-5.009.036-1.31-.756-1.466-1.95-.042-2.772 1.123-.648 2.307-.744 3.419-.522l.946-.978c-1.673-.438-3.918-.306-5.716.732-2.161 1.248-2.182 3.144-.041 4.38 2.151 1.242 5.435 1.242 7.669-.048 2.183-1.26 2.276-2.934.219-4.122l-.728-.42Zm6.286 1.039 1.444-.834-7.274-4.199-1.445.833 7.275 4.2Zm1.544-9.291 4.718 2.724-8.377-.612-1.174.678 7.275 4.2 1.424-.822-4.729-2.73 8.387.618 1.174-.678-7.275-4.199-1.423.821Z"
          fill="#727274"
        />
        <path
          d="m63.513 280.817.94-.542v-3.09l-1.006-.732c-5.869.211-11.133 2.157-13.921 5.146-2.789 2.988-2.706 6.597.218 9.542.176-.243.487-.445.883-.575l4.47-3.6s-.178-.418-.009-.483c-.234-2.884 3.47-5.374 8.444-5.676l-.02.01Z"
          fill="#EA4335"
        />
        <path
          d="M72.998 277.716c-2.88-.953-6.18-1.4-9.495-1.285v4.337c2.883-.167 5.739.438 7.748 1.643l.667.385c1.847-1.066 4.84-1.066 6.687 0 1.847 1.066 1.847 2.794 0 3.86l-6.687 3.861.01.775 4.01 2.315h1.334l6.687-3.86c3.864-2.196 4.78-5.594 2.256-8.365-2.523-2.77-7.893-4.26-13.217-3.666Z"
          fill="#4285F4"
        />
        <path
          d="m70.539 297.452 6.687-3.861-5.354-3.09-6.687 3.86a5.845 5.845 0 0 1-1.68.624l-.649.71-.019 3.102.705.677c2.653-.213 5.11-.924 6.997-2.022Z"
          fill="#34A853"
        />
        <path
          d="M53.173 287.427c-3.692 2.157-4.604 5.43-2.27 8.146 2.336 2.717 7.401 4.278 12.61 3.885v-4.478c-1.967.429-4.189.056-5.451-.915-1.263-.971-1.263-2.307 0-3.278 1.262-.971 3.484-1.344 5.451-.915v-4.478c-3.807-.293-7.633.459-10.34 2.033Z"
          fill="#FBBC05"
        />
      </g>
      <g className="plugin pluginKubernetes">
        <path
          opacity=".2"
          d="m697.562 697.792 39.437-.266 119.054-67.485a1.877 1.877 0 0 0 0-3.263l-38.624-22.641.147 24.08-120.014 69.575Z"
          fill="#A7CDD1"
        />
        <path
          d="m695.59 531.964-130.149 75.129a2.104 2.104 0 0 0 0 3.623l130.149 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.088 2.088 0 0 0 .766-2.857 2.1 2.1 0 0 0-.766-.766l-130.135-75.129a4.184 4.184 0 0 0-4.182 0Z"
          fill="url(#paint6_linear)"
        />
        <path
          d="M830.974 608.905a2.055 2.055 0 0 1-1.053 1.812L699.786 685.86a4.213 4.213 0 0 1-2.091.559v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.09 2.09 0 0 0 1.053-1.811v-11.148Z"
          fill="url(#paint7_linear)"
        />
        <path
          d="m695.592 685.86-130.149-75.143a2.072 2.072 0 0 1-1.039-1.812v11.148a2.107 2.107 0 0 0 1.039 1.811l130.149 75.13a4.17 4.17 0 0 0 2.091.559v-11.134a4.17 4.17 0 0 1-2.091-.559Z"
          fill="url(#paint8_linear)"
        />
        <path
          d="m693.646 654.163 2.459-1.419-10.188-.816-.442-4.947-2.562 1.479.648 5.389-4.991-2.881-2.017 1.164 10.306 5.95 2.017-1.165-2.635-1.521-.162-1.845 7.567.612Zm.782-9.052 3.666 2.116c1.325.765 1.487 1.658.383 2.295-1.075.62-2.327.493-3.46-.161l-3.975-2.295-1.944 1.122 4.343 2.507c2.003 1.156 4.299 1.343 6.258.212 1.074-.62 1.398-1.368 1.236-2.039l.943.544 1.943-1.122-7.45-4.301-1.943 1.122Zm8.011-4.863c-1.06.612-1.443 1.326-1.31 2.031l-4.196-2.422-1.944 1.122 10.748 6.204 1.943-1.121-.912-.527c1.222.076 2.473-.136 3.533-.748 2.061-1.19 1.988-3.086-.265-4.386-2.267-1.309-5.536-1.343-7.597-.153Zm5.786 3.731c-1.178.68-3.033.697-4.328-.051-1.281-.739-1.237-1.802-.059-2.482 1.222-.705 2.988-.688 4.269.051 1.296.748 1.34 1.777.118 2.482Zm10.8-4.229c1.958-1.13 2.017-2.49 1.472-3.297l-2.267.714c.265.493.117 1.071-.825 1.614-1.354.782-2.768.748-3.857.272l5.786-3.34a4.398 4.398 0 0 0-.648-.425c-2.135-1.232-5.226-1.402-7.67.009-2.341 1.351-2.194 3.238.029 4.521 2.356 1.36 5.595 1.309 7.98-.068Zm-6.699-1.402c-.751-.552-.81-1.436.324-2.091 1.163-.671 2.606-.654 3.607-.178l-3.931 2.269Zm7.254-6.483-1.104-.637-1.943 1.122 7.449 4.3 1.944-1.121-3.239-1.87c-2.003-1.156-1.87-2.083-.03-2.856l-1.825-1.054c-1.325.578-1.679 1.36-1.252 2.116Zm6.754-5.412c-1.074.621-1.398 1.369-1.251 2.048l-.942-.543-1.944 1.121 7.45 4.301 1.943-1.122-3.68-2.125c-1.311-.756-1.458-1.657-.368-2.286 1.074-.62 2.311-.501 3.445.153l3.99 2.303 1.943-1.122-4.358-2.515c-1.987-1.148-4.284-1.335-6.228-.213Zm16.227-.29c1.958-1.13 2.017-2.49 1.472-3.298l-2.267.714c.265.493.118 1.071-.824 1.615-1.355.782-2.768.748-3.858.272l5.786-3.34c-.191-.162-.412-.289-.648-.425-2.134-1.233-5.226-1.403-7.67.008-2.341 1.352-2.194 3.239.029 4.522 2.356 1.36 5.595 1.309 7.98-.068Zm-6.699-1.402c-.751-.553-.81-1.437.324-2.091 1.163-.672 2.606-.655 3.607-.179l-3.931 2.27Zm13.885-5.075c-.147.255-.339.433-.677.629-.619.357-1.252.331-1.855-.017l-3.195-1.845 2.179-1.258-1.708-.986-2.179 1.258-2.415-1.394-1.958 1.131 2.415 1.394-1.252.722 1.708.986 1.252-.722 3.194 1.844c1.605.927 3.446 1.088 5.153.102.619-.357 1.031-.731 1.384-1.207l-2.046-.637Zm7.062-1.749c1.958-1.13 2.017-2.49 1.473-3.297l-2.268.714c.265.493.118 1.071-.824 1.614-1.355.782-2.768.748-3.858.272l5.786-3.34a4.44 4.44 0 0 0-.647-.425c-2.135-1.232-5.227-1.402-7.671.009-2.341 1.351-2.194 3.238.03 4.521 2.355 1.36 5.594 1.309 7.979-.068Zm-6.699-1.402c-.75-.552-.809-1.436.324-2.091 1.163-.671 2.606-.654 3.607-.178l-3.931 2.269Zm14.793-3.27c1.899-1.096 2.193-2.456.795-3.264-1.34-.773-2.768-.476-4.211-.017l-2.385.765c-.53.17-.913.187-1.207.017-.354-.204-.221-.654.383-1.003.78-.45 1.722-.535 2.458-.416l1.222-1.284c-1.59-.374-3.577-.11-5.182.816-1.634.944-2.002 2.295-.751 3.018 1.06.612 2.459.518 3.828.085l2.459-.774c.706-.221 1.192-.263 1.56-.051.412.238.28.723-.471 1.156-.986.57-2.223.672-3.18.408l-1.237 1.309c1.576.484 4.078.297 5.919-.765Z"
          fill="#000"
        />
        <path
          d="m663.936 641.5-3.409 1.967 7.275 4.2 1.413-.816-2.224-1.284 1.933-1.116c1.674-.966 1.289-2.243.063-2.951-1.206-.696-3.45-.924-5.051 0Zm3.679 2.243-1.891 1.092-2.495-1.44 1.954-1.127c.696-.402 1.788-.336 2.432.036.634.366.769.995 0 1.439Zm8.317-2.281-5.966-3.444-1.423.822 7.274 4.2 5.051-2.916-1.309-.756-3.627 2.094Zm4.311-9.376 4.271 2.466c1.071.618 1.268 1.391.125 2.051-1.133.654-2.474.54-3.544-.078l-4.271-2.465-1.445.834 4.292 2.477a6.272 6.272 0 0 0 6.277-.012c2.027-1.17 1.871-2.555.021-3.623l-4.292-2.478-1.434.828Zm14.4-4.582-3.71 2.142 1.226.708 2.235-1.29c.779.594.758 1.446-.468 2.154-1.632.942-3.7.792-5.009.036-1.31-.756-1.466-1.95-.042-2.772 1.123-.648 2.307-.744 3.419-.522l.946-.978c-1.673-.438-3.918-.306-5.716.732-2.162 1.248-2.182 3.144-.041 4.38 2.151 1.242 5.435 1.242 7.669-.048 2.183-1.26 2.276-2.934.218-4.122l-.727-.42Zm6.286 1.039 1.444-.834-7.275-4.199-1.444.833 7.275 4.2Zm1.544-9.291 4.718 2.724-8.377-.612-1.174.678 7.275 4.2 1.424-.822-4.729-2.73 8.387.618 1.174-.678-7.275-4.199-1.423.821Z"
          fill="#727274"
        />
        <path
          d="M611.362 600.841a1.773 1.773 0 0 0-.579.566l-5.447 9.14a1.015 1.015 0 0 0-.136.739c.051.25.199.491.433.704l9.039 8.249c.208.19.479.355.798.484.319.129.679.221 1.058.269.093.012.186.021.28.028l16.717 1.147c.432.03.87.003 1.279-.079.41-.081.782-.215 1.087-.392l11.808-6.819c.305-.177.538-.391.679-.627a1.02 1.02 0 0 0 .137-.739l-1.991-9.65c-.052-.249-.2-.49-.434-.704a2.775 2.775 0 0 0-.917-.53l-14.293-5.215a4.458 4.458 0 0 0-1.219-.25 4.906 4.906 0 0 0-1.28.078l-15.831 3.147a3.465 3.465 0 0 0-1.188.454Z"
          fill="#326CE5"
        />
        <path
          d="M615.437 603.072c-.352.203-.314.554.086.785l.019.009c.054.032.117.071.166.097.238.128.463.202.705.307.508.231.929.422 1.251.64a.4.4 0 0 1 .129.314l.261.167a8.53 8.53 0 0 0-.971.769c-1.27 1.176-1.824 2.501-1.733 3.804-.12.013-.333.032-.397.037-.098.075-.177.162-.416.197-.481.051-1.011.045-1.651.038-.3-.007-.552-.032-.873-.02-.073.002-.179.01-.257.015a1.503 1.503 0 0 0-.615.157c-.202.109-.313.263-.278.426.062.288.561.496 1.115.463l.017-.002c.077-.004.173-.008.24-.013.319-.026.554-.081.844-.123.621-.081 1.136-.148 1.627-.154.204.005.409.103.503.142l.39-.01c.587 1.601 2.156 3.09 4.568 4.138l-.187.2c.022.094.069.235.009.32-.223.25-.553.486-.95.77-.192.131-.383.229-.561.382-.04.033-.09.083-.13.121l-.004.004-.007.007c-.283.271-.171.613.253.769.425.155 1.003.066 1.298-.2l.008-.007.008-.009c.041-.037.094-.083.127-.117.158-.16.229-.302.348-.459.267-.332.487-.608.777-.834.13-.088.381-.116.498-.135l.229-.188c2.661.799 5.635.97 8.356.584l.168.23c.152.04.347.099.425.18.203.26.337.582.481.943.062.171.08.319.178.498.024.042.067.104.094.148.194.301.726.469 1.195.377.472-.093.701-.414.512-.719v-.002l-.001-.001c-.027-.043-.059-.101-.087-.141-.121-.174-.271-.295-.412-.45-.264-.347-.625-.662-.676-.959-.014-.081.06-.158.138-.237l-.122-.238c2.057-.518 3.867-1.384 5.136-2.559.289-.268.54-.543.756-.825l.386.066c.146-.042.284-.1.527-.071.477.074.954.213 1.531.379.267.081.48.168.781.237.069.016.171.036.246.051.529.11 1.088-.023 1.249-.296.159-.27-.132-.578-.654-.69-.076-.015-.184-.039-.258-.053-.309-.056-.565-.066-.86-.102-.626-.083-1.146-.152-1.597-.27-.221-.068-.265-.163-.335-.25-.052-.002-.263-.064-.369-.09.7-1.63.303-3.36-1.045-4.843.095-.04.264-.107.32-.129.032-.092.035-.192.222-.283.39-.168.868-.295 1.444-.449.273-.069.519-.109.797-.2.058-.019.136-.051.201-.074l.016-.005.011-.004c.461-.171.616-.504.346-.749-.269-.246-.863-.31-1.331-.147-.067.025-.166.057-.229.082-.265.103-.434.213-.661.323-.493.23-.901.42-1.334.549-.186.046-.444.007-.557-.004l-.333.104c-.852-.646-1.914-1.217-3.171-1.676a17.873 17.873 0 0 0-4.01-.938l.019-.25c-.107-.073-.238-.138-.249-.281.01-.284.127-.581.268-.939.072-.168.169-.304.213-.488.01-.042.018-.102.025-.148.057-.32-.302-.608-.802-.644-.5-.035-.952.195-1.009.515-.008.045-.021.106-.026.148-.02.186.022.332.034.505.012.37.024.677-.065.954-.05.114-.256.204-.343.248l-.066.242c-2.86-.057-5.687.483-7.895 1.546a23.712 23.712 0 0 1-.306-.159c-.164.001-.333.019-.533-.068-.378-.186-.708-.43-1.108-.722-.183-.14-.31-.27-.531-.408-.051-.031-.13-.073-.187-.106-.399-.23-1.008-.252-1.359-.049Zm4.247 3.373 3.223 2.079-.006.011c.292.184.29.467-.012.641a1.082 1.082 0 0 1-.44.128l-.003.004-4.723.437c-.003-.974.449-1.957 1.402-2.839.174-.162.362-.315.559-.461Zm1.597-.922c1.631-.731 3.641-1.118 5.694-1.118l-.75 2.709-.014.003c-.061.244-.446.414-.876.384a1.165 1.165 0 0 1-.455-.121h-.004l-3.595-1.857Zm-3.277 5.531 4.787-.125.011.01c.426-.015.807.167.86.415.022.101-.015.199-.095.281l.008.008-2.261 2.396c-1.687-.785-2.817-1.843-3.31-2.985Zm11.243-6.489a14.27 14.27 0 0 1 2.868.708c.902.329 1.678.73 2.32 1.179l-4.171 1.313-.016-.006c-.369.12-.846.049-1.08-.163-.096-.087-.136-.185-.126-.279l-.008-.003.213-2.749Zm-3.665 4.956 1.025-.591 1.45.101.786.718-.468.792-1.376.271-1.243-.454-.174-.837Zm6.068-.29a.857.857 0 0 1 .139-.069l-.002-.007 3.889-1.584c.908 1.084 1.185 2.317.752 3.499l-4.463-1.09-.002-.006c-.399-.093-.609-.352-.471-.586a.474.474 0 0 1 .158-.157Zm-5.556 3.223c.257-.144.663-.171.985-.053a.662.662 0 0 1 .322.222l.022.002 1.87 2.55c-1.971.237-4.088.11-6.03-.425l2.718-2.227.013.001a.633.633 0 0 1 .1-.07Zm4.155-.808a.956.956 0 0 1 .319-.119c.167-.032.339-.032.497-.004l.012-.007 4.612.791a5.61 5.61 0 0 1-.463.481c-.952.882-2.275 1.545-3.783 1.966l-1.369-2.657.003-.002c-.088-.163-.015-.333.172-.449Z"
          fill="#fff"
          stroke="#fff"
          strokeWidth=".219"
        />
        <path
          d="M611.362 600.841a1.773 1.773 0 0 0-.579.566l-5.447 9.14a1.015 1.015 0 0 0-.136.739c.051.25.199.491.433.704l9.039 8.249c.208.19.479.355.798.484.319.129.679.221 1.058.269.093.012.186.021.28.028l16.717 1.147c.432.03.87.003 1.279-.079.41-.081.782-.215 1.087-.392l11.808-6.819c.305-.177.538-.391.679-.627a1.02 1.02 0 0 0 .137-.739l-1.991-9.65c-.052-.249-.2-.49-.434-.704a2.775 2.775 0 0 0-.917-.53l-14.293-5.215a4.458 4.458 0 0 0-1.219-.25 4.906 4.906 0 0 0-1.28.078l-15.831 3.147a3.465 3.465 0 0 0-1.188.454Z"
          fill="#326CE5"
        />
        <path
          d="M615.437 603.072c-.352.203-.314.554.086.785l.019.009c.054.032.117.071.166.097.238.128.463.202.705.307.508.231.929.422 1.251.64a.4.4 0 0 1 .129.314l.261.167a8.53 8.53 0 0 0-.971.769c-1.27 1.176-1.824 2.501-1.733 3.804-.12.013-.333.032-.397.037-.098.075-.177.162-.416.197-.481.051-1.011.045-1.651.038-.3-.007-.552-.032-.873-.02-.073.002-.179.01-.257.015a1.503 1.503 0 0 0-.615.157c-.202.109-.313.263-.278.426.062.288.561.496 1.115.463l.017-.002c.077-.004.173-.008.24-.013.319-.026.554-.081.844-.123.621-.081 1.136-.148 1.627-.154.204.005.409.103.503.142l.39-.01c.587 1.601 2.156 3.09 4.568 4.138l-.187.2c.022.094.069.235.009.32-.223.25-.553.486-.95.77-.192.131-.383.229-.561.382-.04.033-.09.083-.13.121l-.004.004-.007.007c-.283.271-.171.613.253.769.425.155 1.003.066 1.298-.2l.008-.007.008-.009c.041-.037.094-.083.127-.117.158-.16.229-.302.348-.459.267-.332.487-.608.777-.834.13-.088.381-.116.498-.135l.229-.188c2.661.799 5.635.97 8.356.584l.168.23c.152.04.347.099.425.18.203.26.337.582.481.943.062.171.08.319.178.498.024.042.067.104.094.148.194.301.726.469 1.195.377.472-.093.701-.414.512-.719v-.002l-.001-.001c-.027-.043-.059-.101-.087-.141-.121-.174-.271-.295-.412-.45-.264-.347-.625-.662-.676-.959-.014-.081.06-.158.138-.237l-.122-.238c2.057-.518 3.867-1.384 5.136-2.559.289-.268.54-.543.756-.825l.386.066c.146-.042.284-.1.527-.071.477.074.954.213 1.531.379.267.081.48.168.781.237.069.016.171.036.246.051.529.11 1.088-.023 1.249-.296.159-.27-.132-.578-.654-.69-.076-.015-.184-.039-.258-.053-.309-.056-.565-.066-.86-.102-.626-.083-1.146-.152-1.597-.27-.221-.068-.265-.163-.335-.25-.052-.002-.263-.064-.369-.09.7-1.63.303-3.36-1.045-4.843.095-.04.264-.107.32-.129.032-.092.035-.192.222-.283.39-.168.868-.295 1.444-.449.273-.069.519-.109.797-.2.058-.019.136-.051.201-.074l.016-.005.011-.004c.461-.171.616-.504.346-.749-.269-.246-.863-.31-1.331-.147-.067.025-.166.057-.229.082-.265.103-.434.213-.661.323-.493.23-.901.42-1.334.549-.186.046-.444.007-.557-.004l-.333.104c-.852-.646-1.914-1.217-3.171-1.676a17.873 17.873 0 0 0-4.01-.938l.019-.25c-.107-.073-.238-.138-.249-.281.01-.284.127-.581.268-.939.072-.168.169-.304.213-.488.01-.042.018-.102.025-.148.057-.32-.302-.608-.802-.644-.5-.035-.952.195-1.009.515-.008.045-.021.106-.026.148-.02.186.022.332.034.505.012.37.024.677-.065.954-.05.114-.256.204-.343.248l-.066.242c-2.86-.057-5.687.483-7.895 1.546a23.712 23.712 0 0 1-.306-.159c-.164.001-.333.019-.533-.068-.378-.186-.708-.43-1.108-.722-.183-.14-.31-.27-.531-.408-.051-.031-.13-.073-.187-.106-.399-.23-1.008-.252-1.359-.049Zm4.247 3.373 3.223 2.079-.006.011c.292.184.29.467-.012.641a1.082 1.082 0 0 1-.44.128l-.003.004-4.723.437c-.003-.974.449-1.957 1.402-2.839.174-.162.362-.315.559-.461Zm1.597-.922c1.631-.731 3.641-1.118 5.694-1.118l-.75 2.709-.014.003c-.061.244-.446.414-.876.384a1.165 1.165 0 0 1-.455-.121h-.004l-3.595-1.857Zm-3.277 5.531 4.787-.125.011.01c.426-.015.807.167.86.415.022.101-.015.199-.095.281l.008.008-2.261 2.396c-1.687-.785-2.817-1.843-3.31-2.985Zm11.243-6.489a14.27 14.27 0 0 1 2.868.708c.902.329 1.678.73 2.32 1.179l-4.171 1.313-.016-.006c-.369.12-.846.049-1.08-.163-.096-.087-.136-.185-.126-.279l-.008-.003.213-2.749Zm-3.665 4.956 1.025-.591 1.45.101.786.718-.468.792-1.376.271-1.243-.454-.174-.837Zm6.068-.29a.857.857 0 0 1 .139-.069l-.002-.007 3.889-1.584c.908 1.084 1.185 2.317.752 3.499l-4.463-1.09-.002-.006c-.399-.093-.609-.352-.471-.586a.474.474 0 0 1 .158-.157Zm-5.556 3.223c.257-.144.663-.171.985-.053a.662.662 0 0 1 .322.222l.022.002 1.87 2.55c-1.971.237-4.088.11-6.03-.425l2.718-2.227.013.001a.633.633 0 0 1 .1-.07Zm4.155-.808a.956.956 0 0 1 .319-.119c.167-.032.339-.032.497-.004l.012-.007 4.612.791a5.61 5.61 0 0 1-.463.481c-.952.882-2.275 1.545-3.783 1.966l-1.369-2.657.003-.002c-.088-.163-.015-.333.172-.449Z"
          fill="#fff"
          stroke="#fff"
          strokeWidth=".219"
        />
      </g>
      <g className="plugin pluginNomad">
        <path
          opacity=".15"
          d="m136.25 167.041 39.436-.267L294.74 99.289a1.875 1.875 0 0 0 .694-2.575 1.874 1.874 0 0 0-.694-.688l-38.623-22.641.146 24.08L136.25 167.04Z"
          fill="#A7CDD1"
        />
        <path
          d="M134.277 1.212 4.129 76.342a2.105 2.105 0 0 0 0 3.622l130.148 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.088 2.088 0 0 0 0-3.623L138.459 1.211a4.18 4.18 0 0 0-4.182 0Z"
          fill="url(#paint9_linear)"
        />
        <path
          d="M269.661 78.153a2.048 2.048 0 0 1-1.052 1.812l-130.135 75.143a4.213 4.213 0 0 1-2.091.559v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.094 2.094 0 0 0 1.052-1.811V78.153Z"
          fill="url(#paint10_linear)"
        />
        <path
          d="M134.279 155.108 4.131 79.965a2.064 2.064 0 0 1-1.04-1.812v11.148a2.104 2.104 0 0 0 1.04 1.811l130.148 75.13c.636.367 1.357.56 2.091.559v-11.134a4.172 4.172 0 0 1-2.091-.559Z"
          fill="url(#paint11_linear)"
        />
        <path
          d="m122.087 115.822 6.684 3.859-11.867-.867-1.663.961 10.306 5.949 2.017-1.164-6.699-3.867 11.881.875 1.664-.96-10.306-5.95-2.017 1.164Zm17.982 1.756c2.297-1.326 2.268-3.281.045-4.564-2.238-1.292-5.61-1.3-7.907.026-2.296 1.325-2.296 3.28-.058 4.572 2.223 1.284 5.624 1.292 7.92-.034Zm-1.766-1.02c-1.252.723-3.018.672-4.255-.042-1.237-.714-1.325-1.734-.074-2.457 1.237-.714 3.018-.671 4.255.043 1.237.714 1.31 1.742.074 2.456Zm8.264-11.808c-1.192.688-1.531 1.461-1.398 2.099-1.163-.145-2.312.042-3.357.646-.987.569-1.266 1.258-1.119 1.904l-.883-.51-1.944 1.122 7.45 4.3 1.943-1.121-3.739-2.159c-1.311-.757-1.546-1.539-.501-2.142 1.001-.578 2.12-.391 3.224.246l4.02 2.321 1.958-1.131-3.799-2.193c-1.266-.731-1.516-1.487-.471-2.091 1.016-.586 2.135-.416 3.254.23l4.019 2.32 1.944-1.122-4.432-2.558c-2.076-1.198-4.387-1.19-6.169-.161Zm15.867-.083c1.045-.603 1.428-1.334 1.281-2.031l.913.527 1.958-1.131-7.45-4.3-1.958 1.13.898.519c-1.207-.085-2.459.144-3.504.748-2.061 1.189-2.017 3.085.25 4.394 2.253 1.3 5.551 1.334 7.612.144Zm-1.399-1.198c-1.222.705-3.003.68-4.299-.068-1.281-.74-1.31-1.76-.088-2.465 1.178-.68 3.018-.705 4.299.034 1.295.748 1.266 1.819.088 2.499Zm2.334-11.989 4.196 2.422c-1.207-.085-2.458.145-3.504.748-2.061 1.19-2.017 3.086.25 4.395 2.253 1.3 5.551 1.334 7.612.144 1.045-.603 1.428-1.334 1.281-2.031l.913.527 1.958-1.13-10.748-6.205-1.958 1.13Zm7.155 6.51c-1.222.706-3.003.68-4.299-.067-1.28-.74-1.31-1.76-.088-2.465 1.178-.68 3.018-.706 4.299.034 1.296.748 1.266 1.819.088 2.499Z"
          fill="#000"
        />
        <g clipPath="url(#clip1)">
          <path
            d="m53.16 72.579-4.95 10.666 13.524 7.808 18.476-2.858 4.95-10.666-13.525-7.808-18.475 2.858Zm20.091 5.573-1.317 2.842-5.823.992 4.31 2.488-1.297 3.344-9.01-5.202L61.205 80l5.958-1.065-4.4-2.54 1.494-3.445 8.994 5.203Z"
            fill="#00CA8E"
          />
        </g>
      </g>
      <g className="plugin pluginAzure">
        <path
          opacity=".2"
          d="m317.104 479.471 39.436-.266 119.054-67.485a1.885 1.885 0 0 0 .948-1.632 1.88 1.88 0 0 0-.948-1.631l-38.624-22.642.147 24.08-120.013 69.576Z"
          fill="#A7CDD1"
        />
        <path
          d="m315.131 313.642-130.149 75.13a2.104 2.104 0 0 0 0 3.623l130.149 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.1 2.1 0 0 0 1.046-1.812 2.088 2.088 0 0 0-1.046-1.811l-130.135-75.13a4.183 4.183 0 0 0-4.182 0Z"
          fill="url(#paint12_linear)"
        />
        <path
          d="M450.515 390.584a2.058 2.058 0 0 1-1.053 1.811l-130.135 75.143a4.204 4.204 0 0 1-2.091.56v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.093 2.093 0 0 0 1.053-1.811v-11.148Z"
          fill="url(#paint13_linear)"
        />
        <path
          d="m315.133 467.538-130.149-75.143a2.07 2.07 0 0 1-1.039-1.811v11.148a2.11 2.11 0 0 0 1.039 1.811l130.149 75.13a4.17 4.17 0 0 0 2.091.559v-11.134a4.16 4.16 0 0 1-2.091-.56Z"
          fill="url(#paint14_linear)"
        />
        <path
          d="m313.923 433.812 2.106-1.216-14.267-3.663-2.62 1.513 6.36 8.227 2.091-1.207-1.384-1.784 4.637-2.678 3.077.808Zm-8.833.459-2.709-3.468 6.007 1.564-3.298 1.904Zm12.539-4.468-.663-4.921-1.236-.714-6.434 3.714 1.605.926 3.857-2.227.662 4.939 1.237.714 6.655-3.842-1.62-.935-4.063 2.346Zm4.938-9.583 3.666 2.117c1.325.765 1.487 1.657.382 2.295-1.074.62-2.326.493-3.459-.162l-3.976-2.295-1.943 1.122 4.343 2.508c2.003 1.156 4.299 1.343 6.257.212 1.075-.62 1.399-1.368 1.237-2.04l.942.544 1.944-1.122-7.45-4.3-1.943 1.121Zm6.907-2.712-1.104-.637-1.944 1.121 7.45 4.301 1.943-1.122-3.239-1.87c-2.002-1.156-1.87-2.082-.029-2.855l-1.826-1.054c-1.325.578-1.678 1.36-1.251 2.116Zm13.448-.199c1.958-1.131 2.017-2.491 1.472-3.298l-2.267.714c.265.493.118 1.071-.824 1.615-1.355.782-2.768.748-3.858.272l5.786-3.341a4.44 4.44 0 0 0-.647-.425c-2.135-1.232-5.227-1.402-7.671.009-2.341 1.351-2.194 3.238.029 4.522 2.356 1.36 5.595 1.309 7.98-.068Zm-6.699-1.403c-.751-.552-.809-1.436.324-2.091 1.163-.671 2.606-.654 3.607-.178l-3.931 2.269Z"
          fill="#000"
        />
        <path
          d="m283.934 421.5-3.409 1.967 7.275 4.2 1.414-.816-2.224-1.284 1.933-1.116c1.673-.966 1.288-2.243.062-2.951-1.206-.696-3.45-.924-5.051 0Zm3.679 2.243-1.891 1.092-2.495-1.44 1.954-1.127c.697-.402 1.788-.336 2.432.036.634.366.769.995 0 1.439Zm8.317-2.281-5.966-3.444-1.423.822 7.274 4.2 5.051-2.916-1.309-.756-3.627 2.094Zm4.311-9.376 4.271 2.466c1.071.618 1.268 1.391.125 2.051-1.133.654-2.474.54-3.544-.078l-4.271-2.465-1.445.834 4.292 2.477a6.272 6.272 0 0 0 6.277-.012c2.027-1.17 1.871-2.555.021-3.623l-4.292-2.478-1.434.828Zm14.4-4.582-3.71 2.142 1.226.708 2.235-1.29c.779.594.758 1.446-.468 2.154-1.632.942-3.7.792-5.009.036-1.31-.756-1.466-1.95-.042-2.772 1.123-.648 2.307-.744 3.419-.522l.946-.978c-1.673-.438-3.918-.306-5.716.732-2.161 1.248-2.182 3.144-.041 4.38 2.151 1.242 5.435 1.242 7.669-.048 2.183-1.26 2.276-2.934.219-4.122l-.728-.42Zm6.286 1.039 1.444-.834-7.274-4.199-1.445.833 7.275 4.2Zm1.544-9.291 4.718 2.724-8.377-.612-1.174.678 7.275 4.2 1.424-.822-4.729-2.73 8.387.618 1.174-.678-7.275-4.199-1.423.821Z"
          fill="#727274"
        />
        <path
          d="m230.738 384.707-12.521 7.229 12.521 7.228 12.521-7.228-12.521-7.229Z"
          fill="#F25022"
        />
        <path
          d="m244.562 376.727-12.521 7.228 12.521 7.229 12.521-7.229-12.521-7.228Z"
          fill="#7FBA00"
        />
        <path
          d="m244.562 392.688-12.521 7.228 12.521 7.229 12.521-7.229-12.521-7.228Z"
          fill="#00A4EF"
        />
        <path
          d="m258.386 384.707-12.521 7.229 12.521 7.228 12.521-7.228-12.521-7.229Z"
          fill="#FFB900"
        />
      </g>
      <g className="plugin pluginDocker">
        <path
          opacity=".2"
          d="m500.25 375.041 39.436-.267 119.054-67.485a1.87 1.87 0 0 0 .948-1.631 1.874 1.874 0 0 0-.948-1.632l-38.623-22.641.146 24.08-120.013 69.576Z"
          fill="#A7CDD1"
        />
        <path
          d="m498.277 209.212-130.148 75.129a2.099 2.099 0 0 0-1.033 1.812 2.103 2.103 0 0 0 1.033 1.811l130.148 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.09 2.09 0 0 0 0-3.623l-130.135-75.129a4.181 4.181 0 0 0-4.182 0Z"
          fill="url(#paint15_linear)"
        />
        <path
          d="M633.661 286.153a2.045 2.045 0 0 1-1.052 1.812l-130.135 75.143a4.213 4.213 0 0 1-2.091.559v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.087 2.087 0 0 0 1.052-1.811v-11.148Z"
          fill="url(#paint16_linear)"
        />
        <path
          d="m498.279 363.108-130.148-75.143a2.065 2.065 0 0 1-1.039-1.812v11.148a2.103 2.103 0 0 0 1.039 1.811l130.148 75.13c.636.367 1.357.56 2.091.559v-11.134a4.172 4.172 0 0 1-2.091-.559Z"
          fill="url(#paint17_linear)"
        />
        <path
          d="m483.716 325.191-4.475 2.584 10.306 5.949 4.475-2.584c3.033-1.75 2.753-4.105-.221-5.822-3.032-1.751-7.081-1.861-10.085-.127Zm8.437 4.921-2.43 1.402-6.669-3.85 2.429-1.402c1.767-1.02 4.284-.927 6.243.204 1.987 1.147 2.193 2.626.427 3.646Zm12.031-4.6c2.297-1.326 2.268-3.281.045-4.564-2.238-1.292-5.61-1.301-7.906.025-2.297 1.326-2.297 3.281-.059 4.573 2.223 1.283 5.624 1.292 7.92-.034Zm-1.766-1.02c-1.252.722-3.018.671-4.255-.043-1.237-.714-1.325-1.734-.074-2.456 1.237-.714 3.018-.671 4.255.043 1.237.713 1.31 1.742.074 2.456Zm10.723-4.151c2.047-1.181 2.032-2.669 1.193-3.493l-2.312.756c.457.451.339 1.182-.633 1.743-1.237.714-3.077.569-4.24-.102-1.178-.68-1.399-1.726-.162-2.44.972-.561 2.282-.603 3.062-.34l1.296-1.343c-1.413-.475-4.019-.501-6.081.689-2.267 1.309-2.252 3.255-.029 4.539 2.238 1.292 5.624 1.309 7.906-.009Zm9.735-5.858 2.208-1.275-7.391-.629-.353-3.501-2.267 1.309.397 3.323-6.375-3.68-1.943 1.122 10.747 6.204 1.944-1.122-1.899-1.096-.104-1.063 5.036.408Zm6.586-3.564c1.958-1.13 2.017-2.49 1.472-3.298l-2.267.714c.265.493.118 1.071-.825 1.615-1.354.782-2.768.748-3.857.272l5.786-3.34c-.191-.162-.412-.289-.648-.425-2.135-1.232-5.226-1.402-7.67.008-2.341 1.352-2.194 3.239.029 4.522 2.356 1.36 5.595 1.309 7.98-.068Zm-6.699-1.402c-.751-.553-.81-1.437.324-2.091 1.163-.672 2.606-.655 3.607-.179l-3.931 2.27Zm7.254-6.483-1.104-.637-1.943 1.121 7.449 4.301 1.944-1.122-3.239-1.87c-2.003-1.156-1.87-2.082-.03-2.855l-1.825-1.054c-1.325.578-1.679 1.36-1.252 2.116Z"
          fill="#000"
        />
        <path
          d="m464.934 317.5-3.409 1.967 7.275 4.2 1.414-.816-2.224-1.284 1.933-1.116c1.673-.966 1.288-2.243.062-2.951-1.206-.696-3.45-.924-5.051 0Zm3.679 2.243-1.891 1.092-2.495-1.44 1.954-1.127c.697-.402 1.788-.336 2.432.036.634.366.769.995 0 1.439Zm8.317-2.281-5.966-3.444-1.423.822 7.274 4.2 5.051-2.916-1.309-.756-3.627 2.094Zm4.311-9.376 4.271 2.466c1.071.618 1.268 1.391.125 2.051-1.133.654-2.474.54-3.544-.078l-4.271-2.465-1.445.834 4.292 2.477a6.272 6.272 0 0 0 6.277-.012c2.027-1.17 1.871-2.555.021-3.623l-4.292-2.478-1.434.828Zm14.4-4.582-3.71 2.142 1.226.708 2.235-1.29c.779.594.758 1.446-.468 2.154-1.632.942-3.7.792-5.009.036-1.31-.756-1.466-1.95-.042-2.772 1.123-.648 2.307-.744 3.419-.522l.946-.978c-1.673-.438-3.918-.306-5.716.732-2.161 1.248-2.182 3.144-.041 4.38 2.151 1.242 5.435 1.242 7.669-.048 2.183-1.26 2.276-2.934.219-4.122l-.728-.42Zm6.286 1.039 1.444-.834-7.274-4.199-1.445.833 7.275 4.2Zm1.544-9.291 4.718 2.724-8.377-.612-1.174.678 7.275 4.2 1.424-.822-4.729-2.73 8.387.618 1.174-.678-7.275-4.199-1.423.821Z"
          fill="#727274"
        />
        <path
          d="M443.191 272.233c-.176.012-1.784.142-3.716 1.257-.508.296-.974.615-1.392.955-2.937-1.264-6.306-.762-6.457-.74l-.818.127.151.481c.234.629.651 1.23 1.234 1.778 1.117 1.044 2.702 1.716 4.62 1.966-.397.806-1.714 1.709-1.994 1.883l-23.839 13.763c-.622.359-.624.942-.005 1.303 2.061 1.222 4.49 2.216 7.17 2.934 2.975.769 5.783.979 8.343.622 2.872-.398 6.389-1.709 9.669-3.603a27.51 27.51 0 0 0 4.018-2.781c1.653-1.384 2.894-2.918 3.671-4.538.621-1.346.862-2.741.714-4.131-.25-2.325-1.506-4.349-2.785-6.053l.333-.193c2.068-1.194 2.512-2.406 2.52-3.211.024-.524-.151-1.045-.512-1.526l-.286-.336-.639.043Z"
          fill="#2496ED"
        />
        <path
          d="m412.516 292.035 3.194-1.844c.155-.089.154-.233 0-.322l-2.845-1.643a.62.62 0 0 0-.558-.002l-.001.001-3.195 1.844c-.154.089-.154.234 0 .322l.002.001 2.845 1.643a.616.616 0 0 0 .558 0Z"
          fill="#2496ED"
        />
        <path
          d="m416.92 289.493 3.194-1.844c.154-.089.154-.233 0-.322l-2.845-1.643a.62.62 0 0 0-.558-.002l-.002.001-3.194 1.845c-.155.089-.155.234 0 .323l2.845 1.643a.62.62 0 0 0 .56-.001Z"
          fill="#2496ED"
        />
        <path
          d="m421.369 286.924 3.195-1.844c.154-.089.154-.234 0-.322l-2.846-1.643a.614.614 0 0 0-.557-.002l-.002.001-3.195 1.844c-.154.089-.154.233 0 .322l.002.001 2.845 1.643a.616.616 0 0 0 .558 0Z"
          fill="#2496ED"
        />
        <path
          d="m425.772 284.383 3.194-1.844c.155-.09.155-.234.002-.323l-2.846-1.643a.617.617 0 0 0-.561 0l-3.194 1.844c-.154.089-.154.233 0 .322l.001.001 2.846 1.643a.616.616 0 0 0 .558 0Z"
          fill="#2496ED"
        />
        <path
          d="m412.814 287.123 3.195-1.844c.153-.09.153-.234-.002-.323l-2.845-1.643a.616.616 0 0 0-.558 0l-3.195 1.844c-.154.089-.155.234-.001.323l2.845 1.643a.623.623 0 0 0 .561 0Z"
          fill="#2496ED"
        />
        <path
          d="m417.264 284.555 3.194-1.845c.154-.089.153-.233-.001-.323l-2.846-1.642a.614.614 0 0 0-.557 0l-3.195 1.844c-.154.089-.154.233 0 .322l2.845 1.643a.624.624 0 0 0 .56.001Z"
          fill="#2496ED"
        />
        <path
          d="m421.666 282.013 3.195-1.845c.153-.089.153-.234 0-.323l-2.846-1.643a.619.619 0 0 0-.559.001l-3.195 1.844c-.154.089-.154.233 0 .322l2.846 1.643a.622.622 0 0 0 .559.001Z"
          fill="#2496ED"
        />
        <path
          d="m417.561 279.643 3.194-1.845c.155-.089.155-.233.002-.323l-2.847-1.643a.62.62 0 0 0-.56.001l-3.194 1.844c-.154.089-.154.233 0 .322l2.847 1.644a.623.623 0 0 0 .558 0Z"
          fill="#2496ED"
        />
        <path
          d="m430.272 281.784 3.194-1.844c.155-.089.155-.233.002-.323l-2.846-1.643a.623.623 0 0 0-.561 0l-3.194 1.844c-.154.089-.154.234 0 .323h.001l2.846 1.643a.616.616 0 0 0 .558 0Z"
          fill="#2496ED"
        />
      </g>
      <g className="plugin pluginLambda">
        <path
          opacity=".15"
          d="m501.25 167.041 39.436-.267L659.74 99.289a1.875 1.875 0 0 0 .694-2.575 1.874 1.874 0 0 0-.694-.688l-38.623-22.641.146 24.08L501.25 167.04Z"
          fill="#A7CDD1"
        />
        <path
          d="m499.277 1.212-130.148 75.13a2.103 2.103 0 0 0 0 3.622l130.148 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.088 2.088 0 0 0 0-3.623L503.459 1.211a4.18 4.18 0 0 0-4.182 0Z"
          fill="url(#paint18_linear)"
        />
        <path
          d="M634.661 78.153a2.048 2.048 0 0 1-1.052 1.812l-130.135 75.143a4.213 4.213 0 0 1-2.091.559v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.094 2.094 0 0 0 1.052-1.811V78.153Z"
          fill="url(#paint19_linear)"
        />
        <path
          d="M499.279 155.108 369.131 79.965a2.065 2.065 0 0 1-1.039-1.812v11.148a2.1 2.1 0 0 0 1.039 1.811l130.148 75.13c.636.367 1.357.56 2.091.559v-11.134a4.172 4.172 0 0 1-2.091-.559Z"
          fill="url(#paint20_linear)"
        />
        <path
          d="m490.709 123.489-8.451-4.879-2.017 1.165 10.306 5.949 7.155-4.13-1.855-1.071-5.138 2.966Zm11.55-4.288c1.045-.604 1.428-1.334 1.28-2.031l.913.527 1.958-1.131-7.449-4.301-1.958 1.131.898.518c-1.208-.085-2.459.145-3.504.748-2.062 1.19-2.017 3.086.25 4.394 2.252 1.301 5.55 1.335 7.612.145Zm-1.399-1.198c-1.222.705-3.004.679-4.299-.068-1.281-.74-1.31-1.76-.089-2.465 1.178-.68 3.019-.706 4.3.034 1.295.748 1.266 1.819.088 2.499Zm8.709-12.1c-1.193.689-1.531 1.462-1.399 2.1-1.163-.145-2.311.042-3.357.646-.986.569-1.266 1.258-1.119 1.903l-.883-.509-1.943 1.121 7.449 4.301 1.944-1.122-3.74-2.159c-1.31-.756-1.546-1.538-.5-2.141 1.001-.578 2.12-.391 3.224.246l4.019 2.32 1.958-1.13-3.798-2.193c-1.266-.731-1.517-1.487-.471-2.091 1.016-.586 2.135-.416 3.254.23l4.019 2.32 1.943-1.122-4.431-2.558c-2.076-1.199-4.388-1.19-6.169-.162Zm9.138-5.275c-1.06.612-1.443 1.326-1.31 2.031l-4.196-2.422-1.944 1.122 10.748 6.204 1.943-1.122-.912-.527c1.222.077 2.473-.136 3.533-.748 2.061-1.189 1.988-3.085-.265-4.385-2.267-1.31-5.536-1.343-7.597-.153Zm5.786 3.731c-1.178.68-3.033.697-4.328-.051-1.281-.739-1.237-1.802-.059-2.482 1.222-.705 2.988-.688 4.269.051 1.296.748 1.34 1.777.118 2.482Zm1.878-11.725 4.196 2.422c-1.208-.085-2.459.145-3.504.748-2.061 1.19-2.017 3.085.25 4.394 2.253 1.301 5.55 1.335 7.612.145 1.045-.604 1.428-1.335 1.281-2.032l.912.527 1.958-1.13-10.747-6.205-1.958 1.13Zm7.155 6.51c-1.222.706-3.003.68-4.299-.068-1.281-.74-1.31-1.759-.088-2.464 1.177-.68 3.018-.706 4.299.034 1.295.748 1.266 1.818.088 2.498Zm10.888-4.28c1.045-.603 1.428-1.334 1.281-2.03l.913.526 1.958-1.13-7.45-4.3-1.958 1.13.898.518c-1.207-.085-2.459.144-3.504.748-2.061 1.19-2.017 3.085.25 4.394 2.253 1.3 5.551 1.335 7.612.145Zm-1.399-1.198c-1.222.706-3.003.68-4.299-.068-1.281-.74-1.31-1.76-.088-2.465 1.178-.68 3.018-.705 4.299.034 1.296.748 1.266 1.82.088 2.5Z"
          fill="#000"
        />
        <path
          d="m466.934 107.5-3.409 1.967 7.275 4.2 1.414-.816-2.224-1.284 1.933-1.116c1.673-.966 1.288-2.243.062-2.951-1.206-.696-3.45-.924-5.051 0Zm3.679 2.243-1.891 1.092-2.495-1.44 1.954-1.127c.697-.402 1.788-.336 2.432.036.634.366.769.995 0 1.439Zm8.317-2.281-5.966-3.444-1.423.822 7.274 4.2 5.051-2.916-1.309-.756-3.627 2.094Zm4.311-9.376 4.271 2.466c1.071.618 1.268 1.391.125 2.051-1.133.654-2.474.54-3.544-.078l-4.271-2.465-1.445.834 4.292 2.477a6.272 6.272 0 0 0 6.277-.012c2.027-1.17 1.871-2.555.021-3.623l-4.292-2.478-1.434.828Zm14.4-4.582-3.71 2.142 1.226.708 2.235-1.29c.779.594.758 1.446-.468 2.154-1.632.942-3.7.792-5.009.036-1.31-.756-1.466-1.95-.042-2.772 1.123-.648 2.307-.744 3.419-.522l.946-.978c-1.673-.438-3.918-.306-5.716.732-2.161 1.248-2.182 3.144-.041 4.38 2.151 1.242 5.435 1.242 7.669-.048 2.183-1.26 2.276-2.934.219-4.122l-.728-.42Zm6.286 1.04 1.444-.835-7.274-4.2-1.445.835 7.275 4.2Zm1.544-9.291 4.718 2.723-8.377-.612-1.174.678 7.275 4.2 1.424-.822-4.729-2.73 8.387.618 1.174-.678-7.275-4.2-1.423.822Z"
          fill="#727274"
        />
        <path
          d="M424.364 80.755c.413.24.793.407 1.117.504.335.091.714.182 1.16.26.145.02.257.058.335.103.112.065.157.168.125.316l-.23.675a.416.416 0 0 1-.188.225c-.111.064-.278.096-.49.102a8.3 8.3 0 0 1-.925-.073 19.278 19.278 0 0 1-1.004-.182c.162 1.094-.412 2.02-1.722 2.776a6.017 6.017 0 0 1-3.027.817c-1.08.005-2.074-.248-2.968-.765-.951-.548-1.389-1.186-1.293-1.913.096-.726.705-1.414 1.849-2.074.378-.218.8-.423 1.267-.628.466-.205.978-.397 1.523-.595l-.817-.471c-.849-.491-1.62-.73-2.31-.732-.702.005-1.47.255-2.325.748a5.514 5.514 0 0 0-1.054.777c-.31.295-.587.597-.819.912-.1.147-.188.25-.244.308a.65.65 0 0 1-.144.122c-.155.09-.345.07-.58-.066l-.547-.316c-.179-.103-.291-.194-.314-.27-.023-.078-.001-.18.076-.316.188-.34.486-.706.896-1.098.399-.398.909-.77 1.52-1.123 1.322-.763 2.59-1.146 3.816-1.157 1.214-.004 2.442.346 3.672 1.056l3.623 2.091.022-.013Zm-2.81 3.585c.367-.212.677-.469.943-.777.266-.308.375-.656.339-1.022a1.075 1.075 0 0 0-.338-.631 4.448 4.448 0 0 0-.861-.626l-.47-.271c-.4.14-.812.3-1.212.48-.4.18-.766.365-1.111.564-.744.43-1.143.828-1.207 1.213-.065.386.182.734.741 1.057.526.303 1.051.452 1.597.447.546.007 1.069-.14 1.579-.434Zm10.126-4.452c-.2.116-.367.173-.534.18-.156.012-.39-.034-.669-.118l-11.253-3.483c-.29-.09-.469-.155-.547-.2-.179-.103-.191-.213-.013-.315l1.088-.629c.211-.121.389-.185.545-.185.156-.013.379.04.658.123l9.268 3.196-5.67-5.273c-.168-.161-.246-.283-.225-.373.022-.09.133-.206.333-.321l.888-.513c.211-.122.389-.186.556-.192.156-.013.39.033.647.13l9.246 3.311-5.57-5.433c-.157-.168-.224-.297-.214-.38.022-.09.122-.2.322-.315l1.033-.596a.527.527 0 0 1 .557 0c.056.033.1.072.156.117.056.045.124.11.202.206l5.967 6.535c.157.168.224.296.202.386-.021.09-.121.2-.31.308l-.955.552c-.211.122-.389.186-.556.192a1.719 1.719 0 0 1-.658-.137l-8.933-3.17 5.49 5.145c.168.161.247.284.236.38-.01.096-.132.206-.332.321l-.955.551Zm14.572-8.064a11.45 11.45 0 0 1-1.911.871c-.69.243-1.268.41-1.725.48-.278.044-.512.05-.657.017a1.392 1.392 0 0 1-.38-.142l-.57-.33c-.235-.135-.258-.25-.091-.347.067-.038.144-.07.233-.096.089-.025.234-.057.39-.095.545-.122 1.09-.281 1.613-.48a10.202 10.202 0 0 0 1.456-.685c.699-.404 1.12-.79 1.252-1.15.132-.36-.026-.681-.485-.946a2.193 2.193 0 0 0-1.082-.279c-.413-.007-.98.101-1.703.312l-2.114.64c-1.068.32-2.047.446-2.917.367-.859-.073-1.595-.28-2.177-.615-.469-.272-.783-.568-.941-.89a1.401 1.401 0 0 1-.117-.991c.076-.34.263-.669.574-1.002.31-.334.72-.636 1.209-.918.244-.141.511-.282.789-.404.289-.128.566-.237.844-.345.278-.096.545-.186.812-.263a5.16 5.16 0 0 1 .668-.153 2.32 2.32 0 0 1 .613-.03c.156.013.312.064.469.155l.525.303c.235.136.269.258.103.354-.089.051-.278.109-.557.166a8.775 8.775 0 0 0-2.568.98c-.633.365-1.032.711-1.164 1.033-.132.321.015.611.473.876.313.18.693.271 1.127.266.435-.006 1.058-.12 1.837-.35l2.08-.62c1.057-.314 1.992-.44 2.795-.375.802.066 1.494.273 2.076.61.481.277.817.586 1.008.915.18.335.249.682.173 1.036-.064.36-.274.713-.606 1.073-.344.379-.787.725-1.354 1.052Z"
          fill="#252F3E"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M453.786 73.749c-.937 3.678-4.803 7.575-9.367 10.21-6.397 3.693-14.543 5.646-22.854 5.874-.657.018-.771-.407-.114-.502 7.459-1.13 14.933-3.522 20.941-6.99 4.054-2.34 7.657-5.402 10.011-8.775.331-.514 1.535-.421 1.383.183Z"
          fill="#F90"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M453.562 71.864c-1.07-.08-3.378 1.614-4.421 2.384-.31.231-.679.083-.592-.239.612-2.057 4.469-3.793 5.36-3.74.903.06 3.847 2.35 3.548 4.433-.043.322-.466.41-.668.14-.663-.895-2.168-2.905-3.227-2.978Z"
          fill="#F90"
        />
      </g>
      <g className="plugin pluginEcs">
        <path
          opacity=".2"
          d="m501.25 588.632 39.436-.266 119.054-67.485a1.87 1.87 0 0 0 .948-1.631 1.874 1.874 0 0 0-.948-1.632l-38.623-22.641.146 24.079-120.013 69.576Z"
          fill="#A7CDD1"
        />
        <path
          d="m499.277 422.803-130.148 75.13a2.099 2.099 0 0 0-1.033 1.811 2.107 2.107 0 0 0 1.033 1.812l130.148 75.143a4.183 4.183 0 0 0 4.182 0l130.135-75.143a2.087 2.087 0 0 0 0-3.623l-130.135-75.13a4.18 4.18 0 0 0-4.182 0Z"
          fill="url(#paint21_linear)"
        />
        <path
          d="M634.661 499.745a2.047 2.047 0 0 1-1.052 1.811l-130.135 75.143a4.204 4.204 0 0 1-2.091.56v11.134a4.213 4.213 0 0 0 2.091-.559l130.135-75.13a2.095 2.095 0 0 0 1.052-1.811v-11.148Z"
          fill="url(#paint22_linear)"
        />
        <path
          d="m499.279 576.699-130.148-75.143a2.065 2.065 0 0 1-1.039-1.811v11.148a2.097 2.097 0 0 0 1.039 1.811l130.148 75.13c.636.367 1.357.56 2.091.559v-11.134a4.163 4.163 0 0 1-2.091-.56Z"
          fill="url(#paint23_linear)"
        />
        <path
          d="m489.663 538.035-1.825-1.054-7.597 4.385 10.306 5.95 7.582-4.377-1.826-1.054-5.609 3.238-2.532-1.462 4.873-2.813-1.767-1.02-4.873 2.813-2.356-1.36 5.624-3.246Zm15.081 1.323c2.724-1.573 2.797-3.536 1.62-4.76l-2.459.842c.677.781.471 1.937-1.09 2.838-2.031 1.173-4.961.978-6.816-.093-1.855-1.071-2.135-2.728-.103-3.901 1.56-.901 3.592-1.003 4.932-.621l1.487-1.419c-2.105-.672-5.551-.655-8.333.952-3.063 1.768-3.063 4.436-.03 6.187 3.048 1.76 7.686 1.768 10.792-.025Zm10.492-6.057c2.473-1.428 2.694-3.204.927-4.224-1.678-.969-3.533-.663-5.594-.034l-3.386 1.003c-.884.272-1.502.272-1.959.008-.603-.348-.471-1.02.545-1.606 1.163-.672 2.694-.893 3.961-.655l1.325-1.394c-1.988-.501-4.859-.255-7.082 1.029-2.149 1.241-2.356 2.924-.736 3.842 1.31.773 3.165.705 4.947.169l3.46-1.045c1.31-.382 2.046-.382 2.591-.068.677.391.545 1.181-.663 1.878-1.487.859-3.386.969-4.873.587l-1.34 1.453c2.179.595 5.359.51 7.877-.943Z"
          fill="#000"
        />
        <path
          d="m468.934 531.5-3.409 1.967 7.275 4.2 1.414-.816-2.224-1.284 1.933-1.116c1.673-.966 1.288-2.243.062-2.951-1.206-.696-3.45-.924-5.051 0Zm3.679 2.243-1.891 1.092-2.495-1.44 1.954-1.127c.697-.402 1.788-.336 2.432.036.634.366.769.995 0 1.439Zm8.317-2.281-5.966-3.444-1.423.822 7.274 4.2 5.051-2.916-1.309-.756-3.627 2.094Zm4.311-9.376 4.271 2.466c1.071.618 1.268 1.391.125 2.051-1.133.654-2.474.54-3.544-.078l-4.271-2.465-1.445.834 4.292 2.477a6.272 6.272 0 0 0 6.277-.012c2.027-1.17 1.871-2.555.021-3.623l-4.292-2.478-1.434.828Zm14.4-4.582-3.71 2.142 1.226.708 2.235-1.29c.779.594.758 1.446-.468 2.154-1.632.942-3.7.792-5.009.036-1.31-.756-1.466-1.95-.042-2.772 1.123-.648 2.307-.744 3.419-.522l.946-.978c-1.673-.438-3.918-.306-5.716.732-2.161 1.248-2.182 3.144-.041 4.38 2.151 1.242 5.435 1.242 7.669-.048 2.183-1.26 2.276-2.934.219-4.122l-.728-.42Zm6.286 1.039 1.444-.834-7.274-4.199-1.445.833 7.275 4.2Zm1.544-9.291 4.718 2.724-8.377-.612-1.174.678 7.275 4.2 1.424-.822-4.729-2.73 8.387.618 1.174-.678-7.275-4.199-1.423.821Z"
          fill="#727274"
        />
        <path
          d="M424.364 502.346a5.37 5.37 0 0 0 1.117.504c.335.091.714.182 1.16.26a.914.914 0 0 1 .335.103c.112.065.157.168.125.316l-.23.675a.42.42 0 0 1-.188.225c-.111.064-.278.096-.49.102a8.568 8.568 0 0 1-.925-.073 19.482 19.482 0 0 1-1.004-.182c.162 1.094-.412 2.019-1.722 2.776a6.017 6.017 0 0 1-3.027.817c-1.08.004-2.074-.248-2.968-.765-.951-.548-1.389-1.186-1.293-1.913.096-.727.705-1.414 1.849-2.074.378-.218.8-.423 1.267-.628.466-.205.978-.397 1.523-.595l-.817-.472c-.849-.49-1.62-.73-2.31-.731-.702.005-1.47.254-2.325.748a5.509 5.509 0 0 0-1.054.776c-.31.296-.587.598-.819.912-.1.148-.188.251-.244.309a.686.686 0 0 1-.144.122c-.155.089-.345.07-.58-.066l-.547-.316c-.179-.103-.291-.194-.314-.271-.023-.077-.001-.18.076-.315.188-.341.486-.707.896-1.098.399-.398.909-.771 1.52-1.123 1.322-.763 2.59-1.147 3.816-1.157 1.214-.004 2.442.346 3.672 1.056l3.623 2.091.022-.013Zm-2.81 3.584a3.6 3.6 0 0 0 .943-.776c.266-.308.375-.656.339-1.022a1.072 1.072 0 0 0-.338-.631 4.402 4.402 0 0 0-.861-.626l-.47-.271c-.4.14-.812.3-1.212.48-.4.179-.766.365-1.111.564-.744.429-1.143.827-1.207 1.213-.065.386.182.734.741 1.057.526.303 1.051.452 1.597.447.546.007 1.069-.14 1.579-.435Zm10.126-4.451c-.2.116-.367.173-.534.179-.156.013-.39-.033-.669-.117l-11.253-3.483c-.29-.09-.469-.155-.547-.2-.179-.104-.191-.213-.013-.315l1.088-.629c.211-.122.389-.186.545-.185.156-.013.379.039.658.123l9.268 3.196-5.67-5.273c-.168-.161-.246-.284-.225-.374.022-.09.133-.205.333-.321l.888-.512c.211-.122.389-.186.556-.192.156-.013.39.033.647.13l9.246 3.311-5.57-5.434c-.157-.167-.224-.296-.214-.38.022-.09.122-.199.322-.314l1.033-.596a.525.525 0 0 1 .557.001c.056.032.1.071.156.116.056.045.124.109.202.206l5.967 6.535c.157.167.224.296.202.386-.021.09-.121.199-.31.308l-.955.552c-.211.121-.389.185-.556.192a1.714 1.714 0 0 1-.658-.137l-8.933-3.169 5.49 5.144c.168.161.247.283.236.38-.01.096-.132.205-.332.321l-.955.551Zm14.572-8.064c-.577.333-1.222.628-1.911.871-.69.243-1.268.409-1.725.479-.278.045-.512.051-.657.018a1.382 1.382 0 0 1-.38-.142l-.57-.329c-.235-.136-.258-.252-.091-.348.067-.038.144-.07.233-.096.089-.025.234-.057.39-.096.545-.121 1.09-.28 1.613-.479a10.278 10.278 0 0 0 1.456-.685c.699-.404 1.12-.789 1.252-1.149.132-.36-.026-.682-.485-.947a2.188 2.188 0 0 0-1.082-.279c-.413-.007-.98.101-1.703.312l-2.114.639c-1.068.32-2.047.447-2.917.368-.859-.073-1.595-.28-2.177-.616-.469-.271-.783-.567-.941-.889a1.402 1.402 0 0 1-.117-.991c.076-.341.263-.669.574-1.003.31-.333.72-.635 1.209-.917.244-.141.511-.282.789-.404.289-.128.566-.237.844-.346.278-.096.545-.185.812-.262.267-.076.49-.127.668-.153.245-.038.445-.05.613-.031.156.013.312.065.469.155l.525.304c.235.135.269.258.103.354-.089.051-.278.109-.557.166a8.788 8.788 0 0 0-2.568.979c-.633.366-1.032.712-1.164 1.034-.132.321.015.611.473.876.313.18.693.271 1.127.265.435-.005 1.058-.12 1.837-.35l2.08-.62c1.057-.313 1.992-.44 2.795-.374.802.066 1.494.273 2.076.609.481.278.817.587 1.008.915.18.335.249.683.173 1.036-.064.361-.274.714-.606 1.074-.344.378-.787.725-1.354 1.052Z"
          fill="#252F3E"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M453.786 495.34c-.937 3.678-4.803 7.575-9.367 10.21-6.397 3.693-14.543 5.645-22.854 5.874-.657.018-.771-.407-.114-.502 7.459-1.131 14.933-3.522 20.941-6.991 4.054-2.34 7.657-5.401 10.011-8.774.331-.514 1.535-.422 1.383.183Z"
          fill="#F90"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="M453.562 493.455c-1.07-.08-3.378 1.614-4.421 2.384-.31.231-.679.082-.592-.239.612-2.057 4.469-3.793 5.36-3.74.903.06 3.847 2.349 3.548 4.433-.043.321-.466.411-.668.14-.663-.895-2.168-2.905-3.227-2.978Z"
          fill="#F90"
        />
      </g>
      <g className="yourPlugin">
        <path
          className="yourPluginShadow"
          d="M136.411 471.818 17.933 540.207a.99.99 0 0 0-.486.848.983.983 0 0 0 .486.847l121.044 69.815a2.561 2.561 0 0 0 2.552 0l121.045-69.815a.98.98 0 0 0 0-1.695l-118.478-68.389a7.702 7.702 0 0 0-7.685 0Z"
          fill="#C9F0F2"
        />
        <path
          strokeDasharray="3"
          d="M5.5 492.431v9.942l132 76.058"
          stroke="#62D4DC"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          strokeDasharray="3"
          d="M270.5 492.431v10.5l-132.5 76v-10"
          stroke="#62D4DC"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          strokeDasharray="3"
          d="M136.164 415.424a3.664 3.664 0 0 1 3.672 0l.251-.433-.251.433 129.869 75.122.251-.433-.25.433a1.587 1.587 0 0 1 .581 2.174c-.139.242-.34.443-.581.582h-.001l-129.869 75.136a3.664 3.664 0 0 1-3.672 0L6.286 493.305l-.002-.001a1.601 1.601 0 0 1-.784-1.38 1.606 1.606 0 0 1 .784-1.38l.002-.001 129.878-75.119Z"
          fill="#D7F8FA"
          fillOpacity=".3"
          stroke="#62D4DC"
        />
        <path
          d="m109.757 516.487 2.496 5.401-9.374-1.43-2.953 1.705 13.509 1.947 4.896 2.827 2.649-1.529-4.897-2.827-3.391-7.787-2.935 1.693Zm20.523 3.86c2.972-1.716 2.934-4.246.057-5.907-2.896-1.672-7.259-1.683-10.231.033-2.973 1.716-2.973 4.246-.077 5.918 2.877 1.661 7.279 1.672 10.251-.044Zm-2.287-1.32c-1.619.935-3.905.869-5.506-.055-1.6-.924-1.715-2.244-.095-3.179 1.6-.924 3.906-.869 5.506.055 1.601.924 1.696 2.255.095 3.179Zm6.237-12.4 4.745 2.739c1.714.99 1.924 2.144.495 2.969-1.391.803-3.01.638-4.477-.209l-5.145-2.969-2.515 1.452 5.621 3.244c2.591 1.496 5.563 1.738 8.097.275 1.391-.803 1.81-1.771 1.601-2.639l1.219.703 2.515-1.451-9.641-5.566-2.515 1.452Zm8.939-3.51-1.429-.825-2.515 1.451 9.641 5.566 2.515-1.452-4.192-2.42c-2.591-1.496-2.42-2.694-.038-3.695l-2.362-1.364c-1.715.748-2.173 1.76-1.62 2.739Zm-15.046 26.767-6.25 3.607 13.337 7.7 2.592-1.496-4.078-2.354 3.544-2.046c3.068-1.771 2.363-4.114.114-5.411-2.21-1.276-6.325-1.694-9.259 0Zm6.744 4.113-3.467 2.002-4.573-2.64 3.582-2.068c1.277-.737 3.277-.616 4.458.066 1.163.671 1.41 1.826 0 2.64Zm12.847-.024 2.515-1.452-13.909-8.03-2.515 1.452 13.909 8.03Zm2.148-12.372 4.744 2.739c1.715.99 1.924 2.145.495 2.97-1.391.803-3.01.638-4.477-.209l-5.145-2.97-2.515 1.452 5.621 3.245c2.591 1.496 5.564 1.738 8.098.275 1.39-.803 1.81-1.771 1.6-2.64l1.219.704 2.515-1.452-9.64-5.565-2.515 1.451Zm12.215-7.052 1.124.649c-1.619-.099-3.162.22-4.439.957-2.763 1.595-2.763 3.905.133 5.577 2.744 1.584 6.898 1.672 9.66.077 1.277-.737 1.829-1.628 1.658-2.563l1.162.671c1.41.836 1.715 1.936.133 2.849-1.219.704-2.476.902-3.753.737l-1.41 1.716c2.248.374 4.82.143 7.183-1.221 3.01-1.738 3.049-3.982.362-5.533l-9.298-5.368-2.515 1.452Zm4.649 5.698c-1.6.924-3.772.946-5.335.044-1.562-.902-1.524-2.156.077-3.08 1.543-.891 3.753-.913 5.296-.022 1.563.902 1.505 2.167-.038 3.058Zm.26-10.093c.838-.484.857-1.243.019-1.727-.8-.462-2.115-.451-2.953.033-.839.484-.858 1.243-.058 1.705.839.484 2.153.473 2.992-.011Zm9.698 7.094 2.534-1.463-9.641-5.565-2.534 1.463 9.641 5.565Zm.756-11.875c-1.391.803-1.81 1.771-1.62 2.651l-1.219-.704-2.515 1.451 9.64 5.566 2.515-1.452-4.763-2.75c-1.695-.979-1.886-2.144-.476-2.958 1.391-.803 2.991-.649 4.458.198l5.164 2.98 2.515-1.452-5.64-3.255c-2.572-1.485-5.544-1.727-8.059-.275Z"
          fill="#62D4DC"
        />
        <path
          fillRule="evenodd"
          clipRule="evenodd"
          d="m55.844 481.046 18.28-3.518c1.55-.3 3.26-.069 4.417.598l14.517 8.381c1.155.667 1.556 1.655 1.035 2.55L88 499.609c-.428.744-1.439 1.327-2.726 1.575l-18.28 3.517c-1.555.296-3.267.058-4.417-.616l-14.501-8.371c-1.156-.668-1.557-1.656-1.036-2.55l6.093-10.553c.43-.738 1.433-1.317 2.711-1.565Z"
          stroke="#62D4DC"
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="m46.918 494.482 22.118-4.256 7.372-12.768"
          stroke="#62D4DC"
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
        <path
          d="m86.949 500.568-17.914-10.341"
          stroke="#62D4DC"
          strokeWidth="2"
          strokeLinecap="round"
          strokeLinejoin="round"
        />
      </g>
      <defs>
        <linearGradient
          id="paint0_linear"
          x1="76111.5"
          y1="20544.8"
          x2="129458"
          y2="20544.8"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint1_linear"
          x1="51620.9"
          y1="14821.2"
          x2="64958.1"
          y2="14821.2"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint2_linear"
          x1="38150.4"
          y1="14821.2"
          x2="51487.6"
          y2="14821.2"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint3_linear"
          x1="75927.5"
          y1="20649.1"
          x2="129274"
          y2="20649.1"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint4_linear"
          x1="51436.9"
          y1="14925.5"
          x2="64774.1"
          y2="14925.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint5_linear"
          x1="37966.4"
          y1="14925.5"
          x2="51303.6"
          y2="14925.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint6_linear"
          x1="76489.8"
          y1="20971.8"
          x2="129836"
          y2="20971.8"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint7_linear"
          x1="51999.2"
          y1="15248.2"
          x2="65336.4"
          y2="15248.2"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint8_linear"
          x1="38528.8"
          y1="15248.2"
          x2="51865.9"
          y2="15248.2"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint9_linear"
          x1="75928.5"
          y1="20441.1"
          x2="129275"
          y2="20441.1"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint10_linear"
          x1="51437.9"
          y1="14717.5"
          x2="64775.1"
          y2="14717.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint11_linear"
          x1="37967.4"
          y1="14717.5"
          x2="51304.6"
          y2="14717.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint12_linear"
          x1="76109.3"
          y1="20753.5"
          x2="129456"
          y2="20753.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint13_linear"
          x1="51618.8"
          y1="15029.9"
          x2="64955.9"
          y2="15029.9"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint14_linear"
          x1="38148.3"
          y1="15029.9"
          x2="51485.5"
          y2="15029.9"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint15_linear"
          x1="76292.5"
          y1="20649.1"
          x2="129639"
          y2="20649.1"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint16_linear"
          x1="51801.9"
          y1="14925.5"
          x2="65139.1"
          y2="14925.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint17_linear"
          x1="38331.4"
          y1="14925.5"
          x2="51668.6"
          y2="14925.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint18_linear"
          x1="76293.5"
          y1="20441.1"
          x2="129640"
          y2="20441.1"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint19_linear"
          x1="51802.9"
          y1="14717.5"
          x2="65140.1"
          y2="14717.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint20_linear"
          x1="38332.4"
          y1="14717.5"
          x2="51669.6"
          y2="14717.5"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <linearGradient
          id="paint21_linear"
          x1="76293.5"
          y1="20862.6"
          x2="129640"
          y2="20862.6"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#FAFAFA" />
          <stop offset=".68" stopColor="#FAFAFA" />
          <stop offset="1" stopColor="#EFEFF0" />
        </linearGradient>
        <linearGradient
          id="paint22_linear"
          x1="51802.9"
          y1="15139.1"
          x2="65140.1"
          y2="15139.1"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#C0C0C2" />
          <stop offset="1" stopColor="#DBDBDC" />
        </linearGradient>
        <linearGradient
          id="paint23_linear"
          x1="38332.4"
          y1="15139.1"
          x2="51669.6"
          y2="15139.1"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset=".01" stopColor="#EFEFF0" />
          <stop offset=".48" stopColor="#E7E7E8" />
          <stop offset="1" stopColor="#D8D8D9" />
        </linearGradient>
        <clipPath id="clip0">
          <path
            fill="#fff"
            transform="scale(1.22477 .70706) rotate(-45 402.568 -82.782)"
            d="M0 0h38.773v38.773H0z"
          />
        </clipPath>
        <clipPath id="clip1">
          <path
            fill="#fff"
            transform="scale(1.22477 .70706) rotate(-45 150.753 24.218)"
            d="M0 0h38.773v38.773H0z"
          />
        </clipPath>
      </defs>
    </svg>
  )
}
