import LongformPage from 'components/longform-page'

export default function CopyrightPolicyPage() {
  return (
    <LongformPage title="Copyright Policy">
      <p>
        HashiCorp, Inc. (Company) has adopted the following general policy
        toward copyright infringement in accordance with the Digital Millennium
        Copyright Act or DMCA (posted at 
        <a href="http://www.copyright.gov/legislation/dmca.pdf">
          www.copyright.gov/legislation/dmca.pdf
        </a>
        ). The address of Company’s Designated Agent to Receive Notification of
        Claimed Infringement (“Designated Agent”) is listed at the end of this
        Section. It is Company’s policy to (1) block access to or remove
        material that it believes in good faith to be copyrighted material that
        has been illegally copied and distributed by any of our advertisers,
        affiliates, content providers, members or users; and (2) remove and
        discontinue service to repeat offenders. HashiCorp considers
        &quot;repeat offender&quot; to be any user who repeatedly or egregiously
        infringes other people&apos;s copyrights or other intellectual property
        rights.
      </p>

      <p>
        <strong>A. Procedure for Reporting Copyright Infringements:</strong>
      </p>
      <p>
        If you believe that material or content residing on or accessible
        through the Services infringes a copyright, please send a notice of
        copyright infringement containing the following information to the
        Designated Agent listed below:
      </p>
      <ol>
        <li>
          A physical or electronic signature of a person authorized to act on
          behalf of the owner of the copyright that has been allegedly
          infringed;
        </li>
        <li>Identification of works or materials being infringed;</li>
        <li>
          Identification of the material that is claimed to be infringing
          including information regarding the location of the infringing
          materials that the copyright owner seeks to have removed, with
          sufficient detail so that Company is capable of finding and verifying
          its existence;
        </li>
        <li>
          Contact information about the notifier including address, telephone
          number and, if available, email address;
        </li>
        <li>
          A statement that the notifier has a good faith belief that the
          material identified in (3) is not authorized by the copyright owner,
          its agent, or the law; and
        </li>
        <li>
          A statement made under penalty of perjury that the information
          provided is accurate and the notifying party is authorized to make the
          complaint on behalf of the copyright owner.
        </li>
      </ol>

      <p>
        <strong>
          B. Once Proper Bona Fide Infringement Notification is Received by the
          Designated Agent:
        </strong>
      </p>
      <p>It is Company’s policy:</p>
      <ol>
        <li>to remove or disable access to the infringing material;</li>
        <li>
          to notify the content provider, member or user that it has removed or
          disabled access to the material; and
        </li>
        <li>
          that repeat offenders will have the infringing material removed from
          the system and that Company will terminate such content provider’s,
          member’s or user’s access to the Services.
        </li>
      </ol>

      <p>
        <strong>
          C. Procedure to Supply a Counter-Notice to the Designated Agent:
        </strong>
      </p>
      <p>
        If the content provider, member or user believes that the material that
        was removed (or to which access was disabled) is not infringing, or the
        content provider, member or user believes that it has the right to post
        and use such material from the copyright owner, the copyright owner’s
        agent, or, pursuant to the law, the content provider, member, or user,
        must send a counter-notice containing the following information to the
        Designated Agent listed below:
      </p>

      <ol>
        <li>
          A physical or electronic signature of the content provider, member or
          user;
        </li>
        <li>
          Identification of the material that has been removed or to which
          access has been disabled and the location at which the material
          appeared before it was removed or disabled;
        </li>
        <li>
          A statement that the content provider, member or user has a good faith
          belief that the material was removed or disabled as a result of
          mistake or misidentification of the material; and
        </li>
        <li>
          Content provider’s, member’s or user’s name, address, telephone
          number, and, if available, email address, and a statement that such
          person or entity consents to the jurisdiction of the Federal Court for
          the judicial district in which the content provider’s, member’s or
          user’s address is located, or, if the content provider’s, member’s or
          user’s address is located outside the United States, for any judicial
          district in which Company is located, and that such person or entity
          will accept service of process from the person who provided
          notification of the alleged infringement.
        </li>
      </ol>

      <p>
        If a counter-notice is received by the Designated Agent, Company may
        send a copy of the counter-notice to the original complaining party
        informing that person that Company may replace the removed material or
        cease disabling it in 10 business days. Unless the copyright owner files
        an action seeking a court order against the content provider, member or
        user, the removed material may be replaced or access to it restored in
        10 to 14 business days or more after receipt of the counter-notice, at
        Company’s discretion.
      </p>

      <p>
        Please contact Company’s Designated Agent to Receive Notification of
        Claimed Infringement at the following address:
      </p>

      <p>HashiCorp, Inc.’s Copyright Agent:</p>
      <p>
        Attn: Legal
        <br />
        HashiCorp, Inc.
        <br />
        101 Second Street, Suite 700
        <br />
        San Francisco, CA 94105
        <br />
        Email: legalnotices@hashicorp.com
      </p>
    </LongformPage>
  )
}
