// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointValidateJobResponse hashicorp waypoint validate job response
//
// swagger:model hashicorp.waypoint.ValidateJobResponse
type HashicorpWaypointValidateJobResponse struct {

	// assignable will be true if the job is assignable at this point-in-time.
	// Assignable means that there are runners registered with the server that
	// claim to be able to service this job. Note that this is a point-in-time
	// result so it doesn't guarantee that a job will be serviced when queued.
	// Additionally, assignability doesn't imply anything about queue length,
	// so the job may still be queued for some time.
	//
	// This will always be false if "valid" is false since we don't check
	// assignability of invalid jobs.
	Assignable bool `json:"assignable,omitempty"`

	// valid will be true if the job structure is valid. If it is invalid
	// validation_error will be set with a reason.
	Valid bool `json:"valid,omitempty"`

	// validation error
	ValidationError *GoogleRPCStatus `json:"validation_error,omitempty"`
}

// Validate validates this hashicorp waypoint validate job response
func (m *HashicorpWaypointValidateJobResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateValidationError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointValidateJobResponse) validateValidationError(formats strfmt.Registry) error {
	if swag.IsZero(m.ValidationError) { // not required
		return nil
	}

	if m.ValidationError != nil {
		if err := m.ValidationError.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("validation_error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("validation_error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint validate job response based on the context it is used
func (m *HashicorpWaypointValidateJobResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateValidationError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointValidateJobResponse) contextValidateValidationError(ctx context.Context, formats strfmt.Registry) error {

	if m.ValidationError != nil {
		if err := m.ValidationError.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("validation_error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("validation_error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointValidateJobResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointValidateJobResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointValidateJobResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
