// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointRunPipelineRequest hashicorp waypoint run pipeline request
//
// swagger:model hashicorp.waypoint.RunPipelineRequest
type HashicorpWaypointRunPipelineRequest struct {

	// This is the job template to use for all the queued steps. This should
	// set all the required fields of a job except for "operation".
	JobTemplate *HashicorpWaypointJob `json:"job_template,omitempty"`

	// The pipeline to execute.
	Pipeline *HashicorpWaypointRefPipeline `json:"pipeline,omitempty"`
}

// Validate validates this hashicorp waypoint run pipeline request
func (m *HashicorpWaypointRunPipelineRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJobTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePipeline(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunPipelineRequest) validateJobTemplate(formats strfmt.Registry) error {
	if swag.IsZero(m.JobTemplate) { // not required
		return nil
	}

	if m.JobTemplate != nil {
		if err := m.JobTemplate.SwaggerValidate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job_template")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job_template")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRunPipelineRequest) validatePipeline(formats strfmt.Registry) error {
	if swag.IsZero(m.Pipeline) { // not required
		return nil
	}

	if m.Pipeline != nil {
		if err := m.Pipeline.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint run pipeline request based on the context it is used
func (m *HashicorpWaypointRunPipelineRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJobTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePipeline(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunPipelineRequest) contextValidateJobTemplate(ctx context.Context, formats strfmt.Registry) error {

	if m.JobTemplate != nil {
		if err := m.JobTemplate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job_template")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job_template")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRunPipelineRequest) contextValidatePipeline(ctx context.Context, formats strfmt.Registry) error {

	if m.Pipeline != nil {
		if err := m.Pipeline.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointRunPipelineRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointRunPipelineRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointRunPipelineRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
