// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointOnDemandRunnerConfig *******************************************************************
// OnDemand Runners
// ******************************************************************
//
// swagger:model hashicorp.waypoint.OnDemandRunnerConfig
type HashicorpWaypointOnDemandRunnerConfig struct {

	// config format specifies the format of plugin_config
	ConfigFormat *HashicorpWaypointHclFormat `json:"config_format,omitempty"`

	// Indicates if this entry is the default for any new projects.
	Default bool `json:"default,omitempty"`

	// environment_variables is any env vars that should be exposed to the
	// ondemand runner. This does not need to include any WAYPOINT specific
	// variables, those are automatically added.
	EnvironmentVariables map[string]string `json:"environment_variables,omitempty"`

	// id is the unique ID of the runner config
	ID string `json:"id,omitempty"`

	// name is the unique name for this config
	Name string `json:"name,omitempty"`

	// oci_url is the OCI image that will be used to boot the ondemand runner.
	OciURL string `json:"oci_url,omitempty"`

	// plugin config is the configuration for the plugin that is created. It
	// is usually HCL and is decoded like the other plugins, and is plugin
	// specific.
	// Format: byte
	PluginConfig strfmt.Base64 `json:"plugin_config,omitempty"`

	// plugin type is used to launch the plugin to start the batch task.
	PluginType string `json:"plugin_type,omitempty"`

	// target_runner is the id of the runner to target for this profile.
	// If not set, defaults to use any runner available
	TargetRunner *HashicorpWaypointRefRunner `json:"target_runner,omitempty"`
}

// Validate validates this hashicorp waypoint on demand runner config
func (m *HashicorpWaypointOnDemandRunnerConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfigFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetRunner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointOnDemandRunnerConfig) validateConfigFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigFormat) { // not required
		return nil
	}

	if m.ConfigFormat != nil {
		if err := m.ConfigFormat.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config_format")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config_format")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointOnDemandRunnerConfig) validateTargetRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.TargetRunner) { // not required
		return nil
	}

	if m.TargetRunner != nil {
		if err := m.TargetRunner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target_runner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint on demand runner config based on the context it is used
func (m *HashicorpWaypointOnDemandRunnerConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointOnDemandRunnerConfig) contextValidateConfigFormat(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfigFormat != nil {
		if err := m.ConfigFormat.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config_format")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config_format")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointOnDemandRunnerConfig) contextValidateTargetRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.TargetRunner != nil {
		if err := m.TargetRunner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target_runner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointOnDemandRunnerConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointOnDemandRunnerConfig) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointOnDemandRunnerConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
