// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointConfigSyncPipelineResponse hashicorp waypoint config sync pipeline response
//
// swagger:model hashicorp.waypoint.ConfigSyncPipelineResponse
type HashicorpWaypointConfigSyncPipelineResponse struct {

	// synced_pipelines is a map of Pipeline Name Keys to Pipeline ID Refs for
	// each pipeline that was synced in the config sync request.
	SyncedPipelines map[string]HashicorpWaypointRefPipeline `json:"synced_pipelines,omitempty"`
}

// Validate validates this hashicorp waypoint config sync pipeline response
func (m *HashicorpWaypointConfigSyncPipelineResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSyncedPipelines(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointConfigSyncPipelineResponse) validateSyncedPipelines(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncedPipelines) { // not required
		return nil
	}

	for k := range m.SyncedPipelines {

		if err := validate.Required("synced_pipelines"+"."+k, "body", m.SyncedPipelines[k]); err != nil {
			return err
		}
		if val, ok := m.SyncedPipelines[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("synced_pipelines" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("synced_pipelines" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint config sync pipeline response based on the context it is used
func (m *HashicorpWaypointConfigSyncPipelineResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSyncedPipelines(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointConfigSyncPipelineResponse) contextValidateSyncedPipelines(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.SyncedPipelines {

		if val, ok := m.SyncedPipelines[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointConfigSyncPipelineResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointConfigSyncPipelineResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointConfigSyncPipelineResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
