// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointUpsertWorkspaceReader is a Reader for the WaypointUpsertWorkspace structure.
type WaypointUpsertWorkspaceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointUpsertWorkspaceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointUpsertWorkspaceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointUpsertWorkspaceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointUpsertWorkspaceOK creates a WaypointUpsertWorkspaceOK with default headers values
func NewWaypointUpsertWorkspaceOK() *WaypointUpsertWorkspaceOK {
	return &WaypointUpsertWorkspaceOK{}
}

/*
WaypointUpsertWorkspaceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointUpsertWorkspaceOK struct {
	Payload *models.HashicorpWaypointUpsertWorkspaceResponse
}

// IsSuccess returns true when this waypoint upsert workspace o k response has a 2xx status code
func (o *WaypointUpsertWorkspaceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint upsert workspace o k response has a 3xx status code
func (o *WaypointUpsertWorkspaceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint upsert workspace o k response has a 4xx status code
func (o *WaypointUpsertWorkspaceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint upsert workspace o k response has a 5xx status code
func (o *WaypointUpsertWorkspaceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint upsert workspace o k response a status code equal to that given
func (o *WaypointUpsertWorkspaceOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointUpsertWorkspaceOK) Error() string {
	return fmt.Sprintf("[POST /workspace][%d] waypointUpsertWorkspaceOK  %+v", 200, o.Payload)
}

func (o *WaypointUpsertWorkspaceOK) String() string {
	return fmt.Sprintf("[POST /workspace][%d] waypointUpsertWorkspaceOK  %+v", 200, o.Payload)
}

func (o *WaypointUpsertWorkspaceOK) GetPayload() *models.HashicorpWaypointUpsertWorkspaceResponse {
	return o.Payload
}

func (o *WaypointUpsertWorkspaceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointUpsertWorkspaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointUpsertWorkspaceDefault creates a WaypointUpsertWorkspaceDefault with default headers values
func NewWaypointUpsertWorkspaceDefault(code int) *WaypointUpsertWorkspaceDefault {
	return &WaypointUpsertWorkspaceDefault{
		_statusCode: code,
	}
}

/*
WaypointUpsertWorkspaceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointUpsertWorkspaceDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint upsert workspace default response
func (o *WaypointUpsertWorkspaceDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint upsert workspace default response has a 2xx status code
func (o *WaypointUpsertWorkspaceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint upsert workspace default response has a 3xx status code
func (o *WaypointUpsertWorkspaceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint upsert workspace default response has a 4xx status code
func (o *WaypointUpsertWorkspaceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint upsert workspace default response has a 5xx status code
func (o *WaypointUpsertWorkspaceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint upsert workspace default response a status code equal to that given
func (o *WaypointUpsertWorkspaceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointUpsertWorkspaceDefault) Error() string {
	return fmt.Sprintf("[POST /workspace][%d] Waypoint_UpsertWorkspace default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUpsertWorkspaceDefault) String() string {
	return fmt.Sprintf("[POST /workspace][%d] Waypoint_UpsertWorkspace default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUpsertWorkspaceDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointUpsertWorkspaceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
