// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListPushedArtifactsParams creates a new WaypointListPushedArtifactsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListPushedArtifactsParams() *WaypointListPushedArtifactsParams {
	return &WaypointListPushedArtifactsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListPushedArtifactsParamsWithTimeout creates a new WaypointListPushedArtifactsParams object
// with the ability to set a timeout on a request.
func NewWaypointListPushedArtifactsParamsWithTimeout(timeout time.Duration) *WaypointListPushedArtifactsParams {
	return &WaypointListPushedArtifactsParams{
		timeout: timeout,
	}
}

// NewWaypointListPushedArtifactsParamsWithContext creates a new WaypointListPushedArtifactsParams object
// with the ability to set a context for a request.
func NewWaypointListPushedArtifactsParamsWithContext(ctx context.Context) *WaypointListPushedArtifactsParams {
	return &WaypointListPushedArtifactsParams{
		Context: ctx,
	}
}

// NewWaypointListPushedArtifactsParamsWithHTTPClient creates a new WaypointListPushedArtifactsParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListPushedArtifactsParamsWithHTTPClient(client *http.Client) *WaypointListPushedArtifactsParams {
	return &WaypointListPushedArtifactsParams{
		HTTPClient: client,
	}
}

/*
WaypointListPushedArtifactsParams contains all the parameters to send to the API endpoint

	for the waypoint list pushed artifacts operation.

	Typically these are written to a http.Request.
*/
type WaypointListPushedArtifactsParams struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	/* IncludeBuild.

	     Indicate if the Build value should be returned for each
	of the artifacts as well.
	*/
	IncludeBuild *bool

	// OrderDesc.
	OrderDesc *bool

	/* OrderLimit.

	   Limit the number of results.

	   Format: int64
	*/
	OrderLimit *int64

	/* OrderOrder.

	   Order for the results.

	   Default: "UNSET"
	*/
	OrderOrder *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list pushed artifacts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListPushedArtifactsParams) WithDefaults() *WaypointListPushedArtifactsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list pushed artifacts params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListPushedArtifactsParams) SetDefaults() {
	var (
		orderOrderDefault = string("UNSET")
	)

	val := WaypointListPushedArtifactsParams{
		OrderOrder: &orderOrderDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithTimeout(timeout time.Duration) *WaypointListPushedArtifactsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithContext(ctx context.Context) *WaypointListPushedArtifactsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithHTTPClient(client *http.Client) *WaypointListPushedArtifactsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithApplicationApplication(applicationApplication string) *WaypointListPushedArtifactsParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithApplicationProject(applicationProject string) *WaypointListPushedArtifactsParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithIncludeBuild adds the includeBuild to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithIncludeBuild(includeBuild *bool) *WaypointListPushedArtifactsParams {
	o.SetIncludeBuild(includeBuild)
	return o
}

// SetIncludeBuild adds the includeBuild to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetIncludeBuild(includeBuild *bool) {
	o.IncludeBuild = includeBuild
}

// WithOrderDesc adds the orderDesc to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithOrderDesc(orderDesc *bool) *WaypointListPushedArtifactsParams {
	o.SetOrderDesc(orderDesc)
	return o
}

// SetOrderDesc adds the orderDesc to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetOrderDesc(orderDesc *bool) {
	o.OrderDesc = orderDesc
}

// WithOrderLimit adds the orderLimit to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithOrderLimit(orderLimit *int64) *WaypointListPushedArtifactsParams {
	o.SetOrderLimit(orderLimit)
	return o
}

// SetOrderLimit adds the orderLimit to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetOrderLimit(orderLimit *int64) {
	o.OrderLimit = orderLimit
}

// WithOrderOrder adds the orderOrder to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithOrderOrder(orderOrder *string) *WaypointListPushedArtifactsParams {
	o.SetOrderOrder(orderOrder)
	return o
}

// SetOrderOrder adds the orderOrder to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetOrderOrder(orderOrder *string) {
	o.OrderOrder = orderOrder
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointListPushedArtifactsParams {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list pushed artifacts params
func (o *WaypointListPushedArtifactsParams) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListPushedArtifactsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.IncludeBuild != nil {

		// query param include_build
		var qrIncludeBuild bool

		if o.IncludeBuild != nil {
			qrIncludeBuild = *o.IncludeBuild
		}
		qIncludeBuild := swag.FormatBool(qrIncludeBuild)
		if qIncludeBuild != "" {

			if err := r.SetQueryParam("include_build", qIncludeBuild); err != nil {
				return err
			}
		}
	}

	if o.OrderDesc != nil {

		// query param order.desc
		var qrOrderDesc bool

		if o.OrderDesc != nil {
			qrOrderDesc = *o.OrderDesc
		}
		qOrderDesc := swag.FormatBool(qrOrderDesc)
		if qOrderDesc != "" {

			if err := r.SetQueryParam("order.desc", qOrderDesc); err != nil {
				return err
			}
		}
	}

	if o.OrderLimit != nil {

		// query param order.limit
		var qrOrderLimit int64

		if o.OrderLimit != nil {
			qrOrderLimit = *o.OrderLimit
		}
		qOrderLimit := swag.FormatInt64(qrOrderLimit)
		if qOrderLimit != "" {

			if err := r.SetQueryParam("order.limit", qOrderLimit); err != nil {
				return err
			}
		}
	}

	if o.OrderOrder != nil {

		// query param order.order
		var qrOrderOrder string

		if o.OrderOrder != nil {
			qrOrderOrder = *o.OrderOrder
		}
		qOrderOrder := qrOrderOrder
		if qOrderOrder != "" {

			if err := r.SetQueryParam("order.order", qOrderOrder); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
