// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListJobsReader is a Reader for the WaypointListJobs structure.
type WaypointListJobsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListJobsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListJobsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListJobsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListJobsOK creates a WaypointListJobsOK with default headers values
func NewWaypointListJobsOK() *WaypointListJobsOK {
	return &WaypointListJobsOK{}
}

/*
WaypointListJobsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListJobsOK struct {
	Payload *models.HashicorpWaypointListJobsResponse
}

// IsSuccess returns true when this waypoint list jobs o k response has a 2xx status code
func (o *WaypointListJobsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list jobs o k response has a 3xx status code
func (o *WaypointListJobsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list jobs o k response has a 4xx status code
func (o *WaypointListJobsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list jobs o k response has a 5xx status code
func (o *WaypointListJobsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list jobs o k response a status code equal to that given
func (o *WaypointListJobsOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListJobsOK) Error() string {
	return fmt.Sprintf("[GET /jobs/workspace/{workspace.workspace}][%d] waypointListJobsOK  %+v", 200, o.Payload)
}

func (o *WaypointListJobsOK) String() string {
	return fmt.Sprintf("[GET /jobs/workspace/{workspace.workspace}][%d] waypointListJobsOK  %+v", 200, o.Payload)
}

func (o *WaypointListJobsOK) GetPayload() *models.HashicorpWaypointListJobsResponse {
	return o.Payload
}

func (o *WaypointListJobsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListJobsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListJobsDefault creates a WaypointListJobsDefault with default headers values
func NewWaypointListJobsDefault(code int) *WaypointListJobsDefault {
	return &WaypointListJobsDefault{
		_statusCode: code,
	}
}

/*
WaypointListJobsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListJobsDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list jobs default response
func (o *WaypointListJobsDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list jobs default response has a 2xx status code
func (o *WaypointListJobsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list jobs default response has a 3xx status code
func (o *WaypointListJobsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list jobs default response has a 4xx status code
func (o *WaypointListJobsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list jobs default response has a 5xx status code
func (o *WaypointListJobsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list jobs default response a status code equal to that given
func (o *WaypointListJobsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListJobsDefault) Error() string {
	return fmt.Sprintf("[GET /jobs/workspace/{workspace.workspace}][%d] Waypoint_ListJobs default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListJobsDefault) String() string {
	return fmt.Sprintf("[GET /jobs/workspace/{workspace.workspace}][%d] Waypoint_ListJobs default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListJobsDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListJobsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
