// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetApplicationReader is a Reader for the WaypointGetApplication structure.
type WaypointGetApplicationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetApplicationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetApplicationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetApplicationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetApplicationOK creates a WaypointGetApplicationOK with default headers values
func NewWaypointGetApplicationOK() *WaypointGetApplicationOK {
	return &WaypointGetApplicationOK{}
}

/*
WaypointGetApplicationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetApplicationOK struct {
	Payload *models.HashicorpWaypointGetApplicationResponse
}

// IsSuccess returns true when this waypoint get application o k response has a 2xx status code
func (o *WaypointGetApplicationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get application o k response has a 3xx status code
func (o *WaypointGetApplicationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get application o k response has a 4xx status code
func (o *WaypointGetApplicationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get application o k response has a 5xx status code
func (o *WaypointGetApplicationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get application o k response a status code equal to that given
func (o *WaypointGetApplicationOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetApplicationOK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}][%d] waypointGetApplicationOK  %+v", 200, o.Payload)
}

func (o *WaypointGetApplicationOK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}][%d] waypointGetApplicationOK  %+v", 200, o.Payload)
}

func (o *WaypointGetApplicationOK) GetPayload() *models.HashicorpWaypointGetApplicationResponse {
	return o.Payload
}

func (o *WaypointGetApplicationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetApplicationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetApplicationDefault creates a WaypointGetApplicationDefault with default headers values
func NewWaypointGetApplicationDefault(code int) *WaypointGetApplicationDefault {
	return &WaypointGetApplicationDefault{
		_statusCode: code,
	}
}

/*
WaypointGetApplicationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetApplicationDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get application default response
func (o *WaypointGetApplicationDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get application default response has a 2xx status code
func (o *WaypointGetApplicationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get application default response has a 3xx status code
func (o *WaypointGetApplicationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get application default response has a 4xx status code
func (o *WaypointGetApplicationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get application default response has a 5xx status code
func (o *WaypointGetApplicationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get application default response a status code equal to that given
func (o *WaypointGetApplicationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetApplicationDefault) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}][%d] Waypoint_GetApplication default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetApplicationDefault) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}][%d] Waypoint_GetApplication default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetApplicationDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetApplicationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
