// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointWorkspaceApplication hashicorp waypoint workspace application
//
// swagger:model hashicorp.waypoint.Workspace.Application
type HashicorpWaypointWorkspaceApplication struct {

	// active_time is the last time that this application was active
	// Format: date-time
	ActiveTime strfmt.DateTime `json:"active_time,omitempty"`

	// Application that this is referencing.
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`
}

// Validate validates this hashicorp waypoint workspace application
func (m *HashicorpWaypointWorkspaceApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointWorkspaceApplication) validateActiveTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveTime) { // not required
		return nil
	}

	if err := validate.FormatOf("active_time", "body", "date-time", m.ActiveTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointWorkspaceApplication) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint workspace application based on the context it is used
func (m *HashicorpWaypointWorkspaceApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointWorkspaceApplication) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointWorkspaceApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointWorkspaceApplication) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointWorkspaceApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
