// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointToken The authenticated Token information. This is used to authenticate requests.
//
// swagger:model hashicorp.waypoint.Token
type HashicorpWaypointToken struct {

	// Non-secret ID that is used in logs to represent this token. Internally,
	// this is also used as a nonce when signing. This ID is randomly generated
	// when created.
	// Format: byte
	AccessorID strfmt.Base64 `json:"accessor_id,omitempty"`

	// invite tokens can be exhanged for login tokens and also optionally
	// sign a new user up.
	Invite *HashicorpWaypointTokenInvite `json:"invite,omitempty"`

	// When the token was issued. This may be used for revocation using a
	// "no earlier than" rule.
	// Format: date-time
	IssuedTime strfmt.DateTime `json:"issued_time,omitempty"`

	// login tokens can be used for API requests
	Login *HashicorpWaypointTokenLogin `json:"login,omitempty"`

	// Runner tokens can be used to request work on behalf of a runner.
	// They have full API access as well since the workloads that runners
	// run currently reuse this token.
	Runner *HashicorpWaypointTokenRunner `json:"runner,omitempty"`

	// trigger tokens can be used to trigger lifecycle actions via HTTP
	Trigger *HashicorpWaypointTokenTrigger `json:"trigger,omitempty"`

	// Same as Login.entrypoint, we just moved it.
	UnusedEntrypoint *HashicorpWaypointTokenEntrypoint `json:"unused_entrypoint,omitempty"`

	// unused invite
	UnusedInvite bool `json:"unused_invite,omitempty"`

	// Old way to determine what kind of token this is.
	UnusedLogin bool `json:"unused_login,omitempty"`

	// The user that the token is for. This must be "waypoint" for
	// backwards compat reasons.
	UnusedUser string `json:"unused_user,omitempty"`

	// When the token is valid until. After the given date, the token will be
	// rejected. When this is not set, the token is valid forever.
	// Format: date-time
	ValidUntil strfmt.DateTime `json:"valid_until,omitempty"`
}

// Validate validates this hashicorp waypoint token
func (m *HashicorpWaypointToken) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInvite(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIssuedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogin(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRunner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTrigger(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnusedEntrypoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValidUntil(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointToken) validateInvite(formats strfmt.Registry) error {
	if swag.IsZero(m.Invite) { // not required
		return nil
	}

	if m.Invite != nil {
		if err := m.Invite.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("invite")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("invite")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) validateIssuedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.IssuedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("issued_time", "body", "date-time", m.IssuedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointToken) validateLogin(formats strfmt.Registry) error {
	if swag.IsZero(m.Login) { // not required
		return nil
	}

	if m.Login != nil {
		if err := m.Login.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("login")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("login")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) validateRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.Runner) { // not required
		return nil
	}

	if m.Runner != nil {
		if err := m.Runner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) validateTrigger(formats strfmt.Registry) error {
	if swag.IsZero(m.Trigger) { // not required
		return nil
	}

	if m.Trigger != nil {
		if err := m.Trigger.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("trigger")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("trigger")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) validateUnusedEntrypoint(formats strfmt.Registry) error {
	if swag.IsZero(m.UnusedEntrypoint) { // not required
		return nil
	}

	if m.UnusedEntrypoint != nil {
		if err := m.UnusedEntrypoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unused_entrypoint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("unused_entrypoint")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) validateValidUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.ValidUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("valid_until", "body", "date-time", m.ValidUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint token based on the context it is used
func (m *HashicorpWaypointToken) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInvite(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTrigger(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnusedEntrypoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointToken) contextValidateInvite(ctx context.Context, formats strfmt.Registry) error {

	if m.Invite != nil {
		if err := m.Invite.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("invite")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("invite")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) contextValidateLogin(ctx context.Context, formats strfmt.Registry) error {

	if m.Login != nil {
		if err := m.Login.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("login")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("login")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) contextValidateRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.Runner != nil {
		if err := m.Runner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) contextValidateTrigger(ctx context.Context, formats strfmt.Registry) error {

	if m.Trigger != nil {
		if err := m.Trigger.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("trigger")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("trigger")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointToken) contextValidateUnusedEntrypoint(ctx context.Context, formats strfmt.Registry) error {

	if m.UnusedEntrypoint != nil {
		if err := m.UnusedEntrypoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unused_entrypoint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("unused_entrypoint")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointToken) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointToken) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointToken
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
