// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointRunnerConfig hashicorp waypoint runner config
//
// swagger:model hashicorp.waypoint.RunnerConfig
type HashicorpWaypointRunnerConfig struct {

	// The configuration for any config sources that may be used in the
	// config vars sent down. The server may send down extra configs that
	// aren't used so consumers should filter these based on what env vars
	// are actually in use.
	ConfigSources []*HashicorpWaypointConfigSource `json:"config_sources"`

	// The configuration for the runner. Any locally set runner config will
	// take priority in a conflict. This allows operators to setup runners
	// with specific configuration without fear that the server will override
	// them.
	ConfigVars []*HashicorpWaypointConfigVar `json:"config_vars"`
}

// Validate validates this hashicorp waypoint runner config
func (m *HashicorpWaypointRunnerConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfigSources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigVars(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunnerConfig) validateConfigSources(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigSources) { // not required
		return nil
	}

	for i := 0; i < len(m.ConfigSources); i++ {
		if swag.IsZero(m.ConfigSources[i]) { // not required
			continue
		}

		if m.ConfigSources[i] != nil {
			if err := m.ConfigSources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("config_sources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("config_sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointRunnerConfig) validateConfigVars(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigVars) { // not required
		return nil
	}

	for i := 0; i < len(m.ConfigVars); i++ {
		if swag.IsZero(m.ConfigVars[i]) { // not required
			continue
		}

		if m.ConfigVars[i] != nil {
			if err := m.ConfigVars[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("config_vars" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("config_vars" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint runner config based on the context it is used
func (m *HashicorpWaypointRunnerConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfigSources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigVars(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunnerConfig) contextValidateConfigSources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConfigSources); i++ {

		if m.ConfigSources[i] != nil {
			if err := m.ConfigSources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("config_sources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("config_sources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointRunnerConfig) contextValidateConfigVars(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConfigVars); i++ {

		if m.ConfigVars[i] != nil {
			if err := m.ConfigVars[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("config_vars" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("config_vars" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointRunnerConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointRunnerConfig) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointRunnerConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
