// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointPipeline hashicorp waypoint pipeline
//
// swagger:model hashicorp.waypoint.Pipeline
type HashicorpWaypointPipeline struct {

	// Unique ID for this pipeline.
	ID string `json:"id,omitempty"`

	// Human-friendly name for the pipeline. This is not unique! Users should
	// use the ID and other metadata to differentiate pipelines. In general,
	// we recommend avoiding reusing names.
	Name string `json:"name,omitempty"`

	// This pipeline is created from a waypoint.hcl file that is synced via VCS.
	Project *HashicorpWaypointRefProject `json:"project,omitempty"`

	// The steps that make up this pipeline. This is a set and the order
	// has no meaning; it does not imply any ordering that the steps will
	// be executed. The execution order is purely defined by the "depends_on"
	// fields on the steps.
	//
	// There must be only one "root" step. A root step is a step with no
	// dependencies. It is an error for there to be more than one root step.
	//
	// For API users, the GetPipelineResponse has a number of fields that
	// help make this much easier to consume, such as a dedicated field for
	// the root step, mermaid-formatted graph output, and more.
	//
	// These requirements are usually hidden from users through nicer user
	// experiences for editing: waypoint.hcl syntax (which implicitly creates
	// ordering and root steps), UIs, etc. All these requirements are noted for
	// _internal_ users who are modifying pipelines via the API. For those
	// internal users, they must manage the tedium of adhering to these requirements.
	Steps map[string]HashicorpWaypointPipelineStep `json:"steps,omitempty"`
}

// Validate validates this hashicorp waypoint pipeline
func (m *HashicorpWaypointPipeline) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSteps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointPipeline) validateProject(formats strfmt.Registry) error {
	if swag.IsZero(m.Project) { // not required
		return nil
	}

	if m.Project != nil {
		if err := m.Project.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipeline) validateSteps(formats strfmt.Registry) error {
	if swag.IsZero(m.Steps) { // not required
		return nil
	}

	for k := range m.Steps {

		if err := validate.Required("steps"+"."+k, "body", m.Steps[k]); err != nil {
			return err
		}
		if val, ok := m.Steps[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("steps" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("steps" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint pipeline based on the context it is used
func (m *HashicorpWaypointPipeline) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSteps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointPipeline) contextValidateProject(ctx context.Context, formats strfmt.Registry) error {

	if m.Project != nil {
		if err := m.Project.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointPipeline) contextValidateSteps(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.Steps {

		if val, ok := m.Steps[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointPipeline) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointPipeline) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointPipeline
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
