// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointCompleteOIDCAuthResponse hashicorp waypoint complete o ID c auth response
//
// swagger:model hashicorp.waypoint.CompleteOIDCAuthResponse
type HashicorpWaypointCompleteOIDCAuthResponse struct {

	// These are all the claims that were associated with this OIDC
	// authentication. This is used for debugging and operator inspection
	// when setting up an OIDC auth method and aren't meant for general purpose
	// use. These may also contain sensitive data so it shouldn't be stored.
	IDClaimsJSON string `json:"id_claims_json,omitempty"`

	// token
	Token string `json:"token,omitempty"`

	// The user that was authenticated. This is the same as if GetUser
	// was called with the token returned. This is eager returned because
	// it is commonly useful and also readily available as part of auth.
	User *HashicorpWaypointUser `json:"user,omitempty"`

	// user claims json
	UserClaimsJSON string `json:"user_claims_json,omitempty"`
}

// Validate validates this hashicorp waypoint complete o ID c auth response
func (m *HashicorpWaypointCompleteOIDCAuthResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUser(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointCompleteOIDCAuthResponse) validateUser(formats strfmt.Registry) error {
	if swag.IsZero(m.User) { // not required
		return nil
	}

	if m.User != nil {
		if err := m.User.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint complete o ID c auth response based on the context it is used
func (m *HashicorpWaypointCompleteOIDCAuthResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUser(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointCompleteOIDCAuthResponse) contextValidateUser(ctx context.Context, formats strfmt.Registry) error {

	if m.User != nil {
		if err := m.User.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("user")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointCompleteOIDCAuthResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointCompleteOIDCAuthResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointCompleteOIDCAuthResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
