// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointUpsertApplicationReader is a Reader for the WaypointUpsertApplication structure.
type WaypointUpsertApplicationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointUpsertApplicationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointUpsertApplicationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointUpsertApplicationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointUpsertApplicationOK creates a WaypointUpsertApplicationOK with default headers values
func NewWaypointUpsertApplicationOK() *WaypointUpsertApplicationOK {
	return &WaypointUpsertApplicationOK{}
}

/*
WaypointUpsertApplicationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointUpsertApplicationOK struct {
	Payload *models.HashicorpWaypointUpsertApplicationResponse
}

// IsSuccess returns true when this waypoint upsert application o k response has a 2xx status code
func (o *WaypointUpsertApplicationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint upsert application o k response has a 3xx status code
func (o *WaypointUpsertApplicationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint upsert application o k response has a 4xx status code
func (o *WaypointUpsertApplicationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint upsert application o k response has a 5xx status code
func (o *WaypointUpsertApplicationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint upsert application o k response a status code equal to that given
func (o *WaypointUpsertApplicationOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointUpsertApplicationOK) Error() string {
	return fmt.Sprintf("[POST /project/{project.project}/application][%d] waypointUpsertApplicationOK  %+v", 200, o.Payload)
}

func (o *WaypointUpsertApplicationOK) String() string {
	return fmt.Sprintf("[POST /project/{project.project}/application][%d] waypointUpsertApplicationOK  %+v", 200, o.Payload)
}

func (o *WaypointUpsertApplicationOK) GetPayload() *models.HashicorpWaypointUpsertApplicationResponse {
	return o.Payload
}

func (o *WaypointUpsertApplicationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointUpsertApplicationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointUpsertApplicationDefault creates a WaypointUpsertApplicationDefault with default headers values
func NewWaypointUpsertApplicationDefault(code int) *WaypointUpsertApplicationDefault {
	return &WaypointUpsertApplicationDefault{
		_statusCode: code,
	}
}

/*
WaypointUpsertApplicationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointUpsertApplicationDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint upsert application default response
func (o *WaypointUpsertApplicationDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint upsert application default response has a 2xx status code
func (o *WaypointUpsertApplicationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint upsert application default response has a 3xx status code
func (o *WaypointUpsertApplicationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint upsert application default response has a 4xx status code
func (o *WaypointUpsertApplicationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint upsert application default response has a 5xx status code
func (o *WaypointUpsertApplicationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint upsert application default response a status code equal to that given
func (o *WaypointUpsertApplicationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointUpsertApplicationDefault) Error() string {
	return fmt.Sprintf("[POST /project/{project.project}/application][%d] Waypoint_UpsertApplication default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUpsertApplicationDefault) String() string {
	return fmt.Sprintf("[POST /project/{project.project}/application][%d] Waypoint_UpsertApplication default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUpsertApplicationDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointUpsertApplicationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
