// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointSetConfigParams creates a new WaypointSetConfigParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointSetConfigParams() *WaypointSetConfigParams {
	return &WaypointSetConfigParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointSetConfigParamsWithTimeout creates a new WaypointSetConfigParams object
// with the ability to set a timeout on a request.
func NewWaypointSetConfigParamsWithTimeout(timeout time.Duration) *WaypointSetConfigParams {
	return &WaypointSetConfigParams{
		timeout: timeout,
	}
}

// NewWaypointSetConfigParamsWithContext creates a new WaypointSetConfigParams object
// with the ability to set a context for a request.
func NewWaypointSetConfigParamsWithContext(ctx context.Context) *WaypointSetConfigParams {
	return &WaypointSetConfigParams{
		Context: ctx,
	}
}

// NewWaypointSetConfigParamsWithHTTPClient creates a new WaypointSetConfigParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointSetConfigParamsWithHTTPClient(client *http.Client) *WaypointSetConfigParams {
	return &WaypointSetConfigParams{
		HTTPClient: client,
	}
}

/*
WaypointSetConfigParams contains all the parameters to send to the API endpoint

	for the waypoint set config operation.

	Typically these are written to a http.Request.
*/
type WaypointSetConfigParams struct {

	// Body.
	Body *models.HashicorpWaypointConfigSetRequest

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint set config params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointSetConfigParams) WithDefaults() *WaypointSetConfigParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint set config params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointSetConfigParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint set config params
func (o *WaypointSetConfigParams) WithTimeout(timeout time.Duration) *WaypointSetConfigParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint set config params
func (o *WaypointSetConfigParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint set config params
func (o *WaypointSetConfigParams) WithContext(ctx context.Context) *WaypointSetConfigParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint set config params
func (o *WaypointSetConfigParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint set config params
func (o *WaypointSetConfigParams) WithHTTPClient(client *http.Client) *WaypointSetConfigParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint set config params
func (o *WaypointSetConfigParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint set config params
func (o *WaypointSetConfigParams) WithBody(body *models.HashicorpWaypointConfigSetRequest) *WaypointSetConfigParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint set config params
func (o *WaypointSetConfigParams) SetBody(body *models.HashicorpWaypointConfigSetRequest) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointSetConfigParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
