// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListTriggers4Reader is a Reader for the WaypointListTriggers4 structure.
type WaypointListTriggers4Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListTriggers4Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListTriggers4OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListTriggers4Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListTriggers4OK creates a WaypointListTriggers4OK with default headers values
func NewWaypointListTriggers4OK() *WaypointListTriggers4OK {
	return &WaypointListTriggers4OK{}
}

/*
WaypointListTriggers4OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListTriggers4OK struct {
	Payload *models.HashicorpWaypointListTriggerResponse
}

// IsSuccess returns true when this waypoint list triggers4 o k response has a 2xx status code
func (o *WaypointListTriggers4OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list triggers4 o k response has a 3xx status code
func (o *WaypointListTriggers4OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list triggers4 o k response has a 4xx status code
func (o *WaypointListTriggers4OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list triggers4 o k response has a 5xx status code
func (o *WaypointListTriggers4OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list triggers4 o k response a status code equal to that given
func (o *WaypointListTriggers4OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListTriggers4OK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/triggers][%d] waypointListTriggers4OK  %+v", 200, o.Payload)
}

func (o *WaypointListTriggers4OK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/triggers][%d] waypointListTriggers4OK  %+v", 200, o.Payload)
}

func (o *WaypointListTriggers4OK) GetPayload() *models.HashicorpWaypointListTriggerResponse {
	return o.Payload
}

func (o *WaypointListTriggers4OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListTriggerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListTriggers4Default creates a WaypointListTriggers4Default with default headers values
func NewWaypointListTriggers4Default(code int) *WaypointListTriggers4Default {
	return &WaypointListTriggers4Default{
		_statusCode: code,
	}
}

/*
WaypointListTriggers4Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListTriggers4Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list triggers4 default response
func (o *WaypointListTriggers4Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list triggers4 default response has a 2xx status code
func (o *WaypointListTriggers4Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list triggers4 default response has a 3xx status code
func (o *WaypointListTriggers4Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list triggers4 default response has a 4xx status code
func (o *WaypointListTriggers4Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list triggers4 default response has a 5xx status code
func (o *WaypointListTriggers4Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list triggers4 default response a status code equal to that given
func (o *WaypointListTriggers4Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListTriggers4Default) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/triggers][%d] Waypoint_ListTriggers4 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListTriggers4Default) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/triggers][%d] Waypoint_ListTriggers4 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListTriggers4Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListTriggers4Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
