// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListStatusReports2Params creates a new WaypointListStatusReports2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListStatusReports2Params() *WaypointListStatusReports2Params {
	return &WaypointListStatusReports2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListStatusReports2ParamsWithTimeout creates a new WaypointListStatusReports2Params object
// with the ability to set a timeout on a request.
func NewWaypointListStatusReports2ParamsWithTimeout(timeout time.Duration) *WaypointListStatusReports2Params {
	return &WaypointListStatusReports2Params{
		timeout: timeout,
	}
}

// NewWaypointListStatusReports2ParamsWithContext creates a new WaypointListStatusReports2Params object
// with the ability to set a context for a request.
func NewWaypointListStatusReports2ParamsWithContext(ctx context.Context) *WaypointListStatusReports2Params {
	return &WaypointListStatusReports2Params{
		Context: ctx,
	}
}

// NewWaypointListStatusReports2ParamsWithHTTPClient creates a new WaypointListStatusReports2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListStatusReports2ParamsWithHTTPClient(client *http.Client) *WaypointListStatusReports2Params {
	return &WaypointListStatusReports2Params{
		HTTPClient: client,
	}
}

/*
WaypointListStatusReports2Params contains all the parameters to send to the API endpoint

	for the waypoint list status reports2 operation.

	Typically these are written to a http.Request.
*/
type WaypointListStatusReports2Params struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	// DeploymentID.
	DeploymentID *string

	// DeploymentSequenceNumber.
	//
	// Format: uint64
	DeploymentSequenceNumber *string

	// OrderDesc.
	OrderDesc *bool

	/* OrderLimit.

	   Limit the number of results.

	   Format: int64
	*/
	OrderLimit *int64

	/* OrderOrder.

	   Order for the results.

	   Default: "UNSET"
	*/
	OrderOrder *string

	// ReleaseID.
	ReleaseID *string

	// ReleaseSequenceNumber.
	//
	// Format: uint64
	ReleaseSequenceNumber *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list status reports2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListStatusReports2Params) WithDefaults() *WaypointListStatusReports2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list status reports2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListStatusReports2Params) SetDefaults() {
	var (
		orderOrderDefault = string("UNSET")
	)

	val := WaypointListStatusReports2Params{
		OrderOrder: &orderOrderDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithTimeout(timeout time.Duration) *WaypointListStatusReports2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithContext(ctx context.Context) *WaypointListStatusReports2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithHTTPClient(client *http.Client) *WaypointListStatusReports2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithApplicationApplication(applicationApplication string) *WaypointListStatusReports2Params {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithApplicationProject(applicationProject string) *WaypointListStatusReports2Params {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithDeploymentID adds the deploymentID to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithDeploymentID(deploymentID *string) *WaypointListStatusReports2Params {
	o.SetDeploymentID(deploymentID)
	return o
}

// SetDeploymentID adds the deploymentId to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetDeploymentID(deploymentID *string) {
	o.DeploymentID = deploymentID
}

// WithDeploymentSequenceNumber adds the deploymentSequenceNumber to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithDeploymentSequenceNumber(deploymentSequenceNumber *string) *WaypointListStatusReports2Params {
	o.SetDeploymentSequenceNumber(deploymentSequenceNumber)
	return o
}

// SetDeploymentSequenceNumber adds the deploymentSequenceNumber to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetDeploymentSequenceNumber(deploymentSequenceNumber *string) {
	o.DeploymentSequenceNumber = deploymentSequenceNumber
}

// WithOrderDesc adds the orderDesc to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithOrderDesc(orderDesc *bool) *WaypointListStatusReports2Params {
	o.SetOrderDesc(orderDesc)
	return o
}

// SetOrderDesc adds the orderDesc to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetOrderDesc(orderDesc *bool) {
	o.OrderDesc = orderDesc
}

// WithOrderLimit adds the orderLimit to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithOrderLimit(orderLimit *int64) *WaypointListStatusReports2Params {
	o.SetOrderLimit(orderLimit)
	return o
}

// SetOrderLimit adds the orderLimit to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetOrderLimit(orderLimit *int64) {
	o.OrderLimit = orderLimit
}

// WithOrderOrder adds the orderOrder to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithOrderOrder(orderOrder *string) *WaypointListStatusReports2Params {
	o.SetOrderOrder(orderOrder)
	return o
}

// SetOrderOrder adds the orderOrder to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetOrderOrder(orderOrder *string) {
	o.OrderOrder = orderOrder
}

// WithReleaseID adds the releaseID to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithReleaseID(releaseID *string) *WaypointListStatusReports2Params {
	o.SetReleaseID(releaseID)
	return o
}

// SetReleaseID adds the releaseId to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetReleaseID(releaseID *string) {
	o.ReleaseID = releaseID
}

// WithReleaseSequenceNumber adds the releaseSequenceNumber to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithReleaseSequenceNumber(releaseSequenceNumber *string) *WaypointListStatusReports2Params {
	o.SetReleaseSequenceNumber(releaseSequenceNumber)
	return o
}

// SetReleaseSequenceNumber adds the releaseSequenceNumber to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetReleaseSequenceNumber(releaseSequenceNumber *string) {
	o.ReleaseSequenceNumber = releaseSequenceNumber
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) WithWorkspaceWorkspace(workspaceWorkspace string) *WaypointListStatusReports2Params {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list status reports2 params
func (o *WaypointListStatusReports2Params) SetWorkspaceWorkspace(workspaceWorkspace string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListStatusReports2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.DeploymentID != nil {

		// query param deployment.id
		var qrDeploymentID string

		if o.DeploymentID != nil {
			qrDeploymentID = *o.DeploymentID
		}
		qDeploymentID := qrDeploymentID
		if qDeploymentID != "" {

			if err := r.SetQueryParam("deployment.id", qDeploymentID); err != nil {
				return err
			}
		}
	}

	if o.DeploymentSequenceNumber != nil {

		// query param deployment.sequence.number
		var qrDeploymentSequenceNumber string

		if o.DeploymentSequenceNumber != nil {
			qrDeploymentSequenceNumber = *o.DeploymentSequenceNumber
		}
		qDeploymentSequenceNumber := qrDeploymentSequenceNumber
		if qDeploymentSequenceNumber != "" {

			if err := r.SetQueryParam("deployment.sequence.number", qDeploymentSequenceNumber); err != nil {
				return err
			}
		}
	}

	if o.OrderDesc != nil {

		// query param order.desc
		var qrOrderDesc bool

		if o.OrderDesc != nil {
			qrOrderDesc = *o.OrderDesc
		}
		qOrderDesc := swag.FormatBool(qrOrderDesc)
		if qOrderDesc != "" {

			if err := r.SetQueryParam("order.desc", qOrderDesc); err != nil {
				return err
			}
		}
	}

	if o.OrderLimit != nil {

		// query param order.limit
		var qrOrderLimit int64

		if o.OrderLimit != nil {
			qrOrderLimit = *o.OrderLimit
		}
		qOrderLimit := swag.FormatInt64(qrOrderLimit)
		if qOrderLimit != "" {

			if err := r.SetQueryParam("order.limit", qOrderLimit); err != nil {
				return err
			}
		}
	}

	if o.OrderOrder != nil {

		// query param order.order
		var qrOrderOrder string

		if o.OrderOrder != nil {
			qrOrderOrder = *o.OrderOrder
		}
		qOrderOrder := qrOrderOrder
		if qOrderOrder != "" {

			if err := r.SetQueryParam("order.order", qOrderOrder); err != nil {
				return err
			}
		}
	}

	if o.ReleaseID != nil {

		// query param release.id
		var qrReleaseID string

		if o.ReleaseID != nil {
			qrReleaseID = *o.ReleaseID
		}
		qReleaseID := qrReleaseID
		if qReleaseID != "" {

			if err := r.SetQueryParam("release.id", qReleaseID); err != nil {
				return err
			}
		}
	}

	if o.ReleaseSequenceNumber != nil {

		// query param release.sequence.number
		var qrReleaseSequenceNumber string

		if o.ReleaseSequenceNumber != nil {
			qrReleaseSequenceNumber = *o.ReleaseSequenceNumber
		}
		qReleaseSequenceNumber := qrReleaseSequenceNumber
		if qReleaseSequenceNumber != "" {

			if err := r.SetQueryParam("release.sequence.number", qReleaseSequenceNumber); err != nil {
				return err
			}
		}
	}

	// path param workspace.workspace
	if err := r.SetPathParam("workspace.workspace", o.WorkspaceWorkspace); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
