// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListReleasesParams creates a new WaypointListReleasesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListReleasesParams() *WaypointListReleasesParams {
	return &WaypointListReleasesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListReleasesParamsWithTimeout creates a new WaypointListReleasesParams object
// with the ability to set a timeout on a request.
func NewWaypointListReleasesParamsWithTimeout(timeout time.Duration) *WaypointListReleasesParams {
	return &WaypointListReleasesParams{
		timeout: timeout,
	}
}

// NewWaypointListReleasesParamsWithContext creates a new WaypointListReleasesParams object
// with the ability to set a context for a request.
func NewWaypointListReleasesParamsWithContext(ctx context.Context) *WaypointListReleasesParams {
	return &WaypointListReleasesParams{
		Context: ctx,
	}
}

// NewWaypointListReleasesParamsWithHTTPClient creates a new WaypointListReleasesParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListReleasesParamsWithHTTPClient(client *http.Client) *WaypointListReleasesParams {
	return &WaypointListReleasesParams{
		HTTPClient: client,
	}
}

/*
WaypointListReleasesParams contains all the parameters to send to the API endpoint

	for the waypoint list releases operation.

	Typically these are written to a http.Request.
*/
type WaypointListReleasesParams struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	/* LoadDetails.

	     Load additional details about the release. These will become available
	in the Preload section.

	     Default: "NONE"
	*/
	LoadDetails *string

	// OrderDesc.
	OrderDesc *bool

	/* OrderLimit.

	   Limit the number of results.

	   Format: int64
	*/
	OrderLimit *int64

	/* OrderOrder.

	   Order for the results.

	   Default: "UNSET"
	*/
	OrderOrder *string

	/* PhysicalState.

	     The physical state to filter for. If this is zero or unset then no
	filtering on physical state will be done.

	     Default: "UNKNOWN"
	*/
	PhysicalState *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list releases params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListReleasesParams) WithDefaults() *WaypointListReleasesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list releases params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListReleasesParams) SetDefaults() {
	var (
		loadDetailsDefault = string("NONE")

		orderOrderDefault = string("UNSET")

		physicalStateDefault = string("UNKNOWN")
	)

	val := WaypointListReleasesParams{
		LoadDetails:   &loadDetailsDefault,
		OrderOrder:    &orderOrderDefault,
		PhysicalState: &physicalStateDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint list releases params
func (o *WaypointListReleasesParams) WithTimeout(timeout time.Duration) *WaypointListReleasesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list releases params
func (o *WaypointListReleasesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list releases params
func (o *WaypointListReleasesParams) WithContext(ctx context.Context) *WaypointListReleasesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list releases params
func (o *WaypointListReleasesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list releases params
func (o *WaypointListReleasesParams) WithHTTPClient(client *http.Client) *WaypointListReleasesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list releases params
func (o *WaypointListReleasesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list releases params
func (o *WaypointListReleasesParams) WithApplicationApplication(applicationApplication string) *WaypointListReleasesParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list releases params
func (o *WaypointListReleasesParams) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list releases params
func (o *WaypointListReleasesParams) WithApplicationProject(applicationProject string) *WaypointListReleasesParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list releases params
func (o *WaypointListReleasesParams) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithLoadDetails adds the loadDetails to the waypoint list releases params
func (o *WaypointListReleasesParams) WithLoadDetails(loadDetails *string) *WaypointListReleasesParams {
	o.SetLoadDetails(loadDetails)
	return o
}

// SetLoadDetails adds the loadDetails to the waypoint list releases params
func (o *WaypointListReleasesParams) SetLoadDetails(loadDetails *string) {
	o.LoadDetails = loadDetails
}

// WithOrderDesc adds the orderDesc to the waypoint list releases params
func (o *WaypointListReleasesParams) WithOrderDesc(orderDesc *bool) *WaypointListReleasesParams {
	o.SetOrderDesc(orderDesc)
	return o
}

// SetOrderDesc adds the orderDesc to the waypoint list releases params
func (o *WaypointListReleasesParams) SetOrderDesc(orderDesc *bool) {
	o.OrderDesc = orderDesc
}

// WithOrderLimit adds the orderLimit to the waypoint list releases params
func (o *WaypointListReleasesParams) WithOrderLimit(orderLimit *int64) *WaypointListReleasesParams {
	o.SetOrderLimit(orderLimit)
	return o
}

// SetOrderLimit adds the orderLimit to the waypoint list releases params
func (o *WaypointListReleasesParams) SetOrderLimit(orderLimit *int64) {
	o.OrderLimit = orderLimit
}

// WithOrderOrder adds the orderOrder to the waypoint list releases params
func (o *WaypointListReleasesParams) WithOrderOrder(orderOrder *string) *WaypointListReleasesParams {
	o.SetOrderOrder(orderOrder)
	return o
}

// SetOrderOrder adds the orderOrder to the waypoint list releases params
func (o *WaypointListReleasesParams) SetOrderOrder(orderOrder *string) {
	o.OrderOrder = orderOrder
}

// WithPhysicalState adds the physicalState to the waypoint list releases params
func (o *WaypointListReleasesParams) WithPhysicalState(physicalState *string) *WaypointListReleasesParams {
	o.SetPhysicalState(physicalState)
	return o
}

// SetPhysicalState adds the physicalState to the waypoint list releases params
func (o *WaypointListReleasesParams) SetPhysicalState(physicalState *string) {
	o.PhysicalState = physicalState
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list releases params
func (o *WaypointListReleasesParams) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointListReleasesParams {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list releases params
func (o *WaypointListReleasesParams) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListReleasesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.LoadDetails != nil {

		// query param load_details
		var qrLoadDetails string

		if o.LoadDetails != nil {
			qrLoadDetails = *o.LoadDetails
		}
		qLoadDetails := qrLoadDetails
		if qLoadDetails != "" {

			if err := r.SetQueryParam("load_details", qLoadDetails); err != nil {
				return err
			}
		}
	}

	if o.OrderDesc != nil {

		// query param order.desc
		var qrOrderDesc bool

		if o.OrderDesc != nil {
			qrOrderDesc = *o.OrderDesc
		}
		qOrderDesc := swag.FormatBool(qrOrderDesc)
		if qOrderDesc != "" {

			if err := r.SetQueryParam("order.desc", qOrderDesc); err != nil {
				return err
			}
		}
	}

	if o.OrderLimit != nil {

		// query param order.limit
		var qrOrderLimit int64

		if o.OrderLimit != nil {
			qrOrderLimit = *o.OrderLimit
		}
		qOrderLimit := swag.FormatInt64(qrOrderLimit)
		if qOrderLimit != "" {

			if err := r.SetQueryParam("order.limit", qOrderLimit); err != nil {
				return err
			}
		}
	}

	if o.OrderOrder != nil {

		// query param order.order
		var qrOrderOrder string

		if o.OrderOrder != nil {
			qrOrderOrder = *o.OrderOrder
		}
		qOrderOrder := qrOrderOrder
		if qOrderOrder != "" {

			if err := r.SetQueryParam("order.order", qOrderOrder); err != nil {
				return err
			}
		}
	}

	if o.PhysicalState != nil {

		// query param physical_state
		var qrPhysicalState string

		if o.PhysicalState != nil {
			qrPhysicalState = *o.PhysicalState
		}
		qPhysicalState := qrPhysicalState
		if qPhysicalState != "" {

			if err := r.SetQueryParam("physical_state", qPhysicalState); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
