// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetUserReader is a Reader for the WaypointGetUser structure.
type WaypointGetUserReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetUserReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetUserOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetUserDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetUserOK creates a WaypointGetUserOK with default headers values
func NewWaypointGetUserOK() *WaypointGetUserOK {
	return &WaypointGetUserOK{}
}

/*
WaypointGetUserOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetUserOK struct {
	Payload *models.HashicorpWaypointGetUserResponse
}

// IsSuccess returns true when this waypoint get user o k response has a 2xx status code
func (o *WaypointGetUserOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get user o k response has a 3xx status code
func (o *WaypointGetUserOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get user o k response has a 4xx status code
func (o *WaypointGetUserOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get user o k response has a 5xx status code
func (o *WaypointGetUserOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get user o k response a status code equal to that given
func (o *WaypointGetUserOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetUserOK) Error() string {
	return fmt.Sprintf("[GET /user/by-id/{user.id.id}][%d] waypointGetUserOK  %+v", 200, o.Payload)
}

func (o *WaypointGetUserOK) String() string {
	return fmt.Sprintf("[GET /user/by-id/{user.id.id}][%d] waypointGetUserOK  %+v", 200, o.Payload)
}

func (o *WaypointGetUserOK) GetPayload() *models.HashicorpWaypointGetUserResponse {
	return o.Payload
}

func (o *WaypointGetUserOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetUserResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetUserDefault creates a WaypointGetUserDefault with default headers values
func NewWaypointGetUserDefault(code int) *WaypointGetUserDefault {
	return &WaypointGetUserDefault{
		_statusCode: code,
	}
}

/*
WaypointGetUserDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetUserDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get user default response
func (o *WaypointGetUserDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get user default response has a 2xx status code
func (o *WaypointGetUserDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get user default response has a 3xx status code
func (o *WaypointGetUserDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get user default response has a 4xx status code
func (o *WaypointGetUserDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get user default response has a 5xx status code
func (o *WaypointGetUserDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get user default response a status code equal to that given
func (o *WaypointGetUserDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetUserDefault) Error() string {
	return fmt.Sprintf("[GET /user/by-id/{user.id.id}][%d] Waypoint_GetUser default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetUserDefault) String() string {
	return fmt.Sprintf("[GET /user/by-id/{user.id.id}][%d] Waypoint_GetUser default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetUserDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetUserDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
