// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetTaskReader is a Reader for the WaypointGetTask structure.
type WaypointGetTaskReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetTaskReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetTaskOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetTaskDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetTaskOK creates a WaypointGetTaskOK with default headers values
func NewWaypointGetTaskOK() *WaypointGetTaskOK {
	return &WaypointGetTaskOK{}
}

/*
WaypointGetTaskOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetTaskOK struct {
	Payload *models.HashicorpWaypointGetTaskResponse
}

// IsSuccess returns true when this waypoint get task o k response has a 2xx status code
func (o *WaypointGetTaskOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get task o k response has a 3xx status code
func (o *WaypointGetTaskOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get task o k response has a 4xx status code
func (o *WaypointGetTaskOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get task o k response has a 5xx status code
func (o *WaypointGetTaskOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get task o k response a status code equal to that given
func (o *WaypointGetTaskOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetTaskOK) Error() string {
	return fmt.Sprintf("[GET /task/{ref.id}][%d] waypointGetTaskOK  %+v", 200, o.Payload)
}

func (o *WaypointGetTaskOK) String() string {
	return fmt.Sprintf("[GET /task/{ref.id}][%d] waypointGetTaskOK  %+v", 200, o.Payload)
}

func (o *WaypointGetTaskOK) GetPayload() *models.HashicorpWaypointGetTaskResponse {
	return o.Payload
}

func (o *WaypointGetTaskOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetTaskResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetTaskDefault creates a WaypointGetTaskDefault with default headers values
func NewWaypointGetTaskDefault(code int) *WaypointGetTaskDefault {
	return &WaypointGetTaskDefault{
		_statusCode: code,
	}
}

/*
WaypointGetTaskDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetTaskDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get task default response
func (o *WaypointGetTaskDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get task default response has a 2xx status code
func (o *WaypointGetTaskDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get task default response has a 3xx status code
func (o *WaypointGetTaskDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get task default response has a 4xx status code
func (o *WaypointGetTaskDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get task default response has a 5xx status code
func (o *WaypointGetTaskDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get task default response a status code equal to that given
func (o *WaypointGetTaskDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetTaskDefault) Error() string {
	return fmt.Sprintf("[GET /task/{ref.id}][%d] Waypoint_GetTask default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetTaskDefault) String() string {
	return fmt.Sprintf("[GET /task/{ref.id}][%d] Waypoint_GetTask default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetTaskDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetTaskDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
