// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetConfigParams creates a new WaypointGetConfigParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetConfigParams() *WaypointGetConfigParams {
	return &WaypointGetConfigParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetConfigParamsWithTimeout creates a new WaypointGetConfigParams object
// with the ability to set a timeout on a request.
func NewWaypointGetConfigParamsWithTimeout(timeout time.Duration) *WaypointGetConfigParams {
	return &WaypointGetConfigParams{
		timeout: timeout,
	}
}

// NewWaypointGetConfigParamsWithContext creates a new WaypointGetConfigParams object
// with the ability to set a context for a request.
func NewWaypointGetConfigParamsWithContext(ctx context.Context) *WaypointGetConfigParams {
	return &WaypointGetConfigParams{
		Context: ctx,
	}
}

// NewWaypointGetConfigParamsWithHTTPClient creates a new WaypointGetConfigParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetConfigParamsWithHTTPClient(client *http.Client) *WaypointGetConfigParams {
	return &WaypointGetConfigParams{
		HTTPClient: client,
	}
}

/*
WaypointGetConfigParams contains all the parameters to send to the API endpoint

	for the waypoint get config operation.

	Typically these are written to a http.Request.
*/
type WaypointGetConfigParams struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	/* Prefix.

	     Get all configuration entries under the given prefix. When empty,
	returns all config variables.
	*/
	Prefix *string

	// ProjectProject.
	ProjectProject *string

	// RunnerID.
	RunnerID *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get config params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetConfigParams) WithDefaults() *WaypointGetConfigParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get config params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetConfigParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get config params
func (o *WaypointGetConfigParams) WithTimeout(timeout time.Duration) *WaypointGetConfigParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get config params
func (o *WaypointGetConfigParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get config params
func (o *WaypointGetConfigParams) WithContext(ctx context.Context) *WaypointGetConfigParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get config params
func (o *WaypointGetConfigParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get config params
func (o *WaypointGetConfigParams) WithHTTPClient(client *http.Client) *WaypointGetConfigParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get config params
func (o *WaypointGetConfigParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint get config params
func (o *WaypointGetConfigParams) WithApplicationApplication(applicationApplication string) *WaypointGetConfigParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint get config params
func (o *WaypointGetConfigParams) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint get config params
func (o *WaypointGetConfigParams) WithApplicationProject(applicationProject string) *WaypointGetConfigParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint get config params
func (o *WaypointGetConfigParams) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithPrefix adds the prefix to the waypoint get config params
func (o *WaypointGetConfigParams) WithPrefix(prefix *string) *WaypointGetConfigParams {
	o.SetPrefix(prefix)
	return o
}

// SetPrefix adds the prefix to the waypoint get config params
func (o *WaypointGetConfigParams) SetPrefix(prefix *string) {
	o.Prefix = prefix
}

// WithProjectProject adds the projectProject to the waypoint get config params
func (o *WaypointGetConfigParams) WithProjectProject(projectProject *string) *WaypointGetConfigParams {
	o.SetProjectProject(projectProject)
	return o
}

// SetProjectProject adds the projectProject to the waypoint get config params
func (o *WaypointGetConfigParams) SetProjectProject(projectProject *string) {
	o.ProjectProject = projectProject
}

// WithRunnerID adds the runnerID to the waypoint get config params
func (o *WaypointGetConfigParams) WithRunnerID(runnerID *string) *WaypointGetConfigParams {
	o.SetRunnerID(runnerID)
	return o
}

// SetRunnerID adds the runnerId to the waypoint get config params
func (o *WaypointGetConfigParams) SetRunnerID(runnerID *string) {
	o.RunnerID = runnerID
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get config params
func (o *WaypointGetConfigParams) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointGetConfigParams {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get config params
func (o *WaypointGetConfigParams) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetConfigParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.Prefix != nil {

		// query param prefix
		var qrPrefix string

		if o.Prefix != nil {
			qrPrefix = *o.Prefix
		}
		qPrefix := qrPrefix
		if qPrefix != "" {

			if err := r.SetQueryParam("prefix", qPrefix); err != nil {
				return err
			}
		}
	}

	if o.ProjectProject != nil {

		// query param project.project
		var qrProjectProject string

		if o.ProjectProject != nil {
			qrProjectProject = *o.ProjectProject
		}
		qProjectProject := qrProjectProject
		if qProjectProject != "" {

			if err := r.SetQueryParam("project.project", qProjectProject); err != nil {
				return err
			}
		}
	}

	if o.RunnerID != nil {

		// query param runner.id
		var qrRunnerID string

		if o.RunnerID != nil {
			qrRunnerID = *o.RunnerID
		}
		qRunnerID := qrRunnerID
		if qRunnerID != "" {

			if err := r.SetQueryParam("runner.id", qRunnerID); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
