// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointCreateHostname2Params creates a new WaypointCreateHostname2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointCreateHostname2Params() *WaypointCreateHostname2Params {
	return &WaypointCreateHostname2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointCreateHostname2ParamsWithTimeout creates a new WaypointCreateHostname2Params object
// with the ability to set a timeout on a request.
func NewWaypointCreateHostname2ParamsWithTimeout(timeout time.Duration) *WaypointCreateHostname2Params {
	return &WaypointCreateHostname2Params{
		timeout: timeout,
	}
}

// NewWaypointCreateHostname2ParamsWithContext creates a new WaypointCreateHostname2Params object
// with the ability to set a context for a request.
func NewWaypointCreateHostname2ParamsWithContext(ctx context.Context) *WaypointCreateHostname2Params {
	return &WaypointCreateHostname2Params{
		Context: ctx,
	}
}

// NewWaypointCreateHostname2ParamsWithHTTPClient creates a new WaypointCreateHostname2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointCreateHostname2ParamsWithHTTPClient(client *http.Client) *WaypointCreateHostname2Params {
	return &WaypointCreateHostname2Params{
		HTTPClient: client,
	}
}

/*
WaypointCreateHostname2Params contains all the parameters to send to the API endpoint

	for the waypoint create hostname2 operation.

	Typically these are written to a http.Request.
*/
type WaypointCreateHostname2Params struct {

	// Body.
	Body *models.HashicorpWaypointCreateHostnameRequest

	// TargetApplicationApplicationApplication.
	TargetApplicationApplicationApplication string

	// TargetApplicationApplicationProject.
	TargetApplicationApplicationProject string

	// TargetApplicationWorkspaceWorkspace.
	TargetApplicationWorkspaceWorkspace string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint create hostname2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCreateHostname2Params) WithDefaults() *WaypointCreateHostname2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint create hostname2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCreateHostname2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithTimeout(timeout time.Duration) *WaypointCreateHostname2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithContext(ctx context.Context) *WaypointCreateHostname2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithHTTPClient(client *http.Client) *WaypointCreateHostname2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithBody(body *models.HashicorpWaypointCreateHostnameRequest) *WaypointCreateHostname2Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetBody(body *models.HashicorpWaypointCreateHostnameRequest) {
	o.Body = body
}

// WithTargetApplicationApplicationApplication adds the targetApplicationApplicationApplication to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithTargetApplicationApplicationApplication(targetApplicationApplicationApplication string) *WaypointCreateHostname2Params {
	o.SetTargetApplicationApplicationApplication(targetApplicationApplicationApplication)
	return o
}

// SetTargetApplicationApplicationApplication adds the targetApplicationApplicationApplication to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetTargetApplicationApplicationApplication(targetApplicationApplicationApplication string) {
	o.TargetApplicationApplicationApplication = targetApplicationApplicationApplication
}

// WithTargetApplicationApplicationProject adds the targetApplicationApplicationProject to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithTargetApplicationApplicationProject(targetApplicationApplicationProject string) *WaypointCreateHostname2Params {
	o.SetTargetApplicationApplicationProject(targetApplicationApplicationProject)
	return o
}

// SetTargetApplicationApplicationProject adds the targetApplicationApplicationProject to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetTargetApplicationApplicationProject(targetApplicationApplicationProject string) {
	o.TargetApplicationApplicationProject = targetApplicationApplicationProject
}

// WithTargetApplicationWorkspaceWorkspace adds the targetApplicationWorkspaceWorkspace to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) WithTargetApplicationWorkspaceWorkspace(targetApplicationWorkspaceWorkspace string) *WaypointCreateHostname2Params {
	o.SetTargetApplicationWorkspaceWorkspace(targetApplicationWorkspaceWorkspace)
	return o
}

// SetTargetApplicationWorkspaceWorkspace adds the targetApplicationWorkspaceWorkspace to the waypoint create hostname2 params
func (o *WaypointCreateHostname2Params) SetTargetApplicationWorkspaceWorkspace(targetApplicationWorkspaceWorkspace string) {
	o.TargetApplicationWorkspaceWorkspace = targetApplicationWorkspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointCreateHostname2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param target.application.application.application
	if err := r.SetPathParam("target.application.application.application", o.TargetApplicationApplicationApplication); err != nil {
		return err
	}

	// path param target.application.application.project
	if err := r.SetPathParam("target.application.application.project", o.TargetApplicationApplicationProject); err != nil {
		return err
	}

	// path param target.application.workspace.workspace
	if err := r.SetPathParam("target.application.workspace.workspace", o.TargetApplicationWorkspaceWorkspace); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
