// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointCancelJobParams creates a new WaypointCancelJobParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointCancelJobParams() *WaypointCancelJobParams {
	return &WaypointCancelJobParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointCancelJobParamsWithTimeout creates a new WaypointCancelJobParams object
// with the ability to set a timeout on a request.
func NewWaypointCancelJobParamsWithTimeout(timeout time.Duration) *WaypointCancelJobParams {
	return &WaypointCancelJobParams{
		timeout: timeout,
	}
}

// NewWaypointCancelJobParamsWithContext creates a new WaypointCancelJobParams object
// with the ability to set a context for a request.
func NewWaypointCancelJobParamsWithContext(ctx context.Context) *WaypointCancelJobParams {
	return &WaypointCancelJobParams{
		Context: ctx,
	}
}

// NewWaypointCancelJobParamsWithHTTPClient creates a new WaypointCancelJobParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointCancelJobParamsWithHTTPClient(client *http.Client) *WaypointCancelJobParams {
	return &WaypointCancelJobParams{
		HTTPClient: client,
	}
}

/*
WaypointCancelJobParams contains all the parameters to send to the API endpoint

	for the waypoint cancel job operation.

	Typically these are written to a http.Request.
*/
type WaypointCancelJobParams struct {

	// Body.
	Body *models.HashicorpWaypointCancelJobRequest

	/* JobID.

	   The job to cancel
	*/
	JobID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint cancel job params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCancelJobParams) WithDefaults() *WaypointCancelJobParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint cancel job params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCancelJobParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint cancel job params
func (o *WaypointCancelJobParams) WithTimeout(timeout time.Duration) *WaypointCancelJobParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint cancel job params
func (o *WaypointCancelJobParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint cancel job params
func (o *WaypointCancelJobParams) WithContext(ctx context.Context) *WaypointCancelJobParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint cancel job params
func (o *WaypointCancelJobParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint cancel job params
func (o *WaypointCancelJobParams) WithHTTPClient(client *http.Client) *WaypointCancelJobParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint cancel job params
func (o *WaypointCancelJobParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint cancel job params
func (o *WaypointCancelJobParams) WithBody(body *models.HashicorpWaypointCancelJobRequest) *WaypointCancelJobParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint cancel job params
func (o *WaypointCancelJobParams) SetBody(body *models.HashicorpWaypointCancelJobRequest) {
	o.Body = body
}

// WithJobID adds the jobID to the waypoint cancel job params
func (o *WaypointCancelJobParams) WithJobID(jobID string) *WaypointCancelJobParams {
	o.SetJobID(jobID)
	return o
}

// SetJobID adds the jobId to the waypoint cancel job params
func (o *WaypointCancelJobParams) SetJobID(jobID string) {
	o.JobID = jobID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointCancelJobParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param job_id
	if err := r.SetPathParam("job_id", o.JobID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
