// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointRunnerAdoptionState Valid adoption states. The transitions allowed are:
//
// - ∅ => NEW
// - ∅ => PREADOPTED
// - NEW => PREADOPTED
// - * => ADOPTED
// - * => REJECTED
// - ADOPTED => NEW
// - REJECTED => NEW
//
// Both the "NEW" and "REJECTED" state are effectively "unadopted" states,
// but they're explicit about why they're not currently adopted. Both
// "ADOPTED" and "PREADOPTED" are adopted states where the runner will
// be given work, but are also explicit about how they were adopted.
//
//   - PENDING: New runner we've never seen before or has been forgotten.
//
// Runners in this state are pending adoption.
//   - PREADOPTED: Runner provided a valid runner token despite not being explicitly
//
// adopted. This type of runner can be forcibly rejected later such
// that pre-adoption doesn't work at all.
//   - ADOPTED: Explicitly adopted. Runner will get a token on handshake.
//   - REJECTED: Explicitly rejected. Runner will error immediately on startup.
//
// swagger:model hashicorp.waypoint.Runner.AdoptionState
type HashicorpWaypointRunnerAdoptionState string

func NewHashicorpWaypointRunnerAdoptionState(value HashicorpWaypointRunnerAdoptionState) *HashicorpWaypointRunnerAdoptionState {
	return &value
}

// Pointer returns a pointer to a freshly-allocated HashicorpWaypointRunnerAdoptionState.
func (m HashicorpWaypointRunnerAdoptionState) Pointer() *HashicorpWaypointRunnerAdoptionState {
	return &m
}

const (

	// HashicorpWaypointRunnerAdoptionStatePENDING captures enum value "PENDING"
	HashicorpWaypointRunnerAdoptionStatePENDING HashicorpWaypointRunnerAdoptionState = "PENDING"

	// HashicorpWaypointRunnerAdoptionStatePREADOPTED captures enum value "PREADOPTED"
	HashicorpWaypointRunnerAdoptionStatePREADOPTED HashicorpWaypointRunnerAdoptionState = "PREADOPTED"

	// HashicorpWaypointRunnerAdoptionStateADOPTED captures enum value "ADOPTED"
	HashicorpWaypointRunnerAdoptionStateADOPTED HashicorpWaypointRunnerAdoptionState = "ADOPTED"

	// HashicorpWaypointRunnerAdoptionStateREJECTED captures enum value "REJECTED"
	HashicorpWaypointRunnerAdoptionStateREJECTED HashicorpWaypointRunnerAdoptionState = "REJECTED"
)

// for schema
var hashicorpWaypointRunnerAdoptionStateEnum []interface{}

func init() {
	var res []HashicorpWaypointRunnerAdoptionState
	if err := json.Unmarshal([]byte(`["PENDING","PREADOPTED","ADOPTED","REJECTED"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashicorpWaypointRunnerAdoptionStateEnum = append(hashicorpWaypointRunnerAdoptionStateEnum, v)
	}
}

func (m HashicorpWaypointRunnerAdoptionState) validateHashicorpWaypointRunnerAdoptionStateEnum(path, location string, value HashicorpWaypointRunnerAdoptionState) error {
	if err := validate.EnumCase(path, location, value, hashicorpWaypointRunnerAdoptionStateEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this hashicorp waypoint runner adoption state
func (m HashicorpWaypointRunnerAdoptionState) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateHashicorpWaypointRunnerAdoptionStateEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this hashicorp waypoint runner adoption state based on context it is used
func (m HashicorpWaypointRunnerAdoptionState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
