// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointRunTriggerRequest hashicorp waypoint run trigger request
//
// swagger:model hashicorp.waypoint.RunTriggerRequest
type HashicorpWaypointRunTriggerRequest struct {

	// The trigger ref to execute
	Ref *HashicorpWaypointRefTrigger `json:"ref,omitempty"`

	// This is an optional array of HCL variable overrides that can be set
	// when requesting a trigger to execute. Currently, RunTrigger only supports
	// setting CLI level config vars, which take the top level of presidence
	VariableOverrides []*HashicorpWaypointVariable `json:"variable_overrides"`
}

// Validate validates this hashicorp waypoint run trigger request
func (m *HashicorpWaypointRunTriggerRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRef(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariableOverrides(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunTriggerRequest) validateRef(formats strfmt.Registry) error {
	if swag.IsZero(m.Ref) { // not required
		return nil
	}

	if m.Ref != nil {
		if err := m.Ref.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ref")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRunTriggerRequest) validateVariableOverrides(formats strfmt.Registry) error {
	if swag.IsZero(m.VariableOverrides) { // not required
		return nil
	}

	for i := 0; i < len(m.VariableOverrides); i++ {
		if swag.IsZero(m.VariableOverrides[i]) { // not required
			continue
		}

		if m.VariableOverrides[i] != nil {
			if err := m.VariableOverrides[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_overrides" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_overrides" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint run trigger request based on the context it is used
func (m *HashicorpWaypointRunTriggerRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRef(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableOverrides(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunTriggerRequest) contextValidateRef(ctx context.Context, formats strfmt.Registry) error {

	if m.Ref != nil {
		if err := m.Ref.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ref")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRunTriggerRequest) contextValidateVariableOverrides(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VariableOverrides); i++ {

		if m.VariableOverrides[i] != nil {
			if err := m.VariableOverrides[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_overrides" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_overrides" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointRunTriggerRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointRunTriggerRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointRunTriggerRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
