// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointRunPipelineResponse hashicorp waypoint run pipeline response
//
// swagger:model hashicorp.waypoint.RunPipelineResponse
type HashicorpWaypointRunPipelineResponse struct {

	// All job IDs are the list of all jobs that were queued for this pipeline.
	// They are in topologically sorted order. This means that a job's dependencies
	// are guaranteed to be satisfied by previous jobs in the list, but all
	// previous jobs may not be necessary. This is because two jobs may be
	// totally independent of each other and can execute concurrently. To get
	// a better view, a graph should be built using step dependencies, and
	// the job IDs can be correlated using the job_map field.
	AllJobIds []string `json:"all_job_ids"`

	// The root job of the pipeline.
	JobID string `json:"job_id,omitempty"`

	// This provides a lookup from job ID to what step and pipeline a job
	// corresponds to. Note that some jobs may correspond to pipelines other
	// than the initial pipeline if nested pipelines are used.
	JobMap map[string]HashicorpWaypointRefPipelineStep `json:"job_map,omitempty"`

	// sequence
	Sequence string `json:"sequence,omitempty"`
}

// Validate validates this hashicorp waypoint run pipeline response
func (m *HashicorpWaypointRunPipelineResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJobMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunPipelineResponse) validateJobMap(formats strfmt.Registry) error {
	if swag.IsZero(m.JobMap) { // not required
		return nil
	}

	for k := range m.JobMap {

		if err := validate.Required("job_map"+"."+k, "body", m.JobMap[k]); err != nil {
			return err
		}
		if val, ok := m.JobMap[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("job_map" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("job_map" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint run pipeline response based on the context it is used
func (m *HashicorpWaypointRunPipelineResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJobMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRunPipelineResponse) contextValidateJobMap(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.JobMap {

		if val, ok := m.JobMap[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointRunPipelineResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointRunPipelineResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointRunPipelineResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
