// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointJobDataSource hashicorp waypoint job data source
//
// swagger:model hashicorp.waypoint.Job.DataSource
type HashicorpWaypointJobDataSource struct {

	// git will check out the data from a Git repository.
	Git *HashicorpWaypointJobGit `json:"git,omitempty"`

	// local means the runner has access to the data locally and will
	// know what to do. This is primarily only useful if the target_runner
	// is a specific runner and should not be used by any runner unless your
	// runners are configured to have access to the proper data.
	Local HashicorpWaypointJobLocal `json:"local,omitempty"`

	// remote means that the Waypoint server has special logic for how to
	// fetch the data.
	Remote *HashicorpWaypointJobRemote `json:"remote,omitempty"`
}

// Validate validates this hashicorp waypoint job data source
func (m *HashicorpWaypointJobDataSource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobDataSource) validateGit(formats strfmt.Registry) error {
	if swag.IsZero(m.Git) { // not required
		return nil
	}

	if m.Git != nil {
		if err := m.Git.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("git")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("git")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJobDataSource) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(m.Remote) { // not required
		return nil
	}

	if m.Remote != nil {
		if err := m.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint job data source based on the context it is used
func (m *HashicorpWaypointJobDataSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobDataSource) contextValidateGit(ctx context.Context, formats strfmt.Registry) error {

	if m.Git != nil {
		if err := m.Git.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("git")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("git")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJobDataSource) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if m.Remote != nil {
		if err := m.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointJobDataSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointJobDataSource) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointJobDataSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
