// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointJob A Job is a job that executes on a runner and is queued by QueueOperation.
//
// swagger:model hashicorp.waypoint.Job
type HashicorpWaypointJob struct {

	// ack time
	// Format: date-time
	AckTime strfmt.DateTime `json:"ack_time,omitempty"`

	// The application to target for the operation. Some operations may allow
	// certain fields of this to be empty, so check with the operation
	// documentation to determine what needs to be set. Generally, project
	// must be set.
	// This is required.
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`

	// assign time
	// Format: date-time
	AssignTime strfmt.DateTime `json:"assign_time,omitempty"`

	// The runner that was assigned to execute this job. Note that the
	// runner may have been ephemeral and may no longer exist.
	AssignedRunner *HashicorpWaypointRefRunnerID `json:"assigned_runner,omitempty"`

	// auth
	Auth *HashicorpWaypointJobAuthOp `json:"auth,omitempty"`

	// build
	Build *HashicorpWaypointJobBuildOp `json:"build,omitempty"`

	// cancel time is the time that cancellation of this job was requested.
	// If this is zero then this job was not cancelled. Note that this is the
	// cancellation _request_ time. The actual time a job ended is noted by
	// the complete_time field.
	// Format: date-time
	CancelTime strfmt.DateTime `json:"cancel_time,omitempty"`

	// complete time
	// Format: date-time
	CompleteTime strfmt.DateTime `json:"complete_time,omitempty"`

	// Config is information about the Waypoint configuration (waypoint.hcl)
	// for this job. This is only available once the configuration is loaded.
	// If this is nil and the job is RUNNING, then it may not be loaded yet.
	// API users can wait on the Job event on the JobStream to listen for
	// job updates.
	Config *HashicorpWaypointJobConfig `json:"config,omitempty"`

	// config sync
	ConfigSync HashicorpWaypointJobConfigSyncOp `json:"config_sync,omitempty"`

	// data_source determines where the data to operate on (such as the
	// application source code and Waypoint configuration) comes from.
	// If this is not set then QueueJob will populate this if a default
	// data source is configured for the target project.
	//
	// The overrides will set overrides of configs for the data source. This is
	// data source dependent but this allows for example setting the Git ref
	// without knowing the full data source. Invalid overrides will fail the
	// job.
	// Ergo, this is optional.
	DataSource *HashicorpWaypointJobDataSource `json:"data_source,omitempty"`

	// data source overrides
	DataSourceOverrides map[string]string `json:"data_source_overrides,omitempty"`

	// Ref of the data was fetched for this job. This is available after
	// the Ref event is sent down by GetJobStream. This is NOT used to specify
	// the ref that should be downloaded. That level of configuration should be
	// exposed via the data_source parameter itself.
	DataSourceRef *HashicorpWaypointJobDataSourceRef `json:"data_source_ref,omitempty"`

	// List of IDs that this job depends on. This job will not be allowed to
	// leave the QUEUED state until jobs with these IDs are successfully
	// completed (SUCESS state). If any dependent jobs enter a terminal state
	// that is not SUCCESS, this job will transition to ERROR.
	//
	// These IDs MUST already be registered jobs. It is an error to depend
	// on a non-existent job.
	DependsOn []string `json:"depends_on"`

	// List of IDs that are in depends_on that are ignored if they error.
	// Normally, when a dependency fails, this job also fails. If the ID
	// is specified in both depends_on AND here, then the dependency is
	// allowed to fail and this task will still run. This is good for jobs
	// that should run no matter what.
	//
	// All IDs in this value must ALSO be present in "depends_on". This field
	// only specifies which of those values can fail.
	DependsOnAllowFailure []string `json:"depends_on_allow_failure"`

	// deploy
	Deploy *HashicorpWaypointJobDeployOp `json:"deploy,omitempty"`

	// destroy
	Destroy *HashicorpWaypointJobDestroyOp `json:"destroy,omitempty"`

	// destroy project
	DestroyProject *HashicorpWaypointJobDestroyProjectOp `json:"destroy_project,omitempty"`

	// docs
	Docs HashicorpWaypointJobDocsOp `json:"docs,omitempty"`

	// error is set if state == ERROR
	Error *GoogleRPCStatus `json:"error,omitempty"`

	// exec
	Exec *HashicorpWaypointJobExecOp `json:"exec,omitempty"`

	// expire time is the time when this job would expire. If this isn't set
	// then this is a non-expiring job. This will remain set even if the job
	// never expired because it was accepted and run. This field can be used
	// to detect that it was configured to expire.
	// Format: date-time
	ExpireTime strfmt.DateTime `json:"expire_time,omitempty"`

	// id of the job. This is generated on the server side when queued. If
	// you are queueing a job, this must be empty or unset.
	ID string `json:"id,omitempty"`

	// init
	Init HashicorpWaypointJobInitOp `json:"init,omitempty"`

	// Labels are the labels to set for this operation.
	// This is optional.
	Labels map[string]string `json:"labels,omitempty"`

	// logs
	Logs *HashicorpWaypointJobLogsOp `json:"logs,omitempty"`

	// noop
	Noop HashicorpWaypointJobNoop `json:"noop,omitempty"`

	// If target_runner is Any and this is set, the job will be executed
	// on an ODR spawned from this config.
	OndemandRunner *HashicorpWaypointRefOnDemandRunnerConfig `json:"ondemand_runner,omitempty"`

	// This is optional and overrides the task that is used by the on-demand
	// runner. This requires ODR to exist since the ODR system is used to
	// launch tasks. If an ODR config is not available, queueing this job will
	// fail.
	//
	// This can be used to run custom runner binaries or custom tasks without
	// a runner.
	OndemandRunnerTask *HashicorpWaypointJobTaskOverride `json:"ondemand_runner_task,omitempty"`

	// PipelineStep is a reference to the pipeline and step that might have triggered this job.
	// If the PipelineStep is nil, this job was not initiated by a pipeline.
	// If the Pipeline Ref is set, this job is part of the referenced pipeline.
	Pipeline *HashicorpWaypointRefPipelineStep `json:"pipeline,omitempty"`

	// pipeline step
	PipelineStep *HashicorpWaypointJobPipelineStepOp `json:"pipeline_step,omitempty"`

	// poll
	Poll HashicorpWaypointJobPollOp `json:"poll,omitempty"`

	// push
	Push *HashicorpWaypointJobPushOp `json:"push,omitempty"`

	// queue project
	QueueProject *HashicorpWaypointJobQueueProjectOp `json:"queue_project,omitempty"`

	// The time when the job was queued.
	// Format: date-time
	QueueTime strfmt.DateTime `json:"queue_time,omitempty"`

	// release
	Release *HashicorpWaypointJobReleaseOp `json:"release,omitempty"`

	// result is set based on the operation specified. A nil result is possible
	// for some operations.
	Result *HashicorpWaypointJobResult `json:"result,omitempty"`

	// If this is set, then only one job with this singleton_id may exist
	// at any point in the QUEUED state. If QueueJob is called with this set
	// and an existing job is already queued with a matching singleton_id,
	// that job will be overwritten with this job.
	// This is optional.
	SingletonID string `json:"singleton_id,omitempty"`

	// start task
	StartTask *HashicorpWaypointJobStartTaskLaunchOp `json:"start_task,omitempty"`

	// state of the job
	State *HashicorpWaypointJobState `json:"state,omitempty"`

	// status report
	StatusReport *HashicorpWaypointJobStatusReportOp `json:"status_report,omitempty"`

	// stop task
	StopTask *HashicorpWaypointJobStopTaskLaunchOp `json:"stop_task,omitempty"`

	// The runner that should execute this job.
	// This is required.
	TargetRunner *HashicorpWaypointRefRunner `json:"target_runner,omitempty"`

	// task is a reference to a given Task that this job might be apart of. If
	// the task is Nil, it means the server does not associate this job with
	// an on-demand runner task. If the Task Ref is set, that means this job
	// is part of the referenced task id.
	Task *HashicorpWaypointRefTask `json:"task,omitempty"`

	// up
	Up *HashicorpWaypointJobUpOp `json:"up,omitempty"`

	// validate
	Validate HashicorpWaypointJobValidateOp `json:"validate,omitempty"`

	// Variable refs store the final value used on the operation for each variable
	// defined in the waypoint.hcl. Any variables with `sensitive` set in the
	// waypoint.hcl will have a value hashed with SHA256 so the user can verify
	// the value used.
	VariableFinalValues map[string]HashicorpWaypointVariableFinalValue `json:"variable_final_values,omitempty"`

	// variables store the key/value pairs of parsed variables; the parse
	// prior to running a job only verifies syntax correctness. Verifying type
	// checks and the presence of required values will both need to be done
	// in the job's validation
	Variables []*HashicorpWaypointVariable `json:"variables"`

	// watch task
	WatchTask *HashicorpWaypointJobWatchTaskOp `json:"watch_task,omitempty"`

	// Waypoint.hcl file contents. This is OPTIONAL and not typically supplied.
	// If this is not provided, the job will source the waypoint.hcl file
	// from the server or the data source. This can be used to override those
	// and force a specific waypoint.hcl to be used.
	WaypointHcl *HashicorpWaypointHcl `json:"waypoint_hcl,omitempty"`

	// The workspace to perform the operation in.
	// This is required.
	Workspace *HashicorpWaypointRefWorkspace `json:"workspace,omitempty"`
}

// SwaggerValidate validates this hashicorp waypoint job
func (m *HashicorpWaypointJob) SwaggerValidate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAckTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAssignTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAssignedRunner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuth(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBuild(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCancelTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCompleteTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataSourceRef(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeploy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestroy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestroyProject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExec(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpireTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLogs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOndemandRunner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOndemandRunnerTask(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePipeline(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePipelineStep(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePush(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQueueProject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQueueTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelease(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResult(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartTask(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusReport(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopTask(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTargetRunner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTask(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariableFinalValues(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariables(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatchTask(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWaypointHcl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJob) validateAckTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AckTime) { // not required
		return nil
	}

	if err := validate.FormatOf("ack_time", "body", "date-time", m.AckTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointJob) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateAssignTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AssignTime) { // not required
		return nil
	}

	if err := validate.FormatOf("assign_time", "body", "date-time", m.AssignTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointJob) validateAssignedRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.AssignedRunner) { // not required
		return nil
	}

	if m.AssignedRunner != nil {
		if err := m.AssignedRunner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("assigned_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("assigned_runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateAuth(formats strfmt.Registry) error {
	if swag.IsZero(m.Auth) { // not required
		return nil
	}

	if m.Auth != nil {
		if err := m.Auth.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("auth")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("auth")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateBuild(formats strfmt.Registry) error {
	if swag.IsZero(m.Build) { // not required
		return nil
	}

	if m.Build != nil {
		if err := m.Build.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateCancelTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CancelTime) { // not required
		return nil
	}

	if err := validate.FormatOf("cancel_time", "body", "date-time", m.CancelTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointJob) validateCompleteTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CompleteTime) { // not required
		return nil
	}

	if err := validate.FormatOf("complete_time", "body", "date-time", m.CompleteTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointJob) validateConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.Config) { // not required
		return nil
	}

	if m.Config != nil {
		if err := m.Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateDataSource(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSource) { // not required
		return nil
	}

	if m.DataSource != nil {
		if err := m.DataSource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateDataSourceRef(formats strfmt.Registry) error {
	if swag.IsZero(m.DataSourceRef) { // not required
		return nil
	}

	if m.DataSourceRef != nil {
		if err := m.DataSourceRef.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source_ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source_ref")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateDeploy(formats strfmt.Registry) error {
	if swag.IsZero(m.Deploy) { // not required
		return nil
	}

	if m.Deploy != nil {
		if err := m.Deploy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deploy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deploy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateDestroy(formats strfmt.Registry) error {
	if swag.IsZero(m.Destroy) { // not required
		return nil
	}

	if m.Destroy != nil {
		if err := m.Destroy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destroy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destroy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateDestroyProject(formats strfmt.Registry) error {
	if swag.IsZero(m.DestroyProject) { // not required
		return nil
	}

	if m.DestroyProject != nil {
		if err := m.DestroyProject.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destroy_project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destroy_project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateExec(formats strfmt.Registry) error {
	if swag.IsZero(m.Exec) { // not required
		return nil
	}

	if m.Exec != nil {
		if err := m.Exec.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("exec")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("exec")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateExpireTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpireTime) { // not required
		return nil
	}

	if err := validate.FormatOf("expire_time", "body", "date-time", m.ExpireTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointJob) validateLogs(formats strfmt.Registry) error {
	if swag.IsZero(m.Logs) { // not required
		return nil
	}

	if m.Logs != nil {
		if err := m.Logs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("logs")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("logs")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateOndemandRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.OndemandRunner) { // not required
		return nil
	}

	if m.OndemandRunner != nil {
		if err := m.OndemandRunner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ondemand_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ondemand_runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateOndemandRunnerTask(formats strfmt.Registry) error {
	if swag.IsZero(m.OndemandRunnerTask) { // not required
		return nil
	}

	if m.OndemandRunnerTask != nil {
		if err := m.OndemandRunnerTask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ondemand_runner_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ondemand_runner_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validatePipeline(formats strfmt.Registry) error {
	if swag.IsZero(m.Pipeline) { // not required
		return nil
	}

	if m.Pipeline != nil {
		if err := m.Pipeline.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validatePipelineStep(formats strfmt.Registry) error {
	if swag.IsZero(m.PipelineStep) { // not required
		return nil
	}

	if m.PipelineStep != nil {
		if err := m.PipelineStep.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline_step")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline_step")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validatePush(formats strfmt.Registry) error {
	if swag.IsZero(m.Push) { // not required
		return nil
	}

	if m.Push != nil {
		if err := m.Push.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("push")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("push")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateQueueProject(formats strfmt.Registry) error {
	if swag.IsZero(m.QueueProject) { // not required
		return nil
	}

	if m.QueueProject != nil {
		if err := m.QueueProject.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("queue_project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("queue_project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateQueueTime(formats strfmt.Registry) error {
	if swag.IsZero(m.QueueTime) { // not required
		return nil
	}

	if err := validate.FormatOf("queue_time", "body", "date-time", m.QueueTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointJob) validateRelease(formats strfmt.Registry) error {
	if swag.IsZero(m.Release) { // not required
		return nil
	}

	if m.Release != nil {
		if err := m.Release.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateResult(formats strfmt.Registry) error {
	if swag.IsZero(m.Result) { // not required
		return nil
	}

	if m.Result != nil {
		if err := m.Result.SwaggerValidate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("result")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateStartTask(formats strfmt.Registry) error {
	if swag.IsZero(m.StartTask) { // not required
		return nil
	}

	if m.StartTask != nil {
		if err := m.StartTask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("start_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("start_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateStatusReport(formats strfmt.Registry) error {
	if swag.IsZero(m.StatusReport) { // not required
		return nil
	}

	if m.StatusReport != nil {
		if err := m.StatusReport.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateStopTask(formats strfmt.Registry) error {
	if swag.IsZero(m.StopTask) { // not required
		return nil
	}

	if m.StopTask != nil {
		if err := m.StopTask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stop_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stop_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateTargetRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.TargetRunner) { // not required
		return nil
	}

	if m.TargetRunner != nil {
		if err := m.TargetRunner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target_runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateTask(formats strfmt.Registry) error {
	if swag.IsZero(m.Task) { // not required
		return nil
	}

	if m.Task != nil {
		if err := m.Task.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateUp(formats strfmt.Registry) error {
	if swag.IsZero(m.Up) { // not required
		return nil
	}

	if m.Up != nil {
		if err := m.Up.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("up")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("up")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateVariableFinalValues(formats strfmt.Registry) error {
	if swag.IsZero(m.VariableFinalValues) { // not required
		return nil
	}

	for k := range m.VariableFinalValues {

		if err := validate.Required("variable_final_values"+"."+k, "body", m.VariableFinalValues[k]); err != nil {
			return err
		}
		if val, ok := m.VariableFinalValues[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_final_values" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_final_values" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointJob) validateVariables(formats strfmt.Registry) error {
	if swag.IsZero(m.Variables) { // not required
		return nil
	}

	for i := 0; i < len(m.Variables); i++ {
		if swag.IsZero(m.Variables[i]) { // not required
			continue
		}

		if m.Variables[i] != nil {
			if err := m.Variables[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointJob) validateWatchTask(formats strfmt.Registry) error {
	if swag.IsZero(m.WatchTask) { // not required
		return nil
	}

	if m.WatchTask != nil {
		if err := m.WatchTask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("watch_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("watch_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateWaypointHcl(formats strfmt.Registry) error {
	if swag.IsZero(m.WaypointHcl) { // not required
		return nil
	}

	if m.WaypointHcl != nil {
		if err := m.WaypointHcl.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypoint_hcl")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypoint_hcl")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint job based on the context it is used
func (m *HashicorpWaypointJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAssignedRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAuth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBuild(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataSourceRef(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeploy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestroy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestroyProject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExec(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOndemandRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOndemandRunnerTask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePipeline(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePipelineStep(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePush(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQueueProject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResult(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartTask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatusReport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopTask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTargetRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableFinalValues(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariables(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatchTask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWaypointHcl(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJob) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateAssignedRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.AssignedRunner != nil {
		if err := m.AssignedRunner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("assigned_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("assigned_runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateAuth(ctx context.Context, formats strfmt.Registry) error {

	if m.Auth != nil {
		if err := m.Auth.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("auth")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("auth")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateBuild(ctx context.Context, formats strfmt.Registry) error {

	if m.Build != nil {
		if err := m.Build.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.Config != nil {
		if err := m.Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateDataSource(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSource != nil {
		if err := m.DataSource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateDataSourceRef(ctx context.Context, formats strfmt.Registry) error {

	if m.DataSourceRef != nil {
		if err := m.DataSourceRef.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_source_ref")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("data_source_ref")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateDeploy(ctx context.Context, formats strfmt.Registry) error {

	if m.Deploy != nil {
		if err := m.Deploy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deploy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deploy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateDestroy(ctx context.Context, formats strfmt.Registry) error {

	if m.Destroy != nil {
		if err := m.Destroy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destroy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destroy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateDestroyProject(ctx context.Context, formats strfmt.Registry) error {

	if m.DestroyProject != nil {
		if err := m.DestroyProject.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destroy_project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destroy_project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateExec(ctx context.Context, formats strfmt.Registry) error {

	if m.Exec != nil {
		if err := m.Exec.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("exec")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("exec")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateLogs(ctx context.Context, formats strfmt.Registry) error {

	if m.Logs != nil {
		if err := m.Logs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("logs")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("logs")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateOndemandRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.OndemandRunner != nil {
		if err := m.OndemandRunner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ondemand_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ondemand_runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateOndemandRunnerTask(ctx context.Context, formats strfmt.Registry) error {

	if m.OndemandRunnerTask != nil {
		if err := m.OndemandRunnerTask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ondemand_runner_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ondemand_runner_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidatePipeline(ctx context.Context, formats strfmt.Registry) error {

	if m.Pipeline != nil {
		if err := m.Pipeline.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidatePipelineStep(ctx context.Context, formats strfmt.Registry) error {

	if m.PipelineStep != nil {
		if err := m.PipelineStep.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pipeline_step")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pipeline_step")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidatePush(ctx context.Context, formats strfmt.Registry) error {

	if m.Push != nil {
		if err := m.Push.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("push")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("push")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateQueueProject(ctx context.Context, formats strfmt.Registry) error {

	if m.QueueProject != nil {
		if err := m.QueueProject.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("queue_project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("queue_project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateRelease(ctx context.Context, formats strfmt.Registry) error {

	if m.Release != nil {
		if err := m.Release.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateResult(ctx context.Context, formats strfmt.Registry) error {

	if m.Result != nil {
		if err := m.Result.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("result")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateStartTask(ctx context.Context, formats strfmt.Registry) error {

	if m.StartTask != nil {
		if err := m.StartTask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("start_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("start_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateStatusReport(ctx context.Context, formats strfmt.Registry) error {

	if m.StatusReport != nil {
		if err := m.StatusReport.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateStopTask(ctx context.Context, formats strfmt.Registry) error {

	if m.StopTask != nil {
		if err := m.StopTask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stop_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stop_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateTargetRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.TargetRunner != nil {
		if err := m.TargetRunner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target_runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target_runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateTask(ctx context.Context, formats strfmt.Registry) error {

	if m.Task != nil {
		if err := m.Task.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateUp(ctx context.Context, formats strfmt.Registry) error {

	if m.Up != nil {
		if err := m.Up.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("up")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("up")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateVariableFinalValues(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.VariableFinalValues {

		if val, ok := m.VariableFinalValues[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateVariables(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Variables); i++ {

		if m.Variables[i] != nil {
			if err := m.Variables[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variables" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variables" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateWatchTask(ctx context.Context, formats strfmt.Registry) error {

	if m.WatchTask != nil {
		if err := m.WatchTask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("watch_task")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("watch_task")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateWaypointHcl(ctx context.Context, formats strfmt.Registry) error {

	if m.WaypointHcl != nil {
		if err := m.WaypointHcl.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypoint_hcl")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypoint_hcl")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointJob) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointJob) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
