// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointInviteTokenRequest Passed with GenerateInviteToken with the params on how the invite token should
// be generate.
//
// swagger:model hashicorp.waypoint.InviteTokenRequest
type HashicorpWaypointInviteTokenRequest struct {

	// How long the token should be valid until. The resulting token has a timestamp
	// encoded within it by adding the current time to this duration.
	Duration string `json:"duration,omitempty"`

	// login is the login information you want this token exchange for. All fields
	// can be set (including logging in as another user as long as the requesting
	// user has permission). If this is a signup invite token, the "user_id"
	// will be ignored.
	Login *HashicorpWaypointTokenLogin `json:"login,omitempty"`

	// signup, if non-nil, will exchange this invite token for new user accounts.
	// The signup structure can be used to hint for the username. This must be
	// non-nil for this to be a signup token for new accounts.
	Signup *HashicorpWaypointTokenInviteSignup `json:"signup,omitempty"`

	// Old field, used only for backwards compatibility. If this is set,
	// the old behavior will be followed. If you don't know what that is,
	// then do not use this field.
	UnusedEntrypoint *HashicorpWaypointTokenEntrypoint `json:"unused_entrypoint,omitempty"`
}

// Validate validates this hashicorp waypoint invite token request
func (m *HashicorpWaypointInviteTokenRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLogin(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSignup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnusedEntrypoint(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointInviteTokenRequest) validateLogin(formats strfmt.Registry) error {
	if swag.IsZero(m.Login) { // not required
		return nil
	}

	if m.Login != nil {
		if err := m.Login.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("login")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("login")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointInviteTokenRequest) validateSignup(formats strfmt.Registry) error {
	if swag.IsZero(m.Signup) { // not required
		return nil
	}

	if m.Signup != nil {
		if err := m.Signup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("signup")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("signup")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointInviteTokenRequest) validateUnusedEntrypoint(formats strfmt.Registry) error {
	if swag.IsZero(m.UnusedEntrypoint) { // not required
		return nil
	}

	if m.UnusedEntrypoint != nil {
		if err := m.UnusedEntrypoint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unused_entrypoint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("unused_entrypoint")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint invite token request based on the context it is used
func (m *HashicorpWaypointInviteTokenRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSignup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnusedEntrypoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointInviteTokenRequest) contextValidateLogin(ctx context.Context, formats strfmt.Registry) error {

	if m.Login != nil {
		if err := m.Login.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("login")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("login")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointInviteTokenRequest) contextValidateSignup(ctx context.Context, formats strfmt.Registry) error {

	if m.Signup != nil {
		if err := m.Signup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("signup")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("signup")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointInviteTokenRequest) contextValidateUnusedEntrypoint(ctx context.Context, formats strfmt.Registry) error {

	if m.UnusedEntrypoint != nil {
		if err := m.UnusedEntrypoint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unused_entrypoint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("unused_entrypoint")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointInviteTokenRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointInviteTokenRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointInviteTokenRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
