// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointGetOIDCAuthURLRequest hashicorp waypoint get o ID c auth URL request
//
// swagger:model hashicorp.waypoint.GetOIDCAuthURLRequest
type HashicorpWaypointGetOIDCAuthURLRequest struct {

	// OIDC auth method to use
	AuthMethod *HashicorpWaypointRefAuthMethod `json:"auth_method,omitempty"`

	// Nonce is a randomly generated string to prevent replay attacks.
	// It is up to the client to generate this. This must then be passed
	// back to CompleteOIDCAuthRequest.
	Nonce string `json:"nonce,omitempty"`

	// The URL that authorization should redirect to.
	RedirectURI string `json:"redirect_uri,omitempty"`
}

// Validate validates this hashicorp waypoint get o ID c auth URL request
func (m *HashicorpWaypointGetOIDCAuthURLRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthMethod(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointGetOIDCAuthURLRequest) validateAuthMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthMethod) { // not required
		return nil
	}

	if m.AuthMethod != nil {
		if err := m.AuthMethod.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("auth_method")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("auth_method")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint get o ID c auth URL request based on the context it is used
func (m *HashicorpWaypointGetOIDCAuthURLRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuthMethod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointGetOIDCAuthURLRequest) contextValidateAuthMethod(ctx context.Context, formats strfmt.Registry) error {

	if m.AuthMethod != nil {
		if err := m.AuthMethod.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("auth_method")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("auth_method")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointGetOIDCAuthURLRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointGetOIDCAuthURLRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointGetOIDCAuthURLRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
