// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointGeneration Generation is a shared message type used by operations to denote the
// "generation" they're a part of. A generation denotes whether shared
// physical resources were used or whether new resources were created.
// Another way to conceptualize generations: immutable deployment models
// will create new generations each operation, whereas mutable models will
// reuse a generation.
//
// The concept of a "Generation" was introduced in Waypoint 0.4. Operations
// from earlier versions will have nil generations and callers must handle
// that scenario.
//
// == Read/Write Notes
//
// Callers inserting operations should ONLY set the generation ID. Remaining
// fields will be automatically populated.
//
// Updates should never modify the generation.
//
// swagger:model hashicorp.waypoint.Generation
type HashicorpWaypointGeneration struct {

	// Id is the unique identifier for this generation. This value is opaque.
	// Waypoint internally only requires that two different generations have
	// two different IDs. The format of the value can be anything.
	ID string `json:"id,omitempty"`

	// This is the sequence number of the first operation that introduced
	// this generation. Once all operations using a sequence number are fully
	// destroyed, a reused generation will introduce a new sequence number.
	//
	// This should not be manually set. This value will be automatically
	// populated on insert. Updates should not modify this value.
	//
	// Consumers can compare this to the sequence number of the operation
	// to determine if this generation is new or existing.
	InitialSequence string `json:"initial_sequence,omitempty"`
}

// Validate validates this hashicorp waypoint generation
func (m *HashicorpWaypointGeneration) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this hashicorp waypoint generation based on context it is used
func (m *HashicorpWaypointGeneration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointGeneration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointGeneration) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointGeneration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
