// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointExecStreamRequestStart hashicorp waypoint exec stream request start
//
// swagger:model hashicorp.waypoint.ExecStreamRequest.Start
type HashicorpWaypointExecStreamRequestStart struct {

	// Args including the command at args[0] to execute.
	Args []string `json:"args"`

	// Deployment to exec into
	DeploymentID string `json:"deployment_id,omitempty"`

	// Instance to send the exec request to. This is indicates that
	// the client wants an exec session to this specific instance,
	// rather than one the server picks. Targeted instances can be
	// any instance type, where as untargeted have to be LONG_RUNNING.
	InstanceID string `json:"instance_id,omitempty"`

	// Pty is set if we should allocate a PTY for this exec stream.
	Pty *HashicorpWaypointExecStreamRequestPTY `json:"pty,omitempty"`
}

// Validate validates this hashicorp waypoint exec stream request start
func (m *HashicorpWaypointExecStreamRequestStart) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePty(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointExecStreamRequestStart) validatePty(formats strfmt.Registry) error {
	if swag.IsZero(m.Pty) { // not required
		return nil
	}

	if m.Pty != nil {
		if err := m.Pty.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pty")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pty")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint exec stream request start based on the context it is used
func (m *HashicorpWaypointExecStreamRequestStart) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePty(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointExecStreamRequestStart) contextValidatePty(ctx context.Context, formats strfmt.Registry) error {

	if m.Pty != nil {
		if err := m.Pty.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pty")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pty")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointExecStreamRequestStart) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointExecStreamRequestStart) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointExecStreamRequestStart
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
