// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetPipeline2Reader is a Reader for the WaypointGetPipeline2 structure.
type WaypointGetPipeline2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetPipeline2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetPipeline2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetPipeline2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetPipeline2OK creates a WaypointGetPipeline2OK with default headers values
func NewWaypointGetPipeline2OK() *WaypointGetPipeline2OK {
	return &WaypointGetPipeline2OK{}
}

/*
WaypointGetPipeline2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetPipeline2OK struct {
	Payload *models.HashicorpWaypointGetPipelineResponse
}

// IsSuccess returns true when this waypoint get pipeline2 o k response has a 2xx status code
func (o *WaypointGetPipeline2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get pipeline2 o k response has a 3xx status code
func (o *WaypointGetPipeline2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get pipeline2 o k response has a 4xx status code
func (o *WaypointGetPipeline2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get pipeline2 o k response has a 5xx status code
func (o *WaypointGetPipeline2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get pipeline2 o k response a status code equal to that given
func (o *WaypointGetPipeline2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetPipeline2OK) Error() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}][%d] waypointGetPipeline2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetPipeline2OK) String() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}][%d] waypointGetPipeline2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetPipeline2OK) GetPayload() *models.HashicorpWaypointGetPipelineResponse {
	return o.Payload
}

func (o *WaypointGetPipeline2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetPipelineResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetPipeline2Default creates a WaypointGetPipeline2Default with default headers values
func NewWaypointGetPipeline2Default(code int) *WaypointGetPipeline2Default {
	return &WaypointGetPipeline2Default{
		_statusCode: code,
	}
}

/*
WaypointGetPipeline2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetPipeline2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get pipeline2 default response
func (o *WaypointGetPipeline2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get pipeline2 default response has a 2xx status code
func (o *WaypointGetPipeline2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get pipeline2 default response has a 3xx status code
func (o *WaypointGetPipeline2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get pipeline2 default response has a 4xx status code
func (o *WaypointGetPipeline2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get pipeline2 default response has a 5xx status code
func (o *WaypointGetPipeline2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get pipeline2 default response a status code equal to that given
func (o *WaypointGetPipeline2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetPipeline2Default) Error() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}][%d] Waypoint_GetPipeline2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetPipeline2Default) String() string {
	return fmt.Sprintf("[GET /pipeline/{pipeline.id}][%d] Waypoint_GetPipeline2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetPipeline2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetPipeline2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
