// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetLogStream3Reader is a Reader for the WaypointGetLogStream3 structure.
type WaypointGetLogStream3Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetLogStream3Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetLogStream3OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetLogStream3Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetLogStream3OK creates a WaypointGetLogStream3OK with default headers values
func NewWaypointGetLogStream3OK() *WaypointGetLogStream3OK {
	return &WaypointGetLogStream3OK{}
}

/*
WaypointGetLogStream3OK describes a response with status code 200, with default header values.

A successful response.(streaming responses)
*/
type WaypointGetLogStream3OK struct {
	Payload *WaypointGetLogStream3OKBody
}

// IsSuccess returns true when this waypoint get log stream3 o k response has a 2xx status code
func (o *WaypointGetLogStream3OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get log stream3 o k response has a 3xx status code
func (o *WaypointGetLogStream3OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get log stream3 o k response has a 4xx status code
func (o *WaypointGetLogStream3OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get log stream3 o k response has a 5xx status code
func (o *WaypointGetLogStream3OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get log stream3 o k response a status code equal to that given
func (o *WaypointGetLogStream3OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetLogStream3OK) Error() string {
	return fmt.Sprintf("[POST /project/{application.application.project}/application/{application.application.application}/workspace/{application.workspace.workspace}/logs][%d] waypointGetLogStream3OK  %+v", 200, o.Payload)
}

func (o *WaypointGetLogStream3OK) String() string {
	return fmt.Sprintf("[POST /project/{application.application.project}/application/{application.application.application}/workspace/{application.workspace.workspace}/logs][%d] waypointGetLogStream3OK  %+v", 200, o.Payload)
}

func (o *WaypointGetLogStream3OK) GetPayload() *WaypointGetLogStream3OKBody {
	return o.Payload
}

func (o *WaypointGetLogStream3OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(WaypointGetLogStream3OKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetLogStream3Default creates a WaypointGetLogStream3Default with default headers values
func NewWaypointGetLogStream3Default(code int) *WaypointGetLogStream3Default {
	return &WaypointGetLogStream3Default{
		_statusCode: code,
	}
}

/*
WaypointGetLogStream3Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetLogStream3Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get log stream3 default response
func (o *WaypointGetLogStream3Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get log stream3 default response has a 2xx status code
func (o *WaypointGetLogStream3Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get log stream3 default response has a 3xx status code
func (o *WaypointGetLogStream3Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get log stream3 default response has a 4xx status code
func (o *WaypointGetLogStream3Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get log stream3 default response has a 5xx status code
func (o *WaypointGetLogStream3Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get log stream3 default response a status code equal to that given
func (o *WaypointGetLogStream3Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetLogStream3Default) Error() string {
	return fmt.Sprintf("[POST /project/{application.application.project}/application/{application.application.application}/workspace/{application.workspace.workspace}/logs][%d] Waypoint_GetLogStream3 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLogStream3Default) String() string {
	return fmt.Sprintf("[POST /project/{application.application.project}/application/{application.application.application}/workspace/{application.workspace.workspace}/logs][%d] Waypoint_GetLogStream3 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLogStream3Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetLogStream3Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
WaypointGetLogStream3OKBody Stream result of hashicorp.waypoint.LogBatch
swagger:model WaypointGetLogStream3OKBody
*/
type WaypointGetLogStream3OKBody struct {

	// error
	Error *models.GrpcGatewayRuntimeStreamError `json:"error,omitempty"`

	// result
	Result *models.HashicorpWaypointLogBatch `json:"result,omitempty"`
}

// Validate validates this waypoint get log stream3 o k body
func (o *WaypointGetLogStream3OKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateResult(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WaypointGetLogStream3OKBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStream3OK" + "." + "error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStream3OK" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *WaypointGetLogStream3OKBody) validateResult(formats strfmt.Registry) error {
	if swag.IsZero(o.Result) { // not required
		return nil
	}

	if o.Result != nil {
		if err := o.Result.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStream3OK" + "." + "result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStream3OK" + "." + "result")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this waypoint get log stream3 o k body based on the context it is used
func (o *WaypointGetLogStream3OKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateResult(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *WaypointGetLogStream3OKBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStream3OK" + "." + "error")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStream3OK" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *WaypointGetLogStream3OKBody) contextValidateResult(ctx context.Context, formats strfmt.Registry) error {

	if o.Result != nil {
		if err := o.Result.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("waypointGetLogStream3OK" + "." + "result")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("waypointGetLogStream3OK" + "." + "result")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *WaypointGetLogStream3OKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *WaypointGetLogStream3OKBody) UnmarshalBinary(b []byte) error {
	var res WaypointGetLogStream3OKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
