// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new waypoint API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for waypoint API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	WaypointAdoptRunner(params *WaypointAdoptRunnerParams, opts ...ClientOption) (*WaypointAdoptRunnerOK, error)

	WaypointCancelJob(params *WaypointCancelJobParams, opts ...ClientOption) (*WaypointCancelJobOK, error)

	WaypointCancelTask(params *WaypointCancelTaskParams, opts ...ClientOption) (*WaypointCancelTaskOK, error)

	WaypointCancelTask2(params *WaypointCancelTask2Params, opts ...ClientOption) (*WaypointCancelTask2OK, error)

	WaypointCompleteOIDCAuth(params *WaypointCompleteOIDCAuthParams, opts ...ClientOption) (*WaypointCompleteOIDCAuthOK, error)

	WaypointConfigSyncPipeline(params *WaypointConfigSyncPipelineParams, opts ...ClientOption) (*WaypointConfigSyncPipelineOK, error)

	WaypointConvertInviteToken(params *WaypointConvertInviteTokenParams, opts ...ClientOption) (*WaypointConvertInviteTokenOK, error)

	WaypointCreateHostname(params *WaypointCreateHostnameParams, opts ...ClientOption) (*WaypointCreateHostnameOK, error)

	WaypointCreateHostname2(params *WaypointCreateHostname2Params, opts ...ClientOption) (*WaypointCreateHostname2OK, error)

	WaypointDecodeToken(params *WaypointDecodeTokenParams, opts ...ClientOption) (*WaypointDecodeTokenOK, error)

	WaypointDeleteAuthMethod(params *WaypointDeleteAuthMethodParams, opts ...ClientOption) (*WaypointDeleteAuthMethodOK, error)

	WaypointDeleteHostname(params *WaypointDeleteHostnameParams, opts ...ClientOption) (*WaypointDeleteHostnameOK, error)

	WaypointDeleteUser(params *WaypointDeleteUserParams, opts ...ClientOption) (*WaypointDeleteUserOK, error)

	WaypointDeleteUser2(params *WaypointDeleteUser2Params, opts ...ClientOption) (*WaypointDeleteUser2OK, error)

	WaypointDestroyProject(params *WaypointDestroyProjectParams, opts ...ClientOption) (*WaypointDestroyProjectOK, error)

	WaypointExpediteStatusReport(params *WaypointExpediteStatusReportParams, opts ...ClientOption) (*WaypointExpediteStatusReportOK, error)

	WaypointExpediteStatusReport2(params *WaypointExpediteStatusReport2Params, opts ...ClientOption) (*WaypointExpediteStatusReport2OK, error)

	WaypointExpediteStatusReport3(params *WaypointExpediteStatusReport3Params, opts ...ClientOption) (*WaypointExpediteStatusReport3OK, error)

	WaypointExpediteStatusReport4(params *WaypointExpediteStatusReport4Params, opts ...ClientOption) (*WaypointExpediteStatusReport4OK, error)

	WaypointForgetRunner(params *WaypointForgetRunnerParams, opts ...ClientOption) (*WaypointForgetRunnerOK, error)

	WaypointGenerateInviteToken(params *WaypointGenerateInviteTokenParams, opts ...ClientOption) (*WaypointGenerateInviteTokenOK, error)

	WaypointGenerateLoginToken(params *WaypointGenerateLoginTokenParams, opts ...ClientOption) (*WaypointGenerateLoginTokenOK, error)

	WaypointGenerateRunnerToken(params *WaypointGenerateRunnerTokenParams, opts ...ClientOption) (*WaypointGenerateRunnerTokenOK, error)

	WaypointGetApplication(params *WaypointGetApplicationParams, opts ...ClientOption) (*WaypointGetApplicationOK, error)

	WaypointGetAuthMethod(params *WaypointGetAuthMethodParams, opts ...ClientOption) (*WaypointGetAuthMethodOK, error)

	WaypointGetBuild(params *WaypointGetBuildParams, opts ...ClientOption) (*WaypointGetBuildOK, error)

	WaypointGetBuild2(params *WaypointGetBuild2Params, opts ...ClientOption) (*WaypointGetBuild2OK, error)

	WaypointGetConfig(params *WaypointGetConfigParams, opts ...ClientOption) (*WaypointGetConfigOK, error)

	WaypointGetConfig2(params *WaypointGetConfig2Params, opts ...ClientOption) (*WaypointGetConfig2OK, error)

	WaypointGetConfig3(params *WaypointGetConfig3Params, opts ...ClientOption) (*WaypointGetConfig3OK, error)

	WaypointGetConfigSource(params *WaypointGetConfigSourceParams, opts ...ClientOption) (*WaypointGetConfigSourceOK, error)

	WaypointGetDeployment(params *WaypointGetDeploymentParams, opts ...ClientOption) (*WaypointGetDeploymentOK, error)

	WaypointGetDeployment2(params *WaypointGetDeployment2Params, opts ...ClientOption) (*WaypointGetDeployment2OK, error)

	WaypointGetJob(params *WaypointGetJobParams, opts ...ClientOption) (*WaypointGetJobOK, error)

	WaypointGetJobStream(params *WaypointGetJobStreamParams, opts ...ClientOption) (*WaypointGetJobStreamOK, error)

	WaypointGetLatestBuild(params *WaypointGetLatestBuildParams, opts ...ClientOption) (*WaypointGetLatestBuildOK, error)

	WaypointGetLatestBuild2(params *WaypointGetLatestBuild2Params, opts ...ClientOption) (*WaypointGetLatestBuild2OK, error)

	WaypointGetLatestPipelineRun(params *WaypointGetLatestPipelineRunParams, opts ...ClientOption) (*WaypointGetLatestPipelineRunOK, error)

	WaypointGetLatestPipelineRun2(params *WaypointGetLatestPipelineRun2Params, opts ...ClientOption) (*WaypointGetLatestPipelineRun2OK, error)

	WaypointGetLatestPushedArtifact(params *WaypointGetLatestPushedArtifactParams, opts ...ClientOption) (*WaypointGetLatestPushedArtifactOK, error)

	WaypointGetLatestPushedArtifact2(params *WaypointGetLatestPushedArtifact2Params, opts ...ClientOption) (*WaypointGetLatestPushedArtifact2OK, error)

	WaypointGetLatestRelease(params *WaypointGetLatestReleaseParams, opts ...ClientOption) (*WaypointGetLatestReleaseOK, error)

	WaypointGetLatestRelease2(params *WaypointGetLatestRelease2Params, opts ...ClientOption) (*WaypointGetLatestRelease2OK, error)

	WaypointGetLatestStatusReport(params *WaypointGetLatestStatusReportParams, opts ...ClientOption) (*WaypointGetLatestStatusReportOK, error)

	WaypointGetLatestStatusReport2(params *WaypointGetLatestStatusReport2Params, opts ...ClientOption) (*WaypointGetLatestStatusReport2OK, error)

	WaypointGetLogStream(params *WaypointGetLogStreamParams, opts ...ClientOption) (*WaypointGetLogStreamOK, error)

	WaypointGetLogStream2(params *WaypointGetLogStream2Params, opts ...ClientOption) (*WaypointGetLogStream2OK, error)

	WaypointGetLogStream3(params *WaypointGetLogStream3Params, opts ...ClientOption) (*WaypointGetLogStream3OK, error)

	WaypointGetOIDCAuthURL(params *WaypointGetOIDCAuthURLParams, opts ...ClientOption) (*WaypointGetOIDCAuthURLOK, error)

	WaypointGetOnDemandRunnerConfig(params *WaypointGetOnDemandRunnerConfigParams, opts ...ClientOption) (*WaypointGetOnDemandRunnerConfigOK, error)

	WaypointGetOnDemandRunnerConfig2(params *WaypointGetOnDemandRunnerConfig2Params, opts ...ClientOption) (*WaypointGetOnDemandRunnerConfig2OK, error)

	WaypointGetPipeline(params *WaypointGetPipelineParams, opts ...ClientOption) (*WaypointGetPipelineOK, error)

	WaypointGetPipeline2(params *WaypointGetPipeline2Params, opts ...ClientOption) (*WaypointGetPipeline2OK, error)

	WaypointGetPipelineRun(params *WaypointGetPipelineRunParams, opts ...ClientOption) (*WaypointGetPipelineRunOK, error)

	WaypointGetPipelineRun2(params *WaypointGetPipelineRun2Params, opts ...ClientOption) (*WaypointGetPipelineRun2OK, error)

	WaypointGetProject(params *WaypointGetProjectParams, opts ...ClientOption) (*WaypointGetProjectOK, error)

	WaypointGetPushedArtifact(params *WaypointGetPushedArtifactParams, opts ...ClientOption) (*WaypointGetPushedArtifactOK, error)

	WaypointGetPushedArtifact2(params *WaypointGetPushedArtifact2Params, opts ...ClientOption) (*WaypointGetPushedArtifact2OK, error)

	WaypointGetRelease(params *WaypointGetReleaseParams, opts ...ClientOption) (*WaypointGetReleaseOK, error)

	WaypointGetRelease2(params *WaypointGetRelease2Params, opts ...ClientOption) (*WaypointGetRelease2OK, error)

	WaypointGetRunner(params *WaypointGetRunnerParams, opts ...ClientOption) (*WaypointGetRunnerOK, error)

	WaypointGetServerConfig(params *WaypointGetServerConfigParams, opts ...ClientOption) (*WaypointGetServerConfigOK, error)

	WaypointGetStatusReport(params *WaypointGetStatusReportParams, opts ...ClientOption) (*WaypointGetStatusReportOK, error)

	WaypointGetTask(params *WaypointGetTaskParams, opts ...ClientOption) (*WaypointGetTaskOK, error)

	WaypointGetTask2(params *WaypointGetTask2Params, opts ...ClientOption) (*WaypointGetTask2OK, error)

	WaypointGetTrigger(params *WaypointGetTriggerParams, opts ...ClientOption) (*WaypointGetTriggerOK, error)

	WaypointGetTrigger2(params *WaypointGetTrigger2Params, opts ...ClientOption) (*WaypointGetTrigger2OK, error)

	WaypointGetUser(params *WaypointGetUserParams, opts ...ClientOption) (*WaypointGetUserOK, error)

	WaypointGetUser2(params *WaypointGetUser2Params, opts ...ClientOption) (*WaypointGetUser2OK, error)

	WaypointGetVersionInfo(params *WaypointGetVersionInfoParams, opts ...ClientOption) (*WaypointGetVersionInfoOK, error)

	WaypointGetWorkspace(params *WaypointGetWorkspaceParams, opts ...ClientOption) (*WaypointGetWorkspaceOK, error)

	WaypointListAuthMethods(params *WaypointListAuthMethodsParams, opts ...ClientOption) (*WaypointListAuthMethodsOK, error)

	WaypointListBuilds(params *WaypointListBuildsParams, opts ...ClientOption) (*WaypointListBuildsOK, error)

	WaypointListBuilds2(params *WaypointListBuilds2Params, opts ...ClientOption) (*WaypointListBuilds2OK, error)

	WaypointListDeployments(params *WaypointListDeploymentsParams, opts ...ClientOption) (*WaypointListDeploymentsOK, error)

	WaypointListDeployments2(params *WaypointListDeployments2Params, opts ...ClientOption) (*WaypointListDeployments2OK, error)

	WaypointListHostnames(params *WaypointListHostnamesParams, opts ...ClientOption) (*WaypointListHostnamesOK, error)

	WaypointListHostnames2(params *WaypointListHostnames2Params, opts ...ClientOption) (*WaypointListHostnames2OK, error)

	WaypointListInstances(params *WaypointListInstancesParams, opts ...ClientOption) (*WaypointListInstancesOK, error)

	WaypointListInstances2(params *WaypointListInstances2Params, opts ...ClientOption) (*WaypointListInstances2OK, error)

	WaypointListInstances3(params *WaypointListInstances3Params, opts ...ClientOption) (*WaypointListInstances3OK, error)

	WaypointListJobs(params *WaypointListJobsParams, opts ...ClientOption) (*WaypointListJobsOK, error)

	WaypointListJobs2(params *WaypointListJobs2Params, opts ...ClientOption) (*WaypointListJobs2OK, error)

	WaypointListJobs3(params *WaypointListJobs3Params, opts ...ClientOption) (*WaypointListJobs3OK, error)

	WaypointListJobs4(params *WaypointListJobs4Params, opts ...ClientOption) (*WaypointListJobs4OK, error)

	WaypointListJobs5(params *WaypointListJobs5Params, opts ...ClientOption) (*WaypointListJobs5OK, error)

	WaypointListOIDCAuthMethods(params *WaypointListOIDCAuthMethodsParams, opts ...ClientOption) (*WaypointListOIDCAuthMethodsOK, error)

	WaypointListOnDemandRunnerConfigs(params *WaypointListOnDemandRunnerConfigsParams, opts ...ClientOption) (*WaypointListOnDemandRunnerConfigsOK, error)

	WaypointListPipelineRuns(params *WaypointListPipelineRunsParams, opts ...ClientOption) (*WaypointListPipelineRunsOK, error)

	WaypointListPipelineRuns2(params *WaypointListPipelineRuns2Params, opts ...ClientOption) (*WaypointListPipelineRuns2OK, error)

	WaypointListPipelines(params *WaypointListPipelinesParams, opts ...ClientOption) (*WaypointListPipelinesOK, error)

	WaypointListProjects(params *WaypointListProjectsParams, opts ...ClientOption) (*WaypointListProjectsOK, error)

	WaypointListPushedArtifacts(params *WaypointListPushedArtifactsParams, opts ...ClientOption) (*WaypointListPushedArtifactsOK, error)

	WaypointListPushedArtifacts2(params *WaypointListPushedArtifacts2Params, opts ...ClientOption) (*WaypointListPushedArtifacts2OK, error)

	WaypointListReleases(params *WaypointListReleasesParams, opts ...ClientOption) (*WaypointListReleasesOK, error)

	WaypointListReleases2(params *WaypointListReleases2Params, opts ...ClientOption) (*WaypointListReleases2OK, error)

	WaypointListRunners(params *WaypointListRunnersParams, opts ...ClientOption) (*WaypointListRunnersOK, error)

	WaypointListStatusReports(params *WaypointListStatusReportsParams, opts ...ClientOption) (*WaypointListStatusReportsOK, error)

	WaypointListStatusReports2(params *WaypointListStatusReports2Params, opts ...ClientOption) (*WaypointListStatusReports2OK, error)

	WaypointListTask(params *WaypointListTaskParams, opts ...ClientOption) (*WaypointListTaskOK, error)

	WaypointListTriggers(params *WaypointListTriggersParams, opts ...ClientOption) (*WaypointListTriggersOK, error)

	WaypointListTriggers2(params *WaypointListTriggers2Params, opts ...ClientOption) (*WaypointListTriggers2OK, error)

	WaypointListTriggers3(params *WaypointListTriggers3Params, opts ...ClientOption) (*WaypointListTriggers3OK, error)

	WaypointListTriggers4(params *WaypointListTriggers4Params, opts ...ClientOption) (*WaypointListTriggers4OK, error)

	WaypointListUsers(params *WaypointListUsersParams, opts ...ClientOption) (*WaypointListUsersOK, error)

	WaypointListWorkspaces(params *WaypointListWorkspacesParams, opts ...ClientOption) (*WaypointListWorkspacesOK, error)

	WaypointListWorkspaces2(params *WaypointListWorkspaces2Params, opts ...ClientOption) (*WaypointListWorkspaces2OK, error)

	WaypointListWorkspaces3(params *WaypointListWorkspaces3Params, opts ...ClientOption) (*WaypointListWorkspaces3OK, error)

	WaypointNoAuthRunTrigger(params *WaypointNoAuthRunTriggerParams, opts ...ClientOption) (*WaypointNoAuthRunTriggerOK, error)

	WaypointQueueJob(params *WaypointQueueJobParams, opts ...ClientOption) (*WaypointQueueJobOK, error)

	WaypointRunPipeline(params *WaypointRunPipelineParams, opts ...ClientOption) (*WaypointRunPipelineOK, error)

	WaypointRunPipeline2(params *WaypointRunPipeline2Params, opts ...ClientOption) (*WaypointRunPipeline2OK, error)

	WaypointRunTrigger(params *WaypointRunTriggerParams, opts ...ClientOption) (*WaypointRunTriggerOK, error)

	WaypointSetConfig(params *WaypointSetConfigParams, opts ...ClientOption) (*WaypointSetConfigOK, error)

	WaypointSetConfigSource(params *WaypointSetConfigSourceParams, opts ...ClientOption) (*WaypointSetConfigSourceOK, error)

	WaypointSetServerConfig(params *WaypointSetServerConfigParams, opts ...ClientOption) (*WaypointSetServerConfigOK, error)

	WaypointStartExecStream(params *WaypointStartExecStreamParams, opts ...ClientOption) (*WaypointStartExecStreamOK, error)

	WaypointUIGetProject(params *WaypointUIGetProjectParams, opts ...ClientOption) (*WaypointUIGetProjectOK, error)

	WaypointUIListDeployments(params *WaypointUIListDeploymentsParams, opts ...ClientOption) (*WaypointUIListDeploymentsOK, error)

	WaypointUIListDeployments2(params *WaypointUIListDeployments2Params, opts ...ClientOption) (*WaypointUIListDeployments2OK, error)

	WaypointUIListDeployments3(params *WaypointUIListDeployments3Params, opts ...ClientOption) (*WaypointUIListDeployments3OK, error)

	WaypointUIListDeployments4(params *WaypointUIListDeployments4Params, opts ...ClientOption) (*WaypointUIListDeployments4OK, error)

	WaypointUIListReleases(params *WaypointUIListReleasesParams, opts ...ClientOption) (*WaypointUIListReleasesOK, error)

	WaypointUIListReleases2(params *WaypointUIListReleases2Params, opts ...ClientOption) (*WaypointUIListReleases2OK, error)

	WaypointUIListReleases3(params *WaypointUIListReleases3Params, opts ...ClientOption) (*WaypointUIListReleases3OK, error)

	WaypointUIListReleases4(params *WaypointUIListReleases4Params, opts ...ClientOption) (*WaypointUIListReleases4OK, error)

	WaypointUpdateUser(params *WaypointUpdateUserParams, opts ...ClientOption) (*WaypointUpdateUserOK, error)

	WaypointUpsertApplication(params *WaypointUpsertApplicationParams, opts ...ClientOption) (*WaypointUpsertApplicationOK, error)

	WaypointUpsertAuthMethod(params *WaypointUpsertAuthMethodParams, opts ...ClientOption) (*WaypointUpsertAuthMethodOK, error)

	WaypointUpsertOnDemandRunnerConfig(params *WaypointUpsertOnDemandRunnerConfigParams, opts ...ClientOption) (*WaypointUpsertOnDemandRunnerConfigOK, error)

	WaypointUpsertProject(params *WaypointUpsertProjectParams, opts ...ClientOption) (*WaypointUpsertProjectOK, error)

	WaypointUpsertTrigger(params *WaypointUpsertTriggerParams, opts ...ClientOption) (*WaypointUpsertTriggerOK, error)

	WaypointUpsertWorkspace(params *WaypointUpsertWorkspaceParams, opts ...ClientOption) (*WaypointUpsertWorkspaceOK, error)

	WaypointValidateJob(params *WaypointValidateJobParams, opts ...ClientOption) (*WaypointValidateJobOK, error)

	WaypointWaypointHclFmt(params *WaypointWaypointHclFmtParams, opts ...ClientOption) (*WaypointWaypointHclFmtOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
WaypointAdoptRunner adopts runners allows marking a runner as adopted or rejected
*/
func (a *Client) WaypointAdoptRunner(params *WaypointAdoptRunnerParams, opts ...ClientOption) (*WaypointAdoptRunnerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointAdoptRunnerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_AdoptRunner",
		Method:             "POST",
		PathPattern:        "/runner/{runner_id}/adopt",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointAdoptRunnerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointAdoptRunnerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointAdoptRunnerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WaypointCancelJob cancels job cancels a job if the job is still queued this is a quick and easy operation if the job is already completed then this does nothing if the job is assigned or running then this will signal the runner about the cancellation but it may take time

	This RPC always returns immediately. You must use GetJob or GetJobStream

to wait on the status of the cancellation.
*/
func (a *Client) WaypointCancelJob(params *WaypointCancelJobParams, opts ...ClientOption) (*WaypointCancelJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointCancelJobParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_CancelJob",
		Method:             "PUT",
		PathPattern:        "/jobs/cancel/{job_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointCancelJobReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointCancelJobOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointCancelJobDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointCancelTask cancels task will attempt to gracefully cancel each job in the task job triple
*/
func (a *Client) WaypointCancelTask(params *WaypointCancelTaskParams, opts ...ClientOption) (*WaypointCancelTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointCancelTaskParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_CancelTask",
		Method:             "PUT",
		PathPattern:        "/task/{ref.id}/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointCancelTaskReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointCancelTaskOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointCancelTaskDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointCancelTask2 cancels task will attempt to gracefully cancel each job in the task job triple
*/
func (a *Client) WaypointCancelTask2(params *WaypointCancelTask2Params, opts ...ClientOption) (*WaypointCancelTask2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointCancelTask2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_CancelTask2",
		Method:             "PUT",
		PathPattern:        "/task/by-job/{ref.job_id}/cancel",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointCancelTask2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointCancelTask2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointCancelTask2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointCompleteOIDCAuth completes the o ID c auth cycle after receiving the callback from the o ID c provider
*/
func (a *Client) WaypointCompleteOIDCAuth(params *WaypointCompleteOIDCAuthParams, opts ...ClientOption) (*WaypointCompleteOIDCAuthOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointCompleteOIDCAuthParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_CompleteOIDCAuth",
		Method:             "POST",
		PathPattern:        "/oidc/{auth_method.name}/complete",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointCompleteOIDCAuthReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointCompleteOIDCAuthOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointCompleteOIDCAuthDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointConfigSyncPipeline configs sync pipeline takes a request for a given project and syncs the current project config to the waypoint database
*/
func (a *Client) WaypointConfigSyncPipeline(params *WaypointConfigSyncPipelineParams, opts ...ClientOption) (*WaypointConfigSyncPipelineOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointConfigSyncPipelineParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ConfigSyncPipeline",
		Method:             "POST",
		PathPattern:        "/project/{project.project}/config-sync-pipeline",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointConfigSyncPipelineReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointConfigSyncPipelineOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointConfigSyncPipelineDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointConvertInviteToken exchanges a invite token for a login token if the invite token is for a new user this will create a new user account with the provided username hint
*/
func (a *Client) WaypointConvertInviteToken(params *WaypointConvertInviteTokenParams, opts ...ClientOption) (*WaypointConvertInviteTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointConvertInviteTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ConvertInviteToken",
		Method:             "POST",
		PathPattern:        "/token/exchange",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointConvertInviteTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointConvertInviteTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointConvertInviteTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointCreateHostname creates a hostname with the URL service
*/
func (a *Client) WaypointCreateHostname(params *WaypointCreateHostnameParams, opts ...ClientOption) (*WaypointCreateHostnameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointCreateHostnameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_CreateHostname",
		Method:             "POST",
		PathPattern:        "/project/{target.application.application.project}/application/{target.application.application.application}/hostname",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointCreateHostnameReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointCreateHostnameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointCreateHostnameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointCreateHostname2 creates a hostname with the URL service
*/
func (a *Client) WaypointCreateHostname2(params *WaypointCreateHostname2Params, opts ...ClientOption) (*WaypointCreateHostname2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointCreateHostname2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_CreateHostname2",
		Method:             "POST",
		PathPattern:        "/project/{target.application.application.project}/application/{target.application.application.application}/workspace/{target.application.workspace.workspace}/hostname",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointCreateHostname2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointCreateHostname2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointCreateHostname2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointDecodeToken decodes token takes a token string and returns the structured information about the given token this is useful for frontends c l i UI etc to learn more about a token before using it for example if a UI wants to create a signup flow around signup tokens they can validate the token ahead of time

This endpoint does NOT require authentication.
*/
func (a *Client) WaypointDecodeToken(params *WaypointDecodeTokenParams, opts ...ClientOption) (*WaypointDecodeTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointDecodeTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_DecodeToken",
		Method:             "POST",
		PathPattern:        "/token/decode",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointDecodeTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointDecodeTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointDecodeTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointDeleteAuthMethod deletes an auth method this will invalidate all users authenticated using this auth method and they will have to reauthenticate some other way
*/
func (a *Client) WaypointDeleteAuthMethod(params *WaypointDeleteAuthMethodParams, opts ...ClientOption) (*WaypointDeleteAuthMethodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointDeleteAuthMethodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_DeleteAuthMethod",
		Method:             "DELETE",
		PathPattern:        "/auth-method/{auth_method.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointDeleteAuthMethodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointDeleteAuthMethodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointDeleteAuthMethodDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointDeleteHostname deletes a hostname with the URL service
*/
func (a *Client) WaypointDeleteHostname(params *WaypointDeleteHostnameParams, opts ...ClientOption) (*WaypointDeleteHostnameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointDeleteHostnameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_DeleteHostname",
		Method:             "DELETE",
		PathPattern:        "/hostname/{hostname}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointDeleteHostnameReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointDeleteHostnameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointDeleteHostnameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointDeleteUser deletes a user this will invalidate all authentication for this user as well since they no longer exist
*/
func (a *Client) WaypointDeleteUser(params *WaypointDeleteUserParams, opts ...ClientOption) (*WaypointDeleteUserOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointDeleteUserParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_DeleteUser",
		Method:             "DELETE",
		PathPattern:        "/user/by-id/{user.id.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointDeleteUserReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointDeleteUserOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointDeleteUserDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointDeleteUser2 deletes a user this will invalidate all authentication for this user as well since they no longer exist
*/
func (a *Client) WaypointDeleteUser2(params *WaypointDeleteUser2Params, opts ...ClientOption) (*WaypointDeleteUser2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointDeleteUser2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_DeleteUser2",
		Method:             "DELETE",
		PathPattern:        "/user/by-username/{user.username.username}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointDeleteUser2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointDeleteUser2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointDeleteUser2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointDestroyProject destroys project deletes a project from the database as well as optionally destroys all resources created within a project
*/
func (a *Client) WaypointDestroyProject(params *WaypointDestroyProjectParams, opts ...ClientOption) (*WaypointDestroyProjectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointDestroyProjectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_DestroyProject",
		Method:             "DELETE",
		PathPattern:        "/project/{project.project}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointDestroyProjectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointDestroyProjectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointDestroyProjectDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointExpediteStatusReport expedites status report returns the queued status report job id
*/
func (a *Client) WaypointExpediteStatusReport(params *WaypointExpediteStatusReportParams, opts ...ClientOption) (*WaypointExpediteStatusReportOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointExpediteStatusReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ExpediteStatusReport",
		Method:             "PUT",
		PathPattern:        "/deployment/{deployment.id}/status-report",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointExpediteStatusReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointExpediteStatusReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointExpediteStatusReportDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointExpediteStatusReport2 expedites status report returns the queued status report job id
*/
func (a *Client) WaypointExpediteStatusReport2(params *WaypointExpediteStatusReport2Params, opts ...ClientOption) (*WaypointExpediteStatusReport2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointExpediteStatusReport2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ExpediteStatusReport2",
		Method:             "PUT",
		PathPattern:        "/release/{release.id}/status-report",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointExpediteStatusReport2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointExpediteStatusReport2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointExpediteStatusReport2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointExpediteStatusReport3 expedites status report returns the queued status report job id
*/
func (a *Client) WaypointExpediteStatusReport3(params *WaypointExpediteStatusReport3Params, opts ...ClientOption) (*WaypointExpediteStatusReport3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointExpediteStatusReport3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ExpediteStatusReport3",
		Method:             "PUT",
		PathPattern:        "/project/{deployment.sequence.application.project}/application/{deployment.sequence.application.application}/deployment/{deployment.sequence.number}/status-report",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointExpediteStatusReport3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointExpediteStatusReport3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointExpediteStatusReport3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointExpediteStatusReport4 expedites status report returns the queued status report job id
*/
func (a *Client) WaypointExpediteStatusReport4(params *WaypointExpediteStatusReport4Params, opts ...ClientOption) (*WaypointExpediteStatusReport4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointExpediteStatusReport4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ExpediteStatusReport4",
		Method:             "PUT",
		PathPattern:        "/project/{release.sequence.application.project}/application/{release.sequence.application.application}/release/{release.sequence.number}/status-report",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointExpediteStatusReport4Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointExpediteStatusReport4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointExpediteStatusReport4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointForgetRunner forgets runner deletes an existing runner entry and makes the server behave as if the runner no longer exists if the runner is currently running it will receive errors on subsequent jobs and will have to re register a forgotten runner will not be assigned new jobs until re registered
*/
func (a *Client) WaypointForgetRunner(params *WaypointForgetRunnerParams, opts ...ClientOption) (*WaypointForgetRunnerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointForgetRunnerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ForgetRunner",
		Method:             "POST",
		PathPattern:        "/runner/{runner_id}/forget",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointForgetRunnerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointForgetRunnerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointForgetRunnerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGenerateInviteToken generates a new invite token that users can exchange for a login token this can be used to also invite new users to the waypoint server
*/
func (a *Client) WaypointGenerateInviteToken(params *WaypointGenerateInviteTokenParams, opts ...ClientOption) (*WaypointGenerateInviteTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGenerateInviteTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GenerateInviteToken",
		Method:             "POST",
		PathPattern:        "/token/invite",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGenerateInviteTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGenerateInviteTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGenerateInviteTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGenerateLoginToken generates a new login token that users can use to login directly this can only be called for existing users
*/
func (a *Client) WaypointGenerateLoginToken(params *WaypointGenerateLoginTokenParams, opts ...ClientOption) (*WaypointGenerateLoginTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGenerateLoginTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GenerateLoginToken",
		Method:             "POST",
		PathPattern:        "/token/login",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGenerateLoginTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGenerateLoginTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGenerateLoginTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGenerateRunnerToken generates a new runner token that can be used with runners so they immediately begin work the recommended appraoch is to instead use the adoption flow but this also works
*/
func (a *Client) WaypointGenerateRunnerToken(params *WaypointGenerateRunnerTokenParams, opts ...ClientOption) (*WaypointGenerateRunnerTokenOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGenerateRunnerTokenParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GenerateRunnerToken",
		Method:             "POST",
		PathPattern:        "/token/runner",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGenerateRunnerTokenReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGenerateRunnerTokenOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGenerateRunnerTokenDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetApplication gets application returns one application on the project
*/
func (a *Client) WaypointGetApplication(params *WaypointGetApplicationParams, opts ...ClientOption) (*WaypointGetApplicationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetApplicationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetApplication",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetApplicationReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetApplicationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetApplicationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetAuthMethod gets auth method returns the auth method
*/
func (a *Client) WaypointGetAuthMethod(params *WaypointGetAuthMethodParams, opts ...ClientOption) (*WaypointGetAuthMethodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetAuthMethodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetAuthMethod",
		Method:             "GET",
		PathPattern:        "/auth-method/{auth_method.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetAuthMethodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetAuthMethodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetAuthMethodDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetBuild gets build returns a build
*/
func (a *Client) WaypointGetBuild(params *WaypointGetBuildParams, opts ...ClientOption) (*WaypointGetBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetBuild",
		Method:             "GET",
		PathPattern:        "/build/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetBuildReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetBuild2 gets build returns a build
*/
func (a *Client) WaypointGetBuild2(params *WaypointGetBuild2Params, opts ...ClientOption) (*WaypointGetBuild2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetBuild2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetBuild2",
		Method:             "GET",
		PathPattern:        "/project/{ref.sequence.application.project}/application/{ref.sequence.application.application}/build/{ref.sequence.number}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetBuild2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetBuild2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetBuild2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetConfig retrieves merged configuration values for a specific scope you can determine where a configuration variable was set by looking at the scope field on each variable
*/
func (a *Client) WaypointGetConfig(params *WaypointGetConfigParams, opts ...ClientOption) (*WaypointGetConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetConfig",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetConfig2 retrieves merged configuration values for a specific scope you can determine where a configuration variable was set by looking at the scope field on each variable
*/
func (a *Client) WaypointGetConfig2(params *WaypointGetConfig2Params, opts ...ClientOption) (*WaypointGetConfig2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetConfig2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetConfig2",
		Method:             "GET",
		PathPattern:        "/project/{project.project}/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetConfig2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetConfig2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetConfig2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetConfig3 retrieves merged configuration values for a specific scope you can determine where a configuration variable was set by looking at the scope field on each variable
*/
func (a *Client) WaypointGetConfig3(params *WaypointGetConfig3Params, opts ...ClientOption) (*WaypointGetConfig3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetConfig3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetConfig3",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/{application.application}/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetConfig3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetConfig3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetConfig3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetConfigSource gets the matching configuration source for the request this will return the most specific matching config source given the scope in the request for example if you search for an app specific config source and only a global config exists the global config will be returned
*/
func (a *Client) WaypointGetConfigSource(params *WaypointGetConfigSourceParams, opts ...ClientOption) (*WaypointGetConfigSourceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetConfigSourceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetConfigSource",
		Method:             "GET",
		PathPattern:        "/config-source",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetConfigSourceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetConfigSourceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetConfigSourceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetDeployment gets deployment returns a deployment
*/
func (a *Client) WaypointGetDeployment(params *WaypointGetDeploymentParams, opts ...ClientOption) (*WaypointGetDeploymentOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetDeploymentParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetDeployment",
		Method:             "GET",
		PathPattern:        "/deployment/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetDeploymentReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetDeploymentOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetDeploymentDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetDeployment2 gets deployment returns a deployment
*/
func (a *Client) WaypointGetDeployment2(params *WaypointGetDeployment2Params, opts ...ClientOption) (*WaypointGetDeployment2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetDeployment2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetDeployment2",
		Method:             "GET",
		PathPattern:        "/project/{ref.sequence.application.project}/application/{ref.sequence.application.application}/deployment/{ref.sequence.number}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetDeployment2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetDeployment2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetDeployment2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetJob gets job queries a job by ID
*/
func (a *Client) WaypointGetJob(params *WaypointGetJobParams, opts ...ClientOption) (*WaypointGetJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetJobParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetJob",
		Method:             "GET",
		PathPattern:        "/jobs/{job_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetJobReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetJobOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetJobDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetJobStream gets job stream opens a job event stream for a running job this can be used to listen for terminal output and other events of a running job multiple listeners can open a job stream
*/
func (a *Client) WaypointGetJobStream(params *WaypointGetJobStreamParams, opts ...ClientOption) (*WaypointGetJobStreamOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetJobStreamParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetJobStream",
		Method:             "GET",
		PathPattern:        "/jobs/stream/{job_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetJobStreamReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetJobStreamOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetJobStreamDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestBuild gets latest build returns the most recent successfully completed build for an app
*/
func (a *Client) WaypointGetLatestBuild(params *WaypointGetLatestBuildParams, opts ...ClientOption) (*WaypointGetLatestBuildOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestBuildParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestBuild",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/build/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestBuildReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestBuildOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestBuildDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestBuild2 gets latest build returns the most recent successfully completed build for an app
*/
func (a *Client) WaypointGetLatestBuild2(params *WaypointGetLatestBuild2Params, opts ...ClientOption) (*WaypointGetLatestBuild2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestBuild2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestBuild2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/build/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestBuild2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestBuild2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestBuild2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestPipelineRun gets latest pipeline run returns a pipeline run proto by pipeline ref id and sequence
*/
func (a *Client) WaypointGetLatestPipelineRun(params *WaypointGetLatestPipelineRunParams, opts ...ClientOption) (*WaypointGetLatestPipelineRunOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestPipelineRunParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestPipelineRun",
		Method:             "GET",
		PathPattern:        "/project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/latest-run",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestPipelineRunReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestPipelineRunOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestPipelineRunDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestPipelineRun2 gets latest pipeline run returns a pipeline run proto by pipeline ref id and sequence
*/
func (a *Client) WaypointGetLatestPipelineRun2(params *WaypointGetLatestPipelineRun2Params, opts ...ClientOption) (*WaypointGetLatestPipelineRun2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestPipelineRun2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestPipelineRun2",
		Method:             "GET",
		PathPattern:        "/pipeline/{pipeline.id}/latest-run",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestPipelineRun2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestPipelineRun2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestPipelineRun2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestPushedArtifact gets latest pushed artifact returns the most recent successfully completed artifact push for an app
*/
func (a *Client) WaypointGetLatestPushedArtifact(params *WaypointGetLatestPushedArtifactParams, opts ...ClientOption) (*WaypointGetLatestPushedArtifactOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestPushedArtifactParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestPushedArtifact",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/artifact/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestPushedArtifactReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestPushedArtifactOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestPushedArtifactDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestPushedArtifact2 gets latest pushed artifact returns the most recent successfully completed artifact push for an app
*/
func (a *Client) WaypointGetLatestPushedArtifact2(params *WaypointGetLatestPushedArtifact2Params, opts ...ClientOption) (*WaypointGetLatestPushedArtifact2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestPushedArtifact2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestPushedArtifact2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/artifact/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestPushedArtifact2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestPushedArtifact2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestPushedArtifact2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestRelease gets latest release returns the most recent successfully completed release for an app
*/
func (a *Client) WaypointGetLatestRelease(params *WaypointGetLatestReleaseParams, opts ...ClientOption) (*WaypointGetLatestReleaseOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestReleaseParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestRelease",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/release/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestReleaseReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestReleaseOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestReleaseDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestRelease2 gets latest release returns the most recent successfully completed release for an app
*/
func (a *Client) WaypointGetLatestRelease2(params *WaypointGetLatestRelease2Params, opts ...ClientOption) (*WaypointGetLatestRelease2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestRelease2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestRelease2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/release/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestRelease2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestRelease2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestRelease2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestStatusReport gets latest status report returns the most recent successfully completed health report for an app
*/
func (a *Client) WaypointGetLatestStatusReport(params *WaypointGetLatestStatusReportParams, opts ...ClientOption) (*WaypointGetLatestStatusReportOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestStatusReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestStatusReport",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/status-report/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestStatusReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestStatusReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestStatusReportDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLatestStatusReport2 gets latest status report returns the most recent successfully completed health report for an app
*/
func (a *Client) WaypointGetLatestStatusReport2(params *WaypointGetLatestStatusReport2Params, opts ...ClientOption) (*WaypointGetLatestStatusReport2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLatestStatusReport2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLatestStatusReport2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/status-report/latest",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLatestStatusReport2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLatestStatusReport2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLatestStatusReport2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLogStream gets log stream reads the log stream for a deployment this will immediately send a single log entry with the lines we have so far if there are no available lines this will n o t block and instead will return an error the client can choose to retry or not
*/
func (a *Client) WaypointGetLogStream(params *WaypointGetLogStreamParams, opts ...ClientOption) (*WaypointGetLogStreamOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLogStreamParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLogStream",
		Method:             "POST",
		PathPattern:        "/deployment/{deployment_id}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLogStreamReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLogStreamOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLogStreamDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLogStream2 gets log stream reads the log stream for a deployment this will immediately send a single log entry with the lines we have so far if there are no available lines this will n o t block and instead will return an error the client can choose to retry or not
*/
func (a *Client) WaypointGetLogStream2(params *WaypointGetLogStream2Params, opts ...ClientOption) (*WaypointGetLogStream2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLogStream2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLogStream2",
		Method:             "POST",
		PathPattern:        "/project/{application.application.project}/application/{application.application.application}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLogStream2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLogStream2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLogStream2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetLogStream3 gets log stream reads the log stream for a deployment this will immediately send a single log entry with the lines we have so far if there are no available lines this will n o t block and instead will return an error the client can choose to retry or not
*/
func (a *Client) WaypointGetLogStream3(params *WaypointGetLogStream3Params, opts ...ClientOption) (*WaypointGetLogStream3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetLogStream3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetLogStream3",
		Method:             "POST",
		PathPattern:        "/project/{application.application.project}/application/{application.application.application}/workspace/{application.workspace.workspace}/logs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetLogStream3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetLogStream3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetLogStream3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetOIDCAuthURL gets the URL to visit to start authentication with o ID c
*/
func (a *Client) WaypointGetOIDCAuthURL(params *WaypointGetOIDCAuthURLParams, opts ...ClientOption) (*WaypointGetOIDCAuthURLOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetOIDCAuthURLParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetOIDCAuthURL",
		Method:             "POST",
		PathPattern:        "/oidc/{auth_method.name}/url",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetOIDCAuthURLReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetOIDCAuthURLOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetOIDCAuthURLDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetOnDemandRunnerConfig gets on demand runner config returns the on demand runner configuration
*/
func (a *Client) WaypointGetOnDemandRunnerConfig(params *WaypointGetOnDemandRunnerConfigParams, opts ...ClientOption) (*WaypointGetOnDemandRunnerConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetOnDemandRunnerConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetOnDemandRunnerConfig",
		Method:             "GET",
		PathPattern:        "/on-demand-runner/by-id/{config.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetOnDemandRunnerConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetOnDemandRunnerConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetOnDemandRunnerConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetOnDemandRunnerConfig2 gets on demand runner config returns the on demand runner configuration
*/
func (a *Client) WaypointGetOnDemandRunnerConfig2(params *WaypointGetOnDemandRunnerConfig2Params, opts ...ClientOption) (*WaypointGetOnDemandRunnerConfig2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetOnDemandRunnerConfig2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetOnDemandRunnerConfig2",
		Method:             "GET",
		PathPattern:        "/on-demand-runner/by-name/{config.name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetOnDemandRunnerConfig2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetOnDemandRunnerConfig2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetOnDemandRunnerConfig2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetPipeline gets pipeline returns a pipeline proto by pipeline ref id
*/
func (a *Client) WaypointGetPipeline(params *WaypointGetPipelineParams, opts ...ClientOption) (*WaypointGetPipelineOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetPipelineParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetPipeline",
		Method:             "GET",
		PathPattern:        "/project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetPipelineReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetPipelineOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetPipelineDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetPipeline2 gets pipeline returns a pipeline proto by pipeline ref id
*/
func (a *Client) WaypointGetPipeline2(params *WaypointGetPipeline2Params, opts ...ClientOption) (*WaypointGetPipeline2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetPipeline2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetPipeline2",
		Method:             "GET",
		PathPattern:        "/pipeline/{pipeline.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetPipeline2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetPipeline2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetPipeline2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetPipelineRun gets pipeline run returns a pipeline run proto by pipeline ref id and sequence
*/
func (a *Client) WaypointGetPipelineRun(params *WaypointGetPipelineRunParams, opts ...ClientOption) (*WaypointGetPipelineRunOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetPipelineRunParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetPipelineRun",
		Method:             "GET",
		PathPattern:        "/project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/run/{sequence}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetPipelineRunReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetPipelineRunOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetPipelineRunDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetPipelineRun2 gets pipeline run returns a pipeline run proto by pipeline ref id and sequence
*/
func (a *Client) WaypointGetPipelineRun2(params *WaypointGetPipelineRun2Params, opts ...ClientOption) (*WaypointGetPipelineRun2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetPipelineRun2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetPipelineRun2",
		Method:             "GET",
		PathPattern:        "/pipeline/{pipeline.id}/run/{sequence}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetPipelineRun2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetPipelineRun2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetPipelineRun2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetProject gets project returns the project
*/
func (a *Client) WaypointGetProject(params *WaypointGetProjectParams, opts ...ClientOption) (*WaypointGetProjectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetProjectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetProject",
		Method:             "GET",
		PathPattern:        "/project/{project.project}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetProjectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetProjectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetProjectDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetPushedArtifact gets pushed artifact returns a deployment
*/
func (a *Client) WaypointGetPushedArtifact(params *WaypointGetPushedArtifactParams, opts ...ClientOption) (*WaypointGetPushedArtifactOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetPushedArtifactParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetPushedArtifact",
		Method:             "GET",
		PathPattern:        "/artifact/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetPushedArtifactReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetPushedArtifactOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetPushedArtifactDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetPushedArtifact2 gets pushed artifact returns a deployment
*/
func (a *Client) WaypointGetPushedArtifact2(params *WaypointGetPushedArtifact2Params, opts ...ClientOption) (*WaypointGetPushedArtifact2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetPushedArtifact2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetPushedArtifact2",
		Method:             "GET",
		PathPattern:        "/project/{ref.sequence.application.project}/application/{ref.sequence.application.application}/artifact/{ref.sequence.number}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetPushedArtifact2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetPushedArtifact2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetPushedArtifact2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetRelease gets release returns a release
*/
func (a *Client) WaypointGetRelease(params *WaypointGetReleaseParams, opts ...ClientOption) (*WaypointGetReleaseOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetReleaseParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetRelease",
		Method:             "GET",
		PathPattern:        "/release/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetReleaseReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetReleaseOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetReleaseDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetRelease2 gets release returns a release
*/
func (a *Client) WaypointGetRelease2(params *WaypointGetRelease2Params, opts ...ClientOption) (*WaypointGetRelease2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetRelease2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetRelease2",
		Method:             "GET",
		PathPattern:        "/project/{ref.sequence.application.project}/application/{ref.sequence.application.application}/release/{ref.sequence.number}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetRelease2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetRelease2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetRelease2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetRunner gets runner gets information about a single runner
*/
func (a *Client) WaypointGetRunner(params *WaypointGetRunnerParams, opts ...ClientOption) (*WaypointGetRunnerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetRunnerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetRunner",
		Method:             "GET",
		PathPattern:        "/runner/{runner_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetRunnerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetRunnerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetRunnerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetServerConfig gets server config sets configuration for the waypoint server
*/
func (a *Client) WaypointGetServerConfig(params *WaypointGetServerConfigParams, opts ...ClientOption) (*WaypointGetServerConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetServerConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetServerConfig",
		Method:             "GET",
		PathPattern:        "/server/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetServerConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetServerConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetServerConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetStatusReport gets status report returns a status report
*/
func (a *Client) WaypointGetStatusReport(params *WaypointGetStatusReportParams, opts ...ClientOption) (*WaypointGetStatusReportOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetStatusReportParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetStatusReport",
		Method:             "GET",
		PathPattern:        "/release/by-id/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetStatusReportReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetStatusReportOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetStatusReportDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetTask gets task returns a requested task message or an error if it does not exist
*/
func (a *Client) WaypointGetTask(params *WaypointGetTaskParams, opts ...ClientOption) (*WaypointGetTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetTaskParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetTask",
		Method:             "GET",
		PathPattern:        "/task/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetTaskReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetTaskOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetTaskDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetTask2 gets task returns a requested task message or an error if it does not exist
*/
func (a *Client) WaypointGetTask2(params *WaypointGetTask2Params, opts ...ClientOption) (*WaypointGetTask2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetTask2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetTask2",
		Method:             "GET",
		PathPattern:        "/task/by-job/{ref.job_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetTask2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetTask2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetTask2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetTrigger gets trigger returns a requested trigger message or an error if it does not exist
*/
func (a *Client) WaypointGetTrigger(params *WaypointGetTriggerParams, opts ...ClientOption) (*WaypointGetTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetTriggerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetTrigger",
		Method:             "GET",
		PathPattern:        "/trigger/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetTrigger2 gets trigger returns a requested trigger message or an error if it does not exist
*/
func (a *Client) WaypointGetTrigger2(params *WaypointGetTrigger2Params, opts ...ClientOption) (*WaypointGetTrigger2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetTrigger2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetTrigger2",
		Method:             "DELETE",
		PathPattern:        "/trigger/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetTrigger2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetTrigger2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetTrigger2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetUser gets user returns the current logged in user or some other user
*/
func (a *Client) WaypointGetUser(params *WaypointGetUserParams, opts ...ClientOption) (*WaypointGetUserOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetUserParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetUser",
		Method:             "GET",
		PathPattern:        "/user/by-id/{user.id.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetUserReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetUserOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetUserDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetUser2 gets user returns the current logged in user or some other user
*/
func (a *Client) WaypointGetUser2(params *WaypointGetUser2Params, opts ...ClientOption) (*WaypointGetUser2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetUser2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetUser2",
		Method:             "GET",
		PathPattern:        "/user/by-username/{user.username.username}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetUser2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetUser2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetUser2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetVersionInfo gets version info returns information about the server this RPC call does n o t require authentication it can be used by clients to determine if they are capable of talking to this server
*/
func (a *Client) WaypointGetVersionInfo(params *WaypointGetVersionInfoParams, opts ...ClientOption) (*WaypointGetVersionInfoOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetVersionInfoParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetVersionInfo",
		Method:             "GET",
		PathPattern:        "/version",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetVersionInfoReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetVersionInfoOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetVersionInfoDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointGetWorkspace gets workspace returns the workspace
*/
func (a *Client) WaypointGetWorkspace(params *WaypointGetWorkspaceParams, opts ...ClientOption) (*WaypointGetWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointGetWorkspaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_GetWorkspace",
		Method:             "GET",
		PathPattern:        "/workspace/{workspace.workspace}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointGetWorkspaceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointGetWorkspaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointGetWorkspaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListAuthMethods lists auth methods returns a list of all the auth methods
*/
func (a *Client) WaypointListAuthMethods(params *WaypointListAuthMethodsParams, opts ...ClientOption) (*WaypointListAuthMethodsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListAuthMethodsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListAuthMethods",
		Method:             "GET",
		PathPattern:        "/auth-methods",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListAuthMethodsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListAuthMethodsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListAuthMethodsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListBuilds lists builds returns the builds
*/
func (a *Client) WaypointListBuilds(params *WaypointListBuildsParams, opts ...ClientOption) (*WaypointListBuildsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListBuildsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListBuilds",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/builds",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListBuildsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListBuildsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListBuildsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListBuilds2 lists builds returns the builds
*/
func (a *Client) WaypointListBuilds2(params *WaypointListBuilds2Params, opts ...ClientOption) (*WaypointListBuilds2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListBuilds2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListBuilds2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/builds",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListBuilds2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListBuilds2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListBuilds2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListDeployments lists deployments returns the deployments
*/
func (a *Client) WaypointListDeployments(params *WaypointListDeploymentsParams, opts ...ClientOption) (*WaypointListDeploymentsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListDeploymentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListDeployments",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/deployments",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListDeploymentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListDeploymentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListDeploymentsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListDeployments2 lists deployments returns the deployments
*/
func (a *Client) WaypointListDeployments2(params *WaypointListDeployments2Params, opts ...ClientOption) (*WaypointListDeployments2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListDeployments2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListDeployments2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/deployments",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListDeployments2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListDeployments2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListDeployments2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListHostnames lists all our registered hostnames
*/
func (a *Client) WaypointListHostnames(params *WaypointListHostnamesParams, opts ...ClientOption) (*WaypointListHostnamesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListHostnamesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListHostnames",
		Method:             "GET",
		PathPattern:        "/project/{target.application.application.project}/application/{target.application.application.application}/hostnames",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListHostnamesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListHostnamesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListHostnamesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListHostnames2 lists all our registered hostnames
*/
func (a *Client) WaypointListHostnames2(params *WaypointListHostnames2Params, opts ...ClientOption) (*WaypointListHostnames2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListHostnames2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListHostnames2",
		Method:             "GET",
		PathPattern:        "/project/{target.application.application.project}/application/{target.application.application.application}/workspace/{target.application.workspace.workspace}/hostnames",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListHostnames2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListHostnames2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListHostnames2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListInstances lists instances returns the running instances of deployments
*/
func (a *Client) WaypointListInstances(params *WaypointListInstancesParams, opts ...ClientOption) (*WaypointListInstancesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListInstancesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListInstances",
		Method:             "GET",
		PathPattern:        "/instances/{deployment_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListInstancesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListInstancesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListInstancesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListInstances2 lists instances returns the running instances of deployments
*/
func (a *Client) WaypointListInstances2(params *WaypointListInstances2Params, opts ...ClientOption) (*WaypointListInstances2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListInstances2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListInstances2",
		Method:             "GET",
		PathPattern:        "/project/{application.application.project}/application/{application.application.application}/instances",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListInstances2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListInstances2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListInstances2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListInstances3 lists instances returns the running instances of deployments
*/
func (a *Client) WaypointListInstances3(params *WaypointListInstances3Params, opts ...ClientOption) (*WaypointListInstances3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListInstances3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListInstances3",
		Method:             "GET",
		PathPattern:        "/project/{application.application.project}/application/{application.application.application}/workspace/{application.workspace.workspace}/instances",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListInstances3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListInstances3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListInstances3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListJobs lists jobs will return a list of jobs known to waypoint server can be filtered by request on values like workspace project application job state etc
*/
func (a *Client) WaypointListJobs(params *WaypointListJobsParams, opts ...ClientOption) (*WaypointListJobsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListJobsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListJobs",
		Method:             "GET",
		PathPattern:        "/jobs/workspace/{workspace.workspace}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListJobsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListJobsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListJobsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListJobs2 lists jobs will return a list of jobs known to waypoint server can be filtered by request on values like workspace project application job state etc
*/
func (a *Client) WaypointListJobs2(params *WaypointListJobs2Params, opts ...ClientOption) (*WaypointListJobs2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListJobs2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListJobs2",
		Method:             "GET",
		PathPattern:        "/jobs/workspace/{workspace.workspace}/state/{jobState}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListJobs2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListJobs2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListJobs2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListJobs3 lists jobs will return a list of jobs known to waypoint server can be filtered by request on values like workspace project application job state etc
*/
func (a *Client) WaypointListJobs3(params *WaypointListJobs3Params, opts ...ClientOption) (*WaypointListJobs3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListJobs3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListJobs3",
		Method:             "GET",
		PathPattern:        "/jobs/project/{project.project}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListJobs3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListJobs3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListJobs3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListJobs4 lists jobs will return a list of jobs known to waypoint server can be filtered by request on values like workspace project application job state etc
*/
func (a *Client) WaypointListJobs4(params *WaypointListJobs4Params, opts ...ClientOption) (*WaypointListJobs4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListJobs4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListJobs4",
		Method:             "GET",
		PathPattern:        "/jobs/state/{jobState}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListJobs4Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListJobs4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListJobs4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListJobs5 lists jobs will return a list of jobs known to waypoint server can be filtered by request on values like workspace project application job state etc
*/
func (a *Client) WaypointListJobs5(params *WaypointListJobs5Params, opts ...ClientOption) (*WaypointListJobs5OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListJobs5Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListJobs5",
		Method:             "GET",
		PathPattern:        "/jobs/runner/by-id/{targetRunner.id.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListJobs5Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListJobs5OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListJobs5Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListOIDCAuthMethods lists the available o ID c providers for authentication the name of the o ID c provider can be used with get o ID c auth URL and complete o ID c auth to perform o ID c based authentication
*/
func (a *Client) WaypointListOIDCAuthMethods(params *WaypointListOIDCAuthMethodsParams, opts ...ClientOption) (*WaypointListOIDCAuthMethodsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListOIDCAuthMethodsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListOIDCAuthMethods",
		Method:             "GET",
		PathPattern:        "/oidc/methods",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListOIDCAuthMethodsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListOIDCAuthMethodsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListOIDCAuthMethodsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListOnDemandRunnerConfigs lists on demand runner configs returns a list of all the on demand runners configs
*/
func (a *Client) WaypointListOnDemandRunnerConfigs(params *WaypointListOnDemandRunnerConfigsParams, opts ...ClientOption) (*WaypointListOnDemandRunnerConfigsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListOnDemandRunnerConfigsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListOnDemandRunnerConfigs",
		Method:             "GET",
		PathPattern:        "/on-demand-runners",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListOnDemandRunnerConfigsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListOnDemandRunnerConfigsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListOnDemandRunnerConfigsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListPipelineRuns lists pipeline runs takes a pipeline ref and returns a list of runs of that pipeline it will return an error if the requested pipeline does not exist or an empty response if there are no runs for the pipeline
*/
func (a *Client) WaypointListPipelineRuns(params *WaypointListPipelineRunsParams, opts ...ClientOption) (*WaypointListPipelineRunsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListPipelineRunsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListPipelineRuns",
		Method:             "GET",
		PathPattern:        "/project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/runs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListPipelineRunsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListPipelineRunsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListPipelineRunsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListPipelineRuns2 lists pipeline runs takes a pipeline ref and returns a list of runs of that pipeline it will return an error if the requested pipeline does not exist or an empty response if there are no runs for the pipeline
*/
func (a *Client) WaypointListPipelineRuns2(params *WaypointListPipelineRuns2Params, opts ...ClientOption) (*WaypointListPipelineRuns2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListPipelineRuns2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListPipelineRuns2",
		Method:             "GET",
		PathPattern:        "/pipeline/{pipeline.id}/runs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListPipelineRuns2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListPipelineRuns2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListPipelineRuns2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListPipelines lists pipelines takes a project and evaluates the projects config to get a list of pipeline protos to return in the response these pipelines are scoped to a single project from the request it will return an error if the requested project does not exist or an empty response if no pipelines are defined for the project
*/
func (a *Client) WaypointListPipelines(params *WaypointListPipelinesParams, opts ...ClientOption) (*WaypointListPipelinesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListPipelinesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListPipelines",
		Method:             "GET",
		PathPattern:        "/project/{project.project}/pipelines",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListPipelinesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListPipelinesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListPipelinesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListProjects lists projects returns a list of all the projects there is no equivalent list applications because applications are a part of projects and you can use get project to get more information about the project
*/
func (a *Client) WaypointListProjects(params *WaypointListProjectsParams, opts ...ClientOption) (*WaypointListProjectsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListProjectsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListProjects",
		Method:             "GET",
		PathPattern:        "/projects",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListProjectsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListProjectsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListProjectsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListPushedArtifacts lists pushed artifacts returns the builds
*/
func (a *Client) WaypointListPushedArtifacts(params *WaypointListPushedArtifactsParams, opts ...ClientOption) (*WaypointListPushedArtifactsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListPushedArtifactsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListPushedArtifacts",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/artifacts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListPushedArtifactsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListPushedArtifactsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListPushedArtifactsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListPushedArtifacts2 lists pushed artifacts returns the builds
*/
func (a *Client) WaypointListPushedArtifacts2(params *WaypointListPushedArtifacts2Params, opts ...ClientOption) (*WaypointListPushedArtifacts2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListPushedArtifacts2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListPushedArtifacts2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/artifacts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListPushedArtifacts2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListPushedArtifacts2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListPushedArtifacts2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListReleases lists releases returns the releases
*/
func (a *Client) WaypointListReleases(params *WaypointListReleasesParams, opts ...ClientOption) (*WaypointListReleasesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListReleasesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListReleases",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/releases",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListReleasesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListReleasesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListReleasesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListReleases2 lists releases returns the releases
*/
func (a *Client) WaypointListReleases2(params *WaypointListReleases2Params, opts ...ClientOption) (*WaypointListReleases2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListReleases2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListReleases2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/releases",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListReleases2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListReleases2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListReleases2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListRunners lists runners lists runners that are currently registered with the waypoint server this list does not include previous on demand runners that have exited
*/
func (a *Client) WaypointListRunners(params *WaypointListRunnersParams, opts ...ClientOption) (*WaypointListRunnersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListRunnersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListRunners",
		Method:             "GET",
		PathPattern:        "/runners",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListRunnersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListRunnersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListRunnersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListStatusReports lists status reports returns the deployments
*/
func (a *Client) WaypointListStatusReports(params *WaypointListStatusReportsParams, opts ...ClientOption) (*WaypointListStatusReportsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListStatusReportsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListStatusReports",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/status-reports",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListStatusReportsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListStatusReportsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListStatusReportsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListStatusReports2 lists status reports returns the deployments
*/
func (a *Client) WaypointListStatusReports2(params *WaypointListStatusReports2Params, opts ...ClientOption) (*WaypointListStatusReports2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListStatusReports2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListStatusReports2",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/status-reports",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListStatusReports2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListStatusReports2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListStatusReports2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListTask lists task will return a list of all existing tasks
*/
func (a *Client) WaypointListTask(params *WaypointListTaskParams, opts ...ClientOption) (*WaypointListTaskOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListTaskParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListTask",
		Method:             "GET",
		PathPattern:        "/tasks",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListTaskReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListTaskOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListTaskDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListTriggers lists triggers takes a request filter and returns any matching existing triggers
*/
func (a *Client) WaypointListTriggers(params *WaypointListTriggersParams, opts ...ClientOption) (*WaypointListTriggersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListTriggersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListTriggers",
		Method:             "GET",
		PathPattern:        "/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListTriggersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListTriggersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListTriggersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListTriggers2 lists triggers takes a request filter and returns any matching existing triggers
*/
func (a *Client) WaypointListTriggers2(params *WaypointListTriggers2Params, opts ...ClientOption) (*WaypointListTriggers2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListTriggers2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListTriggers2",
		Method:             "GET",
		PathPattern:        "/project/{project.project}/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListTriggers2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListTriggers2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListTriggers2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListTriggers3 lists triggers takes a request filter and returns any matching existing triggers
*/
func (a *Client) WaypointListTriggers3(params *WaypointListTriggers3Params, opts ...ClientOption) (*WaypointListTriggers3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListTriggers3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListTriggers3",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListTriggers3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListTriggers3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListTriggers3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListTriggers4 lists triggers takes a request filter and returns any matching existing triggers
*/
func (a *Client) WaypointListTriggers4(params *WaypointListTriggers4Params, opts ...ClientOption) (*WaypointListTriggers4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListTriggers4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListTriggers4",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspace/{workspace.workspace}/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListTriggers4Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListTriggers4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListTriggers4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointListUsers lists all users in the system
*/
func (a *Client) WaypointListUsers(params *WaypointListUsersParams, opts ...ClientOption) (*WaypointListUsersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListUsersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListUsers",
		Method:             "GET",
		PathPattern:        "/users",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListUsersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListUsersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListUsersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WaypointListWorkspaces lists workspaces returns a list of all workspaces

	Note that currently this list is never pruned, even if a workspace is

no longer in use. We plan to prune this in a future improvement.
*/
func (a *Client) WaypointListWorkspaces(params *WaypointListWorkspacesParams, opts ...ClientOption) (*WaypointListWorkspacesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListWorkspacesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListWorkspaces",
		Method:             "GET",
		PathPattern:        "/workspaces",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListWorkspacesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListWorkspacesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListWorkspacesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WaypointListWorkspaces2 lists workspaces returns a list of all workspaces

	Note that currently this list is never pruned, even if a workspace is

no longer in use. We plan to prune this in a future improvement.
*/
func (a *Client) WaypointListWorkspaces2(params *WaypointListWorkspaces2Params, opts ...ClientOption) (*WaypointListWorkspaces2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListWorkspaces2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListWorkspaces2",
		Method:             "GET",
		PathPattern:        "/project/{project.project}/workspaces",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListWorkspaces2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListWorkspaces2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListWorkspaces2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WaypointListWorkspaces3 lists workspaces returns a list of all workspaces

	Note that currently this list is never pruned, even if a workspace is

no longer in use. We plan to prune this in a future improvement.
*/
func (a *Client) WaypointListWorkspaces3(params *WaypointListWorkspaces3Params, opts ...ClientOption) (*WaypointListWorkspaces3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointListWorkspaces3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ListWorkspaces3",
		Method:             "GET",
		PathPattern:        "/project/{application.project}/application/{application.application}/workspaces",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointListWorkspaces3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointListWorkspaces3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointListWorkspaces3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointNoAuthRunTrigger attempts to run a trigger given a trigger ID reference if the trigger does not exist we return not found if the trigger exists but requires authentication we return an error
*/
func (a *Client) WaypointNoAuthRunTrigger(params *WaypointNoAuthRunTriggerParams, opts ...ClientOption) (*WaypointNoAuthRunTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointNoAuthRunTriggerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_NoAuthRunTrigger",
		Method:             "POST",
		PathPattern:        "/triggers/no-auth/{ref.id}/run",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointNoAuthRunTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointNoAuthRunTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointNoAuthRunTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointQueueJob queues job queues a job for execution by a runner this will return as soon as the job is queued it will not wait for execution
*/
func (a *Client) WaypointQueueJob(params *WaypointQueueJobParams, opts ...ClientOption) (*WaypointQueueJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointQueueJobParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_QueueJob",
		Method:             "POST",
		PathPattern:        "/jobs/queue",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointQueueJobReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointQueueJobOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointQueueJobDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointRunPipeline runs pipeline queues a pipeline execution
*/
func (a *Client) WaypointRunPipeline(params *WaypointRunPipelineParams, opts ...ClientOption) (*WaypointRunPipelineOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointRunPipelineParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_RunPipeline",
		Method:             "POST",
		PathPattern:        "/project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}/run",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointRunPipelineReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointRunPipelineOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointRunPipelineDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointRunPipeline2 runs pipeline queues a pipeline execution
*/
func (a *Client) WaypointRunPipeline2(params *WaypointRunPipeline2Params, opts ...ClientOption) (*WaypointRunPipeline2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointRunPipeline2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_RunPipeline2",
		Method:             "POST",
		PathPattern:        "/pipeline/{pipeline.id}/run",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointRunPipeline2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointRunPipeline2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointRunPipeline2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointRunTrigger runs trigger will look up the referenced trigger and attempt to queue a job based on the trigger configuration
*/
func (a *Client) WaypointRunTrigger(params *WaypointRunTriggerParams, opts ...ClientOption) (*WaypointRunTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointRunTriggerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_RunTrigger",
		Method:             "PUT",
		PathPattern:        "/trigger/{ref.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointRunTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointRunTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointRunTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointSetConfig sets one or more configuration variables for applications or runners
*/
func (a *Client) WaypointSetConfig(params *WaypointSetConfigParams, opts ...ClientOption) (*WaypointSetConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointSetConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_SetConfig",
		Method:             "PUT",
		PathPattern:        "/project/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointSetConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointSetConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointSetConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointSetConfigSource sets the configuration for a dynamic configuration source if you re looking to set application configuration you probably want set config instead
*/
func (a *Client) WaypointSetConfigSource(params *WaypointSetConfigSourceParams, opts ...ClientOption) (*WaypointSetConfigSourceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointSetConfigSourceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_SetConfigSource",
		Method:             "PUT",
		PathPattern:        "/config-source",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointSetConfigSourceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointSetConfigSourceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointSetConfigSourceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointSetServerConfig sets server config sets configuration for the waypoint server
*/
func (a *Client) WaypointSetServerConfig(params *WaypointSetServerConfigParams, opts ...ClientOption) (*WaypointSetServerConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointSetServerConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_SetServerConfig",
		Method:             "POST",
		PathPattern:        "/server/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointSetServerConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointSetServerConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointSetServerConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointStartExecStream starts exec stream starts an exec session
*/
func (a *Client) WaypointStartExecStream(params *WaypointStartExecStreamParams, opts ...ClientOption) (*WaypointStartExecStreamOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointStartExecStreamParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_StartExecStream",
		Method:             "POST",
		PathPattern:        "/exec",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointStartExecStreamReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointStartExecStreamOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointStartExecStreamDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIGetProject gets a given project with useful related records
*/
func (a *Client) WaypointUIGetProject(params *WaypointUIGetProjectParams, opts ...ClientOption) (*WaypointUIGetProjectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIGetProjectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_GetProject",
		Method:             "GET",
		PathPattern:        "/ui/project/{project.project}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIGetProjectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIGetProjectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIGetProjectDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListDeployments lists deployments for a given application
*/
func (a *Client) WaypointUIListDeployments(params *WaypointUIListDeploymentsParams, opts ...ClientOption) (*WaypointUIListDeploymentsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListDeploymentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListDeployments",
		Method:             "GET",
		PathPattern:        "/ui/deployments/workspace/{workspace.workspace}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListDeploymentsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListDeploymentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListDeploymentsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListDeployments2 lists deployments for a given application
*/
func (a *Client) WaypointUIListDeployments2(params *WaypointUIListDeployments2Params, opts ...ClientOption) (*WaypointUIListDeployments2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListDeployments2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListDeployments2",
		Method:             "GET",
		PathPattern:        "/ui/deployments/application/{application.application}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListDeployments2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListDeployments2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListDeployments2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListDeployments3 lists deployments for a given application
*/
func (a *Client) WaypointUIListDeployments3(params *WaypointUIListDeployments3Params, opts ...ClientOption) (*WaypointUIListDeployments3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListDeployments3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListDeployments3",
		Method:             "GET",
		PathPattern:        "/ui/deployments/project/{application.project}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListDeployments3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListDeployments3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListDeployments3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListDeployments4 lists deployments for a given application
*/
func (a *Client) WaypointUIListDeployments4(params *WaypointUIListDeployments4Params, opts ...ClientOption) (*WaypointUIListDeployments4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListDeployments4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListDeployments4",
		Method:             "GET",
		PathPattern:        "/ui/deployments/state/{physical_state}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListDeployments4Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListDeployments4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListDeployments4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListReleases lists releases for a given application
*/
func (a *Client) WaypointUIListReleases(params *WaypointUIListReleasesParams, opts ...ClientOption) (*WaypointUIListReleasesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListReleasesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListReleases",
		Method:             "GET",
		PathPattern:        "/ui/releases/workspace/{workspace.workspace}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListReleasesReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListReleasesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListReleasesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListReleases2 lists releases for a given application
*/
func (a *Client) WaypointUIListReleases2(params *WaypointUIListReleases2Params, opts ...ClientOption) (*WaypointUIListReleases2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListReleases2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListReleases2",
		Method:             "GET",
		PathPattern:        "/ui/releases/application/{application.application}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListReleases2Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListReleases2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListReleases2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListReleases3 lists releases for a given application
*/
func (a *Client) WaypointUIListReleases3(params *WaypointUIListReleases3Params, opts ...ClientOption) (*WaypointUIListReleases3OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListReleases3Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListReleases3",
		Method:             "GET",
		PathPattern:        "/ui/releases/project/{application.project}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListReleases3Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListReleases3OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListReleases3Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUIListReleases4 lists releases for a given application
*/
func (a *Client) WaypointUIListReleases4(params *WaypointUIListReleases4Params, opts ...ClientOption) (*WaypointUIListReleases4OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUIListReleases4Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UI_ListReleases4",
		Method:             "GET",
		PathPattern:        "/ui/releases/state/{physical_state}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUIListReleases4Reader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUIListReleases4OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUIListReleases4Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpdateUser updates the details about an existing user
*/
func (a *Client) WaypointUpdateUser(params *WaypointUpdateUserParams, opts ...ClientOption) (*WaypointUpdateUserOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpdateUserParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpdateUser",
		Method:             "PUT",
		PathPattern:        "/user/{user.id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpdateUserReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpdateUserOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpdateUserDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpsertApplication upserts application upserts an application with a project
*/
func (a *Client) WaypointUpsertApplication(params *WaypointUpsertApplicationParams, opts ...ClientOption) (*WaypointUpsertApplicationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpsertApplicationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpsertApplication",
		Method:             "POST",
		PathPattern:        "/project/{project.project}/application",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpsertApplicationReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpsertApplicationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpsertApplicationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpsertAuthMethod upserts auth method upserts the auth method all users logged in with this auth method will remain logged in even if settings change
*/
func (a *Client) WaypointUpsertAuthMethod(params *WaypointUpsertAuthMethodParams, opts ...ClientOption) (*WaypointUpsertAuthMethodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpsertAuthMethodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpsertAuthMethod",
		Method:             "POST",
		PathPattern:        "/auth-method",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpsertAuthMethodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpsertAuthMethodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpsertAuthMethodDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpsertOnDemandRunnerConfig upserts on demand runner config updates or inserts a on demand runner configuration this configuration can be used by projects for running operations on just in time launched runners
*/
func (a *Client) WaypointUpsertOnDemandRunnerConfig(params *WaypointUpsertOnDemandRunnerConfigParams, opts ...ClientOption) (*WaypointUpsertOnDemandRunnerConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpsertOnDemandRunnerConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpsertOnDemandRunnerConfig",
		Method:             "POST",
		PathPattern:        "/runner/on-demand",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpsertOnDemandRunnerConfigReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpsertOnDemandRunnerConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpsertOnDemandRunnerConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpsertProject upserts project upserts the project
*/
func (a *Client) WaypointUpsertProject(params *WaypointUpsertProjectParams, opts ...ClientOption) (*WaypointUpsertProjectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpsertProjectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpsertProject",
		Method:             "POST",
		PathPattern:        "/project",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpsertProjectReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpsertProjectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpsertProjectDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpsertTrigger upserts trigger updates or inserts a trigger URL configuration
*/
func (a *Client) WaypointUpsertTrigger(params *WaypointUpsertTriggerParams, opts ...ClientOption) (*WaypointUpsertTriggerOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpsertTriggerParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpsertTrigger",
		Method:             "POST",
		PathPattern:        "/triggers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpsertTriggerReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpsertTriggerOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpsertTriggerDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointUpsertWorkspace upserts workspace upserts the workspace changes to a workspace s projects are ignored at this time
*/
func (a *Client) WaypointUpsertWorkspace(params *WaypointUpsertWorkspaceParams, opts ...ClientOption) (*WaypointUpsertWorkspaceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointUpsertWorkspaceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_UpsertWorkspace",
		Method:             "POST",
		PathPattern:        "/workspace",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointUpsertWorkspaceReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointUpsertWorkspaceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointUpsertWorkspaceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointValidateJob validates job checks if a job appears valid this will check the job structure itself i e missing fields and can also check to ensure the job is assignable to a runner
*/
func (a *Client) WaypointValidateJob(params *WaypointValidateJobParams, opts ...ClientOption) (*WaypointValidateJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointValidateJobParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_ValidateJob",
		Method:             "POST",
		PathPattern:        "/jobs/validateJob",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointValidateJobReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointValidateJobOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointValidateJobDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WaypointWaypointHclFmt waypoints hcl fmt formats a waypoint hcl file this must be in h c l format JSON formatting is not supported
*/
func (a *Client) WaypointWaypointHclFmt(params *WaypointWaypointHclFmtParams, opts ...ClientOption) (*WaypointWaypointHclFmtOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWaypointWaypointHclFmtParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "Waypoint_WaypointHclFmt",
		Method:             "POST",
		PathPattern:        "/hcl/format",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WaypointWaypointHclFmtReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WaypointWaypointHclFmtOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WaypointWaypointHclFmtDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
