// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointRelease hashicorp waypoint release
//
// swagger:model hashicorp.waypoint.Release
type HashicorpWaypointRelease struct {

	// application that this release belongs to
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`

	// component managing the release process.
	Component *HashicorpWaypointComponent `json:"component,omitempty"`

	// A platform resource that this release has created, depends on, or manages.
	DeclaredResources []*HashicorpWaypointDeclaredResource `json:"declared_resources"`

	// ID of the deployment that is being released.
	DeploymentID string `json:"deployment_id,omitempty"`

	// Resources that a destroy operation has destroyed
	DestroyedResources []*HashicorpWaypointDestroyedResource `json:"destroyed_resources"`

	// id is the unique ID for this release.
	ID string `json:"id,omitempty"`

	// ID of the job that created this. This may be empty.
	JobID string `json:"job_id,omitempty"`

	// labels are the set of labels that are present on this build.
	Labels map[string]string `json:"labels,omitempty"`

	// This is the populated preload data. Most of this data can be retrieved
	// through additional API calls or manually computed, but certain API
	// calls will pre-populate some of these fields for convenience. The exact
	// pre-populated fields depend on the API.
	Preload *HashicorpWaypointReleasePreload `json:"preload,omitempty"`

	// release is the raw release object encoded directly from the plugin.
	Release *OpaqueanyAny `json:"release,omitempty"`

	// This is the JSON-encoded protobuf structure of the Any field above.
	// This is generated by the plugin and Waypoint core does not modify this
	// value or have any enforced structure. This will be different per-plugin.
	ReleaseJSON string `json:"release_json,omitempty"`

	// The sequence number for this build.
	Sequence string `json:"sequence,omitempty"`

	// The physical state of the release resources.
	State *HashicorpWaypointOperationPhysicalState `json:"state,omitempty"`

	// status of the release operation.
	Status *HashicorpWaypointStatus `json:"status,omitempty"`

	// template data for HCL variables and template functions, json-encoded
	// Format: byte
	TemplateData strfmt.Base64 `json:"template_data,omitempty"`

	// A boolean to mark this release message as unimplemented by the plugin
	// that generated the message. If true, that means there was not a releaser
	// to execute for the release lifecycle phase.
	Unimplemented bool `json:"unimplemented,omitempty"`

	// URL for this release. This is valid while the release is still
	// in use. After the release is not in use, this may still be set but
	// may no longer be valid.
	URL string `json:"url,omitempty"`

	// The workspace that this exists in
	Workspace *HashicorpWaypointRefWorkspace `json:"workspace,omitempty"`
}

// Validate validates this hashicorp waypoint release
func (m *HashicorpWaypointRelease) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComponent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeclaredResources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestroyedResources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePreload(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelease(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRelease) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) validateComponent(formats strfmt.Registry) error {
	if swag.IsZero(m.Component) { // not required
		return nil
	}

	if m.Component != nil {
		if err := m.Component.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("component")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("component")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) validateDeclaredResources(formats strfmt.Registry) error {
	if swag.IsZero(m.DeclaredResources) { // not required
		return nil
	}

	for i := 0; i < len(m.DeclaredResources); i++ {
		if swag.IsZero(m.DeclaredResources[i]) { // not required
			continue
		}

		if m.DeclaredResources[i] != nil {
			if err := m.DeclaredResources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("declared_resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("declared_resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointRelease) validateDestroyedResources(formats strfmt.Registry) error {
	if swag.IsZero(m.DestroyedResources) { // not required
		return nil
	}

	for i := 0; i < len(m.DestroyedResources); i++ {
		if swag.IsZero(m.DestroyedResources[i]) { // not required
			continue
		}

		if m.DestroyedResources[i] != nil {
			if err := m.DestroyedResources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("destroyed_resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("destroyed_resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointRelease) validatePreload(formats strfmt.Registry) error {
	if swag.IsZero(m.Preload) { // not required
		return nil
	}

	if m.Preload != nil {
		if err := m.Preload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("preload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("preload")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) validateRelease(formats strfmt.Registry) error {
	if swag.IsZero(m.Release) { // not required
		return nil
	}

	if m.Release != nil {
		if err := m.Release.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint release based on the context it is used
func (m *HashicorpWaypointRelease) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateComponent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeclaredResources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestroyedResources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePreload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointRelease) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateComponent(ctx context.Context, formats strfmt.Registry) error {

	if m.Component != nil {
		if err := m.Component.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("component")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("component")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateDeclaredResources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DeclaredResources); i++ {

		if m.DeclaredResources[i] != nil {
			if err := m.DeclaredResources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("declared_resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("declared_resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateDestroyedResources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DestroyedResources); i++ {

		if m.DestroyedResources[i] != nil {
			if err := m.DestroyedResources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("destroyed_resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("destroyed_resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidatePreload(ctx context.Context, formats strfmt.Registry) error {

	if m.Preload != nil {
		if err := m.Preload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("preload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("preload")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateRelease(ctx context.Context, formats strfmt.Registry) error {

	if m.Release != nil {
		if err := m.Release.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointRelease) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointRelease) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointRelease) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointRelease
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
