// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointQueueJobRequest hashicorp waypoint queue job request
//
// swagger:model hashicorp.waypoint.QueueJobRequest
type HashicorpWaypointQueueJobRequest struct {

	// Set an expiration duration. If the job is not assigned and acked
	// in the given duration then the job will be automatically cancelled.
	ExpiresIn string `json:"expires_in,omitempty"`

	// The job to queue. See the Job message documentation for more details
	// on what to set.
	Job *HashicorpWaypointJob `json:"job,omitempty"`
}

// Validate validates this hashicorp waypoint queue job request
func (m *HashicorpWaypointQueueJobRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointQueueJobRequest) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.SwaggerValidate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint queue job request based on the context it is used
func (m *HashicorpWaypointQueueJobRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointQueueJobRequest) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointQueueJobRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointQueueJobRequest) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointQueueJobRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
