// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointConfigVar ConfigVars represent configuration variables for applications and runners.
// Configuration variables can be exposed via env vars, files, and more. They
// are a way to inject configuration into a Waypoint-managed process.
//
// Note that config vars are different from input variables. Input variables
// are a way to parameterize a Waypoint project/app. This is a different feature.
//
// == Conflict Resolution
//
// When two configuration variables share the same name and are both
// valid for a given target environment (for example, config "foo" set for
// both the project and app scope), the following rules are applied to determine
// which variable value is used:
//
//  1. If a workspace is set one one but not the other, the variable
//     with the workspace sorts higher than no workspace.
//
//  2. The most specific "scope" is used: app over project over global.
//
//  3. If scopes match, the variable with a label selector set is used.
//
//  4. If both have label selectors, the config variable with the longer
//     label selector by string length is used. This is arbitrary but makes
//     the process deterministic.
//
// swagger:model hashicorp.waypoint.ConfigVar
type HashicorpWaypointConfigVar struct {

	// These fields used to have docs but removed since they shouldn't be
	// used. If you're really trying to figure how to use these old fields,
	// see a Waypoint 0.5 or earlier git checkout.
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`

	// dynamically sourced value
	Dynamic *HashicorpWaypointConfigVarDynamicVal `json:"dynamic,omitempty"`

	// Indicates if the variable is not meant to be exposed applications or runners.
	// It exists only to be referenced by other variables.
	Internal bool `json:"internal,omitempty"`

	// name is the name of the environment variable that this config var is setting
	Name string `json:"name,omitempty"`

	// Indicates that this is actually be written as a file, with the name
	// field being the filename.
	NameIsPath bool `json:"name_is_path,omitempty"`

	// project
	Project *HashicorpWaypointRefProject `json:"project,omitempty"`

	// runner
	Runner *HashicorpWaypointRefRunner `json:"runner,omitempty"`

	// static, direct value.
	Static string `json:"static,omitempty"`

	// Target is the target environment where this config var will take effect.
	Target *HashicorpWaypointConfigVarTarget `json:"target,omitempty"`

	// unset, if set, unsets this value. For historical reasons, empty static
	// values also unset the value.
	Unset interface{} `json:"unset,omitempty"`
}

// Validate validates this hashicorp waypoint config var
func (m *HashicorpWaypointConfigVar) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDynamic(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRunner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointConfigVar) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) validateDynamic(formats strfmt.Registry) error {
	if swag.IsZero(m.Dynamic) { // not required
		return nil
	}

	if m.Dynamic != nil {
		if err := m.Dynamic.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dynamic")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dynamic")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) validateProject(formats strfmt.Registry) error {
	if swag.IsZero(m.Project) { // not required
		return nil
	}

	if m.Project != nil {
		if err := m.Project.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) validateRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.Runner) { // not required
		return nil
	}

	if m.Runner != nil {
		if err := m.Runner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(m.Target) { // not required
		return nil
	}

	if m.Target != nil {
		if err := m.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint config var based on the context it is used
func (m *HashicorpWaypointConfigVar) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDynamic(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointConfigVar) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) contextValidateDynamic(ctx context.Context, formats strfmt.Registry) error {

	if m.Dynamic != nil {
		if err := m.Dynamic.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dynamic")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dynamic")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) contextValidateProject(ctx context.Context, formats strfmt.Registry) error {

	if m.Project != nil {
		if err := m.Project.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) contextValidateRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.Runner != nil {
		if err := m.Runner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVar) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if m.Target != nil {
		if err := m.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("target")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("target")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointConfigVar) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointConfigVar) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointConfigVar
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
